/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class StdCostLevelRptResultRow
implements IDataTransform {
    private StdCostLevelRptParam stdCostLevelRptParam;

    public StdCostLevelRptResultRow(StdCostLevelRptParam stdCostLevelRptParam) {
        this.stdCostLevelRptParam = stdCostLevelRptParam;
    }

    public DataSet doTransform(DataSet srcData) {
        if (!CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getSrcMatCostInfoIds())) {
            QFilter qFilter = new QFilter("id", "in", this.stdCostLevelRptParam.getSrcMatCostInfoIds());
            DataSet matCostInfoDs = QueryServiceHelper.queryDataSet((String)"getMatCostInfoDs", (String)"cad_matcostinfo", (String)"id,material,configuredcode,tracknumber,srckeycol", (QFilter[])qFilter.toArray(), null);
            DataSet srcKeyColData = srcData.filter("srctype = 'S'");
            srcKeyColData = srcKeyColData.removeFields(new String[]{"material", "configuredcode", "tracknumber"});
            srcKeyColData = srcKeyColData.leftJoin(matCostInfoDs).on("keycol", "srckeycol").select(srcKeyColData.getRowMeta().getFieldNames(), new String[]{"material", "configuredcode", "tracknumber"}).finish();
            srcData = srcData.filter("srctype != 'S'");
            srcData = DataSetUtils.union((DataSet)srcData, (DataSet)srcKeyColData);
        }
        String queryType = this.stdCostLevelRptParam.getQueryType();
        Boolean isSimulated = CostTypePtyEnum.SIMULATED.getValue().equals(queryType);
        HashSet matIds = new HashSet(16);
        HashSet<Long> bomIds = new HashSet<Long>(16);
        HashSet<Long> processrouteIds = new HashSet<Long>(16);
        HashSet subkeycols = new HashSet(16);
        boolean isShowGroup = this.stdCostLevelRptParam.getShowgroup();
        srcData.copy().forEach(o -> {
            if (!CadEmptyUtils.isEmpty((Long)o.getLong("material"))) {
                matIds.add(o.getLong("material"));
            }
            if (!isShowGroup) {
                if (!CadEmptyUtils.isEmpty((Long)o.getLong("submaterial"))) {
                    matIds.add(o.getLong("submaterial"));
                }
                if (!CadEmptyUtils.isEmpty((Long)o.getLong("bom"))) {
                    bomIds.add(o.getLong("bom"));
                }
                if (!CadEmptyUtils.isEmpty((Long)o.getLong("processroute"))) {
                    processrouteIds.add(o.getLong("processroute"));
                }
                if (!CadEmptyUtils.isEmpty((String)o.getString("subkeycol"))) {
                    subkeycols.add(o.getString("subkeycol"));
                }
            }
        });
        QFilter subMatQFilter = new QFilter("id", "in", matIds);
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.addAll(Arrays.asList(srcData.getRowMeta().getFieldNames()));
        selectFields.remove("modelnum");
        selectFields.remove("materialname");
        selectFields.remove("unit");
        selectFields.remove("materialnum");
        DataSet materialDs = QueryServiceHelper.queryDataSet((String)"getMaterialDataSet", (String)"bd_material", (String)"id,number,name,baseunit,baseunit.precision precision,modelnum", (QFilter[])subMatQFilter.toArray(), null);
        srcData = srcData.leftJoin(materialDs).on("material", "id").select(selectFields.toArray(new String[selectFields.size()]), new String[]{"name materialname", "number materialnum", "baseunit unit", "modelnum"}).finish();
        if (!isShowGroup) {
            DataSet resourceDs = srcData.filter("submaterial is null or submaterial = 0");
            DataSet subMaterialDs = srcData.filter("submaterial is not null and submaterial != 0");
            resourceDs = resourceDs.removeFields(new String[]{"bomnum", "processroutenum", "processroutename"});
            DataSet dataSetBom = this.getBomDataSet(bomIds);
            resourceDs = resourceDs.leftJoin(dataSetBom).on("bom", "id").select(resourceDs.getRowMeta().getFieldNames(), new String[]{"bomnum"}).finish();
            DataSet dataSetProcessroute = this.getProcessrouteDataSet(processrouteIds);
            resourceDs = resourceDs.leftJoin(dataSetProcessroute).on("processroute", "id").select(resourceDs.getRowMeta().getFieldNames(), new String[]{"processroutenum", "processroutename"}).finish();
            selectFields.clear();
            selectFields.addAll(Arrays.asList(srcData.getRowMeta().getFieldNames()));
            selectFields.remove("submatname");
            selectFields.remove("submatnum");
            selectFields.remove("submatunit");
            selectFields.remove("submaterialnum");
            selectFields.remove("submodelnum");
            selectFields.remove("qtyprecision");
            subMaterialDs = subMaterialDs.leftJoin(materialDs).on("submaterial", "id").select(selectFields.toArray(new String[selectFields.size()]), new String[]{"name submatname", "number submatnum", "baseunit submatunit", "number submaterialnum", "modelnum submodelnum", "precision qtyprecision"}).finish();
            srcData = DataSetUtils.union((DataSet)subMaterialDs, (DataSet)resourceDs);
        }
        srcData = !isSimulated.booleanValue() ? (isShowGroup ? srcData.orderBy(new String[]{"materialnum", "material", "keycol", "orderby"}) : srcData.orderBy(new String[]{"materialnum", "material", "keycol", "orderby", "expdate desc", "submatnum"})) : (isShowGroup ? srcData.orderBy(new String[]{"materialnum", "material", "keycol", "orderby"}) : (this.stdCostLevelRptParam.getShowSuppier() != false ? srcData.orderBy(new String[]{"materialnum", "material", "keycol", "orderby", "element desc", "submatnum", "suplierorder"}) : srcData.orderBy(new String[]{"materialnum", "material", "keycol", "orderby", "submatnum"})));
        return srcData;
    }

    private DataSet getProcessrouteDataSet(Set<Long> processrouteIds) {
        QFilter subQf = new QFilter("id", "in", processrouteIds);
        DataSet dataPdmSet = QueryServiceHelper.queryDataSet((String)"getProcessrouteDataSet", (String)"pdm_route", (String)"id,number processroutenum,name processroutename", (QFilter[])new QFilter[]{subQf}, null).distinct();
        DataSet dataCostSet = QueryServiceHelper.queryDataSet((String)"getProcessrouteDataSet", (String)"cad_router", (String)"id,number processroutenum,name processroutename", (QFilter[])new QFilter[]{subQf}, null).distinct();
        DataSet dataSet = DataSetUtils.union((DataSet)dataPdmSet, (DataSet)dataCostSet).distinct();
        return dataSet;
    }

    private DataSet getBomDataSet(Set<Long> bomIds) {
        QFilter subQf = new QFilter("id", "in", bomIds);
        DataSet dataPdmSet = QueryServiceHelper.queryDataSet((String)"getBomDataSet", (String)"pdm_mftbom", (String)"id,number bomnum", (QFilter[])new QFilter[]{subQf}, null).distinct();
        DataSet dataCostSet = QueryServiceHelper.queryDataSet((String)"getBomDataSet", (String)"cad_costbom", (String)"id,number bomnum", (QFilter[])new QFilter[]{subQf}, null).distinct();
        DataSet dataSet = DataSetUtils.union((DataSet)dataPdmSet, (DataSet)dataCostSet).distinct();
        return dataSet;
    }
}

