/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.report.queryplugin.stdcostlevel.DiyTotalRow;
import kd.macc.cad.report.queryplugin.stdcostlevel.HandleRow;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptResultRow;

public class StdCostLevelRptSourceCf
implements IReportDataHandle {
    private final Log logger = LogFactory.getLog(StdCostLevelRptSourceCf.class);
    private Set<String> hideProps = Sets.newHashSet((Object[])new String[]{"mylinetype", "submaterial", "submaterialname", "resource", "currency", "unit", "datatype", "costtype", "levelmatver", "levelauxpty", "levelmat", "orderby", "qtyprecision", "calcbasis", "resourcenum", "resourcename", "material", "submaterialnum", "submatversionnum", "submaterialname", "matversionnum", "matversion", "submatversion", "calcdate", "keycol", "srctype", "path", "subkeycol", "bom", "processroute", "priceid"});
    private Set<String> simProps = Sets.newHashSet((Object[])new String[]{"supplier", "suppliername", "quotaratio", "unitprice", "operation", "operationnum", "operationdesc", "workcenter", "workcenternum"});
    private Set<String> groupHideProps = Sets.newHashSet((Object[])new String[]{"mylinetype", "submatname", "submatnum", "submatversion", "subauxpty", "submaterial", "submaterialname", "resource", "currency", "unit", "submatunit", "datatype", "costtype", "levelmatver", "levelauxpty", "levelmat", "orderby", "qtyprecision", "calcbasis", "resourcenum", "resourcename", "qty", "price", "material", "submaterialnum", "submatversion", "submatversionnum", "submaterialname", "matversionnum", "matversion", "suppliername", "supplier", "quotaratio", "unitprice", "calcdate", "keycol", "srctype", "path", "subkeycol", "materialattr", "subconfiguredcode", "submodelnum", "parentmat", "parentmat_ref_name", "baseqty", "priceid", "processroute", "processroutenum", "bom", "bomnum", "operation", "operationnum", "operationdesc", "workcenter", "workcenternum"});
    private Set<String> supplierProps = Sets.newHashSet((Object[])new String[]{"supplier", "suppliername", "quotaratio", "unitprice"});
    private Set<String> workCenterProps = Sets.newHashSet((Object[])new String[]{"workcenternum", "workcenter", "operationnum", "operation", "operationdesc"});
    private Set<String> processInfoProps = Sets.newHashSet((Object[])new String[]{"processroutenum", "processroutename", "processseq", "operationno", "operationnum", "operation", "operationdesc"});
    private StdCostLevelRptParam stdCostLevelRptParam;

    public void setupCtx(ReportDataCtx ctx) {
        boolean isCalType;
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6e\u4e0a\u4e0b\u6587");
        this.stdCostLevelRptParam = (StdCostLevelRptParam)ctx.getParam(StdCostLevelRptParam.class.getName());
        boolean bl = isCalType = !CostTypePtyEnum.SIMULATED.getValue().equals(this.stdCostLevelRptParam.getQueryType());
        if (isCalType) {
            this.getMatInfos();
        }
        ctx.setShowBlockEntity(false);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        boolean isCalType;
        this.logger.info("\u4fee\u6539\u56fa\u5b9a\u6570\u636e\u5757");
        Iterator<SrcBlockConf> selectBlockOr = blockCollector.iterator();
        boolean bl = isCalType = !CostTypePtyEnum.SIMULATED.getValue().equals(this.stdCostLevelRptParam.getQueryType());
        while (selectBlockOr.hasNext()) {
            String calcRecordIdName;
            SrcBlockConf blockConf = selectBlockOr.next();
            String srcEntity = blockConf.getSrcEntity();
            QFilter dataFs = blockConf.getDataFs();
            if (dataFs == null) {
                dataFs = this.getFixedFilter(srcEntity);
            } else {
                dataFs.and(this.getFixedFilter(srcEntity));
            }
            if ("cad_calceffectiveresult".equals(srcEntity)) {
                if (!isCalType || this.isHasTrackNumber(this.stdCostLevelRptParam.getTrackNumberIds())) {
                    selectBlockOr.remove();
                    continue;
                }
                String queryType = this.stdCostLevelRptParam.getQueryType();
                if (queryType == null) continue;
                dataFs.and(new QFilter("matcostid", "in", this.stdCostLevelRptParam.getMatCostInfoIds()));
                if ("period".equals(queryType) && this.stdCostLevelRptParam.getQueryPeriodId() != null) {
                    dataFs.and(new QFilter("effectdate", "<=", (Object)this.stdCostLevelRptParam.getQueryPeriodendDate()));
                    dataFs.and(new QFilter("expdate", ">", (Object)this.stdCostLevelRptParam.getQueryPeriodBeginDate()));
                    continue;
                }
                Date queryDate = this.stdCostLevelRptParam.getQueryDate();
                if (queryDate != null) {
                    dataFs.and(new QFilter("effectdate", "<=", (Object)queryDate));
                    dataFs.and(new QFilter("expdate", ">", (Object)queryDate));
                    continue;
                }
                this.logger.error("\u65e5\u671f\u67e5\u8be2\u6761\u4ef6\u5f02\u5e38,\u6210\u672c\u7c7b\u578b\u4e3a{}", (Object)this.stdCostLevelRptParam.getCostTypeId());
                continue;
            }
            if ("cad_purprices".equals(srcEntity)) {
                if (!isCalType || !CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getMulSubMaterialIds())) {
                    selectBlockOr.remove();
                    continue;
                }
                dataFs.and(new QFilter("matcostid", "in", this.stdCostLevelRptParam.getMatCostInfoIds()));
                continue;
            }
            if ("cad_calcsimulationresult".equals(srcEntity)) {
                if (isCalType) {
                    selectBlockOr.remove();
                    continue;
                }
                if (!this.stdCostLevelRptParam.getIsSimulated().booleanValue()) continue;
                calcRecordIdName = this.stdCostLevelRptParam.getCalcRecordName();
                if (!CadEmptyUtils.isEmpty((String)calcRecordIdName)) {
                    dataFs.and(new QFilter("calcrecord.name", "=", (Object)calcRecordIdName));
                    continue;
                }
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                dataFs.and(recordFilter);
                continue;
            }
            if ("cad_trackstdcalcresult".equals(srcEntity)) {
                String srcType;
                Map defVals = blockConf.getDefVals();
                boolean isSrcKeyColSrc = false;
                if (defVals != null && defVals.get("srctype") != null && (isSrcKeyColSrc = "S".equalsIgnoreCase(srcType = (String)defVals.get("srctype"))) && !isCalType) {
                    selectBlockOr.remove();
                    continue;
                }
                if (isCalType && CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getTrackKeyCols()) && CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getSrcTrackKeyCols())) {
                    selectBlockOr.remove();
                    continue;
                }
                String calcRecordIdName2 = this.stdCostLevelRptParam.getCalcRecordName();
                if (this.stdCostLevelRptParam.getIsSimulated().booleanValue() && !CadEmptyUtils.isEmpty((String)calcRecordIdName2)) {
                    selectBlockOr.remove();
                    continue;
                }
                QFilter otherQf = this.getTrackQf(isSrcKeyColSrc);
                blockConf.setDataFs(otherQf);
                continue;
            }
            if (!"cad_calcpurprices".equals(srcEntity)) continue;
            if (isCalType || !CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getMulSubMaterialIds())) {
                selectBlockOr.remove();
                continue;
            }
            calcRecordIdName = this.stdCostLevelRptParam.getCalcRecordName();
            if (!CadEmptyUtils.isEmpty((String)calcRecordIdName)) {
                dataFs.and(new QFilter("calcrecord.name", "=", (Object)calcRecordIdName));
            } else {
                QFilter recordFilter = new QFilter("calcrecord", "is null", null).or(new QFilter("calcrecord", "<=", (Object)0L));
                dataFs.and(recordFilter);
            }
            blockConf.setDataFs(dataFs);
        }
    }

    private boolean isHasTrackNumber(List<Long> trackNumberIds) {
        if (!CadEmptyUtils.isEmpty(trackNumberIds)) {
            return trackNumberIds.size() != 1 || trackNumberIds.get(0) != 0L;
        }
        return false;
    }

    private void getMatInfos() {
        String queryType;
        String lots;
        List<Long> projectNumberIds;
        List<Long> trackNumberIds;
        ArrayList<Object> filters = new ArrayList<Object>(16);
        filters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId()));
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>();
        Set<Long> mulMaterialIds = this.stdCostLevelRptParam.getMulMaterialIds();
        commonFilters.add(new QFilter("material", "in", mulMaterialIds));
        List<Long> configuredCodeIds = this.stdCostLevelRptParam.getConfiguredCodeIds();
        if (!CadEmptyUtils.isEmpty(configuredCodeIds)) {
            commonFilters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = this.stdCostLevelRptParam.getTrackNumberIds())) {
            commonFilters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = this.stdCostLevelRptParam.getProjectNumberIds())) {
            commonFilters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = this.stdCostLevelRptParam.getLots()))) {
            commonFilters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        if ((queryType = this.stdCostLevelRptParam.getQueryType()) != null) {
            if ("period".equals(queryType) && this.stdCostLevelRptParam.getQueryPeriodId() != null) {
                commonFilters.add(new QFilter("effectdate", "<=", (Object)this.stdCostLevelRptParam.getQueryPeriodendDate()));
                commonFilters.add(new QFilter("expdate", ">", (Object)this.stdCostLevelRptParam.getQueryPeriodBeginDate()));
            } else {
                Date queryDate = this.stdCostLevelRptParam.getQueryDate();
                if (queryDate != null) {
                    commonFilters.add(new QFilter("effectdate", "<=", (Object)queryDate));
                    commonFilters.add(new QFilter("expdate", ">", (Object)queryDate));
                }
            }
        }
        filters.addAll(commonFilters);
        String queryFileds = "id,material,keycol,srckeycol,configuredcode,tracknumber";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet("getMatInfos", "cad_matcostinfo", queryFileds, filters.toArray(new QFilter[0]), "keycol", -1, null);
        commonFilters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getSimCosttypeId()));
        DataSet trackNumberDataSet = orm.queryDataSet("getTrackKeyCols", "cad_trackstdcalcresult", "keycol", commonFilters.toArray(new QFilter[0]), null, -1, null);
        HashSet resultKeyCol = new HashSet(16);
        trackNumberDataSet.forEach(s -> resultKeyCol.add(s.getString("keycol")));
        HashSet<Long> matCostInfoIds = new HashSet<Long>(16);
        HashSet<String> trackKeyCols = new HashSet<String>(16);
        HashSet<String> srcTrackKeyCols = new HashSet<String>(16);
        HashSet<Long> srcMatCostInfoIds = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long tracknumber = row.getLong("tracknumber");
            Long configuredCode = row.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty((Long)tracknumber) && CadEmptyUtils.isEmpty((Long)configuredCode)) {
                matCostInfoIds.add(row.getLong("id"));
                continue;
            }
            if (resultKeyCol.contains(row.getString("keycol"))) {
                trackKeyCols.add(row.getString("keycol"));
            } else {
                String srcKeyCol = row.getString("srckeycol");
                if (CadEmptyUtils.isEmpty((String)srcKeyCol)) continue;
                srcMatCostInfoIds.add(row.getLong("id"));
                srcTrackKeyCols.add(row.getString("srckeycol"));
            }
            trackKeyCols.add(row.getString("keycol"));
        }
        this.stdCostLevelRptParam.setMatCostInfoIds(matCostInfoIds);
        this.stdCostLevelRptParam.setTrackKeyCols(trackKeyCols);
        this.stdCostLevelRptParam.setSrcTrackKeyCols(srcTrackKeyCols);
        this.stdCostLevelRptParam.setSrcMatCostInfoIds(srcMatCostInfoIds);
    }

    private QFilter getTrackQf(boolean isSrcKeyColSrc) {
        DataSet dataSet;
        DataSet dateDataSet;
        boolean isCalType;
        ArrayList filters = new ArrayList(16);
        ArrayList<QFilter> commonFilters = new ArrayList<QFilter>(16);
        boolean bl = isCalType = !CostTypePtyEnum.SIMULATED.getValue().equals(this.stdCostLevelRptParam.getQueryType());
        if (isCalType) {
            commonFilters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getSimCosttypeId()));
            String queryType = this.stdCostLevelRptParam.getQueryType();
            if ("period".equals(queryType) && this.stdCostLevelRptParam.getQueryPeriodId() != null) {
                commonFilters.add(new QFilter("effectdate", "<=", (Object)this.stdCostLevelRptParam.getQueryPeriodendDate()));
                commonFilters.add(new QFilter("expdate", ">", (Object)this.stdCostLevelRptParam.getQueryPeriodBeginDate()));
            } else {
                Date queryDate = this.stdCostLevelRptParam.getQueryDate();
                if (queryDate != null) {
                    commonFilters.add(new QFilter("effectdate", "<=", (Object)queryDate));
                    commonFilters.add(new QFilter("expdate", ">", (Object)queryDate));
                }
            }
        } else {
            commonFilters.add(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId()));
        }
        filters.addAll(commonFilters);
        if (isSrcKeyColSrc && isCalType) {
            filters.add(new QFilter("keycol", "in", this.stdCostLevelRptParam.getSrcTrackKeyCols()));
        } else {
            String lots;
            List<Long> projectNumberIds;
            List<Long> trackNumberIds;
            Set<Long> mulMaterialIds = this.stdCostLevelRptParam.getMulMaterialIds();
            filters.add(new QFilter("material", "in", mulMaterialIds));
            List<Long> configuredCodeIds = this.stdCostLevelRptParam.getConfiguredCodeIds();
            if (!CadEmptyUtils.isEmpty(configuredCodeIds)) {
                filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
            }
            if (!CadEmptyUtils.isEmpty(trackNumberIds = this.stdCostLevelRptParam.getTrackNumberIds())) {
                filters.add(new QFilter("tracknumber", "in", trackNumberIds));
            }
            if (!CadEmptyUtils.isEmpty(projectNumberIds = this.stdCostLevelRptParam.getProjectNumberIds())) {
                filters.add(new QFilter("project", "in", projectNumberIds));
            }
            if (!CadEmptyUtils.isEmpty((String)(lots = this.stdCostLevelRptParam.getLots()))) {
                filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
            }
        }
        String queryFileds = "id,material,costtype,keycol,effectdate,expdate,now() as curDate";
        ORMImpl orm = new ORMImpl();
        DataSet trackNumberDataSet = orm.queryDataSet("getTrackBomCalcIds", "cad_trackstdcalcresult", queryFileds, filters.toArray(new QFilter[0]), null, -1, null);
        trackNumberDataSet = trackNumberDataSet.addField("case when expdate is null then cast(to_date('3000-01-01 23:59:59','yyyy-MM-dd hh:mm:ss') as Timestamp) else expdate end", "calcdate");
        if (!isCalType) {
            dateDataSet = trackNumberDataSet.copy().groupBy(new String[]{"material", "keycol"}).max("calcdate", "maxcalcdate").finish();
            trackNumberDataSet = trackNumberDataSet.join(dateDataSet).on("material", "material").on("keycol", "keycol").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"maxcalcdate"}).finish();
            dataSet = trackNumberDataSet.filter("calcdate=maxcalcdate");
        } else {
            dateDataSet = trackNumberDataSet.filter("expdate is not null");
            DataSet trackNumberDateDataSet = dateDataSet.filter("curdate>=effectdate and curdate<=expdate");
            DataSet keyColDateDataSet = dateDataSet.groupBy(new String[]{"material", "keycol keyColcherck"}).finish();
            DataSet trackNumberUnDateDataSet = trackNumberDataSet.leftJoin(keyColDateDataSet).on("material", "material").on("keycol", "keyColcherck").select(trackNumberDataSet.getRowMeta().getFieldNames(), new String[]{"keyColcherck"}).finish().filter("keyColcherck is null");
            dataSet = DataSetUtils.union((DataSet)trackNumberDateDataSet, (DataSet)trackNumberUnDateDataSet);
        }
        HashSet<Long> ids = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            ids.add(row.getLong("id"));
        }
        if (isSrcKeyColSrc) {
            this.stdCostLevelRptParam.setSrcTrackIds(ids);
        } else {
            this.stdCostLevelRptParam.setTrackIds(ids);
        }
        QFilter qf = new QFilter("id", "in", ids);
        if (isCalType) {
            qf.and(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getSimCosttypeId()));
        } else {
            qf.and(new QFilter("costtype", "=", (Object)this.stdCostLevelRptParam.getCostTypeId()));
        }
        qf.and(new QFilter("origentryentity.origsubentryentity.origdatatype", "in", (Object)new String[]{"2", "4"}));
        qf.and(new QFilter("origentryentity.origentryisleaf", "=", (Object)"0"));
        return qf;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u5904\u7406\u6570\u636e\u5757\u6570\u636e");
        ctx.logInfo((Object)ResManager.loadKDString((String)"\u5904\u7406\u6570\u636e\u5757\u6570\u636e", (String)"StdCostLevelRptSourceCf_0", (String)"macc-cad-report", (Object[])new Object[0]));
        transCollector.add(new HandleRow(this.stdCostLevelRptParam, ctx));
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u6dfb\u52a0\u5b8c\u6c47\u603b\u884c\u540e\u6267\u884c\u7684\u6570\u636e\u8f6c\u6362");
        transCollector.add(new DiyTotalRow(this.stdCostLevelRptParam, ctx));
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
        this.logger.info("\u5904\u7406\u6570\u636e\u8f6c\u6362");
        super.transformResult(transCollector, ctx);
        transCollector.add(new StdCostLevelRptResultRow(this.stdCostLevelRptParam));
    }

    private QFilter getFixedFilter(String srcEntity) {
        String lots;
        List<Long> projectNumberIds;
        List<Long> trackNumberIds;
        List<Long> configuredCodeIds;
        QFilter commonFilters;
        boolean isCalType;
        Long costTypeId = this.stdCostLevelRptParam.getCostTypeId();
        HashSet<Long> costTypeIds = new HashSet<Long>(2);
        costTypeIds.add(costTypeId);
        boolean bl = isCalType = !CostTypePtyEnum.SIMULATED.getValue().equals(this.stdCostLevelRptParam.getQueryType());
        if (!(!isCalType || CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getTrackKeyCols()) && CadEmptyUtils.isEmpty(this.stdCostLevelRptParam.getSrcTrackKeyCols()))) {
            costTypeIds.add(this.stdCostLevelRptParam.getSimCosttypeId());
            commonFilters = new QFilter("costtype", "in", costTypeIds);
        } else {
            commonFilters = new QFilter("costtype", "=", (Object)costTypeId);
        }
        Set<Long> mulMaterialIds = this.stdCostLevelRptParam.getMulMaterialIds();
        QFilter matQf = new QFilter("material", "in", mulMaterialIds);
        commonFilters.and(matQf);
        Set<Long> mulSubMaterialIds = this.stdCostLevelRptParam.getMulSubMaterialIds();
        if (mulSubMaterialIds != null) {
            QFilter subMatQf = null;
            if ("cad_calceffectiveresult".equals(srcEntity) || "cad_calcsimulationresult".equals(srcEntity)) {
                subMatQf = new QFilter("entryentity.submaterial", "in", mulSubMaterialIds);
            } else if ("cad_trackstdcalcresult".equals(srcEntity)) {
                subMatQf = new QFilter("origentryentity.origsubentryentity.origsubmaterial", "in", mulSubMaterialIds);
            }
            if (subMatQf != null) {
                commonFilters.and(subMatQf);
            }
        }
        if (!CadEmptyUtils.isEmpty(configuredCodeIds = this.stdCostLevelRptParam.getConfiguredCodeIds())) {
            commonFilters.and(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = this.stdCostLevelRptParam.getTrackNumberIds())) {
            commonFilters.and(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = this.stdCostLevelRptParam.getProjectNumberIds())) {
            commonFilters.and(new QFilter("projectnumber", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty((String)(lots = this.stdCostLevelRptParam.getLots()))) {
            commonFilters.and(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        return commonFilters;
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        this.logger.info("\u914d\u7f6e\u5217\u662f\u5426\u663e\u793a");
        Iterator<AbstractReportColumn> iterator = cols.iterator();
        Set<String> hidePropSet = this.stdCostLevelRptParam.getShowgroup() != false ? this.groupHideProps : this.hideProps;
        String queryType = this.stdCostLevelRptParam.getQueryType();
        boolean isSimulated = CostTypePtyEnum.SIMULATED.getValue().equals(queryType);
        while (iterator.hasNext()) {
            ReportColumn repCol = (ReportColumn)iterator.next();
            String fieldKey = repCol.getFieldKey();
            if (!isSimulated && this.simProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (fieldKey.equals("parentmat_ref_name")) {
                repCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7236\u9879\u7269\u6599\u540d\u79f0", (String)"StdCostLevelRptSourceCf_1", (String)"macc-cad-report", (Object[])new Object[0])));
            }
            if (isSimulated && !this.stdCostLevelRptParam.getShowSuppier().booleanValue() && this.supplierProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (isSimulated && !this.stdCostLevelRptParam.getShowWorkCenter().booleanValue() && this.workCenterProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (isSimulated && !this.stdCostLevelRptParam.getShowProcessInfo().booleanValue() && this.processInfoProps.contains(fieldKey)) {
                repCol.setHide(true);
            }
            if (hidePropSet.contains(fieldKey)) {
                repCol.setHide(true);
                continue;
            }
            if ("qty".equals(fieldKey) || "baseqty".equals(fieldKey)) {
                repCol.setZeroShow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setScale(10);
                continue;
            }
            if ("price".equals(fieldKey) || "stdprice".equals(fieldKey)) {
                repCol.setFieldType("price");
                repCol.setZeroShow(false);
                repCol.setNoDisplayScaleZero(false);
                repCol.setCurrencyField("currency");
                repCol.setScale(this.stdCostLevelRptParam.getCurrencyPricePrecision());
                continue;
            }
            if (!"level".equals(fieldKey)) continue;
            repCol.setZeroShow(true);
        }
        return cols;
    }
}

