/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.report.queryplugin.stdcostlevel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.macc.cad.algox.utils.BigDecimalUtil;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetXHelper;
import kd.macc.cad.report.queryplugin.stdcostlevel.StdCostLevelRptParam;

public class SupplierDataDetalMap
extends GroupReduceFunction {
    private static final long serialVersionUID = 1L;
    private RowMeta srcMeta;
    private StdCostLevelRptParam stdCostLevelRptParam;

    public SupplierDataDetalMap(RowMeta rowMeta, StdCostLevelRptParam stdCostLevelRptParam) {
        this.srcMeta = rowMeta;
        this.stdCostLevelRptParam = stdCostLevelRptParam;
    }

    public RowMeta getResultRowMeta() {
        return this.sourceRowMeta;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Row row;
        ArrayList<RowX> targetRows = new ArrayList<RowX>(10);
        int quotaratioIndex = this.getSourceRowMeta().getFieldIndex("quotaratio");
        int unitpriceIndex = this.getSourceRowMeta().getFieldIndex("unitprice");
        int qtyIndex = this.getSourceRowMeta().getFieldIndex("qty");
        int priceIndex = this.getSourceRowMeta().getFieldIndex("price");
        int stdpriceIndex = this.getSourceRowMeta().getFieldIndex("stdprice");
        int supplierIndex = this.getSourceRowMeta().getFieldIndex("supplier");
        int supplierNameIndex = this.getSourceRowMeta().getFieldIndex("suppliername");
        int supplierOrderIndex = this.getSourceRowMeta().getFieldIndex("suplierorder");
        RowX rowMax = new RowX(this.srcMeta.getFieldCount());
        DataSet dataset = DataSetXHelper.getDsFromAlgoxRows(iterable, (String[])new String[]{"quotaratio desc"}, (RowMeta)this.srcMeta);
        int count = 0;
        BigDecimal sumStdPrice = BigDecimal.ZERO;
        while (dataset.hasNext()) {
            row = dataset.next();
            RowX rowx = new RowX(this.srcMeta.getFieldCount());
            for (int i = 0; i < this.srcMeta.getFieldCount(); ++i) {
                rowx.set(i, row.get(i));
                if (count != 0) continue;
                rowMax.set(i, row.get(i));
            }
            targetRows.add(rowx);
            ++count;
        }
        if (count == 1 && CadEmptyUtils.isEmpty((Long)rowMax.getLong(this.getSourceRowMeta().getFieldIndex("supplier")))) {
            collector.collect(rowMax);
        } else {
            rowMax.set(supplierIndex, (Object)0L);
            rowMax.set(supplierNameIndex, (Object)"");
            rowMax.set(this.getSourceRowMeta().getFieldIndex("datadealtype"), (Object)1);
            rowMax.set(quotaratioIndex, (Object)BigDecimal.ZERO);
            rowMax.set(unitpriceIndex, (Object)BigDecimal.ZERO);
            sumStdPrice = BigDecimalUtil.getOrZero((Object)rowMax.getBigDecimal(stdpriceIndex));
            collector.collect(rowMax);
            if (targetRows.size() == 1) {
                row = (RowX)targetRows.get(0);
                row.set(supplierOrderIndex, (Object)"1");
                collector.collect((RowX)row);
            } else {
                BigDecimal quotaratio;
                BigDecimal stdPriceTotal = BigDecimal.ZERO;
                ArrayList<RowX> smallRows = new ArrayList<RowX>(10);
                RowX rowxTemp = (RowX)targetRows.get(0);
                for (RowX rowx : targetRows) {
                    Long supplierRowMax = rowxTemp.getLong(this.getSourceRowMeta().getFieldIndex("supplier"));
                    Long supplierRowx = rowx.getLong(this.getSourceRowMeta().getFieldIndex("supplier"));
                    if (supplierRowMax == null || supplierRowMax.compareTo(supplierRowx) == 0) continue;
                    BigDecimal quotaratio2 = BigDecimalUtil.getOrZero((Object)rowx.getBigDecimal(quotaratioIndex));
                    BigDecimal unitprice = BigDecimalUtil.getOrZero((Object)rowx.getBigDecimal(unitpriceIndex));
                    BigDecimal qty = BigDecimalUtil.getOrZero((Object)rowx.getBigDecimal(qtyIndex));
                    if (quotaratio2.compareTo(BigDecimal.ZERO) > 0 && unitprice.compareTo(BigDecimal.ZERO) > 0) {
                        rowx.set(priceIndex, (Object)quotaratio2.divide(BigDecimal.valueOf(100L)).multiply(unitprice));
                        BigDecimal stdprice = qty.multiply(quotaratio2.divide(BigDecimal.valueOf(100L)).multiply(unitprice)).setScale(this.stdCostLevelRptParam.getCurrencyPricePrecision(), RoundingMode.HALF_UP);
                        stdPriceTotal = stdPriceTotal.add(stdprice);
                        rowx.set(stdpriceIndex, (Object)stdprice);
                    }
                    smallRows.add(rowx);
                }
                BigDecimal diff = sumStdPrice.subtract(stdPriceTotal);
                BigDecimal qty = BigDecimalUtil.getOrZero((Object)rowxTemp.getBigDecimal(qtyIndex));
                BigDecimal amt = qty.multiply((quotaratio = BigDecimalUtil.getOrZero((Object)rowxTemp.getBigDecimal(quotaratioIndex))).divide(BigDecimal.valueOf(100L)));
                BigDecimal unitprice = amt.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : diff.divide(qty.multiply(quotaratio.divide(BigDecimal.valueOf(100L))), this.stdCostLevelRptParam.getCurrencyPricePrecision(), RoundingMode.HALF_UP);
                rowxTemp.set(unitpriceIndex, (Object)unitprice);
                rowxTemp.set(stdpriceIndex, (Object)diff);
                rowxTemp.set(priceIndex, (Object)quotaratio.divide(BigDecimal.valueOf(100L)).multiply(unitprice));
                rowxTemp.set(supplierOrderIndex, (Object)"1");
                collector.collect(rowxTemp);
                for (RowX row2 : smallRows) {
                    row2.set(supplierOrderIndex, (Object)"2");
                    collector.collect(row2);
                }
            }
        }
    }
}

