/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.base;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.bos.id.ID;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.DBServiceHelper;
import kd.macc.cad.common.dto.CollectReport;

public class CollectReportContext {
    private CollectReport collectReport;
    private boolean singleSelected = false;
    private boolean isValidate = false;
    public Map<String, String> billNoReasonMap = Maps.newHashMapWithExpectedSize((int)8);
    public Map<String, String> billNoSuggestMap = Maps.newHashMapWithExpectedSize((int)8);

    public CollectReport getCollectReport() {
        if (this.collectReport == null) {
            this.collectReport = new CollectReport();
            this.collectReport.setId(DBServiceHelper.genGlobalLongId());
            this.collectReport.setBillNo(ID.genStringId());
            this.collectReport.setBillStatus("A");
        }
        return this.collectReport;
    }

    public Map<String, String> getErrorInfMap() {
        return this.billNoReasonMap;
    }

    public void logSuggestMsg(String key, String suggest) {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)suggest)) {
            return;
        }
        if (this.billNoSuggestMap.containsKey(key)) {
            String suggestMsg = this.billNoSuggestMap.get(key);
            String allSuggest = suggestMsg.concat("\uff1b").concat(suggest);
            this.billNoSuggestMap.put(key, allSuggest);
        } else {
            this.billNoSuggestMap.put(key, suggest);
        }
    }

    public Map<String, String> getBillNoSuggestMap() {
        return this.billNoSuggestMap;
    }

    public void logErrorMsg(String key, String msg) {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)msg)) {
            return;
        }
        if (this.billNoReasonMap.containsKey(key)) {
            String errorMsg = this.billNoReasonMap.get(key);
            String allMsg = errorMsg.concat("\uff1b").concat(msg);
            this.billNoReasonMap.put(key, allMsg);
        } else {
            this.billNoReasonMap.put(key, msg);
        }
    }

    public boolean isSingleSelected() {
        return this.singleSelected;
    }

    public void setSingleSelected(boolean singleSelected) {
        this.singleSelected = singleSelected;
    }

    public boolean isValidate() {
        return this.isValidate;
    }

    public void setValidate(boolean validate) {
        this.isValidate = validate;
    }
}

