/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.check.SingleCalcCheckContext;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.LogUtils;
import kd.macc.cad.common.utils.TimeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSingleCalcCheckAction
extends AbstractCalcCheckAction {
    private final Log logger = LogFactory.getLog(AbstractSingleCalcCheckAction.class);
    private SingleCalcCheckContext singleCheckContext;
    private final String CHECK_EXP_ERRORMESSAGE = ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u7684\u63d2\u4ef6\u4f7f\u7528\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractSingleCalcCheckAction_2", (String)"macc-cad-common", (Object[])new Object[0]);

    @Override
    protected void doExecute() {
        Date startTime = TimeServiceHelper.now();
        if (!"cad_stdcalcnew".equals(this.getContext().getTaskType())) {
            this.upateTaskRecordDetail(this.getContext().getTaskId(), this.getSingleCheckContext().getItemId(), "2");
        }
        String errorInfo = null;
        try {
            if (!this.skipCheck()) {
                this.doCheck();
            }
        }
        catch (Exception exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(exp);
            int count = 0;
            for (StackTraceElement stackTraceElement : exp.getStackTrace()) {
                sb.append("\n").append(stackTraceElement.toString());
                if (++count > 30) break;
            }
            errorInfo = sb.toString();
            this.logger.error("\u5408\u6cd5\u6027\u68c0\u67e5\u5f02\u5e38\u3002", (Throwable)exp);
        }
        LogUtils.logInfo(this.getSingleCheckContext().getItemName(), this.logger, String.format(ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5\uff1a%1$s,\u8017\u65f6:%2$s\u3002", (String)"AbstractSingleCalcCheckAction_1", (String)"macc-cad-common", (Object[])new Object[0]), this.getSingleCheckContext().getItemId(), TimeUtils.getSecond(startTime, TimeServiceHelper.now())));
        boolean isPass = this.getSingleCheckContext().isPass();
        this.dealCheckResult(this.getContext(), this.getSingleCheckContext(), errorInfo, isPass, startTime);
        if ("cad_stdcalcnew".equals(this.getContext().getTaskType())) {
            this.updateStandCalcProgress(this.getContext().getTaskId(), this.getSingleCheckContext().getUnitProcess());
        } else {
            this.upateTaskRecord(this.getContext().getTaskId(), this.getSingleCheckContext().getUnitProcess(), "2");
            if (this.skipCheck()) {
                this.upateTaskRecordDetail(this.getContext().getTaskId(), this.getSingleCheckContext().getItemId(), "1");
            } else {
                this.upateTaskRecordDetail(this.getContext().getTaskId(), this.getSingleCheckContext().getItemId(), "4");
            }
        }
    }

    private void dealCheckResult(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, String errorInfo, Boolean isPass, Date startTime) {
        String taskType;
        switch (taskType = this.getContext().getTaskType()) {
            case "cad_stdcalcnew": {
                this.dealStandCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.dealStandCalcCheckResultDetail(context, singleCheckContext, singleCheckContext.getCheckDetailResult());
                break;
            }
            case "cad_costupdatenew": {
                this.dealStandCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.dealStandCalcCheckResultDetail(context, singleCheckContext, singleCheckContext.getCheckDetailResult());
                break;
            }
            case "sca_finishcalwizards": 
            case "sca_realtimefinishcal": {
                Long entryId = this.dealFinishAndWipCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.setFinishAndWipCalcCheckResultDetail(entryId, context, singleCheckContext.getCheckDetailResult());
                break;
            }
            case "sca_wipcalwizards": {
                Long entryId = this.dealFinishAndWipCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.setFinishAndWipCalcCheckResultDetail(entryId, context, singleCheckContext.getCheckDetailResult());
                break;
            }
            case "sca_differencecalcwizards": {
                Long entryId = this.dealDiffCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.setDiffCalcCheckResultDetail(entryId, context, singleCheckContext.getCheckDetailResult());
                break;
            }
            case "sca_factcostreduction": {
                Long entryId = this.dealReductCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.setReductCalcCheckResultDetail(entryId, context, singleCheckContext.getCheckDetailResult());
                break;
            }
            case "aca_terminalcalwizards": {
                Long entryId = this.dealTerminalCalcCheckResult(context, singleCheckContext, errorInfo, startTime, isPass);
                if (isPass.booleanValue() || CadEmptyUtils.isEmpty(singleCheckContext.getCheckDetailResult())) break;
                this.setTerminalCalcCheckResultDetail(entryId, context, singleCheckContext.getCheckDetailResult());
                break;
            }
        }
    }

    protected void dealStandCalcCheckResult(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, String errorInfo, Date startTime, boolean isPass) {
        DynamicObject taskRecord;
        QFilter taskFilter;
        QFilter checkItmeFilter = new QFilter("checkitem", "=", (Object)singleCheckContext.getItemId());
        DynamicObject checkResult = QueryServiceHelper.queryOne((String)"cad_calccheckresult", (String)"id", (QFilter[])new QFilter[]{checkItmeFilter, taskFilter = new QFilter("calctaskrecord", "=", (Object)context.getCheckResultId())});
        if (checkResult != null) {
            DeleteServiceHelper.delete((String)"cad_calccheckresult", (QFilter[])new QFilter[]{checkItmeFilter, taskFilter});
        }
        checkResult = BusinessDataServiceHelper.newDynamicObject((String)"cad_calccheckresult");
        checkResult.set("createtime", (Object)new Date());
        checkResult.set("costtype", (Object)context.getCostTypeId());
        checkResult.set("calctaskrecord", (Object)context.getCheckResultId());
        checkResult.set("checkitem", (Object)singleCheckContext.getItemId());
        if (errorInfo != null && !CadEmptyUtils.isEmpty(errorInfo)) {
            checkResult.set("checkresult", (Object)"2");
            checkResult.set("checkresultdesc", (Object)(errorInfo.length() > 255 ? errorInfo.substring(0, 255) : errorInfo));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
            return;
        }
        checkResult.set("checkresult", (Object)(isPass ? "0" : singleCheckContext.getCheckLevel()));
        if (!isPass) {
            checkResult.set("checkresultdesc", (Object)singleCheckContext.getCheckResult());
            if ("1".equals(singleCheckContext.getCheckLevel())) {
                context.setRemindCount(context.getRemindCount() + 1L);
            }
            if ("2".equals(singleCheckContext.getCheckLevel())) {
                context.setFailCount(context.getFailCount() + 1L);
            }
        } else {
            checkResult.set("checkresultdesc", (Object)"");
        }
        checkResult.set("calctime", (taskRecord = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_calctaskrecord", (String)"starttime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)context.getCheckResultId())})) == null ? null : taskRecord.getDate("starttime"));
        long time = TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now());
        checkResult.set("cnsmtime", (Object)(time == 0L ? 1L : time));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }

    protected void dealStandCalcCheckResultDetail(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, List<CalcCheckDetailResultInfo> detailDesc) {
        QFilter checkItmeFilter = new QFilter("checkitem", "=", (Object)singleCheckContext.getItemId());
        QFilter taskFilter = new QFilter("calctaskrecord", "=", (Object)context.getCheckResultId());
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((String)"cad_calccheckresult", (String)"entryentity.seq,entryentity.errordesc,entryentity.suggest", (QFilter[])new QFilter[]{checkItmeFilter, taskFilter});
        DynamicObjectCollection checkRsDetails = checkResult.getDynamicObjectCollection("entryentity");
        int index = 0;
        for (CalcCheckDetailResultInfo info : detailDesc) {
            DynamicObject detailInfo = checkRsDetails.addNew();
            detailInfo.set("seq", (Object)(index + 1));
            String checkDetailResult = info.getCheckDetailResult();
            detailInfo.set("errordesc", (Object)(checkDetailResult.length() > 2000 ? checkDetailResult.substring(0, 2000) : checkDetailResult));
            detailInfo.set("suggest", (Object)singleCheckContext.getItemOpSuggest());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
    }

    protected Long dealFinishAndWipCalcCheckResult(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, String errorInfo, Date startTime, boolean isPass) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)context.getCheckResultId(), (String)"sca_calcreport");
        String checkItemLevel = singleCheckContext.getCheckLevel();
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entrys.addNew();
        Long entryId = DBServiceHelper.genGlobalLongId();
        entry.set("id", (Object)entryId);
        entry.set("seq", (Object)entrys.size());
        entry.set("detailstep", (Object)singleCheckContext.getItemName());
        if (errorInfo != null && !CadEmptyUtils.isEmpty(errorInfo)) {
            entry.set("dtstatus", (Object)"3");
            entry.set("errlog", (Object)this.CHECK_EXP_ERRORMESSAGE);
            entry.set("tip", (Object)StringUtils.substring((String)errorInfo, (int)0, (int)500));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
            return entryId;
        }
        String noPassStatus = null;
        if (isPass) {
            entry.set("dtstatus", (Object)"5");
        } else {
            if ("1".equals(checkItemLevel)) {
                noPassStatus = "7";
                context.setRemindCount(context.getRemindCount() + 1L);
            }
            if ("2".equals(checkItemLevel)) {
                noPassStatus = "6";
                context.setFailCount(context.getFailCount() + 1L);
            }
            entry.set("dtstatus", (Object)noPassStatus);
            entry.set("errlog", (Object)StringUtils.substring((String)singleCheckContext.getCheckResult(), (int)0, (int)500));
            entry.set("tip", (Object)StringUtils.substring((String)singleCheckContext.getItemOpSuggest(), (int)0, (int)500));
        }
        long time = TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now());
        entry.set("cnsmtime", (Object)(time == 0L ? 1L : time));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
        return entryId;
    }

    protected void setFinishAndWipCalcCheckResultDetail(Long entryId, CalcCheckContext context, List<CalcCheckDetailResultInfo> detailDesc) {
        DynamicObject newEntry;
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)context.getCheckResultId(), (String)"sca_calcreport");
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkdetail");
        checkDetail.set("id", (Object)entryId);
        checkDetail.set("org", checkResult.get("accountorg"));
        checkDetail.set("costaccount", checkResult.get("costaccount"));
        checkDetail.set("period", checkResult.get("period"));
        checkDetail.set("currency", checkResult.get("currency"));
        DynamicObjectCollection costCenter = checkResult.getDynamicObjectCollection("costcenter");
        if (costCenter.size() > 0) {
            DynamicObjectCollection needCenter = checkDetail.getDynamicObjectCollection("costcenter");
            for (DynamicObject center : costCenter) {
                newEntry = needCenter.addNew();
                newEntry.set("fbasedataid", (Object)center.getDynamicObject("fbasedataid"));
                newEntry.set("fbasedataid_id", (Object)center.getLong("fbasedataid_id"));
            }
        }
        checkDetail.set("calcdate", checkResult.get("starttime"));
        checkDetail.set("checkitemdesc", (Object)this.getSingleCheckContext().getItemName());
        DynamicObjectCollection detailentry = checkDetail.getDynamicObjectCollection("entryentity");
        for (CalcCheckDetailResultInfo resultInfo : detailDesc) {
            newEntry = detailentry.addNew();
            newEntry.set("entrycostcenter", (Object)resultInfo.getCostCenter());
            if (StringUtils.isEmpty((CharSequence)resultInfo.getCheckDetailResult()) || resultInfo.getCheckDetailResult().length() < 1000) {
                newEntry.set("checkdetail", (Object)resultInfo.getCheckDetailResult());
                continue;
            }
            newEntry.set("checkdetail", (Object)(resultInfo.getCheckDetailResult().substring(0, 500) + "..."));
            newEntry.set("bigtext_tag", (Object)resultInfo.getCheckDetailResult());
        }
        if (detailentry.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
    }

    protected Long dealDiffCalcCheckResult(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, String errorInfo, Date startTime, boolean ispass) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)context.getCheckResultId(), (String)"sca_restore_calcreport");
        String checkItemLevel = singleCheckContext.getCheckLevel();
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        Long entryId = DBServiceHelper.genGlobalLongId();
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)entryId);
        entry.set("seq", (Object)entrys.size());
        entry.set("item", (Object)singleCheckContext.getItemName());
        if (errorInfo != null && !CadEmptyUtils.isEmpty(errorInfo)) {
            entry.set("result", (Object)"3");
            entry.set("checkdesc", (Object)this.CHECK_EXP_ERRORMESSAGE);
            entry.set("bigtext_tag", (Object)errorInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
            return entryId;
        }
        String noPassStatus = null;
        if (ispass) {
            entry.set("result", (Object)"5");
        } else {
            if ("1".equals(checkItemLevel)) {
                noPassStatus = "7";
                context.setRemindCount(context.getRemindCount() + 1L);
            }
            if ("2".equals(checkItemLevel)) {
                noPassStatus = "6";
                context.setFailCount(context.getFailCount() + 1L);
            }
            entry.set("result", (Object)noPassStatus);
            entry.set("checkdesc", (Object)singleCheckContext.getCheckResult());
            if (singleCheckContext.getCheckResult().length() > 1000) {
                entry.set("bigtext_tag", (Object)singleCheckContext.getCheckResult());
            } else {
                entry.set("bigtext_tag", (Object)singleCheckContext.getItemOpSuggest());
            }
        }
        long time = TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now());
        BigDecimal sortTime = new BigDecimal(time == 0L ? 1L : time).divide(new BigDecimal(1000), 2, 4);
        entry.set("cnsmtime", (Object)sortTime.toString());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
        return entryId;
    }

    protected void setDiffCalcCheckResultDetail(Long entryId, CalcCheckContext context, List<CalcCheckDetailResultInfo> detailDesc) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)context.getCheckResultId(), (String)"sca_restore_calcreport");
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_checkreportdetail");
        checkDetail.set("id", (Object)entryId);
        checkDetail.set("org", checkResult.get("org"));
        checkDetail.set("costaccount", checkResult.get("costaccount"));
        checkDetail.set("period", checkResult.get("period"));
        checkDetail.set("currency", checkResult.get("currency"));
        checkDetail.set("calcdate", checkResult.get("calcdate"));
        checkDetail.set("item", (Object)this.getSingleCheckContext().getItemName());
        DynamicObjectCollection detailentry = checkDetail.getDynamicObjectCollection("entryentity");
        for (CalcCheckDetailResultInfo resultInfo : detailDesc) {
            DynamicObject newEntry = detailentry.addNew();
            newEntry.set("entrycostcenter", (Object)resultInfo.getCostCenter());
            newEntry.set("checkdetail", (Object)resultInfo.getCheckDetailResult());
        }
        if (detailentry.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
    }

    protected Long dealReductCalcCheckResult(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, String errorInfo, Date startTime, boolean ispass) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)context.getCheckResultId(), (String)"sca_reductreport");
        String checkItemLevel = singleCheckContext.getCheckLevel();
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        Long entryId = DBServiceHelper.genGlobalLongId();
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)entryId);
        entry.set("seq", (Object)entrys.size());
        entry.set("item", (Object)singleCheckContext.getItemName());
        if (errorInfo != null && !CadEmptyUtils.isEmpty(errorInfo)) {
            entry.set("result", (Object)"3");
            entry.set("checkdesc", (Object)this.CHECK_EXP_ERRORMESSAGE);
            entry.set("bigtext_tag", (Object)errorInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
            return entryId;
        }
        String noPassStatus = null;
        if (ispass) {
            entry.set("result", (Object)"5");
        } else {
            if ("1".equals(checkItemLevel)) {
                noPassStatus = "7";
                context.setRemindCount(context.getRemindCount() + 1L);
            }
            if ("2".equals(checkItemLevel)) {
                noPassStatus = "6";
                context.setFailCount(context.getFailCount() + 1L);
            }
            entry.set("result", (Object)noPassStatus);
            entry.set("checkdesc", (Object)singleCheckContext.getCheckResult());
            entry.set("bigtext_tag", (Object)singleCheckContext.getItemOpSuggest());
        }
        long time = TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now());
        entry.set("cnsmtime", (Object)(time == 0L ? 1L : time));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
        return entryId;
    }

    protected void setReductCalcCheckResultDetail(Long entryId, CalcCheckContext context, List<CalcCheckDetailResultInfo> detailDesc) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingle((Object)context.getCheckResultId(), (String)"sca_reductreport");
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"sca_reductcheckdetail");
        checkDetail.set("id", (Object)entryId);
        checkDetail.set("org", checkResult.get("org"));
        checkDetail.set("costaccount", checkResult.get("costaccount"));
        checkDetail.set("period", checkResult.get("period"));
        checkDetail.set("prodorg", checkResult.get("prdorg"));
        checkDetail.set("calcdate", checkResult.get("starttime"));
        checkDetail.set("item", (Object)this.getSingleCheckContext().getItemId());
        checkDetail.set("currency", checkResult.get("org"));
        checkDetail.set("checkitemdesc", (Object)this.getSingleCheckContext().getItemName());
        DynamicObjectCollection detailentry = checkDetail.getDynamicObjectCollection("entryentity");
        for (CalcCheckDetailResultInfo resultInfo : detailDesc) {
            DynamicObject newEntry = detailentry.addNew();
            newEntry.set("checkdetail", (Object)resultInfo.getCheckDetailResult());
        }
        if (detailentry.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
    }

    protected Long dealTerminalCalcCheckResult(CalcCheckContext context, SingleCalcCheckContext singleCheckContext, String errorInfo, Date startTime, boolean isPass) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getContext().getCheckResultId(), (String)"aca_calcreport");
        DynamicObjectCollection entrys = checkResult.getDynamicObjectCollection("entryentity");
        String checkLevel = singleCheckContext.getCheckLevel();
        long entryId = DB.genGlobalLongId();
        DynamicObject entry = entrys.addNew();
        entry.set("id", (Object)entryId);
        entry.set("seq", (Object)entrys.size());
        entry.set("item", (Object)singleCheckContext.getItemName());
        if (errorInfo != null && !CadEmptyUtils.isEmpty(errorInfo)) {
            entry.set("result", (Object)"3");
            entry.set("checkdesc", (Object)this.CHECK_EXP_ERRORMESSAGE);
            entry.set("bigtext_tag", (Object)errorInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
            return entryId;
        }
        String noPassStatus = null;
        if (isPass) {
            entry.set("result", (Object)"5");
        } else {
            if ("1".equals(checkLevel)) {
                noPassStatus = "7";
                context.setRemindCount(context.getRemindCount() + 1L);
            }
            if ("2".equals(checkLevel)) {
                noPassStatus = "6";
                context.setFailCount(context.getFailCount() + 1L);
            }
            entry.set("result", (Object)noPassStatus);
            if (singleCheckContext.getCheckResult() != null && singleCheckContext.getCheckResult().length() > 250) {
                entry.set("checkdesc", (Object)(singleCheckContext.getCheckResult().substring(0, 250) + "..."));
                entry.set("bigtext_tag", (Object)(singleCheckContext.getItemOpSuggest() + "\n" + singleCheckContext.getCheckResult()));
            } else {
                entry.set("checkdesc", (Object)singleCheckContext.getCheckResult());
                entry.set("bigtext_tag", (Object)singleCheckContext.getItemOpSuggest());
            }
            if (context.getFailCount() > 0L) {
                checkResult.set("type", (Object)"3");
            } else if (context.getRemindCount() > 0L) {
                checkResult.set("type", (Object)"5");
            } else {
                checkResult.set("type", (Object)"4");
            }
        }
        long time = TimeUtils.getMilliSecond(startTime, TimeServiceHelper.now());
        entry.set("cnsmtime", (Object)(time == 0L ? 1L : time));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResult});
        return entryId;
    }

    protected void setTerminalCalcCheckResultDetail(Long entryId, CalcCheckContext context, List<CalcCheckDetailResultInfo> detailDesc) {
        DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getContext().getCheckResultId(), (String)"aca_calcreport");
        DynamicObject checkDetail = BusinessDataServiceHelper.newDynamicObject((String)"aca_calcreportdetail");
        checkDetail.set("id", (Object)entryId);
        checkDetail.set("org", (Object)context.getOrgId());
        checkDetail.set("costaccount", (Object)context.getCostAccountId());
        checkDetail.set("period", (Object)context.getPeriodId());
        checkDetail.set("currency", (Object)context.getCurrencyId());
        checkDetail.set("calcdate", checkResult.get("calcdate"));
        checkDetail.set("checkitemdesc", (Object)this.getSingleCheckContext().getItemName());
        DynamicObjectCollection detailentry = checkDetail.getDynamicObjectCollection("entryentity");
        int i = 1;
        for (CalcCheckDetailResultInfo resultInfo : detailDesc) {
            DynamicObject newEntry = detailentry.addNew();
            newEntry.set("seq", (Object)i++);
            newEntry.set("entrycostcenter", (Object)resultInfo.getCostCenter());
            newEntry.set("checkdetail", (Object)resultInfo.getCheckDetailResult());
        }
        if (detailentry.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkDetail});
        }
    }

    protected abstract void doCheck();

    protected boolean skipCheck() {
        return false;
    }

    public SingleCalcCheckContext getSingleCheckContext() {
        return this.singleCheckContext;
    }

    public void setSingleCheckContext(SingleCalcCheckContext singleCheckContext) {
        this.singleCheckContext = singleCheckContext;
    }

    protected void upateTaskRecord(Long taskId, int mProgess, String status) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"id,progress,time,starttime,status", (QFilter[])new QFilter[]{filter});
        if (record == null) {
            return;
        }
        long totalProgress = record.getLong("progress") + (long)mProgess;
        this.logger.info("\u66f4\u65b0\u524d\u8fdb\u5ea6\uff1a" + totalProgress);
        if (totalProgress < 100L) {
            record.set("progress", (Object)totalProgress);
        } else if (mProgess == 100) {
            record.set("progress", (Object)100);
            this.logger.info("\u5355\u6b21\u66f4\u65b0\u8fdb\u5ea6100\uff1a\u8ba1\u7b97\u7ed3\u675f" + totalProgress);
        } else {
            record.set("progress", (Object)99);
        }
        record.set("time", (Object)TimeUtils.getSecond(record.getDate("starttime"), new Date()));
        record.set("status", (Object)status);
        SaveServiceHelper.update((DynamicObject)record);
        this.logger.info("\u672c\u6b21\u66f4\u65b0\u8fdb\u5ea6\uff1a" + mProgess);
    }

    protected void upateTaskRecordDetail(Long taskId, Long taskDetailId, String status) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime", (QFilter[])new QFilter[]{filter});
        if (record == null) {
            return;
        }
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
            entry.set("substatus", (Object)status);
            if ("2".equals(status)) {
                entry.set("substarttime", (Object)TimeServiceHelper.now());
            }
            if ("4".equals(status)) {
                long oldTime = entry.getLong("subtime");
                Long subTime = TimeUtils.getMilliSecond(entry.getDate("substarttime"), TimeServiceHelper.now());
                entry.set("subtime", (Object)(subTime + oldTime));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    protected void updateStandCalcProgress(Long taskid, int progress) {
        QFilter idFilter = new QFilter("id", "=", (Object)taskid);
        DynamicObject taskrecord = BusinessDataServiceHelper.loadSingle((String)"cad_calctaskrecord", (String)"id,progress,status,starttime,time", (QFilter[])new QFilter[]{idFilter});
        if (taskrecord == null) {
            return;
        }
        if (progress >= 100) {
            taskrecord.set("progress", (Object)100);
            taskrecord.set("status", (Object)3);
        } else if (progress < 0) {
            taskrecord.set("progress", (Object)0);
        } else {
            taskrecord.set("progress", (Object)(taskrecord.getInt("progress") + progress));
        }
        long time = TimeUtils.getSecond(taskrecord.getDate("starttime"), new Date());
        taskrecord.set("time", (Object)(time <= 0L ? 1L : time));
        SaveServiceHelper.update((DynamicObject)taskrecord);
    }

    public QFilter getCheckCostobjectQFilter(CalcCheckContext context, String fieldName) {
        if (context.getParams().containsKey("checkCostobjectIds")) {
            return new QFilter(fieldName, "in", context.getParams().get("checkCostobjectIds"));
        }
        return QFilter.of((String)"1=1", null);
    }

    protected DynamicObject[] getUnAuditCollectBills(String entityName, CalcCheckContext context) {
        return this.getUnAuditCollectBills(entityName, context, null);
    }

    protected DynamicObject[] getUnAuditCollectBills(String entityName, CalcCheckContext context, QFilter filter) {
        IDataEntityProperty costAccount;
        MainEntityType entityType;
        IDataEntityProperty appnum;
        String bizDateFieldName = "bookdate";
        String orgFieldName = "org";
        String costCenterFieldName = "costcenter";
        String selectFields = "billno,costcenter,billstatus";
        switch (entityName) {
            case "cad_plannedoutputbill": {
                orgFieldName = "accountorg";
                bizDateFieldName = "bizdate";
            }
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("billstatus", "in", (Object)new String[]{"A", "B"}));
        filters.add(new QFilter(bizDateFieldName, ">=", (Object)context.getPeriodStartDate()));
        filters.add(new QFilter(bizDateFieldName, "<=", (Object)context.getPeriodEndDate()));
        filters.add(new QFilter(orgFieldName, "=", (Object)context.getOrgId()));
        if (!CadEmptyUtils.isEmpty(context.getCostCenterIds())) {
            filters.add(new QFilter(costCenterFieldName, "in", context.getCostCenterIds()));
        }
        if (!CadEmptyUtils.isEmpty(context.getManuOrgIds())) {
            filters.add(new QFilter("manuorg", "in", context.getManuOrgIds()));
        }
        if ((appnum = (entityType = MetadataServiceHelper.getDataEntityType((String)entityName)).findProperty("appnum")) != null) {
            filters.add(new QFilter("appnum", "=", (Object)context.getAppNum()));
        }
        if ((costAccount = entityType.findProperty("costaccount")) != null && !"cad_factnedoutputbill".equals(entityName)) {
            filters.add(new QFilter("costaccount", "=", (Object)context.getCostAccountId()));
        }
        if (filter != null) {
            filters.add(filter);
        }
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
    }

    protected DynamicObject[] getUnConfirmAllocBills(String entityName, CalcCheckContext context) {
        return this.getUnConfirmAllocBills(entityName, context, null);
    }

    protected DynamicObject[] getUnConfirmAllocBills(String entityName, CalcCheckContext context, QFilter filter) {
        QFilter commonFilter = this.getCommonOrgCostAccountFilter(context);
        String selectFields = "billno,costcenter";
        if ("cad_mfgfeeallocco".equals(entityName)) {
            selectFields = "billno,benefcostcenter";
            if (!CadEmptyUtils.isEmpty(context.getCostCenterIds())) {
                commonFilter.and(new QFilter("benefcostcenter", "in", context.getCostCenterIds()));
            }
        } else if (!CadEmptyUtils.isEmpty(context.getCostCenterIds())) {
            commonFilter.and(new QFilter("costcenter", "in", context.getCostCenterIds()));
        }
        if (filter != null) {
            commonFilter.and(filter);
        }
        QFilter statusFilter = new QFilter("allocstatus", "!=", (Object)"2");
        DataSet ds = QueryServiceHelper.queryDataSet((String)"filename", (String)entityName, (String)"id", (QFilter[])new QFilter[]{commonFilter, statusFilter}, null);
        HashSet<Long> ids = new HashSet<Long>(10);
        for (Row row : ds) {
            ids.add(row.getLong("id"));
            if (ids.size() <= 10000) continue;
            break;
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])idFilter.toArray());
    }

    protected Date[] getPeriodStartAndEndTime(Long periodId) {
        ArrayList<String> selectFields = new ArrayList<String>(2);
        selectFields.add("begindate");
        selectFields.add("enddate");
        MainEntityType type = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"bd_period", selectFields);
        Map periods = BusinessDataServiceHelper.loadFromCache((Object[])new Object[]{periodId}, (DynamicObjectType)type);
        if (CadEmptyUtils.isEmpty(periods)) {
            return null;
        }
        DynamicObject period = (DynamicObject)periods.get(periodId);
        if (period == null) {
            return null;
        }
        Date[] dates = new Date[]{period.getDate("begindate"), period.getDate("enddate")};
        return dates;
    }

    protected Map<String, Date> getDateByCostAccount(Long orgId, Long costAccount, Long periodId) {
        HashMap<String, Date> date = new HashMap<String, Date>();
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("entry.costaccount", "=", (Object)costAccount);
        QFilter qfIsEnabled = new QFilter("entry.isenabled", "=", (Object)true);
        DynamicObject sysCtrlEntity = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.calpolicy.periodtype.id periodtypeid", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfIsEnabled});
        if (sysCtrlEntity == null || sysCtrlEntity.get("periodtypeid") == null) {
            return date;
        }
        QFilter qfId = new QFilter("id", "=", (Object)periodId);
        QFilter qfPeriodType = new QFilter("periodtype", "=", (Object)sysCtrlEntity.getLong("periodtypeid"));
        DynamicObject period = QueryServiceHelper.queryOne((String)"bd_period", (String)"begindate,enddate", (QFilter[])new QFilter[]{qfId, qfPeriodType});
        if (period == null || period.get("begindate") == null || period.get("enddate") == null) {
            return date;
        }
        date.put("begindate", period.getDate("begindate"));
        date.put("enddate", period.getDate("enddate"));
        return date;
    }

    protected QFilter getCommonFilter(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)context.getCostAccountId()));
        filter.and(new QFilter("period", "=", (Object)context.getPeriodId()));
        if (context.getCostCenterIds() != null && context.getCostCenterIds().size() > 0) {
            filter.and(new QFilter("costcenter", "in", context.getCostCenterIds()));
        }
        if (context.getManuOrgIds() != null && context.getManuOrgIds().size() > 0) {
            filter.and(new QFilter("manuorg", "in", context.getManuOrgIds()));
        }
        return filter;
    }

    protected QFilter getCommonOrgCostAccountFilter(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and(new QFilter("costaccount", "=", (Object)context.getCostAccountId()));
        filter.and(new QFilter("period", "=", (Object)context.getPeriodId()));
        if (context.getManuOrgIds() != null && context.getManuOrgIds().size() > 0) {
            filter.and(new QFilter("manuorg", "in", context.getManuOrgIds()));
        }
        return filter;
    }

    protected QFilter getSpecialOrgCostCenterFilter(Long orgId, List<Long> costCenterIds, List<Long> manuOrgIds) {
        QFilter filter = new QFilter("accountorg", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            filter.and(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            filter.and(new QFilter("manuorg", "in", manuOrgIds));
        }
        return filter;
    }

    protected QFilter getOrgCostCenterFilter(Long orgId, List<Long> costCenters, List<Long> manuOrgs) {
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(costCenters)) {
            filter.and(new QFilter("costcenter", "in", costCenters));
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            filter.and(new QFilter("manuorg", "in", manuOrgs));
        }
        return filter;
    }

    protected QFilter getOrgCostAccountFilter(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and(new QFilter("costaccount", "in", (Object)context.getCostAccountId()));
        if (!CadEmptyUtils.isEmpty(context.getManuOrgIds())) {
            filter.and(new QFilter("manuorg", "in", context.getManuOrgIds()));
        }
        return filter;
    }

    protected QFilter getOrgAndManuOrgFilter(CalcCheckContext context) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        if (!CadEmptyUtils.isEmpty(context.getManuOrgIds())) {
            filter.and(new QFilter("manuorg", "in", context.getManuOrgIds()));
        }
        return filter;
    }
}

