/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.check;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.SingleCalcCheckContext;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;

public class CalcCheckHelper {
    private static final Log logger = LogFactory.getLog(CalcCheckHelper.class);

    public static List<AbstractCalcCheckAction> getCheckActionList(CalcCheckContext calcCheckContext, List<Long> checkItemList, String calcType, String appnum) {
        ArrayList<AbstractCalcCheckAction> actions = new ArrayList<AbstractCalcCheckAction>(10);
        DynamicObjectCollection checkItems = CalcCheckHelper.getCheckItems(calcType, checkItemList, appnum);
        if (CadEmptyUtils.isEmpty(checkItems)) {
            return actions;
        }
        int progress = 0;
        progress = calcCheckContext.getCheckMode() == 1 ? (int)Math.ceil(100.0 / (double)checkItems.size()) : (int)Math.ceil(30.0 / (double)checkItems.size());
        for (int index = 0; index < checkItems.size(); ++index) {
            DynamicObject checkItem = (DynamicObject)checkItems.get(index);
            String policyclass = checkItem.getString("plugin");
            try {
                Class<?> checkerClass = null;
                try {
                    checkerClass = Class.forName(policyclass);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Throwable)e);
                }
                if (checkerClass == null) continue;
                AbstractSingleCalcCheckAction checker = (AbstractSingleCalcCheckAction)checkerClass.newInstance();
                SingleCalcCheckContext singleContext = new SingleCalcCheckContext();
                singleContext.setUnitProcess(progress);
                singleContext.setItemId(checkItem.getLong("checkitemid"));
                singleContext.setItemName(checkItem.getString("checkitem"));
                singleContext.setCheckLevel(checkItem.getString("level"));
                singleContext.setItemOpSuggest(checkItem.getString("opsuggestion"));
                singleContext.setItemDesc(checkItem.getString("description"));
                singleContext.setItemErrorlog(checkItem.getString("errorlog"));
                singleContext.setBizObject(checkItem.getString("bizobject"));
                singleContext.setCustomFilter(checkItem.getString("customfilter"));
                checker.setContext(calcCheckContext);
                checker.setSingleCheckContext(singleContext);
                actions.add(checker);
                continue;
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return actions;
    }

    public static DynamicObjectCollection getCheckItems(String calcType, List<Long> checkItemList, String appnum) {
        QFilter filter = new QFilter("caltype", "=", (Object)calcType);
        if (!CadEmptyUtils.isEmpty(checkItemList)) {
            filter.and("entryentity.checkitem", "in", checkItemList);
        }
        filter.and("entryentity.isenable", "=", (Object)Boolean.TRUE);
        filter.and("appnum", "=", (Object)appnum);
        return QueryServiceHelper.query((String)"cad_checktask", (String)CalcCheckHelper.getCheckItemsField(), (QFilter[])new QFilter[]{filter}, (String)"entryentity.seq asc");
    }

    private static String getCheckItemsField() {
        return "id,entryentity.checkitem.id as checkitemid,entryentity.checkitem.name as checkitem,entryentity.checkitem.plugin as plugin,entryentity.level as level,entryentity.checkitem.opsuggestion as opsuggestion,entryentity.checkitem.errorlog as errorlog,entryentity.checkitem.description as description,entryentity.checkitem.bizobject as bizobject,entryentity.checkitem.customfilter as customfilter";
    }

    public static Long initFinWipCalcCheckReport(JSONObject jsonObject, String taskType, Date calTime) {
        JSONArray manuOrgIds;
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_calcreport");
        Long id = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)id);
        String taskname = null;
        taskname = "1".equals(taskType) || "4".equals(taskType) ? ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcCheckHelper_0", (String)"macc-cad-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcCheckHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
        calcReport.set("taskname", (Object)taskname);
        calcReport.set("starttime", (Object)calTime);
        calcReport.set("usetime", (Object)0);
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        calcReport.set("reporttype", (Object)taskType);
        calcReport.set("currency", (Object)jsonObject.getLong("currencyId"));
        calcReport.set("accountorg", (Object)jsonObject.getLong("org"));
        calcReport.set("costaccount", (Object)jsonObject.getLong("costaccount"));
        calcReport.set("period", (Object)jsonObject.getLong("period"));
        JSONArray costCenters = jsonObject.getJSONArray("costcenters");
        if (costCenters != null && costCenters.size() > 0) {
            CalcCheckHelper.setMulControlVal(calcReport, "costcenter", costCenters.toArray());
        }
        if ((manuOrgIds = jsonObject.getJSONArray("manuOrgIds")) != null && manuOrgIds.size() > 0) {
            CalcCheckHelper.setMulControlVal(calcReport, "manuorg", manuOrgIds.toArray());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return id;
    }

    private static void setMulControlVal(DynamicObject calcReport, String key, Object[] ids) {
        DynamicObject[] costcentersParam;
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"sca_calcreport");
        MulBasedataProp mulBasedataProp = (MulBasedataProp)mainType.findProperty(key);
        DynamicObjectType subEntityType = mulBasedataProp.getDynamicCollectionItemPropertyType();
        BasedataProp basedataProp = (BasedataProp)subEntityType.getProperties().get((Object)"fbasedataid");
        DynamicObjectCollection rows = (DynamicObjectCollection)mulBasedataProp.getValue((Object)calcReport);
        for (DynamicObject cc : costcentersParam = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)basedataProp.getDynamicComplexPropertyType())) {
            DynamicObject newRow = new DynamicObject(subEntityType);
            rows.add((Object)newRow);
            basedataProp.setValue((Object)newRow, (Object)cc);
        }
    }

    public static Long initTaskRecord(String taskName, List<Long> checkItemIds, String calType, String appNum) {
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskName);
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        String entity = "";
        if (calType.equals("sca_finishcalwizards") || calType.equals("sca_wipcalwizards")) {
            entity = "sca_calcreport";
        } else if (calType.equals("sca_differencecalcwizards")) {
            entity = "sca_restore_calcreport";
        } else if (calType.equals("sca_factcostreduction")) {
            entity = "sca_reductreport";
        } else if (calType.equals("aca_terminalcalwizards")) {
            entity = "aca_calcreport";
        }
        taskrecord.set("nextpage", (Object)entity);
        QFilter filter = new QFilter("entryentity.checkitem", "in", checkItemIds);
        filter.and("caltype", "=", (Object)calType);
        DynamicObjectCollection checkItems = QueryServiceHelper.query((String)"cad_checktask", (String)CalcCheckHelper.getCheckItemsField(), (QFilter[])new QFilter[]{filter}, (String)"entryentity.seq asc");
        DynamicObjectCollection taskrecordEntrys = taskrecord.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : checkItems) {
            DynamicObject taskrecordEntry = taskrecordEntrys.addNew();
            taskrecordEntry.set("detailconfig", (Object)entry.getLong("checkitemid"));
            taskrecordEntry.set("subname", (Object)entry.getString("checkitem"));
            taskrecordEntry.set("substatus", (Object)1);
            if (seq == 1) {
                taskrecordEntry.set("substarttime", (Object)startTime);
            }
            taskrecordEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }

    public static Long initDiffCalcCheckReport(JSONObject checkParamJs, String taskName, Date calTime) {
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_restore_calcreport");
        Long calcReportId = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)calcReportId);
        calcReport.set("taskname", (Object)taskName);
        calcReport.set("billtype", (Object)"1");
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("org", (Object)checkParamJs.getString("org"));
        calcReport.set("costaccount", (Object)checkParamJs.getString("costaccount"));
        calcReport.set("period", (Object)checkParamJs.getString("period"));
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        calcReport.set("calcdate", (Object)calTime);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return calcReportId;
    }

    public static Long initReductCalcCheckReport(JSONObject calcParamJs, Date calTime) {
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_reductreport");
        Long id = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)id);
        calcReport.set("taskname", (Object)ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CalcCheckHelper_2", (String)"macc-cad-common", (Object[])new Object[0]));
        calcReport.set("starttime", (Object)calTime);
        calcReport.set("usetime", (Object)0);
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("billtype", (Object)"1");
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        calcReport.set("currency", (Object)calcParamJs.getLong("currencyId"));
        calcReport.set("org", (Object)calcParamJs.getLong("calOrgId"));
        calcReport.set("costaccount", (Object)calcParamJs.getLong("costAccountId"));
        if (calcParamJs.get("manuOrgId") != null) {
            calcReport.set("prdorg", (Object)calcParamJs.getLong("manuOrgId"));
        }
        calcReport.set("period", (Object)calcParamJs.getLong("periodId"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return id;
    }

    public static QFilter getOrgAndCostCenterFilter(JSONObject checkParamJs) {
        QFilter filter = new QFilter("org", "=", (Object)checkParamJs.getLong("org"));
        if (checkParamJs.getJSONArray("costcenters") != null && checkParamJs.getJSONArray("costcenters").size() > 0) {
            filter.and(new QFilter("costcenter", "in", (Object)checkParamJs.getJSONArray("costcenters")));
        }
        if (checkParamJs.containsKey((Object)"manuOrgIds") && checkParamJs.getJSONArray("manuOrgIds") != null && checkParamJs.getJSONArray("manuOrgIds").size() > 0) {
            filter.and(new QFilter("manuorg", "in", (Object)checkParamJs.getJSONArray("manuOrgIds")));
        }
        return filter;
    }

    public static List<ComboItem> getCostCenterByOrg(String orgId) {
        QFilter orgdutyFilter;
        QFilter enableFilter;
        if (orgId == null || StringUtils.isBlank((CharSequence)orgId)) {
            return Collections.emptyList();
        }
        QFilter orgQf = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{orgQf, enableFilter = new QFilter("enable", "=", (Object)"1"), orgdutyFilter = new QFilter("orgduty", "=", (Object)4L)});
        if (CadEmptyUtils.isEmpty(ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    public static Set<Long> getCostCenterByOrg(Long orgId, Long[] orgduty) {
        HashSet<Long> centerIds = new HashSet<Long>(200);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        filters.add(new QFilter("orgduty", "in", (Object)orgduty));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        costCenters.forEach(p -> centerIds.add(p.getLong("id")));
        return centerIds;
    }

    public static Set<Long> getCenterIdsByManuOrgIds(Long orgId, List<Long> manuList, String appId) {
        HashSet<Long> centerIds = new HashSet<Long>(20);
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(manuList)) {
            qFilter.and("manuorg", "in", manuList);
        }
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">", (Object)nowTime);
        qFilter.and("appnum", "=", (Object)appId);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"entryentity.costcenter as costcenterid", (QFilter[])qFilter.toArray());
        dynamicObjects.forEach(p -> centerIds.add(p.getLong("costcenterid")));
        return centerIds;
    }

    public static Set<Long> getManuOrgIdsByEntity(IDataModel model, Long orgId, String entity, Boolean isMulFactory, String appNum) {
        DynamicObjectCollection costcenter;
        HashSet<Long> bizOrgs = new HashSet<Long>(200);
        if (isMulFactory.booleanValue()) {
            DynamicObjectCollection manuorgs = model.getDataEntity().getDynamicObjectCollection("manuorg");
            for (DynamicObject row : manuorgs) {
                DynamicObject manuOrgDyn = row.getDynamicObject("fbasedataid");
                bizOrgs.add(manuOrgDyn.getLong("masterid"));
            }
            return bizOrgs;
        }
        String bizDateFieldName = "bookdate";
        String orgFieldName = "org";
        HashSet<Long> costCenterIds = new HashSet<Long>();
        MainEntityType entityType = model.getDataEntityType();
        IDataEntityProperty costcenterFiled = entityType.findProperty("costcenter");
        if (costcenterFiled != null && !CadEmptyUtils.isEmpty(costcenter = (DynamicObjectCollection)model.getValue("costcenter"))) {
            for (DynamicObject row : costcenter) {
                DynamicObject center = row.getDynamicObject("fbasedataid");
                costCenterIds.add(center.getLong("masterid"));
            }
        }
        List<Long> manuIdList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, entity, appNum);
        if ("cad_plannedoutputbill".equals(entity)) {
            orgFieldName = "accountorg";
            bizDateFieldName = "bizdate";
        }
        QFilter filter = new QFilter(orgFieldName, "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            filter.and("costcenter", "in", costCenterIds);
        }
        filter.and("manuorg", "in", manuIdList);
        DynamicObject period = (DynamicObject)model.getValue("period");
        QFilter timeFilter = null;
        if (period != null) {
            timeFilter = new QFilter(bizDateFieldName, ">", (Object)period.getDate("begindate"));
            timeFilter.and(bizDateFieldName, "<=", (Object)period.getDate("enddate"));
        }
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)entity, (String)"manuorg", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            bizOrgs.add(dynamicObject.getLong("manuorg"));
        }
        return bizOrgs;
    }

    public static DataSet getMfgDataSet(String allocType, CalcCheckContext context) {
        return CalcCheckHelper.getMfgDataSet(allocType, context, null, false);
    }

    public static DataSet getMfgDataSet(String allocType, CalcCheckContext context, Map<String, List<String>> mfgBillNosMap, boolean isGetBasicAlloc) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("allocmold", "=", (Object)allocType);
        filter.and("appnum", "=", (Object)context.getAppNum());
        if (isGetBasicAlloc) {
            filter.and("costobject", "=", (Object)0L);
        }
        if (!context.getManuOrgIds().isEmpty()) {
            Set<Long> centerIds = OrgHelper.getCenterIdsByManuOrgIds(context.getOrgId(), new ArrayList<Long>(context.getManuOrgIds()), context.getAppNum());
            filter.and("costcenter", "in", centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryBillDataSet", (String)"cad_mfgfeebill", (String)"billno,costcenter.id as centerId,costcenter.number as centerNumber,costcenter.name as centerName,expenseitem,expenseitem.number as expNumber,expenseitem.name as expName,totalamount as amount", (QFilter[])new QFilter[]{filter}, null);
        if (mfgBillNosMap != null) {
            DataSet copyDs = dataSet.copy();
            for (Row row : copyDs) {
                mfgBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("centerId"), row.getString("expNumber")), t -> new ArrayList()).add(row.getString("billno"));
            }
        }
        dataSet = dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("amount").finish();
        return dataSet;
    }

    public static DataSet getNonProdDataSet(CalcCheckContext context, Long centerType) {
        return CalcCheckHelper.getNonProdDataSet(context, centerType, null);
    }

    public static DataSet getNonProdDataSet(CalcCheckContext context, Long centerType, Map<String, List<String>> mfgBillNosMap) {
        QFilter filter = new QFilter("org", "=", (Object)context.getOrgId());
        filter.and("costaccount", "=", (Object)context.getCostAccountId());
        filter.and("period", "=", (Object)context.getPeriodId());
        filter.and("appnum", "=", (Object)context.getAppNum());
        filter.and("allocstatus", "=", (Object)"2");
        filter.and("entryentity.benefcostcenter.orgduty", "=", (Object)centerType);
        if (!context.getManuOrgIds().isEmpty()) {
            Set<Long> centerIds = OrgHelper.getCenterIdsByManuOrgIds(context.getOrgId(), new ArrayList<Long>(context.getManuOrgIds()), context.getAppNum());
            filter.and("entryentity.benefcostcenter", "in", centerIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"BasicProdAllocCostDiffCheckAction_getNonProdDataSet", (String)"cad_nonprodalloc", (String)"billno,entryentity.benefcostcenter.id as centerId,entryentity.benefcostcenter.number as centerNumber,entryentity.benefcostcenter.name as centerName,expenseitem,expenseitem.number as expNumber,expenseitem.name as expName,entryentity.allocamt as amount", (QFilter[])new QFilter[]{filter}, null);
        if (mfgBillNosMap != null) {
            DataSet copyDs = dataSet.copy();
            for (Row row : copyDs) {
                mfgBillNosMap.computeIfAbsent(String.format("%s@%s", row.getLong("centerId"), row.getString("expNumber")), t -> new ArrayList()).add(row.getString("billno"));
            }
        }
        dataSet = dataSet.groupBy(new String[]{"centerId", "centerNumber", "centerName", "expenseitem", "expNumber", "expName"}).sum("amount").finish();
        return dataSet;
    }
}

