/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.check.AbstractSingleCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckDetailResultInfo;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class EquivalentCheckAction
extends AbstractSingleCalcCheckAction {
    private static final Log logger = LogFactory.getLog(EquivalentCheckAction.class);

    @Override
    protected void doCheck() {
        CalcCheckContext context = this.getContext();
        String appNum = context.getAppNum();
        List<Long> costCenterIds = context.getCostCenterIds();
        boolean checkFlag = true;
        String checkDesc = "";
        DynamicObjectCollection proAllocStds = this.queryProAllocStd(context.getOrgId(), context.getCostAccountId(), appNum);
        Map<String, String> proAllocStdMap = this.buildProAllocStdMap(proAllocStds);
        HashSet<Long> equivalentCostCenters = new HashSet<Long>(32);
        if (!CadEmptyUtils.isEmpty(proAllocStdMap)) {
            this.queryEquivalentCostCenters(context.getOrgId(), context.getCostAccountId(), costCenterIds, proAllocStdMap, equivalentCostCenters);
        }
        if (!CadEmptyUtils.isEmpty(equivalentCostCenters)) {
            DynamicObjectCollection equivalents = this.queryEquivalents(context.getOrgId(), context.getCostAccountId(), context.getManuOrgIds(), equivalentCostCenters, appNum);
            Set<String> equivalentKeys = this.buildEquivalentSet(equivalents);
            DynamicObjectCollection allCostObjects = null;
            if ("sca".equals(appNum)) {
                ArrayList<QFilter> planQfilters = new ArrayList<QFilter>();
                if (!CadEmptyUtils.isEmpty(equivalentCostCenters)) {
                    planQfilters.add(new QFilter("costobject.costcenter", "in", equivalentCostCenters));
                }
                planQfilters.add(new QFilter("appnum", "=", (Object)appNum));
                planQfilters.add(new QFilter("costobject.producttype", "=", (Object)"C"));
                QFilter closeFilter = new QFilter("closedatetime", "is null", null).or("closedatetime", "<=", (Object)context.getPeriodEndDate());
                planQfilters.add(closeFilter);
                DynamicObjectCollection plans = QueryServiceHelper.query((String)"cad_plannedoutputbill", (String)"costobject id,costobject,costobject.billno billno,costobject.costcenter costcenter,costobject.name name", (QFilter[])planQfilters.toArray(new QFilter[0]));
                HashSet<Long> costObjectIds = new HashSet<Long>(64);
                if (!CadEmptyUtils.isEmpty(plans)) {
                    Iterator iterator = plans.iterator();
                    while (iterator.hasNext()) {
                        DynamicObject plan = (DynamicObject)iterator.next();
                        long costObjectId = plan.getLong("costobject");
                        if (costObjectIds.add(costObjectId)) continue;
                        iterator.remove();
                    }
                }
                allCostObjects = plans;
            } else if ("aca".equals(appNum)) {
                allCostObjects = this.queryAcaCalcCostObjectIds(context.getOrgId(), context.getCostAccountId(), context.getPeriodId(), equivalentCostCenters);
            }
            if (allCostObjects != null && !CadEmptyUtils.isEmpty(allCostObjects)) {
                String costObjectDetail = ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c\u7f16\u7801\uff1a%1$s\uff0c\u540d\u79f0\uff1a%2$s\u201d\u672a\u914d\u7f6e\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"EquivalentCheckAction_0", (String)"macc-cad-common", (Object[])new Object[0]);
                Long costAccountId = context.getCostAccountId();
                int count = 0;
                if (!CadEmptyUtils.isEmpty(equivalentKeys)) {
                    for (DynamicObject costObject : allCostObjects) {
                        long costObjectId = costObject.getLong("id");
                        long costCenterId = costObject.getLong("costcenter");
                        String billNo = costObject.getString("billno");
                        String name = costObject.getString("name");
                        String key = String.format("%s@%s@%s", costAccountId, costCenterId, costObjectId);
                        if (equivalentKeys.contains(key) || equivalentKeys.contains(key = String.format("%s@%s", costAccountId, costCenterId)) || equivalentKeys.contains(key = String.format("%s", costAccountId))) continue;
                        checkFlag = false;
                        ++count;
                        CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                        info.setCostCenter(costCenterId);
                        info.setCheckDetailResult(String.format(costObjectDetail, billNo, name));
                        this.getSingleCheckContext().getCheckDetailResult().add(info);
                    }
                } else {
                    for (DynamicObject costObject : allCostObjects) {
                        long costCenterId = costObject.getLong("costcenter");
                        String billNo = costObject.getString("billno");
                        String name = costObject.getString("name");
                        checkFlag = false;
                        ++count;
                        CalcCheckDetailResultInfo info = new CalcCheckDetailResultInfo();
                        info.setCostCenter(costCenterId);
                        info.setCheckDetailResult(String.format(costObjectDetail, billNo, name));
                        this.getSingleCheckContext().getCheckDetailResult().add(info);
                    }
                }
                checkDesc = String.format(ResManager.loadKDString((String)"%s\u4e2a\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u672a\u7ef4\u62a4\u7ea6\u5f53\u7cfb\u6570\u3002", (String)"EquivalentCheckAction_1", (String)"macc-cad-common", (Object[])new Object[0]), count);
            }
        }
        if (!checkFlag) {
            this.getSingleCheckContext().setPass(false);
            this.getSingleCheckContext().setCheckResult(checkDesc);
        }
    }

    private List<Long> getCostCenterIds(List<Long> costCenterIds, Long orgId) {
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            costCenterIds = CostCenterHelper.getCostCenterByOrg(orgId, new Long[]{4L});
        }
        return costCenterIds;
    }

    private Map<String, String> buildProAllocStdMap(DynamicObjectCollection proAllocStds) {
        HashMap<String, String> proAllocStdMap = new HashMap<String, String>(8);
        if (!CadEmptyUtils.isEmpty(proAllocStds)) {
            for (DynamicObject proAllocStd : proAllocStds) {
                String costCenter = proAllocStd.getString("costcenter");
                String costAccount = proAllocStd.getString("costaccount");
                String costDriver = proAllocStd.getString("costdriver");
                String costDriverDetail = proAllocStd.getString("costdriverdetail");
                if (CadEmptyUtils.isEmpty(costCenter)) {
                    proAllocStdMap.put(String.format("%s", costAccount), costDriver);
                    continue;
                }
                proAllocStdMap.put(String.format("%s@%s", costAccount, costCenter), costDriver);
            }
        }
        return proAllocStdMap;
    }

    private DynamicObjectCollection queryProAllocStd(Long orgId, Long costAccountId, String appNum) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter effectStatus = new QFilter("effectstatus", "=", (Object)"1");
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection proAllocStds = null;
        if ("aca".equals(appNum)) {
            proAllocStds = QueryServiceHelper.query((String)"aca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver,allocentry.productsubentry.costdriverdetail costdriverdetail", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfBillStatus, effectStatus});
        } else if ("sca".equals(appNum)) {
            proAllocStds = QueryServiceHelper.query((String)"sca_proallocstd", (String)"costaccount,allocentry.costcenter costcenter,allocentry.costdriver costdriver,allocentry.productsubentry.costdriverdetail costdriverdetail", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfBillStatus, effectStatus});
        }
        return proAllocStds;
    }

    private void queryEquivalentCostCenters(Long orgId, Long costAccountId, List<Long> costCenterIds, Map<String, String> proAllocStdMap, Set<Long> equivalentCostCenters) {
        if (!CadEmptyUtils.isEmpty(costCenterIds = this.getCostCenterIds(costCenterIds, orgId))) {
            for (Long costCenterId : costCenterIds) {
                String key = String.format("%s@%s", costAccountId, costCenterId);
                String proAllocStd = proAllocStdMap.get(key);
                if (StringUtils.isEmpty((String)proAllocStd)) {
                    key = String.format("%s", costAccountId);
                    proAllocStd = proAllocStdMap.get(key);
                }
                if (!StringUtils.isNotEmpty((String)proAllocStd) || !"2".equals(proAllocStd)) continue;
                equivalentCostCenters.add(costCenterId);
            }
        }
    }

    private DynamicObjectCollection queryEquivalents(Long orgId, Long costAccountId, Set<Long> manuOrgIds, Set<Long> equivalentCostCenters, String appNum) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfCostAccount = new QFilter("costaccount", "=", (Object)costAccountId);
        QFilter qfBillStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter qfCostCenter = new QFilter("entryentity.costcenter", "in", equivalentCostCenters);
        qfCostCenter.or("entryentity.costcenter", "=", (Object)0L);
        QFilter manuOrgQf = null;
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            manuOrgQf = new QFilter("manuorg", "in", manuOrgIds);
        }
        DynamicObjectCollection equivalents = null;
        if ("aca".equals(appNum)) {
            equivalents = QueryServiceHelper.query((String)"aca_equivalent", (String)"costaccount,entryentity.costobject costobject,entryentity.costcenter costcenter", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfCostCenter, manuOrgQf, qfBillStatus});
        } else if ("sca".equals(appNum)) {
            equivalents = QueryServiceHelper.query((String)"sca_equivalent", (String)"costaccount,entryentity.costobject costobject,entryentity.costcenter costcenter", (QFilter[])new QFilter[]{qfOrg, qfCostAccount, qfCostCenter, manuOrgQf, qfBillStatus});
        }
        return equivalents;
    }

    private Set<String> buildEquivalentSet(DynamicObjectCollection equivalents) {
        HashSet<String> equivalentKeys = new HashSet<String>(8);
        if (!CadEmptyUtils.isEmpty(equivalents)) {
            for (DynamicObject equivalent : equivalents) {
                String key;
                long costAccount = equivalent.getLong("costaccount");
                long costCenter = equivalent.getLong("costcenter");
                long costObject = equivalent.getLong("costobject");
                if (!CadEmptyUtils.isEmpty(costObject)) {
                    key = String.format("%s@%s@%s", costAccount, costCenter, costObject);
                    equivalentKeys.add(key);
                    continue;
                }
                if (!CadEmptyUtils.isEmpty(costCenter)) {
                    key = String.format("%s@%s", costAccount, costCenter);
                    equivalentKeys.add(key);
                    continue;
                }
                key = String.format("%s", costAccount);
                equivalentKeys.add(key);
            }
        }
        return equivalentKeys;
    }

    private DynamicObjectCollection queryAcaCalcCostObjectIds(Long orgId, Long costAccountId, Long periodId, Set<Long> equivalentCostCenters) {
        Set allCostObjectIds = (Set)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"ActCostCalcService", (String)"getPeriodCalcCostObjetIds", (Object[])new Object[]{orgId, costAccountId, periodId, 0L});
        if (!CadEmptyUtils.isEmpty(allCostObjectIds)) {
            QFilter costObjectIdQf = new QFilter("id", "in", (Object)allCostObjectIds);
            costObjectIdQf.and(new QFilter("producttype", "=", (Object)"C"));
            QFilter costCenterQf = null;
            if (!CadEmptyUtils.isEmpty(equivalentCostCenters)) {
                costCenterQf = new QFilter("costcenter", "in", equivalentCostCenters);
            }
            return QueryServiceHelper.query((String)"cad_costobject", (String)"id,billno,costcenter,name", (QFilter[])new QFilter[]{costObjectIdQf, costCenterQf});
        }
        return null;
    }
}

