/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.CollectConfig;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReportDetail;
import kd.macc.cad.common.enums.CollectObjectEnum;
import kd.macc.cad.common.enums.CollectStatus;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CollectReport
implements Serializable {
    private static final long serialVersionUID = -9080567919661804639L;
    private Long id;
    private Long org;
    private String billStatus;
    private String billNo;
    private Date collectDate;
    private String dateRange;
    private QFilter timeQf;
    private CollectObjectEnum collectObjectEnum;
    private boolean error = false;
    private String appNum;
    private List<CollectReportDetail> collectReportDetails = Lists.newArrayListWithExpectedSize((int)8);
    private List<CollectConfig> collectConfigDetails = Lists.newArrayListWithExpectedSize((int)8);
    private List<CollectDiff> collectDiffs = Lists.newArrayListWithExpectedSize((int)8);
    private Set<Long> transactionTypes = Sets.newHashSetWithExpectedSize((int)5);
    private Set<Long> bizTypeIds = Sets.newHashSetWithExpectedSize((int)5);
    private Set<Long> invSchemeIds = Sets.newHashSetWithExpectedSize((int)5);
    private Map<Long, List<Long>> ccWcMap = Maps.newHashMapWithExpectedSize((int)8);
    private Map<Long, List<Long>> ccOrgMap = Maps.newHashMapWithExpectedSize((int)8);
    private Map<Long, List<Long>> ccAdminMap = Maps.newHashMapWithExpectedSize((int)8);
    private Map<Long, Long> srcCostCenterMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, String> ccRangeMap = Maps.newHashMapWithExpectedSize((int)8);
    private List<Long> reProCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> fpCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> flCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> pzCostCenters = Lists.newArrayListWithExpectedSize((int)8);
    private List<Long> swCostCenters = Lists.newArrayListWithCapacity((int)8);
    private List<Long> spCostCenters = Lists.newArrayListWithCapacity((int)8);
    private List<Long> cuCostCenters = Lists.newArrayListWithExpectedSize((int)8);

    public Map<Long, Long> getSrcCostCenterMap() {
        return this.srcCostCenterMap;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getOrg() {
        return this.org;
    }

    public void setOrg(Long org) {
        this.org = org;
    }

    public Date getCollectDate() {
        return this.collectDate;
    }

    public void setCollectDate(Date collectDate) {
        this.collectDate = collectDate;
    }

    public List<CollectReportDetail> getEntryEntity() {
        return this.collectReportDetails;
    }

    public List<CollectConfig> getCollectConfigDetails() {
        return this.collectConfigDetails;
    }

    public List<CollectDiff> getCollectDiffs() {
        return this.collectDiffs;
    }

    public CollectReportDetail getCurrentEntry() {
        List<CollectReportDetail> entryEntity = this.getEntryEntity();
        if (entryEntity != null && entryEntity.size() > 0) {
            return entryEntity.get(entryEntity.size() - 1);
        }
        return new CollectReportDetail(ResManager.loadKDString((String)"\u672a\u8fdb\u5165\u5904\u7406\uff0c\u62a5\u544a\u9519\u8bef\u3002", (String)"CollectReport_0", (String)"macc-cad-common", (Object[])new Object[0]));
    }

    public String getAppNum() {
        return this.appNum;
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public String getDateRange() {
        return this.dateRange;
    }

    public void setDateRange(String dateRange) {
        this.dateRange = dateRange;
    }

    public QFilter getTimeQf() {
        return this.timeQf;
    }

    public void setTimeQf(QFilter timeQf) {
        this.timeQf = timeQf;
    }

    public CollectObjectEnum getCollectObjectEnum() {
        return this.collectObjectEnum;
    }

    public void setCollectObjectEnum(CollectObjectEnum collectObjectEnum) {
        this.collectObjectEnum = collectObjectEnum;
    }

    public Map<Long, List<Long>> getCcWcMap() {
        return this.ccWcMap;
    }

    public Map<Long, List<Long>> getCcOrgMap() {
        return this.ccOrgMap;
    }

    public Map<Long, List<Long>> getCcAdminMap() {
        return this.ccAdminMap;
    }

    public Map<Long, String> getCcRangeMap() {
        return this.ccRangeMap;
    }

    public void setCcRangeMap(Map<Long, String> ccRangeMap) {
        this.ccRangeMap = ccRangeMap;
    }

    public Set<Long> getTransactionTypes() {
        return this.transactionTypes;
    }

    public void setTransactionTypes(Set<Long> transactionTypes) {
        this.transactionTypes = transactionTypes;
    }

    public Set<Long> getBizTypeIds() {
        return this.bizTypeIds;
    }

    public void setBizTypeIds(Set<Long> bizTypeIds) {
        this.bizTypeIds = bizTypeIds;
    }

    public Set<Long> getInvSchemeIds() {
        return this.invSchemeIds;
    }

    public void setInvSchemeIds(Set<Long> invSchemeIds) {
        this.invSchemeIds = invSchemeIds;
    }

    public List<Long> getReProCostCenters() {
        return this.reProCostCenters;
    }

    public List<Long> getFpCostCenters() {
        return this.fpCostCenters;
    }

    public List<Long> getFlCostCenters() {
        return this.flCostCenters;
    }

    public List<Long> getPzCostCenters() {
        return this.pzCostCenters;
    }

    private void addConfigEntry(DynamicObject dynamicObject) {
        CollectConfig collectConfig;
        DynamicObjectCollection configEntry = dynamicObject.getDynamicObjectCollection("configentry");
        if (!CadEmptyUtils.isEmpty(this.reProCostCenters)) {
            this.reProCostCenters.sort(Long::compareTo);
        }
        if (!CadEmptyUtils.isEmpty(this.fpCostCenters)) {
            this.fpCostCenters.sort(Long::compareTo);
        }
        if (!CadEmptyUtils.isEmpty(this.pzCostCenters)) {
            this.pzCostCenters.sort(Long::compareTo);
        }
        if (!CadEmptyUtils.isEmpty(this.flCostCenters)) {
            this.flCostCenters.sort(Long::compareTo);
        }
        if (!CadEmptyUtils.isEmpty(this.swCostCenters)) {
            this.swCostCenters.sort(Long::compareTo);
        }
        if (!CadEmptyUtils.isEmpty(this.spCostCenters)) {
            this.spCostCenters.sort(Long::compareTo);
        }
        for (Long costCenter : this.reProCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u5de5\u5355\u6cd5", (String)"CollectReport_1", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (Long costCenter : this.fpCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u5206\u6279\u6cd5", (String)"CollectReport_2", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (Long costCenter : this.pzCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u54c1\u79cd\u6cd5", (String)"CollectReport_3", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (Long costCenter : this.flCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u5206\u7c7b\u6cd5", (String)"CollectReport_4", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (Long costCenter : this.swCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u670d\u52a1\u5de5\u5355", (String)"CollectReport_6", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (Long costCenter : this.spCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u670d\u52a1\u9879\u76ee", (String)"CollectReport_7", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (Long costCenter : this.cuCostCenters) {
            collectConfig = new CollectConfig();
            collectConfig.setCostCenter(costCenter);
            collectConfig.setSrcWorkCenters(this.ccWcMap.get(costCenter));
            collectConfig.setSrcOrgs(this.ccOrgMap.get(costCenter));
            collectConfig.setSrcAdminOrgs(this.ccAdminMap.get(costCenter));
            collectConfig.setColRange(this.ccRangeMap.get(costCenter));
            collectConfig.setCalMethod(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49", (String)"CollectReport_8", (String)"macc-cad-common", (Object[])new Object[0]));
            this.collectConfigDetails.add(collectConfig);
        }
        for (CollectConfig collectConfigDetail : this.collectConfigDetails) {
            DynamicObject configRow = configEntry.addNew();
            collectConfigDetail.transfer2Dynamic(configRow);
        }
    }

    public DynamicObject transfer2Dynamic(Boolean firstFlag) {
        DynamicObject dynamicObject;
        Long id = this.getId();
        if (CadEmptyUtils.isEmpty(id)) {
            firstFlag = Boolean.TRUE;
        }
        if (firstFlag == null) {
            boolean exists = QueryServiceHelper.exists((String)"cad_colreport", (Object)id);
            firstFlag = !exists;
        }
        if (firstFlag.booleanValue()) {
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_colreport");
            dynamicObject.set("id", (Object)this.getId());
            dynamicObject.set("org", (Object)this.org);
            dynamicObject.set("coldate", (Object)this.collectDate);
            dynamicObject.set("billstatus", (Object)this.getBillStatus());
            dynamicObject.set("billno", (Object)this.getBillNo());
            dynamicObject.set("appnum", (Object)this.getAppNum());
            dynamicObject.set("creator", (Object)RequestContext.getOrCreate().getCurrUserId());
            if (this.getCollectObjectEnum() != null) {
                dynamicObject.set("colobj", (Object)this.getCollectObjectEnum().getObj());
            }
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((Object)this.getId(), (String)"cad_colreport");
            dynamicObject.set("daterange", (Object)this.getDateRange());
            dynamicObject.set("error", (Object)this.isError());
            DynamicObjectCollection transactionType = dynamicObject.getDynamicObjectCollection("transactiontype");
            for (Long l : this.getTransactionTypes()) {
                DynamicObject dynamicObject2 = transactionType.addNew();
                dynamicObject2.set("fbasedataid", (Object)l);
            }
            DynamicObjectCollection bizType = dynamicObject.getDynamicObjectCollection("biztype");
            for (Long l : this.getBizTypeIds()) {
                DynamicObject entry = bizType.addNew();
                entry.set("fbasedataid", (Object)l);
            }
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("invscheme");
            for (Long notNeedInvSchemeId : this.getInvSchemeIds()) {
                DynamicObject entry = dynamicObjectCollection.addNew();
                entry.set("fbasedataid", (Object)notNeedInvSchemeId);
            }
            this.addConfigEntry(dynamicObject);
            DynamicObjectCollection dynamicObjectCollection2 = dynamicObject.getDynamicObjectCollection("entryentity");
            for (int i = 0; i < this.collectReportDetails.size(); ++i) {
                DynamicObject reportDetail = dynamicObjectCollection2.addNew();
                CollectReportDetail collectReportDetail = this.collectReportDetails.get(i);
                collectReportDetail.transfer2Dynamic(reportDetail, i);
            }
            DynamicObjectCollection diffEntity = dynamicObject.getDynamicObjectCollection("diffentry");
            this.collectDiffs.sort(Comparator.comparing(CollectDiff::getBillNo).thenComparing(CollectDiff::getSeq));
            HashSet<String> diffSet = new HashSet<String>(16);
            for (int i = 0; i < this.collectDiffs.size(); ++i) {
                DynamicObject colDiff = diffEntity.addNew();
                CollectDiff collectDiff = this.collectDiffs.get(i);
                collectDiff.transfer2Dynamic(colDiff, i);
                diffSet.add(colDiff.getString("reason"));
                diffSet.add(colDiff.getString("suggest"));
            }
            if (!CadEmptyUtils.isEmpty(diffSet)) {
                dynamicObject.set("diff", (Object)CollectReport.getDiff(diffSet));
            }
        }
        return dynamicObject;
    }

    public DynamicObject transfer2Dynamic() {
        return this.transfer2Dynamic(null);
    }

    private static String getDiff(Set<String> diffSet) {
        List<String> diffList = new ArrayList<String>(diffSet);
        diffList = diffList.stream().filter(str -> str != null && !str.trim().isEmpty()).collect(Collectors.toList());
        Collections.sort(diffList);
        String diffStr = String.join((CharSequence)"\uff1b", diffList);
        if (!StringUtils.isEmpty((Object)diffStr) && diffStr.length() > 2000) {
            diffStr = diffStr.substring(0, 1980).concat("\u2026\u2026");
        }
        return diffStr;
    }

    public void logBaseInfo(Long orgId, CollectObjectEnum collectObjectEnum, String appNum) {
        this.collectObjectEnum = collectObjectEnum;
        this.org = orgId;
        this.collectDate = new Date();
        this.appNum = appNum;
    }

    public void logTip(String tip, String tipTag) {
        CollectReportDetail currentEntry = this.getCurrentEntry();
        currentEntry.logTip(tip, tipTag);
    }

    public void logError(Throwable e, String errorMsg) {
        CollectReportDetail currentEntry = this.getCurrentEntry();
        currentEntry.logError(e, errorMsg);
        this.error = true;
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.transfer2Dynamic(Boolean.FALSE)});
    }

    public void logReportDetail(String step) {
        CollectReportDetail collectReportDetail = new CollectReportDetail(step);
        this.collectReportDetails.add(collectReportDetail);
    }

    public void logStatusChange(CollectStatus collectStatus, String tip) {
        if (this.collectReportDetails.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6b63\u5728\u8fdb\u884c\u7684\u6b65\u9aa4\uff0c\u65e0\u6cd5\u8fdb\u884c\u72b6\u6001\u8f6c\u53d8\u3002", (String)"CollectReport_5", (String)"macc-cad-common", (Object[])new Object[0]));
        }
        CollectReportDetail collectReportDetail = this.collectReportDetails.get(this.collectReportDetails.size() - 1);
        collectReportDetail.statusChange(collectStatus, tip);
    }

    public void logCheckDesc(String checkDesc) {
        if (this.collectReportDetails.isEmpty()) {
            this.logReportDetail("");
        }
        CollectReportDetail collectReportDetail = this.collectReportDetails.get(this.collectReportDetails.size() - 1);
        collectReportDetail.logCheckDesc(checkDesc);
    }

    public void logWorkCenterMap(Map<Long, List<Long>> costCenterWcMap) {
        if (costCenterWcMap != null && !costCenterWcMap.isEmpty()) {
            this.ccWcMap.putAll(costCenterWcMap);
            for (Map.Entry<Long, List<Long>> ccWc : costCenterWcMap.entrySet()) {
                Long costCenter = ccWc.getKey();
                List<Long> workCenters = ccWc.getValue();
                for (Long workCenter : workCenters) {
                    this.srcCostCenterMap.put(workCenter, costCenter);
                }
            }
        }
    }

    public void logOrgMap(Map<Long, List<Long>> costCenterOrgMap) {
        if (costCenterOrgMap != null && !costCenterOrgMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> ccOrg : costCenterOrgMap.entrySet()) {
                Long costCenter = ccOrg.getKey();
                List<Long> orgs = ccOrg.getValue();
                for (Long org : orgs) {
                    this.srcCostCenterMap.put(org, costCenter);
                }
            }
            this.ccOrgMap.putAll(costCenterOrgMap);
        }
    }

    public void logAdminMap(Map<Long, List<Long>> costCenterAdminMap) {
        if (costCenterAdminMap != null && !costCenterAdminMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> ccAdmin : costCenterAdminMap.entrySet()) {
                Long costCenter = ccAdmin.getKey();
                List<Long> admins = ccAdmin.getValue();
                for (Long admin : admins) {
                    this.srcCostCenterMap.put(admin, costCenter);
                }
            }
            this.ccAdminMap.putAll(costCenterAdminMap);
        }
    }

    public void setReProCostCenters(List<Long> reProduceCostCenters) {
        if (reProduceCostCenters == null) {
            return;
        }
        this.reProCostCenters = reProduceCostCenters;
    }

    public void setFpCostCenters(List<Long> fpCostCenters) {
        if (fpCostCenters == null) {
            return;
        }
        this.fpCostCenters = fpCostCenters;
    }

    public void setFlCostCenters(List<Long> flCostCenters) {
        if (flCostCenters == null) {
            return;
        }
        this.flCostCenters = flCostCenters;
    }

    public void setPzCostCenters(List<Long> pzCostCenters) {
        if (pzCostCenters == null) {
            return;
        }
        this.pzCostCenters = pzCostCenters;
    }

    public List<Long> getSwCostCenters() {
        return this.swCostCenters;
    }

    public void setSwCostCenters(List<Long> swCostCenters) {
        if (swCostCenters == null) {
            return;
        }
        this.swCostCenters = swCostCenters;
    }

    public List<Long> getSpCostCenters() {
        return this.spCostCenters;
    }

    public void setSpCostCenters(List<Long> spCostCenters) {
        if (spCostCenters == null) {
            return;
        }
        this.spCostCenters = spCostCenters;
    }

    public List<Long> getCuCostCenters() {
        return this.cuCostCenters;
    }

    public void setCuCostCenters(List<Long> cuCostCenters) {
        if (cuCostCenters == null) {
            return;
        }
        this.cuCostCenters = cuCostCenters;
    }
}

