/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.dto;

import java.io.Serializable;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.CollectStatus;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class CollectReportDetail
implements Serializable {
    private Long id;
    private int seq;
    private String step = "";
    private Date startTime;
    private Date endTime;
    private String status;
    private String checkDesc = "";
    private String tip = "";
    private StringBuilder tipTag = new StringBuilder();
    private boolean canChange;

    public CollectReportDetail(String step) {
        this.step = step;
        this.startTime = TimeServiceHelper.now();
        this.canChange = true;
        this.status = CollectStatus.DOING.getKey();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCheckDesc() {
        return StringUtils.substring((String)this.checkDesc, (int)0, (int)200);
    }

    public void setCheckDesc(String checkDesc) {
        this.checkDesc = checkDesc;
    }

    public String getTip() {
        return StringUtils.substring((String)this.tip, (int)0, (int)200);
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public String getStep() {
        return StringUtils.substring((String)this.step, (int)0, (int)50);
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public String getTipTag() {
        return StringUtils.substring((String)this.tipTag.toString(), (int)0, (int)2000000);
    }

    public void statusChange(CollectStatus collectStatus, String tip) {
        if (this.canChange) {
            this.endTime = TimeServiceHelper.now();
            this.status = collectStatus.getKey();
            this.tip = tip;
            this.canChange = false;
        }
    }

    public void logError(Throwable e, String msg) {
        this.endTime = TimeServiceHelper.now();
        this.status = CollectStatus.FAILURE.getKey();
        this.tip = msg;
        this.tipTag = new StringBuilder();
        this.tipTag.append(ExceptionUtils.getStackTrace((Throwable)e));
    }

    public void logTip(String tip, String tipTag) {
        if (StringUtils.isBlank((CharSequence)this.tip)) {
            this.tip = tip;
        }
        this.tipTag = this.tipTag.append("\n").append(tipTag);
    }

    public void logCheckDesc(String checkDesc) {
        this.checkDesc = checkDesc;
        this.endTime = TimeServiceHelper.now();
        this.status = CollectStatus.SUCCESS.getKey();
    }

    public DynamicObject transfer2Dynamic(DynamicObject reportDetail, int seq) {
        reportDetail.set("seq", (Object)seq);
        reportDetail.set("step", (Object)this.getStep());
        reportDetail.set("result", (Object)this.getStatus());
        if (this.getEndTime() != null) {
            reportDetail.set("costime", (Object)(this.getEndTime().getTime() - this.getStartTime().getTime()));
        }
        reportDetail.set("checkdesc", (Object)this.getCheckDesc());
        reportDetail.set("tip", (Object)this.getTip());
        reportDetail.set("tip_tag", (Object)this.getTipTag());
        return reportDetail;
    }
}

