/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.dto.CollectDiff;
import kd.macc.cad.common.dto.CollectReportDetail;
import kd.macc.cad.common.dto.MfgFeeReportConfig;
import kd.macc.cad.common.enums.CollectStatus;

public class MfgFeeImportReport
implements Serializable {
    private Long id;
    private String billNo;
    private Long orgId;
    private String appNum;
    private Long creator;
    private Date createTime;
    private Set<MfgFeeReportConfig> mfgFeeReportConfigSet = new HashSet<MfgFeeReportConfig>(16);
    private List<CollectReportDetail> collectReportDetails = new ArrayList<CollectReportDetail>();
    private List<CollectDiff> collectDiffs = Lists.newArrayListWithExpectedSize((int)128);
    public Map<String, String> billNoReasonMap = Maps.newHashMapWithExpectedSize((int)128);
    private Boolean error = false;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getBillNo() {
        return this.billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getAppNum() {
        return this.appNum;
    }

    public void setAppNum(String appNum) {
        this.appNum = appNum;
    }

    public Long getCreator() {
        return this.creator;
    }

    public void setCreator(Long creator) {
        this.creator = creator;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Boolean getError() {
        return this.error;
    }

    public void setError(Boolean error) {
        this.error = error;
    }

    public Set<MfgFeeReportConfig> getMfgFeeReportConfigSet() {
        return this.mfgFeeReportConfigSet;
    }

    public List<CollectReportDetail> getCollectReportDetails() {
        return this.collectReportDetails;
    }

    public List<CollectDiff> getCollectDiffs() {
        return this.collectDiffs;
    }

    public DynamicObject transfer2Dynamic() {
        DynamicObject mfgFeeReport = BusinessDataServiceHelper.newDynamicObject((String)"cad_mfgfee_report");
        mfgFeeReport.set("id", (Object)this.id);
        mfgFeeReport.set("billno", (Object)this.billNo);
        mfgFeeReport.set("org", (Object)this.orgId);
        mfgFeeReport.set("creator", (Object)this.creator);
        mfgFeeReport.set("createtime", (Object)this.createTime);
        mfgFeeReport.set("error", (Object)this.error);
        mfgFeeReport.set("billstatus", (Object)"C");
        mfgFeeReport.set("appnum", (Object)this.appNum);
        if (!this.mfgFeeReportConfigSet.isEmpty()) {
            DynamicObjectCollection configEntry = mfgFeeReport.getDynamicObjectCollection("configentry");
            for (MfgFeeReportConfig reportConfig : this.mfgFeeReportConfigSet) {
                DynamicObject config = configEntry.addNew();
                config.set("accountorg", (Object)reportConfig.getAccountOrgId());
                config.set("period", (Object)reportConfig.getPeriodId());
                config.set("accountbook", (Object)reportConfig.getAccountBook());
                config.set("srcbill", (Object)reportConfig.getSrcBill());
            }
        }
        if (!this.collectReportDetails.isEmpty()) {
            DynamicObjectCollection stepEntry = mfgFeeReport.getDynamicObjectCollection("stepentry");
            for (int i = 0; i < this.collectReportDetails.size(); ++i) {
                DynamicObject dynamicObject = stepEntry.addNew();
                CollectReportDetail collectReportDetail = this.collectReportDetails.get(i);
                collectReportDetail.transfer2Dynamic(dynamicObject, i);
            }
        }
        if (!this.collectDiffs.isEmpty()) {
            DynamicObjectCollection diffEntity = mfgFeeReport.getDynamicObjectCollection("diffentry");
            this.collectDiffs.sort(Comparator.comparing(CollectDiff::getBillNo).thenComparing(CollectDiff::getSeq));
            for (int i = 0; i < this.collectDiffs.size(); ++i) {
                DynamicObject colDiff = diffEntity.addNew();
                CollectDiff collectDiff = this.collectDiffs.get(i);
                collectDiff.transfer2MfgDynamic(colDiff, i);
            }
        }
        return mfgFeeReport;
    }

    public DynamicObject transfer2Dynamic(DynamicObject mfgFeeReport) {
        if (!this.mfgFeeReportConfigSet.isEmpty()) {
            DynamicObjectCollection configEntry = mfgFeeReport.getDynamicObjectCollection("configentry");
            for (MfgFeeReportConfig reportConfig : this.mfgFeeReportConfigSet) {
                DynamicObject config = configEntry.addNew();
                config.set("accountorg", (Object)reportConfig.getAccountOrgId());
                config.set("period", (Object)reportConfig.getPeriodId());
                config.set("accountbook", (Object)reportConfig.getAccountBook());
                config.set("srcbill", (Object)reportConfig.getSrcBill());
            }
        }
        if (!this.collectReportDetails.isEmpty()) {
            DynamicObjectCollection stepEntry = mfgFeeReport.getDynamicObjectCollection("stepentry");
            for (int i = 0; i < this.collectReportDetails.size(); ++i) {
                DynamicObject dynamicObject = stepEntry.addNew();
                CollectReportDetail collectReportDetail = this.collectReportDetails.get(i);
                collectReportDetail.transfer2Dynamic(dynamicObject, i);
            }
        }
        if (!this.collectDiffs.isEmpty()) {
            DynamicObjectCollection diffEntity = mfgFeeReport.getDynamicObjectCollection("diffentry");
            this.collectDiffs.sort(Comparator.comparing(CollectDiff::getBillNo).thenComparing(CollectDiff::getSeq));
            for (int i = 0; i < this.collectDiffs.size(); ++i) {
                DynamicObject colDiff = diffEntity.addNew();
                CollectDiff collectDiff = this.collectDiffs.get(i);
                collectDiff.transfer2MfgDynamic(colDiff, i);
            }
        }
        return mfgFeeReport;
    }

    public Map<String, String> getBillNoReasonMap() {
        return this.billNoReasonMap;
    }

    public CollectReportDetail getCurrentEntry() {
        List<CollectReportDetail> entryEntity = this.getCollectReportDetails();
        if (entryEntity != null && entryEntity.size() > 0) {
            return entryEntity.get(entryEntity.size() - 1);
        }
        return new CollectReportDetail(ResManager.loadKDString((String)"\u672a\u8fdb\u5165\u5904\u7406\uff0c\u62a5\u544a\u9519\u8bef\u3002", (String)"MfgFeeImportReport_0", (String)"macc-cad-common", (Object[])new Object[0]));
    }

    public void logTip(String tip, String tipTag) {
        CollectReportDetail currentEntry = this.getCurrentEntry();
        currentEntry.logTip(tip, tipTag);
    }

    public void logError(Throwable e, String errorMsg) {
        CollectReportDetail currentEntry = this.getCurrentEntry();
        currentEntry.logError(e, errorMsg);
        this.error = true;
    }

    public void logReportDetail(String step) {
        CollectReportDetail collectReportDetail = new CollectReportDetail(step);
        this.collectReportDetails.add(collectReportDetail);
    }

    public void logStatusChange(CollectStatus collectStatus, String tip) {
        if (this.collectReportDetails.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6b63\u5728\u8fdb\u884c\u7684\u6b65\u9aa4\uff0c\u65e0\u6cd5\u8fdb\u884c\u72b6\u6001\u8f6c\u53d8\u3002", (String)"MfgFeeImportReport_1", (String)"macc-cad-common", (Object[])new Object[0]));
        }
        CollectReportDetail collectReportDetail = this.collectReportDetails.get(this.collectReportDetails.size() - 1);
        collectReportDetail.statusChange(collectStatus, tip);
    }

    public void logErrorMsg(String key, String msg) {
        if (StringUtils.isEmpty((Object)key) || StringUtils.isEmpty((Object)msg)) {
            return;
        }
        if (this.billNoReasonMap.containsKey(key)) {
            String errorMsg = this.billNoReasonMap.get(key);
            String allMsg = errorMsg.concat("\uff1b").concat(msg);
            this.billNoReasonMap.put(key, allMsg);
        } else {
            this.billNoReasonMap.put(key, msg);
        }
    }

    public void logCheckDesc(String checkDesc) {
        if (this.collectReportDetails.size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6b63\u5728\u8fdb\u884c\u7684\u6b65\u9aa4\uff0c\u65e0\u6cd5\u8fdb\u884c\u72b6\u6001\u8f6c\u53d8\u3002", (String)"MfgFeeImportReport_1", (String)"macc-cad-common", (Object[])new Object[0]));
        }
        CollectReportDetail collectReportDetail = this.collectReportDetails.get(this.collectReportDetails.size() - 1);
        collectReportDetail.logCheckDesc(checkDesc);
    }

    public void logTipMarkError(String tip, String tipTag) {
        this.error = true;
        CollectReportDetail currentEntry = this.getCurrentEntry();
        currentEntry.logTip(tip, tipTag);
    }
}

