/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.AllocReport;
import kd.macc.cad.common.dto.AllocReportDetail;
import kd.macc.cad.common.dto.AllocReportEntry;
import org.apache.commons.lang3.StringUtils;

public class AllocReportHelper {
    public static AllocReport initReport(long orgId, long costaccountId, long periodId, long currencyId, String tasktype, String appnum) {
        AllocReport report = new AllocReport();
        report.setOrgId(orgId);
        report.setCostaccountId(costaccountId);
        report.setPeriodId(periodId);
        report.setCurrencyId(currencyId);
        report.setStarttime(new Date());
        report.setStatus("1");
        report.setTasktype(tasktype);
        report.setAppnum(appnum);
        return report;
    }

    public static void addCheckItem(AllocReport report, String checktype, String checkitem) {
        AllocReportHelper.addCheckItem(report, checktype, checkitem, "1");
    }

    public static void addCheckItem(AllocReport report, String checktype, String checkitem, String tiptype) {
        AllocReportEntry reportEntry = new AllocReportEntry();
        reportEntry.setChecktype(checktype);
        reportEntry.setCheckitem(checkitem);
        reportEntry.setTiptype(tiptype);
        report.getReportDetails().add(reportEntry);
    }

    public static void addCheckDatail(AllocReport report, String checktype, long costcenter, String detailMsg) {
        AllocReportEntry entry = null;
        if (!report.getReportDetails().isEmpty()) {
            entry = report.getReportDetails().get(report.getReportDetails().size() - 1);
        }
        if (!StringUtils.isEmpty((CharSequence)checktype)) {
            for (AllocReportEntry reportentry : report.getReportDetails()) {
                if (!checktype.equals(reportentry.getChecktype())) continue;
                entry = reportentry;
                break;
            }
        }
        if (entry != null) {
            AllocReportDetail detail = new AllocReportDetail();
            detail.setCostcenter(costcenter);
            detail.setCheckdetail(detailMsg);
            entry.addAllocDetail(detail);
        }
    }

    public static void saveReport(AllocReport report) {
        DynamicObject allocReport = BusinessDataServiceHelper.newDynamicObject((String)"cad_allocreport");
        ArrayList<DynamicObject> allocDetails = new ArrayList<DynamicObject>(10);
        long id = DB.genGlobalLongId();
        allocReport.set("id", (Object)id);
        allocReport.set("taskname", (Object)report.getTasktype());
        allocReport.set("org", (Object)report.getOrgId());
        allocReport.set("costaccount", (Object)report.getCostaccountId());
        allocReport.set("period", (Object)report.getPeriodId());
        allocReport.set("currency", (Object)report.getCurrencyId());
        allocReport.set("starttime", (Object)report.getStarttime());
        allocReport.set("reporttype", (Object)(StringUtils.isEmpty((CharSequence)report.getReportType()) ? ResManager.loadKDString((String)"\u5206\u914d\u62a5\u544a", (String)"AllocReportHelper_0", (String)"macc-cad-common", (Object[])new Object[0]) : report.getReportType()));
        allocReport.set("executor", (Object)RequestContext.get().getCurrUserId());
        allocReport.set("appnum", (Object)report.getAppnum());
        long usertime = (System.currentTimeMillis() - report.getStarttime().getTime()) / 1000L;
        allocReport.set("usetime", (Object)(usertime <= 0L ? 1L : usertime));
        allocReport.set("isplandata", (Object)report.isPlandata());
        allocReport.set("planscheme", (Object)report.getPlanschemeId());
        DynamicObjectCollection entryentity = allocReport.getDynamicObjectCollection("entryentity");
        String queryDetail = ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"AllocReportHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
        boolean isContainError = false;
        boolean isContainTip = false;
        for (AllocReportEntry entry : report.getReportDetails()) {
            DynamicObject allocEntry = entryentity.addNew();
            long entryid = DB.genGlobalLongId();
            allocEntry.set("id", (Object)entryid);
            allocEntry.set("checkitem", (Object)entry.getCheckitem());
            if (!entry.getAllocDetail().isEmpty()) {
                boolean tip = "4".equals(entry.getTiptype());
                if (!tip) {
                    isContainError = true;
                } else {
                    isContainTip = true;
                }
                allocEntry.set("allocresult", (Object)(tip ? "4" : "2"));
                allocEntry.set("checkdetail", (Object)queryDetail);
                DynamicObject reportDetailDyn = AllocReportHelper.getReportDetailDyn(report, entryid, entry.getCheckitem());
                allocDetails.add(reportDetailDyn);
                DynamicObjectCollection detailEntry = reportDetailDyn.getDynamicObjectCollection("entryentity");
                for (AllocReportDetail detail : entry.getAllocDetail()) {
                    DynamicObject detailDyn = detailEntry.addNew();
                    detailDyn.set("subcostcenternum", (Object)detail.getCostcenter());
                    detailDyn.set("checkdetail", (Object)detail.getCheckdetail());
                }
                continue;
            }
            allocEntry.set("allocresult", (Object)"1");
        }
        report.setReportId(id);
        String status = "1";
        if (isContainError) {
            status = "3";
        } else if (isContainTip) {
            status = "5";
        }
        report.setStatus(status);
        allocReport.set("status", (Object)report.getStatus());
        try (TXHandle handle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{allocReport});
        }
        if (!allocDetails.isEmpty()) {
            handle = TX.requiresNew();
            var13_11 = null;
            try {
                SaveServiceHelper.save((DynamicObject[])allocDetails.toArray(new DynamicObject[0]));
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            finally {
                if (handle != null) {
                    if (var13_11 != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable) {
                            var13_11.addSuppressed(throwable);
                        }
                    } else {
                        handle.close();
                    }
                }
            }
        }
    }

    private static DynamicObject getReportDetailDyn(AllocReport report, long id, String checkItem) {
        DynamicObject allocReportDetail = BusinessDataServiceHelper.newDynamicObject((String)"cad_allocreportdetail");
        allocReportDetail.set("id", (Object)id);
        allocReportDetail.set("org", (Object)report.getOrgId());
        allocReportDetail.set("costaccount", (Object)report.getCostaccountId());
        allocReportDetail.set("period", (Object)report.getPeriodId());
        allocReportDetail.set("starttime", (Object)report.getStarttime());
        allocReportDetail.set("checkitemdesc", (Object)checkItem);
        return allocReportDetail;
    }
}

