/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;

public class AppIdHelper {
    public static void setAppIdWhenAddNew(IFormView view, IDataModel model) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        OperationStatus operationStatus = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            String appId = formShowParameter.getAppId();
            model.setValue("appnum", (Object)appId);
        }
    }

    public static QFilter getAppIdFilter(IFormView view) {
        String appId = view.getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            ArrayList<String> appNumListForSca = new ArrayList<String>();
            appNumListForSca.add("sca");
            appNumListForSca.add(" ");
            return new QFilter("appnum", "in", appNumListForSca);
        }
        return new QFilter("appnum", "=", (Object)appId);
    }

    public static void setAppId(IFormView view, IDataModel model) {
        String appId = view.getFormShowParameter().getAppId();
        model.setValue("appnum", (Object)appId);
    }

    public static String getCurAppNum(IFormView view) {
        return view.getFormShowParameter().getAppId();
    }

    public static String getCurAppNumAndDefaultSca(IFormView view) {
        String appId = view.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appId)) {
            appId = "sca";
        }
        return appId;
    }

    public static boolean isMacc(IFormView view) {
        String appId = AppIdHelper.getCurAppNum(view);
        return "sca".equals(appId) || "aca".equals(appId) || "eca".equals(appId);
    }

    public static String getAppName(String appId) {
        String appName;
        switch (appId) {
            case "aca": {
                appName = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u6838\u7b97", (String)"AppIdHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            case "eca": {
                appName = ResManager.loadKDString((String)"\u670d\u52a1\u6210\u672c\u6838\u7b97", (String)"AppIdHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
                break;
            }
            default: {
                appName = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u6838\u7b97", (String)"AppIdHelper_2", (String)"macc-cad-common", (Object[])new Object[0]);
            }
        }
        return appName;
    }

    public static boolean isSCA(IFormView view) {
        return "sca".equals(AppIdHelper.getCurAppNum(view));
    }
}

