/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.utils.BigDecimalUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang.ObjectUtils;

public class BaseDataCompareDiffHelper {
    public static Map<Long, DynamicObject> getRecentDataByUnAudit(Set<Long> sourceIdsSet, String entity, String selectFileName) {
        HashMap<Long, DynamicObject> recentDataByUnAuditMap = new HashMap<Long, DynamicObject>(sourceIdsSet.size());
        if (!CadEmptyUtils.isEmpty(sourceIdsSet)) {
            DynamicObject[] recentDataByUnAudit;
            for (DynamicObject recentData : recentDataByUnAudit = BusinessDataServiceHelper.load((String)entity, (String)selectFileName, (QFilter[])new QFilter[]{new QFilter("sourceid", "in", sourceIdsSet)}, (String)"expdate desc")) {
                Long sourceid = recentData.getLong("sourceid");
                DynamicObject dynamicObject = recentDataByUnAuditMap.get(sourceid);
                if (dynamicObject != null) continue;
                recentDataByUnAuditMap.put(sourceid, recentData);
            }
        }
        return recentDataByUnAuditMap;
    }

    public static Set<String> recentDataDiffResult(DynamicObject recentDataByUnAudit, DynamicObject dataEntity, String[] billFileNames, String[] entryFileNames) {
        String billFileName;
        Boolean billSameFlag = true;
        String[] stringArray = billFileNames;
        int n = stringArray.length;
        for (int i = 0; i < n && (billSameFlag = BaseDataCompareDiffHelper.isSameFileName(recentDataByUnAudit, dataEntity, billFileName = stringArray[i])).booleanValue(); ++i) {
        }
        if (!billSameFlag.booleanValue()) {
            return null;
        }
        Set<String> recentEntrySet = BaseDataCompareDiffHelper.appendFileValue(recentDataByUnAudit, entryFileNames);
        Set<String> dataEntityEntrySet = BaseDataCompareDiffHelper.appendFileValue(dataEntity, entryFileNames);
        recentEntrySet.removeAll(dataEntityEntrySet);
        return recentEntrySet;
    }

    public static Boolean recentDataDiffFlag(DynamicObject recentDataByUnAudit, DynamicObject dataEntity, String[] billFileNames, String[] entryFileNames) {
        Boolean billSameFlag = true;
        for (String billFileName : billFileNames) {
            billSameFlag = BaseDataCompareDiffHelper.isSameFileName(recentDataByUnAudit, dataEntity, billFileName);
            if (billSameFlag.booleanValue()) continue;
            return false;
        }
        Set<String> recentEntrySet = BaseDataCompareDiffHelper.appendFileValue(recentDataByUnAudit, entryFileNames);
        Set<String> dataEntityEntrySet = BaseDataCompareDiffHelper.appendFileValue(dataEntity, entryFileNames);
        if (Integer.compare(recentEntrySet.size(), dataEntityEntrySet.size()) != 0) {
            return false;
        }
        recentEntrySet.removeAll(dataEntityEntrySet);
        billSameFlag = CadEmptyUtils.isEmpty(recentEntrySet);
        return billSameFlag;
    }

    public static Boolean isSameFileName(DynamicObject recentDataByUnAudit, DynamicObject dataEntity, String fileName) {
        Boolean flag;
        Object fileValue = recentDataByUnAudit.get(fileName);
        if (fileValue instanceof DynamicObject) {
            Object recentId;
            Object dataEntityId = dataEntity.get(fileName);
            fileName = fileName + ".id";
            if (dataEntityId instanceof DynamicObject) {
                dataEntityId = dataEntity.get(fileName);
            }
            if ((recentId = recentDataByUnAudit.get(fileName)) instanceof Long) {
                return ((Long)recentId).compareTo((Long)dataEntityId) == 0;
            }
            return recentId.equals(dataEntityId);
        }
        if (fileValue instanceof String) {
            String dataEntityValue = dataEntity.getString(fileName);
            return StringUtils.equals((CharSequence)dataEntityValue, (CharSequence)((String)fileValue));
        }
        if (fileValue instanceof BigDecimal) {
            BigDecimal dataEntityValue = dataEntity.getBigDecimal(fileName);
            BigDecimal value = (BigDecimal)fileValue;
            if (dataEntityValue == null && value == null) {
                return true;
            }
            if (dataEntityValue != null && value != null) {
                return dataEntityValue.compareTo(value) == 0;
            }
            return false;
        }
        Object dataEntityValue = dataEntity.get(fileName);
        if (fileValue == null && (flag = BaseDataCompareDiffHelper.getaBooleanNullCompore(dataEntityValue)) != null) {
            return flag;
        }
        if (dataEntityValue == null && (flag = BaseDataCompareDiffHelper.getaBooleanNullCompore(fileValue)) != null) {
            return flag;
        }
        return ObjectUtils.equals((Object)fileValue, (Object)dataEntityValue);
    }

    private static Boolean getaBooleanNullCompore(Object dataEntityValue) {
        if (dataEntityValue instanceof Long) {
            return CadEmptyUtils.isEmpty((Long)dataEntityValue);
        }
        if (dataEntityValue instanceof String) {
            return CadEmptyUtils.isEmpty((String)dataEntityValue);
        }
        if (dataEntityValue instanceof BigDecimal) {
            return CadEmptyUtils.isEmpty((BigDecimal)dataEntityValue);
        }
        return null;
    }

    public static Set<String> appendFileValue(DynamicObject recentDataByUnAudit, String[] fileNames) {
        String entity = recentDataByUnAudit.getDataEntityType().getName();
        String entryEntity = "entryentity";
        if ("sca_matallocstd".equals(entity)) {
            entryEntity = "allocentry";
        }
        DynamicObjectCollection recentDataEntitys = recentDataByUnAudit.getDynamicObjectCollection(entryEntity);
        StringBuilder keyBuilder = new StringBuilder();
        HashSet<String> returnSet = new HashSet<String>(recentDataEntitys.size());
        for (DynamicObject recentDataEntity : recentDataEntitys) {
            for (String fileName : fileNames) {
                Object fileValue = recentDataEntity.get(fileName);
                if (fileValue instanceof DynamicObject) {
                    fileName = fileName + ".id";
                    Long dataEntityId = recentDataEntity.getLong(fileName);
                    keyBuilder.append(dataEntityId).append("@");
                    continue;
                }
                if (fileValue instanceof BigDecimal) {
                    BigDecimal fileValueBigDecimal = (BigDecimal)fileValue;
                    String format = BigDecimalUtils.format(fileValueBigDecimal, "0.0000000000");
                    keyBuilder.append(format).append("@");
                    continue;
                }
                if (fileValue == null) {
                    fileValue = 0;
                }
                keyBuilder.append(fileValue).append("@");
            }
            returnSet.add(keyBuilder.toString());
            keyBuilder.setLength(0);
        }
        return returnSet;
    }

    public static Long getDynamicObjectIdValue(String dynamicObjectIdValue) {
        if (StringUtils.isEmpty((CharSequence)dynamicObjectIdValue) || "null".equals(dynamicObjectIdValue)) {
            return 0L;
        }
        return Long.parseLong(dynamicObjectIdValue);
    }
}

