/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.ElementRelationHelper;

public class BomRouterHelper {
    public static String getMatBizCtrl(DynamicObject mat) {
        String bizCtrlName = "";
        String info1 = ResManager.loadKDString((String)"\u53ef\u751f\u4ea7", (String)"BomRouterHelper_9", (String)"macc-cad-common", (Object[])new Object[0]);
        String info2 = ResManager.loadKDString((String)"\u53ef\u91c7\u8d2d", (String)"BomRouterHelper_10", (String)"macc-cad-common", (Object[])new Object[0]);
        if (mat.getBoolean("enableproduct")) {
            bizCtrlName = info1;
        }
        if (mat.getBoolean("enablepur")) {
            if (StringUtils.isNotEmpty((String)bizCtrlName)) {
                bizCtrlName = bizCtrlName + ",";
            }
            bizCtrlName = bizCtrlName + info2;
        }
        return bizCtrlName;
    }

    public static Map<Object, String> getMatBizCtrl(DynamicObjectCollection mats) {
        HashMap<Object, String> map = new HashMap<Object, String>();
        for (DynamicObject mat : mats) {
            String bizCtrlName = BomRouterHelper.getMatBizCtrl(mat);
            if (!StringUtils.isNotEmpty((String)bizCtrlName)) continue;
            map.put(mat.getString("id"), bizCtrlName);
        }
        return map;
    }

    public static DynamicObject[] getAllCostTypes(String appNum) {
        if ("aca".equals(appNum)) {
            return ElementRelationHelper.getCostTypesBy("1");
        }
        return ElementRelationHelper.getCostTypesBy(null);
    }

    public static boolean isAnalogCostType(Long costTypeId) {
        QFilter[] qfilters = new QFilter[]{new QFilter("id", "=", (Object)costTypeId), new QFilter("type", "=", (Object)"1")};
        return QueryServiceHelper.exists((String)"cad_costtype", (QFilter[])qfilters);
    }

    public static boolean isEnableMatversion(DynamicObject mat) {
        if (mat == null) {
            return false;
        }
        return mat.getBoolean("isenablematerialversion");
    }

    public static boolean isEnableAuxprop(DynamicObject mat) {
        if (mat == null || !mat.getBoolean("isuseauxpty")) {
            return false;
        }
        if (mat != null && mat.getBoolean("isuseauxpty")) {
            DynamicObjectCollection auxprops = mat.getDynamicObjectCollection("auxptyentry");
            if (auxprops == null) {
                return false;
            }
            for (DynamicObject auxprop : auxprops) {
                if (!auxprop.getBoolean("isaffectprice")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean enableAuxNotEffCost(DynamicObject mat) {
        if (mat == null || !mat.getBoolean("isuseauxpty")) {
            return false;
        }
        if (mat != null && mat.getBoolean("isuseauxpty")) {
            DynamicObjectCollection auxprops = mat.getDynamicObjectCollection("auxptyentry");
            return auxprops != null;
        }
        return false;
    }

    private static Boolean isAuxptyMustInput(Set<Long> auxptyId, String flex) {
        DynamicObject[] auxpty;
        for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            if (flex.contains(aux.getString("flexfield"))) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getAuptyInfo(Set<Long> auxptyId, String Flex) {
        DynamicObject[] auxpty;
        String[] flexs;
        HashMap<String, String> mapFlex = new HashMap<String, String>(16);
        if (!Flex.startsWith("{")) {
            return null;
        }
        Flex = Flex.substring(1, Flex.length() - 1);
        for (String flex : flexs = Flex.split(",")) {
            String[] f = flex.split(":");
            mapFlex.put(f[0].replace("\"", ""), f[1]);
        }
        StringBuilder auptyInfo = new StringBuilder();
        block5: for (DynamicObject aux : auxpty = BusinessDataServiceHelper.load((Object[])auxptyId.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_auxproperty"))) {
            String flexField = aux.getString("flexfield");
            if (!Flex.contains(flexField)) continue;
            Object val = mapFlex.get(flexField);
            String typeName = aux.getString("name");
            int valueType = aux.getInt("valuetype");
            switch (valueType) {
                case 1: 
                case 2: {
                    String valueSource = aux.getString("valuesource.number");
                    if (2 == valueType && StringUtils.isEmpty((String)valueSource)) {
                        valueSource = "bos_assistantdata_detail";
                    }
                    DynamicObject dyFlex = BusinessDataServiceHelper.loadSingle(val, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)valueSource));
                    auptyInfo.append(typeName);
                    auptyInfo.append(':');
                    auptyInfo.append(dyFlex.getString("name"));
                    auptyInfo.append("||");
                    continue block5;
                }
                case 3: {
                    auptyInfo.append(typeName);
                    auptyInfo.append(':');
                    auptyInfo.append(val);
                    auptyInfo.append("||");
                }
            }
        }
        String returnInfo = auptyInfo.toString();
        if (returnInfo.endsWith("||")) {
            return returnInfo.substring(0, returnInfo.length() - 2);
        }
        return auptyInfo.toString();
    }

    public static String validateAuxptyMustInput(DynamicObject mat, DynamicObject auxpty) {
        if (mat == null) {
            return null;
        }
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        boolean isAuxprop = false;
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            if (!price.getBoolean("isaffectprice")) continue;
            auxptyIdSet.add(auxptyId);
            isAuxprop = true;
        }
        if (isAuxprop) {
            if (auxpty == null) {
                return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"BomRouterHelper_4", (String)"macc-cad-common", (Object[])new Object[0]);
            }
            Boolean notAuxpty = BomRouterHelper.isAuxptyMustInput(auxptyIdSet, (String)auxpty.get(1));
            if (notAuxpty.booleanValue()) {
                return ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027\u672a\u586b\u5199\u3002", (String)"BomRouterHelper_4", (String)"macc-cad-common", (Object[])new Object[0]);
            }
        }
        return null;
    }
}

