/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class BomSettingHelper {
    public static DataSet getIsNotDownCalcMaterialInfo(Long costTypeId) {
        String selectedFields = "material.masterid AS masterid";
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        QFilter qfEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter qfDownCalc = new QFilter("isdowncalc", "=", (Object)Boolean.FALSE);
        return QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.calc.helper.BomSettingHelper.getAllOutSourcingMaterialInfo", (String)"cad_bomsetting", (String)selectedFields, (QFilter[])new QFilter[]{qfStatus, qfEnable, qfDownCalc, costTypeFilter}, null);
    }

    public static DataSet filterIsDownCalcMatIds(List<Long> materialIds, Long costTypeId) {
        if (CadEmptyUtils.isEmpty(materialIds)) {
            return null;
        }
        String selectedFields = "material.masterid AS masterid,isdowncalc";
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter isDownCalcFilter = new QFilter("isdowncalc", "=", (Object)Boolean.TRUE);
        QFilter qfMaterialId = new QFilter("material.masterid", "in", materialIds);
        QFilter qfStatus = new QFilter("status", "=", (Object)"C");
        QFilter qfEnable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        return QueryServiceHelper.queryDataSet((String)"kd.macc.cad.algox.calc.helper.BomSettingHelper.getMaterialInfoByMaterialIds", (String)"cad_bomsetting", (String)selectedFields, (QFilter[])new QFilter[]{qfMaterialId, qfStatus, qfEnable, costTypeFilter, isDownCalcFilter}, null);
    }

    public static DataSet getBomSettingMatIds(Long costTypeId, DynamicObject material, Date date) {
        ArrayList<QFilter> bomSettingQF = new ArrayList<QFilter>();
        bomSettingQF.add(new QFilter("costtype", "=", (Object)costTypeId));
        bomSettingQF.add(new QFilter("status", "=", (Object)"C"));
        bomSettingQF.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (date != null) {
            bomSettingQF.add(new QFilter("effectdate", "<=", (Object)date));
            bomSettingQF.add(new QFilter("expdate", ">", (Object)date));
        }
        if (material != null) {
            bomSettingQF.add(new QFilter("material", "=", material.getPkValue()));
        }
        String bomSettingFields = "material.masterid AS material, isdowncalc";
        ORMImpl orm = new ORMImpl();
        DataSet bomSettingDataSet = orm.queryDataSet("kd.macc.cad.algox.calc.helper.BomSettingHelper.getBomSettingMatIds", "cad_bomsetting", bomSettingFields, bomSettingQF.toArray(new QFilter[0]), "", -1, null);
        DataSet bomSettingDataSetCopy = bomSettingDataSet.copy();
        return bomSettingDataSetCopy;
    }

    public static DataSet getBomSettingMatIds(Long costTypeId, List<Long> materials, Date date) {
        ArrayList<QFilter> bomSettingQF = new ArrayList<QFilter>();
        bomSettingQF.add(new QFilter("costtype", "=", (Object)costTypeId));
        bomSettingQF.add(new QFilter("status", "=", (Object)"C"));
        bomSettingQF.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (date != null) {
            bomSettingQF.add(new QFilter("effectdate", "<=", (Object)date));
            bomSettingQF.add(new QFilter("expdate", ">", (Object)date));
        }
        if (!CadEmptyUtils.isEmpty(materials)) {
            bomSettingQF.add(new QFilter("material", "in", materials));
        }
        String bomSettingFields = "material.masterid AS material, isdowncalc";
        ORMImpl orm = new ORMImpl();
        DataSet bomSettingDataSet = orm.queryDataSet("kd.macc.cad.algox.calc.helper.BomSettingHelper.getBomSettingMatIds", "cad_bomsetting", bomSettingFields, bomSettingQF.toArray(new QFilter[0]), "", -1, null);
        DataSet bomSettingDataSetCopy = bomSettingDataSet.copy();
        return bomSettingDataSetCopy;
    }

    public static DynamicObjectCollection getCostTypeBomSettings(Set<Long> costTypes, Set<Long> materials) {
        ArrayList<QFilter> bomSettingQF = new ArrayList<QFilter>();
        if (!CadEmptyUtils.isEmpty(costTypes)) {
            bomSettingQF.add(new QFilter("costtype", "in", costTypes));
        }
        bomSettingQF.add(new QFilter("status", "=", (Object)"C"));
        bomSettingQF.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (!CadEmptyUtils.isEmpty(materials)) {
            bomSettingQF.add(new QFilter("material", "in", materials));
        }
        return QueryServiceHelper.query((String)"cad_bomsetting", (String)"id,costtype,material", (QFilter[])bomSettingQF.toArray(new QFilter[0]));
    }
}

