/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.NumericType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import org.apache.commons.lang3.StringUtils;

public class CalcKeyHelper {
    private static Log logger = LogFactory.getLog(CalcKeyHelper.class);
    public static final String KEY_MATERIAL = "material";
    public static final String KEY_VERSION = "matvers";
    public static final String KEY_AUXPTY = "auxproperty";
    public static final String KEY_PROJECT = "project";
    public static final String KEY_TRACKNUMBER = "tracknumber";
    public static final String KEY_CONFIGUREDCODE = "configuredcode";
    public static final String KEY_LOT = "lot";
    public static final String KEY_PRODUCTNUM = "productnum";
    private static final String[] ORDER_KEYARRAY = new String[]{"material", "matvers", "auxproperty", "project", "tracknumber", "configuredcode", "lot", "productnum"};
    public static final Keycol NULL_KEYCOL = new Keycol(" ", 0L, " ");
    public static final String EXT_FLAG = "_s";
    public static Map<String, Map<String, Keycol>> accountKeycolLocalCache = Maps.newConcurrentMap();

    public static boolean isDbDefaultValue(Object value) {
        if (value == null) {
            return true;
        }
        if (value.getClass() == String.class) {
            return StringUtils.isBlank((CharSequence)((String)value));
        }
        if (value.getClass() == BigDecimal.class) {
            return ((BigDecimal)value).compareTo(BigDecimal.ZERO) == 0;
        }
        return value.toString().equals("0");
    }

    public static String getCalcKeycol(Map<String, Object> values, List<String> extColList) {
        StringBuilder sb = new StringBuilder();
        for (String keyCol : ORDER_KEYARRAY) {
            Object value = values.get(keyCol);
            if (KEY_VERSION.equals(keyCol)) {
                value = 0L;
            }
            if (CalcKeyHelper.isDbDefaultValue(value)) continue;
            sb.append(keyCol).append(':').append(value).append(',');
        }
        for (String extKey : extColList) {
            Object value = values.get(extKey);
            if (CalcKeyHelper.isDbDefaultValue(value)) continue;
            sb.append(extKey).append(':').append(value).append(',');
        }
        if (sb.length() == 0) {
            return "";
        }
        return CalcKeyHelper.getKeyStr(sb.toString());
    }

    public static Keycol getCalcKey(Map<String, Object> values, List<String> extColList, boolean isAddNew) {
        block21: {
            String keycol = CalcKeyHelper.getCalcKeycol(values, extColList);
            if ("".equals(keycol)) {
                return NULL_KEYCOL;
            }
            Map<String, Keycol> keycolLocalCache = CalcKeyHelper.getKeycolLocalCache();
            if (keycolLocalCache.containsKey(keycol)) {
                return keycolLocalCache.get(keycol);
            }
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((String)"cad_keycol", (String)"id,keycol", (QFilter[])new QFilter[]{new QFilter("keycol", "=", (Object)keycol)});
            if (dyo != null) {
                Keycol keycolObj = new Keycol(keycol, dyo.getLong("id"), " ");
                keycolLocalCache.put(keycol, keycolObj);
                return keycolObj;
            }
            if (isAddNew) {
                dyo = BusinessDataServiceHelper.newDynamicObject((String)"cad_keycol");
                for (Map.Entry<String, Object> entry : values.entrySet()) {
                    Object value = entry.getValue();
                    if (CalcKeyHelper.isDbDefaultValue(value)) continue;
                    dyo.set(entry.getKey(), value);
                }
                dyo.set("keycol", (Object)keycol);
                dyo.set("createtime", (Object)new Date());
                try {
                    Object[] objs = null;
                    try (TXHandle h = TX.requiresNew();){
                        objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
                    }
                    if (objs != null && objs.length > 0) {
                        Keycol keycolObj = new Keycol(keycol, ((DynamicObject)objs[0]).getLong("id"), " ");
                        keycolLocalCache.put(keycol, keycolObj);
                        return keycolObj;
                    }
                }
                catch (Exception e) {
                    logger.info("\u4fdd\u5b58keycol\u5f02\u5e38==>{}", (Object)e);
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cad_keycol", (String)"id,keycol", (QFilter[])new QFilter[]{new QFilter("keycol", "=", (Object)keycol)});
                    if (dynamicObject == null) break block21;
                    return new Keycol(keycol, dynamicObject.getLong("id"), " ");
                }
            }
        }
        return NULL_KEYCOL;
    }

    private static Map<String, Keycol> getKeycolLocalCache() {
        String acctId = CacheKeyUtil.getAcctId();
        if (accountKeycolLocalCache.containsKey(acctId)) {
            return accountKeycolLocalCache.get(acctId);
        }
        ConcurrentMap keycolLocalCache = Maps.newConcurrentMap();
        accountKeycolLocalCache.put(acctId, keycolLocalCache);
        return keycolLocalCache;
    }

    public static Keycol getCalcKey(DynamicObject obj, boolean isAddNew) {
        List<String> extColList = CalcKeyHelper.getExtColList();
        Map<String, Object> values = CalcKeyHelper.getKeycolValue(obj, extColList);
        if (values == null || values.size() == 0) {
            return NULL_KEYCOL;
        }
        return CalcKeyHelper.getCalcKey(values, extColList, isAddNew);
    }

    private static Map<String, Object> getKeycolValue(DynamicObject obj, List<String> extColList) {
        HashMap result;
        block21: {
            String entityName;
            block40: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                block27: {
                                                                    block26: {
                                                                        block25: {
                                                                            block24: {
                                                                                block23: {
                                                                                    block22: {
                                                                                        block20: {
                                                                                            if (obj == null || obj.getDataEntityType() == null || StringUtils.isEmpty((CharSequence)obj.getDataEntityType().getName())) {
                                                                                                return null;
                                                                                            }
                                                                                            entityName = obj.getDataEntityType().getName();
                                                                                            result = Maps.newHashMapWithExpectedSize((int)16);
                                                                                            if (!entityName.equals("cad_calcsimulationresult")) break block20;
                                                                                            result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                                            result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, KEY_VERSION));
                                                                                            result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, KEY_AUXPTY));
                                                                                            result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                                            result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                                            result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                                            result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                                            for (String key : extColList) {
                                                                                                result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                                            }
                                                                                            break block21;
                                                                                        }
                                                                                        if (!entityName.equals("cad_calceffectiveresult")) break block22;
                                                                                        result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                                        result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, KEY_VERSION));
                                                                                        result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, KEY_AUXPTY));
                                                                                        result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                                        result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                                        result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                                        result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                                        for (String key : extColList) {
                                                                                            result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                                        }
                                                                                        break block21;
                                                                                    }
                                                                                    if (!entityName.equals("cad_costbom")) break block23;
                                                                                    result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                                    result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, KEY_AUXPTY));
                                                                                    result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                                    for (String key : extColList) {
                                                                                        result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                                    }
                                                                                    break block21;
                                                                                }
                                                                                if (!entityName.equals("cad_bomsetting")) break block24;
                                                                                result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                                result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "bomversion"));
                                                                                result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxprop"));
                                                                                result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                                result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                                result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                                result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                                for (String key : extColList) {
                                                                                    result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                                }
                                                                                break block21;
                                                                            }
                                                                            if (!entityName.equals("cad_purprices")) break block25;
                                                                            result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                            result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "matversion"));
                                                                            result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                                                                            result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                            result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                            result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                            result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                            for (String key : extColList) {
                                                                                result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                            }
                                                                            break block21;
                                                                        }
                                                                        if (!entityName.equals("cad_calcpurprices")) break block26;
                                                                        result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                        result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "matversion"));
                                                                        result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                                                                        result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                        result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                        result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                        result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                        for (String key : extColList) {
                                                                            result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                        }
                                                                        break block21;
                                                                    }
                                                                    if (!entityName.equals("cad_outsourceprice")) break block27;
                                                                    result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                    result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "matversion"));
                                                                    result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                                                                    result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                    result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                    result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                    result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                    for (String key : extColList) {
                                                                        result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                    }
                                                                    break block21;
                                                                }
                                                                if (!entityName.equals("cad_matcostinfo")) break block28;
                                                                result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                                                result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "matversion"));
                                                                result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                                                                result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                                                result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                                                result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                                                result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                                                for (String key : extColList) {
                                                                    result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                                                }
                                                                break block21;
                                                            }
                                                            if (!obj.getDataEntityType().getAlias().equals("t_bd_vicebomentry")) break block29;
                                                            result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, "copentrymaterial"));
                                                            result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "copentryauxproperty"));
                                                            break block21;
                                                        }
                                                        if (!obj.getDataEntityType().getAlias().equals("t_bd_bomentry")) break block30;
                                                        result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, "entrymaterial"));
                                                        result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "entryauxproperty"));
                                                        result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, "entryconfiguredcode"));
                                                        break block21;
                                                    }
                                                    if (!obj.getDataEntityType().getAlias().equals("t_cad_calcsimularsentry")) break block31;
                                                    result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, "submaterial"));
                                                    result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "submatvers"));
                                                    result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "subauxproperty"));
                                                    result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, "subproject"));
                                                    result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, "subtracknumber"));
                                                    result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, "subconfiguredcode"));
                                                    result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, "sublot"));
                                                    for (String key : extColList) {
                                                        result.put(key, CalcKeyHelper.getAttrValue(obj, key + EXT_FLAG));
                                                    }
                                                    break block21;
                                                }
                                                if (!obj.getDataEntityType().getAlias().equals("t_cad_calcsimularsentryal")) break block32;
                                                result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, "origsubmaterial"));
                                                result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "origsubmatvers"));
                                                result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "origsubauxproperty"));
                                                result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, "origsubproject"));
                                                result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, "origsubtracknumber"));
                                                result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, "origsubconfiguredcode"));
                                                result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, "origsublot"));
                                                for (String key : extColList) {
                                                    result.put(key, CalcKeyHelper.getAttrValue(obj, key + EXT_FLAG));
                                                }
                                                break block21;
                                            }
                                            if (!obj.getDataEntityType().getAlias().equals("t_cad_calceffectrsentry")) break block33;
                                            result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, "submaterial"));
                                            result.put(KEY_VERSION, CalcKeyHelper.getAttrValue(obj, "submatvers"));
                                            result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "subauxproperty"));
                                            result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, "subproject"));
                                            result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, "subtracknumber"));
                                            result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, "subconfiguredcode"));
                                            result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, "sublot"));
                                            for (String key : extColList) {
                                                result.put(key, CalcKeyHelper.getAttrValue(obj, key + EXT_FLAG));
                                            }
                                            break block21;
                                        }
                                        if (!obj.getDataEntityType().getAlias().equals("t_cad_routersetting_entry")) break block34;
                                        result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                        result.put(KEY_VERSION, 0L);
                                        result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                                        result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                                        result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                        result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                        result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                        for (String key : extColList) {
                                            result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                        }
                                        break block21;
                                    }
                                    if (!entityName.equals("cad_router")) break block35;
                                    result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                    result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, KEY_AUXPTY));
                                    for (String key : extColList) {
                                        result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                    }
                                    break block21;
                                }
                                if (!entityName.equals("cad_costobject")) break block36;
                                result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                                result.put(KEY_VERSION, 0L);
                                result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                                result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, "projectnumber"));
                                result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                                result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                                result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                                for (String key : extColList) {
                                    result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                                }
                                break block21;
                            }
                            if (!entityName.equals("cad_plannedoutputbill")) break block37;
                            result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                            result.put(KEY_VERSION, 0L);
                            result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                            result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                            result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                            result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                            result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                            for (String key : extColList) {
                                result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                            }
                            break block21;
                        }
                        if (!entityName.equals("cad_factnedoutputbill")) break block38;
                        result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                        result.put(KEY_VERSION, 0L);
                        result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                        result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                        result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                        result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                        result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                        for (String key : extColList) {
                            result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                        }
                        break block21;
                    }
                    if (!obj.getDataEntityType().getAlias().equals("t_sca_resourceuseentry")) break block39;
                    result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                    result.put(KEY_VERSION, 0L);
                    result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                    result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                    result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                    result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                    result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, KEY_LOT));
                    for (String key : extColList) {
                        result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                    }
                    break block21;
                }
                if (!obj.getDataEntityType().getAlias().equals("t_sca_matusecollectentry")) break block40;
                result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
                result.put(KEY_VERSION, 0L);
                result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
                result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
                result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
                result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
                result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, "lotcoderule"));
                for (String key : extColList) {
                    result.put(key, CalcKeyHelper.getAttrValue(obj, key));
                }
                break block21;
            }
            if (!entityName.equals("sca_matalloc") && !entityName.equals("aca_matalloc")) break block21;
            result.put(KEY_MATERIAL, CalcKeyHelper.getAttrValue(obj, KEY_MATERIAL));
            result.put(KEY_VERSION, 0L);
            result.put(KEY_AUXPTY, CalcKeyHelper.getAttrValue(obj, "auxpty"));
            result.put(KEY_PROJECT, CalcKeyHelper.getAttrValue(obj, KEY_PROJECT));
            result.put(KEY_TRACKNUMBER, CalcKeyHelper.getAttrValue(obj, KEY_TRACKNUMBER));
            result.put(KEY_CONFIGUREDCODE, CalcKeyHelper.getAttrValue(obj, KEY_CONFIGUREDCODE));
            result.put(KEY_LOT, CalcKeyHelper.getAttrValue(obj, "lotcoderule"));
            for (String key : extColList) {
                result.put(key, CalcKeyHelper.getAttrValue(obj, key));
            }
        }
        return result;
    }

    public static List<String> getExtColList() {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cad_keycol");
        Map allFields = entityType.getAllFields();
        Iterator it = allFields.values().iterator();
        ArrayList result = Lists.newArrayListWithCapacity((int)16);
        while (it.hasNext()) {
            IDataEntityProperty pro = (IDataEntityProperty)it.next();
            if (!pro.getName().contains("_")) continue;
            result.add(pro.getName());
        }
        Collections.sort(result);
        return result;
    }

    public static Object getAttrValue(DynamicObject obj, String key) {
        try {
            if (obj.get(key) != null) {
                if (obj.get(key) instanceof Long) {
                    return obj.getLong(key);
                }
                if (obj.get(key) instanceof String) {
                    return obj.getString(key);
                }
                if (obj.get(key) instanceof DynamicObject) {
                    return obj.get(key + ".id");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5b9e\u4f53{}\u4e0d\u5b58\u5728\u5c5e\u6027{}", (Object)obj.getDataEntityType().getName(), (Object)key);
        }
        return null;
    }

    public static String getKeyStr(String message) {
        return CalcKeyHelper.getSHA256Base64Str(message);
    }

    private static String getSHA256Base64Str(String message) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(message.getBytes(StandardCharsets.UTF_8));
            byte[] computation = digest.digest();
            return Base64.getEncoder().encodeToString(computation);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new KDBizException(String.format("CalcKeyHelper:[%s] args:[%s]", e1.getMessage(), message));
        }
    }

    public static DataSet handleNullCol(DataSet detail) {
        RowMeta rowMeta = detail.getRowMeta();
        Field[] fields = rowMeta.getFields();
        int len = fields.length;
        String[] cols = new String[len];
        for (int i = 0; i < len; ++i) {
            DataType type = fields[i].getDataType();
            cols[i] = fields[i].getAlias();
            if (!(type instanceof NumericType)) continue;
            cols[i] = "case when " + cols[i] + " is Null then 0 else " + cols[i] + " end " + cols[i];
        }
        return detail.select(cols);
    }
}

