/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcKeyUpdateHelper {
    private static final Log logger = LogFactory.getLog(CalcKeyUpdateHelper.class);
    private static final String ALGOKEY = "CalcKeyUpdate";
    private static final int BATCH_SIZE = 1000;

    public static void updateKeyColByCostType(Long costTypeId) {
        CalcKeyUpdateHelper.updateForCalcCost(costTypeId);
        CalcKeyUpdateHelper.updateForEffectCalcCost(costTypeId);
        CalcKeyUpdateHelper.updateCostBom(costTypeId);
        CalcKeyUpdateHelper.updateBomSettingKeyCol(costTypeId);
        CalcKeyUpdateHelper.updatePurPricesKeyCol(costTypeId);
        CalcKeyUpdateHelper.updateOutSourcePriceKeyCol(costTypeId);
        CalcKeyUpdateHelper.updateMatCostInfoKeyCol(costTypeId);
        CalcKeyUpdateHelper.updateRouter(costTypeId);
        CalcKeyUpdateHelper.updateRouterSettingKeyCol(costTypeId);
    }

    public static void updateForCalcCost(Long costTypeId) {
        QFilter keyColNullFilter = CalcKeyUpdateHelper.getKeyColNullFilter();
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_calcsimulationresult", (String)"id", (QFilter[])new QFilter[]{keyColNullFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        for (List list : splitIdList) {
            DynamicObject[] dyos;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((String)"cad_calcsimulationresult", (String)"id,keycol,keycolid,material,matvers,auxproperty,project,tracknumber,configuredcode,lot,entryentity.subkeycol,entryentity.subkeycolid,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.subproject,entryentity.subtracknumber,entryentity.subconfiguredcode,entryentity.sublot", (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dyo, true);
                dyo.set("keycol", (Object)calcKey.getKeycol());
                dyo.set("keycolid", (Object)calcKey.getId());
                dyo.set("keycolid_id", (Object)calcKey.getId());
                DynamicObjectCollection entryColl = dyo.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryColl) {
                    Keycol subCalcKey = CalcKeyHelper.getCalcKey(entry, true);
                    entry.set("subkeycol", (Object)subCalcKey.getKeycol());
                    entry.set("subkeycolid", (Object)subCalcKey.getId());
                    entry.set("subkeycolid_id", (Object)subCalcKey.getId());
                }
            }
            if (dyos.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dyos);
        }
    }

    public static void updateForEffectCalcCost(Long costTypeId) {
        QFilter keyColNullFilter = CalcKeyUpdateHelper.getKeyColNullFilter();
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_calceffectiveresult", (String)"id", (QFilter[])new QFilter[]{keyColNullFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,keycolid,material,matvers,auxproperty,project,tracknumber,configuredcode,lot,entryentity.subkeycol,entryentity.subkeycolid,,entryentity.submaterial,entryentity.submatvers,entryentity.subauxproperty,entryentity.subproject,entryentity.subtracknumber,entryentity.subconfiguredcode ,entryentity.sublot";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_calceffectiveresult", (String)selectField, (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dynamicObject, true);
                dynamicObject.set("keycol", (Object)calcKey.getKeycol());
                dynamicObject.set("keycolid", (Object)calcKey.getId());
                dynamicObject.set("keycolid_id", (Object)calcKey.getId());
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject obj : entryEntity) {
                    Keycol subCalcKey = CalcKeyHelper.getCalcKey(obj, true);
                    obj.set("subkeycol", (Object)subCalcKey.getKeycol());
                    obj.set("subkeycolid", (Object)subCalcKey.getId());
                    obj.set("subkeycolid_id", (Object)subCalcKey.getId());
                }
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private static void updateCostBom(Long costTypeId) {
        QFilter qFilter = new QFilter("keycol", "in", (Object)Sets.newHashSet((Object[])new String[]{"", " "}));
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_costbom", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,material,keycol,auxproperty,configuredcode,copentry.copentrymaterial,copentry.copentrykeycol,copentry.copentryauxproperty,entry.entrymaterial,entry.entrykeycol,entry.entryauxproperty,entry.entryconfiguredcode";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dyo : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_costbom", (String)selectField, (QFilter[])qFilters)) {
                dyo.set("keycol", (Object)CalcKeyHelper.getCalcKey(dyo, true).getKeycol());
                DynamicObjectCollection copEntry = dyo.getDynamicObjectCollection("copentry");
                for (DynamicObject copDyo : copEntry) {
                    copDyo.set("copentrykeycol", (Object)CalcKeyHelper.getCalcKey(copDyo, true).getKeycol());
                }
                DynamicObjectCollection entry = dyo.getDynamicObjectCollection("entry");
                for (DynamicObject entryDto : entry) {
                    entryDto.set("entrykeycol", (Object)CalcKeyHelper.getCalcKey(entryDto, true).getKeycol());
                }
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static void updateBomSettingKeyCol(Long costTypeId) {
        QFilter keyColNullFilter = CalcKeyUpdateHelper.getKeyColNullFilter();
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_bomsetting", (String)"id", (QFilter[])new QFilter[]{keyColNullFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,keycolid,material,bomversion,auxprop,project,tracknumber,configuredcode,lot";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_bomsetting", (String)selectField, (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dynamicObject, true);
                dynamicObject.set("keycol", (Object)calcKey.getKeycol());
                dynamicObject.set("keycolid", (Object)calcKey.getId());
                dynamicObject.set("keycolid_id", (Object)calcKey.getId());
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static void updatePurPricesKeyCol(Long costTypeId) {
        QFilter keyColNullFilter = CalcKeyUpdateHelper.getKeyColNullFilter();
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_purprices", (String)"id", (QFilter[])new QFilter[]{keyColNullFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,keycolid,material,matversion,auxpty,project,tracknumber,configuredcode,lot";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_purprices", (String)selectField, (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dynamicObject, true);
                dynamicObject.set("keycol", (Object)calcKey.getKeycol());
                dynamicObject.set("keycolid", (Object)calcKey.getId());
                dynamicObject.set("keycolid_id", (Object)calcKey.getId());
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static void updateOutSourcePriceKeyCol(Long costTypeId) {
        QFilter keyColNullFilter = CalcKeyUpdateHelper.getKeyColNullFilter();
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_outsourceprice", (String)"id", (QFilter[])new QFilter[]{keyColNullFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,keycolid,material,matversion,auxpty,project,tracknumber,configuredcode,lot";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_outsourceprice", (String)selectField, (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dynamicObject, true);
                dynamicObject.set("keycol", (Object)calcKey.getKeycol());
                dynamicObject.set("keycolid", (Object)calcKey.getId());
                dynamicObject.set("keycolid_id", (Object)calcKey.getId());
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static void updateMatCostInfoKeyCol(Long costTypeId) {
        QFilter keyColNullFilter = CalcKeyUpdateHelper.getKeyColNullFilter();
        String keyColFilter = CadBgParamUtils.getCadBgParamForString("keyColFilter", "1");
        if ("0".equals(keyColFilter)) {
            keyColNullFilter = null;
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_matcostinfo", (String)"id", (QFilter[])new QFilter[]{keyColNullFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,keycolid,material,matversion,auxpty,project,tracknumber,configuredcode,lot";
        List<String> extColList = CalcKeyHelper.getExtColList();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_matcostinfo");
        extColList.removeIf(extCol -> mainEntityType.findProperty(extCol) == null);
        String costObjectFields = String.join((CharSequence)",", extColList);
        if (!CadEmptyUtils.isEmpty(costObjectFields)) {
            selectField = selectField + "," + costObjectFields;
        }
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_matcostinfo", (String)selectField, (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dynamicObject, true);
                dynamicObject.set("keycol", (Object)calcKey.getKeycol());
                dynamicObject.set("keycolid", (Object)calcKey.getId());
                dynamicObject.set("keycolid_id", (Object)calcKey.getId());
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private static void updateRouter(Long costTypeId) {
        QFilter qFilter = new QFilter("keycol", "in", (Object)Sets.newHashSet((Object[])new String[]{"", " "}));
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_router", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,material,auxproperty";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_router", (String)selectField, (QFilter[])qFilters)) {
                Keycol calcKey = CalcKeyHelper.getCalcKey(dynamicObject, true);
                dynamicObject.set("keycol", (Object)calcKey.getKeycol());
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static void updateRouterSettingKeyCol(Long costTypeId) {
        QFilter qFilter = new QFilter("materialentry.keycol", "in", (Object)Sets.newHashSet((Object[])new String[]{"", " "}));
        qFilter.or(new QFilter("materialentry.keycolid", "=", (Object)0));
        DataSet ds = QueryServiceHelper.queryDataSet((String)ALGOKEY, (String)"cad_routersetting", (String)"id", (QFilter[])new QFilter[]{qFilter}, null);
        ArrayList idList = Lists.newArrayList();
        for (Row row : ds) {
            idList.add(row.getLong("id"));
        }
        List splitIdList = Lists.partition((List)idList, (int)1000);
        String selectField = "id,keycol,keycolid,materialentry.material,materialentry.auxpty,materialentry.project,materialentry.tracknumber,materialentry.configuredcode,materialentry.lot";
        for (List list : splitIdList) {
            DynamicObject[] dynamicObjects;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)list)};
            for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_routersetting", (String)selectField, (QFilter[])qFilters)) {
                DynamicObjectCollection materialEntry = dynamicObject.getDynamicObjectCollection("materialentry");
                for (DynamicObject entry : materialEntry) {
                    Keycol calcKey = CalcKeyHelper.getCalcKey(entry, true);
                    entry.set("keycol", (Object)calcKey.getKeycol());
                    entry.set("keycolid", (Object)calcKey.getId());
                    entry.set("keycolid_id", (Object)calcKey.getId());
                }
            }
            if (dynamicObjects.length <= 0) continue;
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    private static QFilter getKeyColNullFilter() {
        QFilter qFilter = new QFilter("keycol", "in", (Object)Sets.newHashSet((Object[])new String[]{"", " "}));
        qFilter.or(new QFilter("keycolid", "=", (Object)0));
        return qFilter;
    }
}

