/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CalcKeycolHelper {
    private static final Log logger = LogFactory.getLog(CalcKeycolHelper.class);
    public static final String DEFAULT_DIFFCOL = "calorg";
    private static final String[] CALCMATERIAL_DEFAULT_DIM_COLS = new String[]{"material", "auxpty", "configuredcode", "tracknumber", "project", "lot", "productnum"};
    private static final String[] CLASSIFY_DIM = new String[]{"calorg", "storageorgunit", "ownertype", "owner", "warehouse", "location", "invtype", "invstatus"};
    private static final String COSTOBJECT_UPDATE_CALCKEY_SQL = "update t_cad_costobject set fcalckeycolid=?,fkeycolfield=?,fnoupdatecostfields=? where fid=?";
    private static final String COSTOBJECT_UPDATECOL_CALCKEY_SQL = "update t_cad_costobject set fkeycolfield=?,fnoupdatecostfields=? where fid=?";
    private static final String WIPENTRY_UPDATE_CALCKEY_SQL = "update t_aca_ewipentersubentry set fcalckeycolid=? where FDetailID=?";
    private static final String WIPINIT_UPDATE_CALCKEY_SQL = "update t_aca_wipcostinitsubentry set fcalckeycolid=? where FDetailID=?";
    private static final String WIPADJUST_UPDATE_CALCKEY_SQL = "update t_aca_wipadjustbilldetail set fcalckeycolid=? where FDetailID=?";
    private static final String HALFSTRUCTBILL_UPDATE_CALCKEY_SQL = "update t_sca_halfprdstructure set fcalckeycolid=? where fid=?";
    private static final String HALFSTRUCTENTRY_UPDATE_CALCKEY_SQL = "update t_sca_halfprdstructentry set fsubcalckeycolid=? where fentryid=?";

    public static String getCostaccountAppnum(Long costaccountId) {
        QFilter filter = new QFilter("entryentity.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection costAccountIds = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount as costaccountid,appnum", (QFilter[])filter.toArray());
        if (CollectionUtils.isNotEmpty((Collection)costAccountIds)) {
            return ((DynamicObject)costAccountIds.iterator().next()).getString("appnum");
        }
        return "";
    }

    public static Set<String> getCostaccountReductKeyCols(Long orgId, Long costaccount, String appnum) {
        Map params;
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(costaccount)) {
            qFilter.and(new QFilter("costaccount", "=", (Object)costaccount));
        }
        qFilter.and(new QFilter("tab", "=", (Object)"costaccounttabpage"));
        if (!StringUtils.isEmpty((CharSequence)appnum)) {
            qFilter.and(new QFilter("appnum", "=", (Object)appnum));
        }
        if ((params = BusinessDataServiceHelper.loadFromCache((String)"cad_sysparam", (QFilter[])qFilter.toArray())).isEmpty()) {
            return null;
        }
        DynamicObject costParamDyn = (DynamicObject)params.values().iterator().next();
        boolean reductcalckeycol = false;
        reductcalckeycol = "sca".equals(appnum) ? costParamDyn.getBoolean("reductrestorekeycol") : costParamDyn.getBoolean("reductcalckeycol");
        if (!reductcalckeycol) {
            return null;
        }
        return CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccount, appnum);
    }

    public static Set<String> getCostaccountKeyCols(Long orgId, Long costaccount, String appnum) {
        String costAccountKeyField = null;
        if ("sca".equals(appnum)) {
            costAccountKeyField = CalcKeycolHelper.getDiffAllocDimConfig(orgId);
            Set<String> fields = CalcKeycolHelper.getKeySet(costAccountKeyField);
            if (fields.remove("assist")) {
                fields.add("auxpty");
            }
            fields.removeAll(Arrays.asList(CLASSIFY_DIM));
            return fields;
        }
        if ("aca".equals(appnum)) {
            DynamicObject costParamDyn;
            Map params;
            QFilter qFilter = new QFilter("org", "=", (Object)orgId);
            if (!CadEmptyUtils.isEmpty(costaccount)) {
                qFilter.and(new QFilter("costaccount", "=", (Object)costaccount));
            }
            qFilter.and(new QFilter("tab", "=", (Object)"costaccounttabpage"));
            if (!StringUtils.isEmpty((CharSequence)appnum)) {
                qFilter.and(new QFilter("appnum", "=", (Object)appnum));
            }
            costAccountKeyField = (params = BusinessDataServiceHelper.loadFromCache((String)"cad_sysparam", (QFilter[])qFilter.toArray())).isEmpty() ? "" : ((costParamDyn = (DynamicObject)params.values().iterator().next()) == null ? "" : costParamDyn.getString("calckeyfield"));
        }
        return CalcKeycolHelper.getKeySet(costAccountKeyField);
    }

    public static List<String> getExtendKeyCol(Set<String> calcKeyCols) {
        ArrayList<String> copyKeyCols = new ArrayList<String>(calcKeyCols);
        for (String key : CALCMATERIAL_DEFAULT_DIM_COLS) {
            copyKeyCols.remove(key);
        }
        return copyKeyCols;
    }

    public static Set<String> dealFeycolMerge(String costKeyFieldStr, String srcKeyFieldStr) {
        Set<String> costKeyFields = CalcKeycolHelper.getKeySet(costKeyFieldStr);
        Set<String> srcKeyFields = CalcKeycolHelper.getKeySet(srcKeyFieldStr);
        return CalcKeycolHelper.dealFeycolMerge(costKeyFields, srcKeyFields);
    }

    public static Set<String> getKeySet(String costKeyFieldStr) {
        String[] keys;
        TreeSet<String> costKeyFields = new TreeSet<String>();
        if (costKeyFieldStr == null || StringUtils.isEmpty((CharSequence)costKeyFieldStr)) {
            return costKeyFields;
        }
        for (String key : keys = costKeyFieldStr.split(",")) {
            if (StringUtils.isEmpty((CharSequence)key)) continue;
            costKeyFields.add(key);
        }
        return costKeyFields;
    }

    public static Set<String> dealFeycolMerge(Set<String> costKeyFields, Set<String> srcKeyFields) {
        if (srcKeyFields.remove("assist")) {
            srcKeyFields.add("auxpty");
        }
        TreeSet<String> newKeys = new TreeSet<String>(costKeyFields);
        newKeys.retainAll(srcKeyFields);
        return newKeys;
    }

    public static String getDiffAllocDimConfig(Long orgId) {
        String diffAllocDims = (String)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)orgId, (Long)0L, (String)"diffalloccols");
        if (StringUtils.isEmpty((CharSequence)diffAllocDims)) {
            diffAllocDims = DEFAULT_DIFFCOL;
        }
        return diffAllocDims;
    }

    public static Set<String> getDiffMaterialCalcDim(Long orgId) {
        String diffAllocDims = CalcKeycolHelper.getDiffAllocDimConfig(orgId);
        String[] diffAllocDimArr = diffAllocDims.split(",");
        HashSet<String> pamFields = new HashSet<String>(10);
        for (String dim : diffAllocDimArr) {
            if (StringUtils.isBlank((CharSequence)dim)) continue;
            pamFields.add(dim);
        }
        return pamFields;
    }

    private static void updateCostobjectKeycolFields(Map<Long, Tuple2<String, String>> costobjectKeyColMap, Set<Long> keycolfieldUpdateSet, String appnum) {
        if (CadEmptyUtils.isEmpty(keycolfieldUpdateSet)) {
            return;
        }
        String keycolfield = "material";
        ArrayList<Object[]> cbaddParams = new ArrayList<Object[]>(100);
        if ("sca".equals(appnum)) {
            for (Map.Entry<Long, Tuple2<String, String>> entry : costobjectKeyColMap.entrySet()) {
                if (!keycolfieldUpdateSet.contains(entry.getKey())) continue;
                cbaddParams.add(new Object[]{keycolfield, entry.getValue().t2, entry.getKey()});
            }
        } else {
            for (Map.Entry<Long, Tuple2<String, String>> entry : costobjectKeyColMap.entrySet()) {
                if (!keycolfieldUpdateSet.contains(entry.getKey())) continue;
                if (StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue().t1))) {
                    cbaddParams.add(new Object[]{keycolfield, entry.getValue().t2, entry.getKey()});
                    continue;
                }
                Set<String> calDims = CalcKeycolHelper.getKeySet((String)entry.getValue().t1);
                Set<String> nullFields = CalcKeycolHelper.getNotUpdateFields((String)entry.getValue().t2);
                calDims.removeAll(nullFields);
                cbaddParams.add(new Object[]{CalcKeycolHelper.getKeycolField(calDims), entry.getValue().t2, entry.getKey()});
            }
        }
        if (!cbaddParams.isEmpty()) {
            List groupList = Lists.partition(cbaddParams, (int)1000);
            for (List list : groupList) {
                CalcKeycolHelper.executeBatch(DBRoute.of((String)"cal"), COSTOBJECT_UPDATECOL_CALCKEY_SQL, list);
            }
        }
    }

    public static void costobjectRecalKeycol(Long orgId, Long costaccount, Set<Long> costobject, String appnum) {
        Set<Long> costobjectIds = new HashSet<Long>(10);
        Long costaccountId = costaccount;
        if (CadEmptyUtils.isEmpty(costaccount) && CadEmptyUtils.isEmpty(costaccountId = CostAccountHelper.getCostAccountByOrg(orgId, appnum))) {
            return;
        }
        if (CadEmptyUtils.isEmpty(costobject)) {
            DynamicObject periodDyn = PeriodHelper.getCurrentPeriod(costaccountId);
            if (periodDyn == null) {
                return;
            }
            Long currentPeriodId = periodDyn.getLong("id");
            if ("sca".equals(appnum)) {
                DynamicObject prePeriodDyn = PeriodHelper.getPreviousPeriod(currentPeriodId);
                if (prePeriodDyn != null) {
                    QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                    qFilter.and("costaccount", "=", (Object)costaccountId);
                    qFilter.and("period", "=", (Object)prePeriodDyn.getLong("id"));
                    DataSet ds = QueryServiceHelper.queryDataSet((String)"getCurDiffResult", (String)"sca_calcresult", (String)"costobject", (QFilter[])qFilter.toArray(), null);
                    for (Row row : ds) {
                        costobjectIds.add(row.getLong("costobject"));
                    }
                }
                Date[] startDates = PeriodHelper.getPeriodStartAndEndTime(currentPeriodId);
                QFilter qFilter = new QFilter("org", "=", (Object)orgId);
                qFilter.and("bookdate", ">=", (Object)startDates[0]);
                DataSet ds = QueryServiceHelper.queryDataSet((String)"getCurDiffResult", (String)"cad_costobject", (String)"id", (QFilter[])qFilter.toArray(), null);
                for (Row row : ds) {
                    costobjectIds.add(row.getLong("id"));
                }
            } else if ("aca".equals(appnum)) {
                costobjectIds = (Set)DispatchServiceHelper.invokeBizService((String)"macc", (String)"aca", (String)"ActCostCalcService", (String)"getPeriodCalcCostObjetIds", (Object[])new Object[]{orgId, costaccountId, currentPeriodId, 0L});
            }
        } else {
            costobjectIds.addAll(costobject);
        }
        QFilter qFilter = new QFilter("id", "in", costobjectIds);
        DataSet result = QueryServiceHelper.queryDataSet((String)"getCurDiffResult", (String)"cad_costobject", (String)"id,keycolfield,noupdatecostfields", (QFilter[])qFilter.toArray(), null);
        HashMap<Long, Tuple2<String, String>> costobjectKeyColMap = new HashMap<Long, Tuple2<String, String>>(10);
        for (Row row : result) {
            costobjectKeyColMap.put(row.getLong("id"), (Tuple2<String, String>)new Tuple2((Object)row.getString("keycolfield"), (Object)row.getString("noupdatecostfields")));
        }
        if (costobjectKeyColMap.isEmpty()) {
            return;
        }
        CalcKeycolHelper.costobjectGenKeyCol(orgId, costaccountId, appnum, costobjectKeyColMap, null, true);
    }

    public static void costobjectGenKeyCol(Long orgId, Long costaccount, String appnum, Map<Long, Tuple2<String, String>> costobjectKeyColMap, Set<Long> keycolfieldUpdateSet) {
        CalcKeycolHelper.costobjectGenKeyCol(orgId, costaccount, appnum, costobjectKeyColMap, keycolfieldUpdateSet, false);
    }

    public static void costobjectGenKeyCol(Long orgId, Long costaccount, String appnum, Map<Long, Tuple2<String, String>> costobjectKeyColMap, Set<Long> keycolfieldUpdateSet, boolean isRecal) {
        if (CadEmptyUtils.isEmpty(costobjectKeyColMap)) {
            return;
        }
        Set<String> calcKeys = CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccount, appnum);
        if (CadEmptyUtils.isEmpty(calcKeys)) {
            CalcKeycolHelper.updateCostobjectKeycolFields(costobjectKeyColMap, keycolfieldUpdateSet, appnum);
            return;
        }
        List<String> extCalcKeys = CalcKeycolHelper.getExtendKeyCol(calcKeys);
        StringBuilder selectFields = new StringBuilder("id,material");
        for (String key : calcKeys) {
            selectFields.append(",");
            if ("project".equals(key)) {
                selectFields.append("projectnumber as project");
                continue;
            }
            if ("productnum".equals(key)) {
                selectFields.append("producenum as productnum");
                continue;
            }
            selectFields.append(key);
        }
        List groupList = Lists.partition(new ArrayList<Long>(costobjectKeyColMap.keySet()), (int)1000);
        HashMap<String, Keycol> keyColMap = new HashMap<String, Keycol>(10);
        logger.info("\u6210\u672c\u5bf9\u8c61\uff1a\u6838\u7b97\u7ec4\u7ec7{}\uff0c\u83b7\u53d6\u5230\u7684\u7ef4\u5ea6\u4fe1\u606f{}\uff0c\u5355\u636e\u6570{}\uff0c\u5206\u6279\u6570{}", new Object[]{orgId, calcKeys, costobjectKeyColMap.size(), groupList.size()});
        for (List group : groupList) {
            ArrayList<Object[]> cbaddParams = new ArrayList<Object[]>(100);
            QFilter filter = new QFilter("id", "in", (Object)group);
            if (!isRecal) {
                filter.and("calckeycol", "=", (Object)0L);
            }
            DynamicObjectCollection costobjectDs = QueryServiceHelper.query((String)"cad_costobject", (String)selectFields.toString(), (QFilter[])filter.toArray());
            for (DynamicObject dynObj : costobjectDs) {
                Long id = dynObj.getLong("id");
                Set<String> cbDims = null;
                Tuple2<String, String> tuple = costobjectKeyColMap.get(id);
                Set<String> nullFields = CalcKeycolHelper.getNotUpdateFields((String)tuple.t2);
                String keycolfield = "material";
                if ("sca".equals(appnum)) {
                    if (nullFields.isEmpty()) {
                        cbDims = calcKeys;
                    } else {
                        cbDims = new TreeSet<String>(calcKeys);
                        cbDims.removeAll(nullFields);
                    }
                    keycolfield = CalcKeycolHelper.getKeycolField(cbDims);
                } else if ("aca".equals(appnum)) {
                    Set<String> calDims = CalcKeycolHelper.getKeySet((String)tuple.t1);
                    calDims.removeAll(nullFields);
                    keycolfield = CalcKeycolHelper.getKeycolField(calDims);
                    cbDims = CalcKeycolHelper.dealFeycolMerge(calcKeys, calDims);
                }
                if (cbDims == null) continue;
                TreeMap<String, Object> values = new TreeMap<String, Object>();
                values.put("material", dynObj.get("material"));
                for (String key : cbDims) {
                    if ("auxpty".equals(key)) {
                        values.put("auxproperty", dynObj.get(key));
                        continue;
                    }
                    values.put(key, dynObj.get(key));
                }
                String valueKey = ((Object)values).toString();
                Keycol keycol = (Keycol)keyColMap.get(valueKey);
                if (keycol == null) {
                    keycol = CalcKeyHelper.getCalcKey(values, extCalcKeys, true);
                }
                if (keycol != null && keycol.getId() != 0L) {
                    keyColMap.putIfAbsent(valueKey, keycol);
                    cbaddParams.add(new Object[]{keycol.getId(), keycolfield, tuple.t2, id});
                    continue;
                }
                logger.info("costobjectGenKeyCol error:{},{}", (Object)id, cbDims);
            }
            if (cbaddParams.isEmpty()) continue;
            CalcKeycolHelper.executeBatch(DBRoute.of((String)"cal"), COSTOBJECT_UPDATE_CALCKEY_SQL, cbaddParams);
        }
    }

    private static String getKeycolField(Set<String> dims) {
        StringBuilder sb = new StringBuilder();
        if (dims == null || !dims.contains("material")) {
            sb.append("material");
        }
        if (dims != null) {
            for (String dim : dims) {
                sb.append(",");
                sb.append(dim);
            }
        }
        return sb.toString();
    }

    private static Set<String> getNotUpdateFields(String noupdatecalfields) {
        if (StringUtils.isEmpty((CharSequence)noupdatecalfields)) {
            return new HashSet<String>(10);
        }
        JSONObject jsonObj = JSON.parseObject((String)noupdatecalfields);
        JSONArray arr = jsonObj.getJSONArray("setnull");
        if (arr == null || arr.isEmpty()) {
            return new HashSet<String>(10);
        }
        HashSet nullFields = Sets.newHashSetWithExpectedSize((int)10);
        for (int i = 0; i < arr.size(); ++i) {
            nullFields.add(arr.getString(i));
        }
        return nullFields;
    }

    private static void updateMatAllocKeycolField(String calKeyStr, String noupdatecalfields, DynamicObject matallocDyn, String appnum) {
        if ("sca".equals(appnum)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)calKeyStr)) {
            return;
        }
        Set<String> calDims = CalcKeycolHelper.getKeySet(calKeyStr);
        Set<String> nullFields = CalcKeycolHelper.getNotUpdateFields(noupdatecalfields);
        calDims.removeAll(nullFields);
        matallocDyn.set("keycolfield", (Object)CalcKeycolHelper.getKeycolField(calDims));
    }

    public static void genMatAllocCalcKey(Set<String> calcKeys, String calKeyStr, String noupdatecalfields, DynamicObject matallocDyn, DynamicObject matusercollectDyn, String appnum) {
        if (CadEmptyUtils.isEmpty(calcKeys)) {
            CalcKeycolHelper.updateMatAllocKeycolField(calKeyStr, noupdatecalfields, matallocDyn, appnum);
            return;
        }
        List<String> extCalcKeys = CalcKeycolHelper.getExtendKeyCol(calcKeys);
        Set<String> cbDims = null;
        Set<String> nullFields = CalcKeycolHelper.getNotUpdateFields(noupdatecalfields);
        String keycolfield = "material";
        if ("sca".equals(appnum)) {
            if (nullFields.isEmpty()) {
                cbDims = calcKeys;
            } else {
                cbDims = new TreeSet<String>(calcKeys);
                cbDims.removeAll(nullFields);
            }
            keycolfield = CalcKeycolHelper.getKeycolField(cbDims);
        } else if ("aca".equals(appnum)) {
            Set<String> calDims = CalcKeycolHelper.getKeySet(calKeyStr);
            calDims.removeAll(nullFields);
            keycolfield = CalcKeycolHelper.getKeycolField(calDims);
            cbDims = CalcKeycolHelper.dealFeycolMerge(calcKeys, calDims);
        }
        matallocDyn.set("keycolfield", (Object)keycolfield);
        if (cbDims == null) {
            return;
        }
        HashMap<String, Object> values = new HashMap<String, Object>(10);
        values.put("material", matallocDyn.get("material"));
        for (String key : cbDims) {
            if ("auxpty".equals(key)) {
                values.put("auxproperty", matallocDyn.get(key));
                continue;
            }
            if ("lot".equals(key)) {
                values.put("lot", matallocDyn.get("lotcoderule"));
                continue;
            }
            if ("productnum".equals(key)) {
                values.put("productnum", matallocDyn.get("subproductnum"));
                continue;
            }
            if (extCalcKeys.contains(key)) {
                values.put(key, matusercollectDyn.get(key));
                continue;
            }
            values.put(key, matallocDyn.get(key));
        }
        Keycol keycol = CalcKeyHelper.getCalcKey(values, extCalcKeys, true);
        if (keycol != null && keycol.getId() != 0L) {
            matallocDyn.set("calckeycol", (Object)keycol.getId());
        } else {
            logger.info("genMatAllocCalcKey error:{},{}", (Object)matallocDyn.getString("billno"), cbDims);
        }
    }

    public static void wipEntryGenKeycol(Long orgId, Long costaccountId, List<Long> ids, Set<String> calcKeys) {
        if (calcKeys == null) {
            calcKeys = CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccountId, "aca");
        }
        if (CadEmptyUtils.isEmpty(calcKeys)) {
            return;
        }
        List<String> extCalcKeys = CalcKeycolHelper.getExtendKeyCol(calcKeys);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_ewipenter");
        StringBuilder selectFields = new StringBuilder("entryentity.subentryentity.id id,entryentity.subentryentity.calckeycol calckeycolid,entryentity.subentryentity.submateriel material");
        for (String key : calcKeys) {
            if ("auxpty".equals(key)) {
                selectFields.append(",entryentity.subentryentity.subauxpty as auxpty");
                continue;
            }
            selectFields.append(CalcKeycolHelper.getEntityUseFields(entityType, key));
        }
        CalcKeycolHelper.dealKeyColGen(ids, 500, calcKeys, extCalcKeys, "aca_ewipenter", selectFields.toString(), new QFilter("entryentity.subentryentity.id", ">", (Object)0L), WIPENTRY_UPDATE_CALCKEY_SQL);
    }

    public static void wipCostInitGenKeycol(Long orgId, Long costaccountId, List<Long> ids, Set<String> calcKeys) {
        if (calcKeys == null) {
            calcKeys = CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccountId, "aca");
        }
        if (CadEmptyUtils.isEmpty(calcKeys)) {
            return;
        }
        List<String> extCalcKeys = CalcKeycolHelper.getExtendKeyCol(calcKeys);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_wipcostinit");
        StringBuilder selectFields = new StringBuilder("entryentity.subentryentity.id id,entryentity.subentryentity.calckeycol calckeycolid,entryentity.subentryentity.submateriel material");
        for (String key : calcKeys) {
            if ("auxpty".equals(key)) {
                selectFields.append(",entryentity.subentryentity.subauxpty as auxpty");
                continue;
            }
            selectFields.append(CalcKeycolHelper.getEntityUseFields(entityType, key));
        }
        QFilter filter = new QFilter("entryentity.subentryentity.id", ">", (Object)0L);
        CalcKeycolHelper.dealKeyColGen(ids, 500, calcKeys, extCalcKeys, "aca_wipcostinit", selectFields.toString(), filter, WIPINIT_UPDATE_CALCKEY_SQL);
    }

    public static void wipAdjustGenKeycol(Long orgId, Long costaccountId, List<Long> ids, Set<String> calcKeys) {
        if (calcKeys == null) {
            calcKeys = CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccountId, "aca");
        }
        if (CadEmptyUtils.isEmpty(calcKeys)) {
            return;
        }
        List<String> extCalcKeys = CalcKeycolHelper.getExtendKeyCol(calcKeys);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_wipadjustbill");
        StringBuilder selectFields = new StringBuilder("entryentity.subentryentity.id id,entryentity.subentryentity.calckeycol calckeycolid,entryentity.subentryentity.submaterial material");
        for (String key : calcKeys) {
            selectFields.append(CalcKeycolHelper.getEntityUseFields(entityType, key));
        }
        QFilter filter = new QFilter("entryentity.subentryentity.id", ">", (Object)0L);
        filter.and("entryentity.subentryentity.subdatatype", "!=", (Object)"sysImport");
        CalcKeycolHelper.dealKeyColGen(ids, 500, calcKeys, extCalcKeys, "aca_wipadjustbill", selectFields.toString(), filter, WIPADJUST_UPDATE_CALCKEY_SQL);
    }

    public static void halfPrdStructGenKeycol(Long orgId, Long costaccountId, List<Long> ids, String appnum, Set<String> calcKeys) {
        if (calcKeys == null) {
            calcKeys = CalcKeycolHelper.getCostaccountReductKeyCols(orgId, costaccountId, appnum);
        }
        if (CadEmptyUtils.isEmpty(calcKeys)) {
            return;
        }
        List<String> extCalcKeys = CalcKeycolHelper.getExtendKeyCol(calcKeys);
        StringBuilder selectFields = new StringBuilder("id,material,calckeycol as calckeycolid");
        for (String string : calcKeys) {
            if ("auxpty".equals(string)) {
                selectFields.append(",auxprop as auxpty");
                continue;
            }
            selectFields.append(",").append(string);
        }
        CalcKeycolHelper.dealKeyColGen(ids, 500, calcKeys, extCalcKeys, "sca_halfprdstructure", selectFields.toString(), null, HALFSTRUCTBILL_UPDATE_CALCKEY_SQL);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"sca_halfprdstructure");
        selectFields = new StringBuilder("entryentity.id id,entryentity.submaterial material,entryentity.subcalckeycol as calckeycolid");
        for (String key : calcKeys) {
            if ("auxpty".equals(key)) {
                selectFields.append(",entryentity.submaterialauxprop as auxpty");
                continue;
            }
            selectFields.append(CalcKeycolHelper.getEntityUseFields(entityType, key, "sub"));
        }
        QFilter qFilter = new QFilter("entryentity.submaterial", ">", (Object)0L);
        qFilter.and("entryentity.subelement.type", "in", (Object)new String[]{"001"});
        CalcKeycolHelper.dealKeyColGen(ids, 100, calcKeys, extCalcKeys, "sca_halfprdstructure", selectFields.toString(), qFilter, HALFSTRUCTENTRY_UPDATE_CALCKEY_SQL);
    }

    private static void dealKeyColGen(List<Long> ids, int batch, Set<String> calcKeys, List<String> extCalcKeys, String entity, String selectFields, QFilter extFilter, String updateSql) {
        List groupList = Lists.partition(new ArrayList<Long>(ids), (int)batch);
        HashMap<String, Keycol> keyColMap = new HashMap<String, Keycol>(10);
        logger.info("\u5728\u4ea7\u54c1\u6210\u672c\u521d\u59cb\u5316:\u83b7\u53d6\u5230\u7684\u7ef4\u5ea6\u4fe1\u606f{}\uff0c\u5355\u636e\u6570{}\uff0c\u5206\u6279\u6570{}", new Object[]{calcKeys, ids.size(), groupList.size()});
        for (List group : groupList) {
            ArrayList<Object[]> cbaddParams = new ArrayList<Object[]>(100);
            QFilter filter = new QFilter("id", "in", (Object)group);
            if (extFilter != null) {
                filter.and(extFilter);
            }
            DynamicObjectCollection resultDs = QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])filter.toArray());
            for (DynamicObject dynObj : resultDs) {
                Long id = dynObj.getLong("id");
                if (CadEmptyUtils.isEmpty(id)) continue;
                TreeMap<String, Object> values = new TreeMap<String, Object>();
                values.put("material", dynObj.get("material"));
                for (String key : calcKeys) {
                    if ("auxpty".equals(key)) {
                        values.put("auxproperty", dynObj.get(key));
                        continue;
                    }
                    values.put(key, dynObj.get(key));
                }
                String valueKey = ((Object)values).toString();
                Keycol keycol = (Keycol)keyColMap.get(valueKey);
                if (keycol == null) {
                    keycol = CalcKeyHelper.getCalcKey(values, extCalcKeys, true);
                }
                if (keycol != null && keycol.getId() != 0L) {
                    keyColMap.putIfAbsent(valueKey, keycol);
                    long calckeycolid = dynObj.getLong("calckeycolid");
                    if (keycol.getId() == calckeycolid) continue;
                    cbaddParams.add(new Object[]{keycol.getId(), id});
                    continue;
                }
                logger.info("{} error:{},{}", new Object[]{entity, id, calcKeys});
            }
            if (cbaddParams.isEmpty()) continue;
            CalcKeycolHelper.executeBatch(DBRoute.of((String)"cal"), updateSql, cbaddParams);
        }
    }

    public static String getEntityUseFields(MainEntityType entityType, String fieldName) {
        return CalcKeycolHelper.getEntityUseFields(entityType, fieldName, "");
    }

    public static String getEntityUseFields(MainEntityType entityType, String fieldName, String keyPre) {
        IDataEntityProperty property = entityType.findProperty(fieldName + (StringUtils.isEmpty((CharSequence)keyPre) ? "" : "_s"));
        if (property == null && (property = entityType.findProperty(keyPre + fieldName)) == null) {
            return " ";
        }
        IDataEntityType parentProp = property.getParent();
        boolean isEntryProp = parentProp instanceof EntryType;
        StringBuilder exFileds = new StringBuilder();
        exFileds.append(",");
        if (isEntryProp) {
            if (parentProp.getParent() instanceof EntryType) {
                exFileds.append(parentProp.getParent().getName());
                exFileds.append('.');
            }
            exFileds.append(parentProp.getName());
            exFileds.append('.');
        }
        exFileds.append(property.getName());
        exFileds.append(" as ");
        exFileds.append(fieldName);
        return exFileds.toString();
    }

    public static String getEntityUseDbFields(MainEntityType entityType, String fieldName, String keyPre) {
        IDataEntityProperty property = entityType.findProperty(fieldName + (StringUtils.isEmpty((CharSequence)keyPre) ? "" : "_s"));
        if (property == null) {
            property = entityType.findProperty(keyPre + fieldName);
        }
        if (property == null) {
            return null;
        }
        return property.getAlias();
    }

    private static void executeBatch(DBRoute route, String sql, List<Object[]> entrys) {
        DB.executeBatch((DBRoute)route, (String)sql, entrys);
    }

    public static Map<String, Tuple2<String, IDataEntityProperty>> getWipAdjustKeyColFieldMap(Long orgId, Long costaccountId, boolean getMatField) {
        HashMap<String, Tuple2<String, IDataEntityProperty>> keycolFieldMap = new HashMap<String, Tuple2<String, IDataEntityProperty>>(10);
        Set<String> calcKeys = CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccountId, "aca");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"aca_wipadjustbill");
        for (String keycol : calcKeys) {
            IDataEntityProperty entity;
            if (!("material".equals(keycol) || "version".equals(keycol) || "auxpty".equals(keycol))) {
                IDataEntityProperty entity2 = entityType.findProperty(keycol);
                if (entity2 == null) {
                    entity2 = entityType.findProperty(keycol + "_s");
                }
                if (entity2 == null || !(entity2.getParent() instanceof EntryType) || !"subentryentity".equals(entity2.getParent().getName())) continue;
                keycolFieldMap.put(keycol, (Tuple2<String, IDataEntityProperty>)new Tuple2((Object)entity2.getName(), (Object)entity2));
                continue;
            }
            if (!getMatField) continue;
            String keyField = null;
            if ("material".equals(keycol)) {
                keyField = "submaterial";
            } else if ("version".equals(keycol)) {
                keyField = "version";
            } else if ("auxpty".equals(keycol)) {
                keyField = "auxpty";
            }
            if (keyField == null || (entity = entityType.findProperty(keyField)) == null) continue;
            keycolFieldMap.put(keycol, (Tuple2<String, IDataEntityProperty>)new Tuple2((Object)entity.getName(), (Object)entity));
        }
        return keycolFieldMap;
    }

    public static Map<String, Tuple2<String, IDataEntityProperty>> getCostObjectKeyColFieldMap(Long orgId, Long costaccountId, boolean getMatField) {
        HashMap<String, Tuple2<String, IDataEntityProperty>> keycolFieldMap = new HashMap<String, Tuple2<String, IDataEntityProperty>>(10);
        Set<String> calcKeys = CalcKeycolHelper.getCostaccountKeyCols(orgId, costaccountId, "aca");
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cad_costobject");
        for (String keycol : calcKeys) {
            IDataEntityProperty entity;
            if (!("material".equals(keycol) || "version".equals(keycol) || "auxpty".equals(keycol))) {
                IDataEntityProperty entity2 = entityType.findProperty(keycol);
                if (entity2 == null) {
                    entity2 = entityType.findProperty(keycol + "_s");
                }
                if (entity2 == null) continue;
                keycolFieldMap.put(keycol, (Tuple2<String, IDataEntityProperty>)new Tuple2((Object)entity2.getName(), (Object)entity2));
                continue;
            }
            if (!getMatField) continue;
            String keyField = null;
            if ("material".equals(keycol)) {
                keyField = "submaterial";
            } else if ("version".equals(keycol)) {
                keyField = "version";
            } else if ("auxpty".equals(keycol)) {
                keyField = "auxpty";
            }
            if (keyField == null || (entity = entityType.findProperty(keyField)) == null) continue;
            keycolFieldMap.put(keycol, (Tuple2<String, IDataEntityProperty>)new Tuple2((Object)entity.getName(), (Object)entity));
        }
        return keycolFieldMap;
    }
}

