/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcRptHelper {
    public static boolean verifyMustInput(ReportQueryParam queryParam, List<String> mustinputFields) {
        boolean isPass = true;
        FilterInfo filterInfo = queryParam.getFilter();
        for (String field : mustinputFields) {
            FilterItemInfo filterItemInfo = filterInfo.getFilterItem(field);
            Object value = filterItemInfo.getValue();
            if (value != null) continue;
            isPass = false;
            break;
        }
        return isPass;
    }

    public static Long getCurrPeriod(Long orgId, Long costaccountId) {
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        DynamicObjectCollection res = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"id, entry.currentperiod AS currentperiod", (QFilter[])new QFilter[]{orgQF, costaccountQF});
        if (res != null && res.size() > 0) {
            return ((DynamicObject)res.get(0)).getLong("currentperiod");
        }
        return null;
    }

    public static Long getCurrency(DynamicObject costaccount) {
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return 0L;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", calpolicy.getPkValue())});
        if (dynamicObject == null) {
            return 0L;
        }
        return dynamicObject.getLong("currency");
    }

    public static Object getFilterItemValue(FilterInfo filterInfo, String propName) {
        FilterItemInfo filterItem = filterInfo.getFilterItem(propName);
        if (filterItem != null && filterItem.getValue() != null) {
            Object value = filterItem.getValue();
            if (value instanceof DynamicObject) {
                return ((DynamicObject)value).getPkValue();
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection values = (DynamicObjectCollection)value;
                return values.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            }
            return value;
        }
        return null;
    }

    public static QFilter getQFilter(ReportQueryParam reportQueryParam, boolean isCalcResultQuery) {
        String bizstatus;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        Object value = CalcRptHelper.getFilterItemValue(filterInfo, "org");
        QFilter filter = new QFilter("org", "=", value);
        value = CalcRptHelper.getFilterItemValue(filterInfo, "manuorg");
        if (value != null) {
            filter.and(new QFilter("costobject.manuorg", "in", value));
        }
        value = CalcRptHelper.getFilterItemValue(filterInfo, "costaccount");
        filter.and(new QFilter("costaccount", "=", value));
        value = CalcRptHelper.getFilterItemValue(filterInfo, "fperiod");
        filter.and(new QFilter("period", "in", value));
        value = CalcRptHelper.getFilterItemValue(filterInfo, "fcostcenter");
        if (value != null) {
            filter.and(new QFilter("costcenter", "in", value));
        }
        ArrayList<Long> materialIds = new ArrayList(10);
        DynamicObjectCollection products = filterInfo.getDynamicObjectCollection("fmaterial");
        if (products != null) {
            materialIds = products.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        }
        List<Long> costObjectIds = new ArrayList<Long>(10);
        DynamicObjectCollection costobjcts = filterInfo.getDynamicObjectCollection("fcostobject");
        if (costobjcts != null) {
            costObjectIds = costobjcts.stream().map(r -> r.getLong("id")).collect(Collectors.toList());
        }
        if (!CadEmptyUtils.isEmpty(costObjectIds) || !CadEmptyUtils.isEmpty(materialIds)) {
            Set<Long> mainCostObjectIds = CalcRptHelper.getMainCostobjectIds(filter, costObjectIds, materialIds);
            filter.and(new QFilter("costobject", "in", mainCostObjectIds));
        }
        if ("A".equals(bizstatus = (String)CalcRptHelper.getFilterItemValue(filterInfo, "fbizstatus")) || "B".equals(bizstatus)) {
            filter.and(new QFilter("bizstatus", "=", (Object)bizstatus));
        }
        if (isCalcResultQuery) {
            filter.and(new QFilter("entryentity.caltype", "=", (Object)"5"));
        } else {
            filter.and(new QFilter("entryentity.datatype", "=", (Object)"2"));
        }
        return filter;
    }

    private static Set<Long> getMainCostobjectIds(QFilter filter, List<Long> costObjectIds, List<Long> materialIds) {
        DataSet dataSet;
        ArrayList<QFilter> calResultFilter = new ArrayList<QFilter>(10);
        calResultFilter.add(filter);
        HashSet<Long> ids = new HashSet<Long>(16);
        calResultFilter.add(new QFilter("entryentity.caltype", "=", (Object)"5"));
        if (costObjectIds != null && !costObjectIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.obj", "in", costObjectIds));
        }
        if (materialIds != null && !materialIds.isEmpty()) {
            calResultFilter.add(new QFilter("entryentity.obj.material", "in", materialIds));
        }
        if ((dataSet = QueryServiceHelper.queryDataSet((String)"costobject", (String)"sca_calcresult", (String)"costobject", (QFilter[])calResultFilter.toArray(new QFilter[0]), (String)"")) != null && dataSet.hasNext()) {
            for (Row row : dataSet) {
                ids.add(row.getLong("costobject"));
            }
        }
        return ids;
    }
}

