/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.LogarithmHelper;

public class CollectRangeHelper {
    public static boolean checkContainsEntity(LogarithmParam logarithmParam, String targetEntity, String sourceEntity) {
        if (StringUtils.isBlank((String)targetEntity) || StringUtils.isBlank((String)sourceEntity)) {
            return false;
        }
        boolean result = false;
        Long orgId = logarithmParam.getOrgId();
        String appNum = logarithmParam.getAppnum();
        List<Long> costCenterIds = logarithmParam.getCostCenterIds();
        if (costCenterIds == null) {
            return false;
        }
        List<Long> enableCostCenters = ImportServiceHelper.getCostCenterByDataRule(RequestContext.get().getCurrUserId(), Collections.singletonList(null), Sets.newHashSet(costCenterIds), "cad_costobject", null);
        Map<String, DynamicObject> objRules = CostObjectHelper.getCostObjectRulesMap(orgId, enableCostCenters);
        HashSet<Long> calcDimensionIds = new HashSet<Long>(10);
        objRules.values().forEach(p -> {
            if ("RO".equalsIgnoreCase(p.getString("biztype"))) {
                calcDimensionIds.add(p.getLong("costcalcdimension"));
            }
        });
        Map<String, List<DynamicObject>> costCenterSourceDataMap = LogarithmHelper.getCostCenterSourceDataMap(enableCostCenters, logarithmParam);
        HashMap costCentersourceTypeDataMap = new HashMap(16);
        costCenterSourceDataMap.forEach((ccs, obj) -> {
            String[] srcDataStr = ccs.split("@");
            if (srcDataStr.length < 2) {
                return;
            }
            String sourceType = srcDataStr[0];
            Long sourceData = Long.parseLong(srcDataStr[1]);
            costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
        });
        List<DynamicObject> collconfigs = ImportServiceHelper.getCollConfigs(orgId, null, calcDimensionIds, targetEntity, appNum);
        for (DynamicObject collconfig : collconfigs) {
            String sourceNum = collconfig.getString("sourcebill.number");
            if (!sourceEntity.equals(sourceNum)) continue;
            return true;
        }
        return result;
    }
}

