/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ConfigTrackHelper {
    public static Set<Long> getMaterialBySalOrder(Long configCodeId, Long trackNumId) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(configCodeId)) {
            filter.and(new QFilter("billentry.configuredcode", "=", (Object)configCodeId));
        }
        if (!CadEmptyUtils.isEmpty(trackNumId)) {
            filter.and(new QFilter("billentry.tracknumber", "=", (Object)trackNumId));
        }
        DataSet orders = QueryServiceHelper.queryDataSet((String)"SALORDER", (String)"sm_salorder", (String)"billentry.material.masterid as material", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> materials = new HashSet<Long>(10);
        for (Row order : orders) {
            Long material = order.getLong("material");
            if (CadEmptyUtils.isEmpty(material)) continue;
            materials.add(material);
        }
        return materials;
    }

    public static Set<Long> getConfigCodeIds(Set<Long> materials) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(materials)) {
            filter.and(new QFilter("billentry.material.masterid", "in", materials));
        }
        DataSet orders = QueryServiceHelper.queryDataSet((String)"SALORDER", (String)"sm_salorder", (String)"billentry.configuredcode as configuredcode", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> configuredCodes = new HashSet<Long>(10);
        for (Row order : orders) {
            Long configuredCode = order.getLong("configuredcode");
            if (CadEmptyUtils.isEmpty(configuredCode)) continue;
            configuredCodes.add(configuredCode);
        }
        return configuredCodes;
    }

    public static List<Object> getConfigCodeIdsByMaterial(Set<Long> materials) {
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        if (!CadEmptyUtils.isEmpty(materials)) {
            filter.and(new QFilter("material", "in", materials));
        }
        return QueryServiceHelper.queryPrimaryKeys((String)"bd_configuredcode", (QFilter[])filter.toArray(), null, (int)-1);
    }

    public static Set<Long> getTrackNumIds(Long configCode) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(configCode)) {
            filter.and(new QFilter("billentry.configuredcode", "=", (Object)configCode));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.tracknumber as tracknumber", (QFilter[])new QFilter[]{filter});
        HashSet<Long> trackNumbers = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long trackNumber = order.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty(trackNumber)) continue;
            trackNumbers.add(trackNumber);
        }
        return trackNumbers;
    }

    public static Set<Long> getTrackNumIdsByConfigCodeIds(Set<Long> configCodeIds) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(configCodeIds)) {
            filter.and(new QFilter("billentry.configuredcode", "in", configCodeIds));
        }
        DataSet trackNumberDs = QueryServiceHelper.queryDataSet((String)"getTrackNumberIds", (String)"sm_salorder", (String)"billentry.tracknumber as tracknumber", (QFilter[])new QFilter[]{filter}, null);
        HashSet<Long> trackNumbers = new HashSet<Long>(10);
        for (Row row : trackNumberDs) {
            long trackNumber = row.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty(trackNumber)) continue;
            trackNumbers.add(trackNumber);
        }
        return trackNumbers;
    }

    public static Set<Long> getTrackNumIds(Long materialId, Long configCode) {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(materialId)) {
            filter.and(new QFilter("billentry.material.masterid", "=", (Object)materialId));
        }
        if (!CadEmptyUtils.isEmpty(configCode)) {
            filter.and(new QFilter("billentry.configuredcode", "=", (Object)configCode));
        }
        DynamicObjectCollection orders = QueryServiceHelper.query((String)"sm_salorder", (String)"billentry.tracknumber as tracknumber", (QFilter[])new QFilter[]{filter});
        HashSet<Long> trackNumbers = new HashSet<Long>(10);
        for (DynamicObject order : orders) {
            long trackNumber = order.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty(trackNumber)) continue;
            trackNumbers.add(trackNumber);
        }
        return trackNumbers;
    }

    public static Long getConfigCodeId(Long trackNumId) {
        DynamicObject order;
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(trackNumId)) {
            filter.and(new QFilter("billentry.tracknumber", "=", (Object)trackNumId));
        }
        if ((order = QueryServiceHelper.queryOne((String)"sm_salorder", (String)"billentry.configuredcode as configuredcode", (QFilter[])new QFilter[]{filter})) == null) {
            return 0L;
        }
        return order.getLong("configuredcode");
    }

    public static void setConfigValueByTrack(IFormView view, IDataModel model, Integer index) {
    }

    public static void setMaterialValueByConfig(IFormView view, IDataModel model, Integer index) {
        model.beginInit();
        DynamicObject configuredCode = (DynamicObject)model.getValue("configuredcode");
        if (configuredCode == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)configuredCode.getLong("id"));
        DynamicObject materialConfiguredCode = QueryServiceHelper.queryOne((String)"bd_configuredcode", (String)"material", (QFilter[])qFilter.toArray());
        if (materialConfiguredCode != null) {
            if (index == null) {
                if (model.getValue("material") != null) {
                    return;
                }
                model.setValue("material", materialConfiguredCode.get("material"));
                view.updateView("material");
            } else {
                if (model.getValue("material", index.intValue()) != null) {
                    return;
                }
                model.setValue("material", materialConfiguredCode.get("material"), index.intValue());
                view.updateView("material", index.intValue());
            }
        }
        model.endInit();
    }

    public static void setTrackValueByConfig(IFormView view, IDataModel model, Integer index) {
    }

    public static void setConfigTrackValueByMat(IFormView view, IDataModel model, Integer index, Long material, Long curConfigCodeId) {
        Set<Long> configCodeIds = ConfigTrackHelper.getConfigCodeIds(Collections.singleton(material));
        if (configCodeIds.contains(curConfigCodeId)) {
            return;
        }
        if (index == null) {
            model.setValue("configuredcode", null);
            model.setValue("tracknumber", null);
            view.updateView("configuredcode");
            view.updateView("tracknumber");
        } else {
            model.setValue("configuredcode", null, index.intValue());
            model.setValue("tracknumber", null, index.intValue());
            view.updateView("configuredcode", index.intValue());
            view.updateView("tracknumber", index.intValue());
        }
    }
}

