/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostAccountHelper {
    private static Map<Long, Boolean> costaccountEnableMultiFactoryMap = new HashMap<Long, Boolean>(200);

    public static List<Long> getCostAccountByCostType(Long costTypeId) {
        ArrayList<Long> matList = new ArrayList<Long>(10);
        QFilter idQF = new QFilter("costtype", "in", (Object)costTypeId);
        QFilter enableQF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusQF = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{idQF, enableQF, statusQF});
        query.forEach(s -> matList.add(s.getLong("id")));
        return matList;
    }

    public static List<Long> getUseStdCostAccount() {
        ArrayList<Long> matList = new ArrayList<Long>(10);
        QFilter stdCostQF = new QFilter("enablestandardcost", "=", (Object)Boolean.TRUE);
        QFilter enableQF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusQF = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{stdCostQF, enableQF, statusQF});
        query.forEach(s -> matList.add(s.getLong("id")));
        return matList;
    }

    @Deprecated
    public static boolean isEnableMulFactory(Long costAccountId) {
        long calorg;
        DynamicObject costAcctObj;
        if (costAccountId == null) {
            return false;
        }
        Boolean isEnable = costaccountEnableMultiFactoryMap.get(costAccountId);
        if (isEnable == null && (costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount")) != null && (isEnable = (Boolean)SystemParamServiceHelper.getAppParameter((String)"/KIUHEXROK3D", (String)"10", (Long)(calorg = costAcctObj.getLong("calorg.id")), (Long)0L, (String)"multifactoryaccount")).booleanValue()) {
            costaccountEnableMultiFactoryMap.put(costAccountId, isEnable);
        }
        if (isEnable == null) {
            return false;
        }
        return isEnable;
    }

    public static List<Long> getOrgUseStdCostAccount(Long orgId, String appNum) {
        ArrayList<Long> matList = new ArrayList<Long>(10);
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter enableQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id,entryentity.costaccount.name name", (QFilter[])new QFilter[]{orgQF, enableQF, appNumQF});
        query.forEach(s -> matList.add(s.getLong("id")));
        return matList;
    }

    public static List<Long> getOrgStdCostAccount(Long orgId, String appNum) {
        ArrayList<Long> matList = new ArrayList<Long>(10);
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter enableQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isinitQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id,entryentity.costaccount.name name", (QFilter[])new QFilter[]{orgQF, enableQF, isinitQF, appNumQF});
        query.forEach(s -> matList.add(s.getLong("id")));
        return matList;
    }

    public static boolean isOrgEnableMulFactory(Long orgid, String appNum) {
        List<Long> costAccounts = CostAccountHelper.getOrgUseStdCostAccount(orgid, appNum);
        Boolean isEnableMulFactory = false;
        for (Long costAccount : costAccounts) {
            if (!CostAccountHelper.isEnableMulFactory(costAccount)) continue;
            isEnableMulFactory = true;
            break;
        }
        return isEnableMulFactory;
    }

    public static Long getMainCostAccount(Long accountOrgIds, String appNum) {
        QFilter orgFilter = new QFilter("org", "in", (Object)accountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter ismainaccount = new QFilter("entryentity.costaccount.ismainaccount", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, ismainaccount, appNumQF};
        DynamicObject result = QueryServiceHelper.queryOne((String)"sca_startstdcost", (String)"entryentity.costaccount.id id", (QFilter[])filters);
        if (result != null) {
            return result.getLong("id");
        }
        return 0L;
    }

    public static Long getCostAccountByOrg(Long accountOrgIds, String appNum) {
        QFilter orgFilter = new QFilter("org", "in", (Object)accountOrgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter isInitFilter = new QFilter("entryentity.isinit", "=", (Object)true);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, isInitFilter, enable, appNumQF};
        DynamicObjectCollection results = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount.id id,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])filters, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.number asc");
        if (CadEmptyUtils.isEmpty(results)) {
            return 0L;
        }
        return ((DynamicObject)results.get(0)).getLong("id");
    }

    public static Long getCostAccountByAccoutOrg(Long accountOrgId, String appnum) {
        List<Long> useActualCostAccountIds = CostAccountHelper.getOrgUseStdCostAccount(accountOrgId, appnum);
        if (useActualCostAccountIds.size() == 0) {
            return 0L;
        }
        if (useActualCostAccountIds.size() == 1) {
            return useActualCostAccountIds.get(0);
        }
        Long mainCostAccountId = CostAccountHelper.getMainCostAccount(accountOrgId, appnum);
        if (CadEmptyUtils.isEmpty(mainCostAccountId)) {
            return 0L;
        }
        for (Long costAccount : useActualCostAccountIds) {
            if (!costAccount.equals(mainCostAccountId)) continue;
            return costAccount;
        }
        return 0L;
    }

    public static Long getDefaultAccountByAcctOrg(Long accountOrgId, String appnum) {
        QFilter accountorgQF = new QFilter("org", "=", (Object)accountOrgId);
        QFilter enablestdtQF = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        enablestdtQF.and("appnum", "=", (Object)appnum);
        QFilter isinitaccountQF = new QFilter("entryentity.isinit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection result = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.costaccount costaccount,entryentity.costaccount.ismainaccount ismainaccount", (QFilter[])new QFilter[]{accountorgQF, enablestdtQF, isinitaccountQF}, (String)"entryentity.costaccount.ismainaccount desc,entryentity.costaccount.id desc");
        if (CadEmptyUtils.isEmpty(result)) {
            return 0L;
        }
        return ((DynamicObject)result.get(0)).getLong("costaccount");
    }

    public static DynamicObject getGlAccountBook(Long orgId, Long costaccountId) {
        String fields = "id, accounttable, basecurrency,exratetable,bookstype";
        QFilter orgQF = new QFilter("org", "=", (Object)orgId);
        QFilter costaccountQF = new QFilter("b_entry.b_relatebook.fbasedataid", "=", (Object)costaccountId);
        QFilter accoTypeFilter = new QFilter("bookstype.accounttype", "=", (Object)"1");
        QFilter[] qf = new QFilter[]{orgQF, costaccountQF, accoTypeFilter};
        DynamicObject accountBook = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)fields, (QFilter[])qf);
        return accountBook;
    }

    public static DynamicObject getApInit(long orgId) {
        QFilter qFilter = new QFilter("isfinishinit", "=", (Object)Boolean.TRUE).and("org", "=", (Object)orgId);
        return QueryServiceHelper.queryOne((String)"ap_init", (String)"standardcurrency.id as currency", (QFilter[])new QFilter[]{qFilter});
    }

    public static Date getCostAccountBeginDate(long orgId, String appNum) {
        DynamicObjectCollection costAccounts = StartCostHelper.getCostAccounts(orgId, true, "entryentity.costaccount costaccount", appNum);
        Date accountBeginDate = null;
        if (costAccounts != null) {
            Date tempDate = null;
            for (DynamicObject costAccount : costAccounts) {
                Date beginDate;
                long costAccountId = costAccount.getLong("costaccount");
                DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
                if (currentPeriod == null || (beginDate = currentPeriod.getDate("begindate")) == null) continue;
                if (tempDate == null) {
                    tempDate = beginDate;
                    continue;
                }
                if (!beginDate.after(tempDate)) continue;
                tempDate = beginDate;
            }
            accountBeginDate = tempDate;
        }
        return accountBeginDate;
    }

    public static List<Map<String, Date>> getImportScopeDate(Long costAccountId, String appNum) {
        Object[] timeDate;
        ArrayList<Map<String, Date>> resultMap = new ArrayList<Map<String, Date>>(1);
        if (CadEmptyUtils.isEmpty(costAccountId)) {
            return resultMap;
        }
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        if (currentPeriod != null && !CadEmptyUtils.isEmpty(timeDate = PeriodHelper.getPeriodStartAndEndTime(currentPeriod.getLong("id"))) && timeDate.length > 1) {
            HashMap<String, Object> dateMap = new HashMap<String, Object>(2);
            dateMap.put("start", timeDate[0]);
            dateMap.put("end", timeDate[1]);
            resultMap.add(dateMap);
        }
        return resultMap;
    }

    public static QFilter getImportScopeDateQf(Long costAccountId, String field, String appNum) {
        Object[] timeDate;
        QFilter timeQf = null;
        DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
        if (currentPeriod != null && !CadEmptyUtils.isEmpty(timeDate = PeriodHelper.getPeriodStartAndEndTime(currentPeriod.getLong("id"))) && timeDate.length > 1) {
            timeQf = new QFilter(field, ">", timeDate[0]);
            timeQf.and(field, "<=", timeDate[1]);
        }
        return timeQf;
    }

    public static DynamicObject getCostAccountInfo(Long costAccountId, String appNum) {
        QFilter costAccountQf = new QFilter("entry.costaccount", "=", (Object)costAccountId);
        QFilter costAccountEnableFilter = new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter("entry.startperiod", "!=", (Object)0L);
        QFilter[] filters = new QFilter[]{costAccountQf, costAccountEnableFilter, enableFilter};
        String selectedFields = "entry.costaccount.id as id,entry.costaccount.number canumber, entry.costaccount.calpolicy.currency as currency,entry.currentperiod as currentperiod";
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)selectedFields, (QFilter[])filters);
    }
}

