/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostBomImportHelper {
    private static Log logger = LogFactory.getLog(CostBomImportHelper.class);
    private static final int MAP_INITIAL_CAPACITY = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> syncBom(Long useOrgId, List<Long> manuOrgIds, String progressId) {
        String tip;
        logger.info("\u81ea\u52a8\u6267\u884c-\u540c\u6b65\u5236\u9020BOM\u5f00\u59cb\u3002\u6838\u7b97\u7ec4\u7ec7\uff1a{}", (Object)useOrgId);
        HashMap<String, String> resultMsgMap = new HashMap<String, String>(16);
        try {
            if (CadEmptyUtils.isEmpty(useOrgId)) {
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"\u6570\u636e\u9884\u5904\u7406", (String)"CostBomImportHelper_1", (String)"macc-cad-common", (Object[])new Object[0]), 1, 4, Boolean.FALSE, progressId);
            resultMsgMap.put("status", "success");
            resultMsgMap.put("qty", String.valueOf(0));
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            if (CadEmptyUtils.isEmpty(manuOrgIds)) {
                OrgRelationParam param = new OrgRelationParam();
                param.setFromViewType("10");
                param.setToViewType("04");
                param.setOrgId(useOrgId.longValue());
                param.setDirectViewType("toorg");
                param.setIncludeSelf(true);
                orgList.addAll(OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param));
            } else {
                orgList.addAll(manuOrgIds);
            }
            logger.info("\u540c\u6b65\u5236\u9020BOM\uff0c\u83b7\u53d6\u7684\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", (Object)SerializationUtils.toJsonString(orgList));
            if (orgList.isEmpty()) {
                logger.info("\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u627e\u5230\u59d4\u6258\u65b9\u751f\u4ea7\u7ec4\u7ec7\uff0c\u9700\u8981\u4ece\u7cfb\u7edf\u4e91-\u57fa\u7840\u670d\u52a1-\u7ba1\u63a7\u7b56\u7565-\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7ef4\u62a4\u59d4\u6258\u53d7\u6258\u5173\u7cfb\u3002");
                tip = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u627e\u5230\u59d4\u6258\u65b9\u751f\u4ea7\u7ec4\u7ec7\uff0c\u9700\u8981\u4ece\u201c\u7cfb\u7edf\u4e91>\u57fa\u7840\u670d\u52a1>\u7ba1\u63a7\u7b56\u7565>\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u201d\u7ef4\u62a4\u59d4\u6258\u53d7\u6258\u5173\u7cfb\u3002", (String)"CostBomImportHelper_2", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip);
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            Long user = Long.valueOf(RequestContext.get().getUserId());
            QFilter userFilter = new QFilter("user", "=", (Object)user);
            QFilter saveTypeFilter = new QFilter("savetype", "=", (Object)"A");
            DynamicObject syncRuleMS = QueryServiceHelper.queryOne((String)"cad_syncrulesave", (String)"isincrementsync,islatestaudittime,bomtype,matfilter,matfilter_tag,isreplace,isjumplevel", (QFilter[])new QFilter[]{userFilter, saveTypeFilter});
            if (syncRuleMS == null) {
                logger.info("\u672a\u8bbe\u7f6e\u540c\u6b65\u5236\u9020BOM\u89c4\u5219\uff0c\u8bf7\u70b9\u51fb\u6309\u94ae\uff1a\u66f4\u591a-\u540c\u6b65\u5236\u9020BOM\u89c4\u5219\u6765\u8bbe\u7f6e\u3002");
                String tip2 = ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u8bbe\u7f6e\u540c\u6b65\u5236\u9020BOM\u89c4\u5219\uff0c\u8bf7\u5148\u5728\u3010\u66f4\u591a\u3011->\u3010\u540c\u6b65\u5236\u9020BOM\u89c4\u5219\u3011\u4e2d\u8bbe\u7f6e\u540e\u518d\u8fdb\u884c\u540c\u6b65\u3002", (String)"CostBomImportHelper_3", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip2);
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            ArrayList<QFilter> clearCadBomList = new ArrayList<QFilter>();
            List<QFilter> qFilterList = CostBomImportHelper.getQFiltersBySyncRule(orgList, syncRuleMS, clearCadBomList);
            Boolean isLatestAuditTime = syncRuleMS.getBoolean("islatestaudittime");
            Boolean isReplace = syncRuleMS.getBoolean("isreplace");
            Boolean isJumpLevel = syncRuleMS.getBoolean("isjumplevel");
            Map<Long, Date> bomSyncDate = CostBomImportHelper.getPdm_eco();
            List<Long> fBomIds = CostBomImportHelper.getBoms(qFilterList, isLatestAuditTime, bomSyncDate);
            logger.info("\u81ea\u52a8\u6267\u884c-\u540c\u6b65\u5236\u9020BOM\uff0c\u7b26\u5408\u89c4\u5219\u7684\u5236\u9020BOM\u4e2a\u6570\uff1a{}", (Object)fBomIds.size());
            if (CadEmptyUtils.isEmpty(fBomIds)) {
                logger.info("\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u5236\u9020BOM\u3002");
                String tip3 = ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u5236\u9020BOM\u3002", (String)"CostBomImportHelper_4", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip3);
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            HashMap<String, String> matKeyColMap = new HashMap<String, String>(16);
            OperationResult msgResult = null;
            ArrayList successPkIds = new ArrayList(200);
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u9700\u8981\u540c\u6b65\u7684\u5236\u9020BOM", (String)"CostBomImportHelper_5", (String)"macc-cad-common", (Object[])new Object[0]), 2, 4, Boolean.FALSE, progressId);
            HashSet<Long> needSyncBomIds = new HashSet<Long>(10);
            Map<String, Date> existCadBOM = CostBomImportHelper.getCadBomSyncDate(manuOrgIds);
            for (Object fBomIdSubList : Lists.partition(fBomIds, (int)10000)) {
                QFilter filter = new QFilter("id", "in", fBomIdSubList);
                DynamicObject[] fBomDyos = BusinessDataServiceHelper.load((String)"pdm_mftbom", (String)"id,number,auditdate", (QFilter[])new QFilter[]{filter});
                needSyncBomIds.addAll(CostBomImportHelper.getNeedSyncBomIds(fBomDyos, bomSyncDate, existCadBOM));
            }
            logger.info("\u9700\u8981\u540c\u6b65\u7684BOM\u4e2a\u6570\uff1a{}", (Object)needSyncBomIds.size());
            if (CadEmptyUtils.isEmpty(needSyncBomIds)) {
                Object fBomIdSubList;
                logger.info("\u5df2\u7ecf\u540c\u6b65\u5230\u6700\u65b0\u4e86\u3002");
                String tip4 = ResManager.loadKDString((String)"\u5df2\u7ecf\u540c\u6b65\u5230\u6700\u65b0\u4e86\u3002", (String)"CostBomImportHelper_6", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip4);
                fBomIdSubList = resultMsgMap;
                return fBomIdSubList;
            }
            int index = 1;
            int syncBomBatchSize = CadBgParamUtils.getCadParamForInt("syncBomBatchSize", 500);
            List lists = Lists.partition(new ArrayList(needSyncBomIds), (int)syncBomBatchSize);
            for (List needSyncBomIdList : lists) {
                ProgressHelper.refreshProgress(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6279\u5236\u9020BOM\u6b63\u5728\u540c\u6b65\u3002", (String)"CostBomImportHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), index), 1, 0, Boolean.TRUE, progressId);
                List<DynamicObject> res = CostBomImportHelper.doSynce(needSyncBomIdList, bomSyncDate, useOrgId, isReplace, isJumpLevel, matKeyColMap);
                OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_costbom", (DynamicObject[])res.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!CadEmptyUtils.isEmpty(operateResult.getSuccessPkIds())) {
                    successPkIds.addAll(operateResult.getSuccessPkIds());
                }
                if (!operateResult.isSuccess()) {
                    if (msgResult == null) {
                        msgResult = operateResult;
                    } else {
                        msgResult.mergeOperateResult(operateResult);
                    }
                }
                ++index;
            }
            matKeyColMap.clear();
            if (!CadEmptyUtils.isEmpty(successPkIds)) {
                CostBomImportHelper.clearCadBom(useOrgId, manuOrgIds, clearCadBomList);
            }
            if (msgResult != null) {
                resultMsgMap.put("msg", SerializationUtils.toJsonString(msgResult));
            } else {
                logger.info("\u540c\u6b65\u5b8c\u6210\uff0c\u5df2\u6210\u529f\u540c\u6b65%s\u6761\u6570\u636e\u3002");
                String tip5 = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5b8c\u6210\uff0c\u5df2\u6210\u529f\u540c\u6b65%s\u6761\u6570\u636e\u3002", (String)"CostBomImportHelper_8", (String)"macc-cad-common", (Object[])new Object[0]), successPkIds.size());
                resultMsgMap.put("tip", tip5);
            }
            resultMsgMap.put("qty", String.valueOf(successPkIds.size()));
        }
        catch (Exception ex) {
            logger.error("\u540c\u6b65\u5236\u9020BOM\u62a5\u9519\u3002", (Throwable)ex);
            tip = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020BOM\u62a5\u9519\uff1a%s\u3002", (String)"CostBomImportHelper_9", (String)"macc-cad-common", (Object[])new Object[0]), ex.toString());
            resultMsgMap.put("status", "fail");
            resultMsgMap.put("tip", tip);
        }
        finally {
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"", (String)"CostBomImportHelper_10", (String)"macc-cad-common", (Object[])new Object[0]), -1, 0, Boolean.FALSE, progressId);
        }
        return resultMsgMap;
    }

    private static Set<Long> getNeedSyncBomIds(DynamicObject[] fBomIds, Map<Long, Date> bomSyncDate, Map<String, Date> existCadBOM) {
        HashSet<Long> bomIds = new HashSet<Long>(16);
        if (CadEmptyUtils.isEmpty(fBomIds)) {
            return bomIds;
        }
        for (DynamicObject fBomId : fBomIds) {
            Date syncTime;
            Date auditTime;
            Date date = auditTime = bomSyncDate.get(fBomId.getLong("id")) == null ? fBomId.getDate("auditdate") : bomSyncDate.get(fBomId.getLong("id"));
            if (auditTime == null) continue;
            long mftbomId = fBomId.getLong("id");
            String mftbomIdStr = String.valueOf(mftbomId);
            if (!existCadBOM.containsKey(fBomId.getString("number")) && !existCadBOM.containsKey(mftbomIdStr)) {
                bomIds.add(fBomId.getLong("id"));
                continue;
            }
            if (auditTime.before(fBomId.getDate("auditdate"))) {
                auditTime = fBomId.getDate("auditdate");
            }
            if ((syncTime = existCadBOM.get(mftbomIdStr)) == null) {
                syncTime = existCadBOM.get(fBomId.getString("number"));
            }
            if (auditTime.equals(syncTime)) continue;
            bomIds.add(mftbomId);
        }
        return bomIds;
    }

    private static List<DynamicObject> doSynce(List<Long> bomIds, Map<Long, Date> bomSyncDate, Long useOrg, Boolean isRePlace, Boolean isjumplevel, Map<String, String> matKeyColMap) {
        Object[] mfgbomBill;
        ArrayList<DynamicObject> costBomBill = new ArrayList<DynamicObject>(10);
        DynamicObject createorg = null;
        if (!CadEmptyUtils.isEmpty(useOrg)) {
            createorg = BusinessDataServiceHelper.loadSingle((Object)useOrg, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
        }
        logger.info("\u540c\u6b65\u5236\u9020BOM\uff0c\u83b7\u53d6BOM\u4e2a\u6570\uff1a{}", (Object)((mfgbomBill = BusinessDataServiceHelper.load((Object[])bomIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pdm_mftbom"))) == null ? 0 : mfgbomBill.length));
        if (CadEmptyUtils.isEmpty(mfgbomBill)) {
            return costBomBill;
        }
        CostBomImportHelper.removeInValidData((DynamicObject[])mfgbomBill, isRePlace, isjumplevel);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auxptFilter = new QFilter("isuseauxpty", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid as masterId", (QFilter[])new QFilter[]{statusFilter, enableFilter, auxptFilter});
        HashSet<Long> matWithAuxpt = new HashSet<Long>(10);
        for (DynamicObject material : materials) {
            matWithAuxpt.add(material.getLong("masterId"));
        }
        logger.info("\u540c\u6b65\u5236\u9020BOM\uff0c\u8f6c\u6362\u6210\u672cBOM\u5f00\u59cb\u3002");
        for (Object manu : mfgbomBill) {
            Object entry2;
            DynamicObjectCollection entryentitys = manu.getDynamicObjectCollection("entry");
            if (CadEmptyUtils.isEmpty((List)entryentitys)) continue;
            DynamicObject costBom = BusinessDataServiceHelper.newDynamicObject((String)"cad_costbom");
            costBom.set("number", manu.get("number"));
            costBom.set("sourceid", manu.getPkValue());
            costBom.set("type", (Object)manu.getDynamicObject("type"));
            costBom.set("group", (Object)manu.getLong("group.id"));
            costBom.set("createorg", (Object)createorg);
            costBom.set("manuorg", manu.get("createorg"));
            costBom.set("useorg", (Object)createorg);
            costBom.set("enable", (Object)manu.getString("enable"));
            costBom.set("ctrlstrategy", (Object)BaseDataServiceHelper.getBdCtrlStrgy((String)"cad_costbom", (String)String.valueOf(useOrg)));
            costBom.set("material", manu.get("material.masterid"));
            costBom.set("version", (Object)manu.getDynamicObject("version"));
            costBom.set("replaceno", (Object)manu.getDynamicObject("replaceno"));
            costBom.set("yieldrate", (Object)manu.getBigDecimal("yieldrate"));
            costBom.set("auxproperty", (Object)CalcDimenHelper.getAffectAuxpty(costBom.getDynamicObject("material") == null ? null : Long.valueOf(costBom.getLong("material.id")), manu.getDynamicObject("auxproperty")));
            costBom.set("iscoproduct", (Object)manu.getBoolean("iscoproduct"));
            costBom.set("configuredcode", (Object)manu.getDynamicObject("configuredcode"));
            if (bomSyncDate.get(manu.getLong("id")) == null) {
                costBom.set("synctime", (Object)manu.getDate("auditdate"));
            } else if (bomSyncDate.get(manu.getLong("id")).after(manu.getDate("auditdate"))) {
                costBom.set("synctime", (Object)bomSyncDate.get(manu.getLong("id")));
            } else {
                costBom.set("synctime", (Object)manu.getDate("auditdate"));
            }
            DynamicObjectCollection costCopentry = costBom.getDynamicObjectCollection("copentry");
            DynamicObjectCollection copentrys = manu.getDynamicObjectCollection("copentry");
            for (Object entry2 : copentrys) {
                DynamicObject addNew = costCopentry.addNew();
                addNew.set("copentrytype", (Object)entry2.getString("copentrytype"));
                addNew.set("copentrymaterial", entry2.get("copentrymaterial.masterid"));
                addNew.set("copentryunit", (Object)entry2.getDynamicObject("copentryunit"));
                addNew.set("copentryqty", (Object)entry2.getBigDecimal("copentryqty"));
                addNew.set("copentryoperation", (Object)entry2.getLong("copentryoperation.id"));
                addNew.set("copentryvaliddate", (Object)entry2.getDate("copentryvaliddate"));
                addNew.set("copentryinvaliddate", (Object)entry2.getDate("copentryinvaliddate"));
                addNew.set("copentryversion", (Object)entry2.getDynamicObject("copentryversion"));
                addNew.set("copentryauxproperty", (Object)CalcDimenHelper.getAffectAuxpty(addNew.getDynamicObject("copentrymaterial") == null ? null : Long.valueOf(addNew.getLong("copentrymaterial.id")), entry2.getDynamicObject("copentryauxproperty")));
            }
            DynamicObjectCollection entryentity = costBom.getDynamicObjectCollection("entry");
            entry2 = entryentitys.iterator();
            while (entry2.hasNext()) {
                DynamicObject entry3 = (DynamicObject)entry2.next();
                DynamicObject addNew = entryentity.addNew();
                addNew.set("entrytype", (Object)entry3.getString("entrytype"));
                addNew.set("entrymaterial", entry3.get("entrymaterial.masterid"));
                addNew.set("ownertype", entry3.get("entryownertype"));
                addNew.set("entryqty", (Object)entry3.getBigDecimal("entryqty"));
                addNew.set("entryunit", (Object)entry3.getDynamicObject("entryunit"));
                addNew.set("entryversion", (Object)entry3.getDynamicObject("entryversion"));
                addNew.set("entryqtytype", (Object)entry3.getString("entryqtytype"));
                addNew.set("entryqtynumerator", (Object)entry3.getBigDecimal("entryqtynumerator"));
                addNew.set("entryqtydenominator", (Object)entry3.getBigDecimal("entryqtydenominator"));
                addNew.set("entryfixscrap", (Object)entry3.getBigDecimal("entryfixscrap"));
                addNew.set("entryscraprate", (Object)entry3.getBigDecimal("entryscraprate"));
                addNew.set("entryvaliddate", (Object)entry3.getDate("entryvaliddate"));
                addNew.set("entryinvaliddate", (Object)entry3.getDate("entryinvaliddate"));
                addNew.set("entryauxproperty", (Object)CalcDimenHelper.getAffectAuxpty(addNew.getDynamicObject("entrymaterial") == null ? null : Long.valueOf(addNew.getLong("entrymaterial.id")), entry3.getDynamicObject("entryauxproperty")));
                addNew.set("owner", (Object)entry3.getLong("entryowner.id"));
                addNew.set("entryisjumplevel", (Object)entry3.getBoolean("entryisjumplevel"));
                addNew.set("entryisreplace", (Object)entry3.getBoolean("entryisreplace"));
                addNew.set("entryconfiguredcode", entry3.get("entryconfiguredcode"));
            }
            costBom.set("creator", (Object)RequestContext.getOrCreate().getUserId());
            costBom.set("createtime", (Object)TimeServiceHelper.now());
            Long matId = costBom.get("material") == null ? 0L : costBom.getLong("material.id");
            if (matWithAuxpt.contains(matId) && (manu.getDynamicObject("auxproperty") == null || manu.getDynamicObject("auxproperty").getLong("id") == 0L)) {
                costBom.set("status", (Object)"A");
            } else {
                costBom.set("status", (Object)"C");
                costBom.set("auditor", (Object)RequestContext.getOrCreate().getUserId());
                costBom.set("auditdate", (Object)TimeServiceHelper.now());
            }
            costBomBill.add(costBom);
        }
        logger.info("\u540c\u6b65\u5236\u9020BOM\uff0c\u8f6c\u6362\u6210\u672cBOM\u7ed3\u675f\u3002\u4e2a\u6570\uff1a{}", (Object)costBomBill.size());
        return costBomBill;
    }

    private static List<Long> getBoms(List<QFilter> qFilterList, Boolean isLatestAuditTime, Map<Long, Date> bomSyncDate) {
        ArrayList<Long> fBomIds = new ArrayList<Long>(200);
        if (isLatestAuditTime.booleanValue()) {
            DataSet pdmBomDataSet = QueryServiceHelper.queryDataSet((String)"getBoms#1", (String)"pdm_mftbom", (String)"id,createorg,material,auxproperty,version,type,auditdate", (QFilter[])qFilterList.toArray(new QFilter[0]), null);
            HashMap<String, Long> keyAndBom = new HashMap<String, Long>(16);
            HashMap<Long, Date> bomDateMap = new HashMap<Long, Date>(10);
            while (pdmBomDataSet.hasNext()) {
                Date nowLatestAuditTime;
                Row row = pdmBomDataSet.next();
                if (row == null) continue;
                Long bomId = row.getLong("id");
                Long createOrg = row.getLong("createorg");
                Long material = row.getLong("material");
                Long auxpropertyId = row.getLong("auxproperty");
                Long versionId = row.getLong("version");
                Long bomtype = row.getLong("type");
                Date auditDate = row.getDate("auditdate");
                String key = createOrg + "@" + material + "@" + auxpropertyId + "@" + versionId + "@" + bomtype;
                if (!keyAndBom.containsKey(key)) {
                    keyAndBom.put(key, bomId);
                    bomDateMap.put(bomId, auditDate);
                    continue;
                }
                Long nowBomid = (Long)keyAndBom.get(key);
                Date latestAduitTime = bomSyncDate.get(bomId) == null ? auditDate : bomSyncDate.get(bomId);
                Date date = nowLatestAuditTime = bomSyncDate.get(nowBomid) == null ? (Date)bomDateMap.get(nowBomid) : bomSyncDate.get(nowBomid);
                if (latestAduitTime == null || nowLatestAuditTime == null || !nowLatestAuditTime.before(latestAduitTime)) continue;
                keyAndBom.put(key, bomId);
                bomDateMap.put(bomId, latestAduitTime);
            }
            fBomIds.addAll(keyAndBom.values());
        } else {
            DataSet pdmBomDataSet = QueryServiceHelper.queryDataSet((String)"getBoms#2", (String)"pdm_mftbom", (String)"id", (QFilter[])qFilterList.toArray(new QFilter[0]), null);
            while (pdmBomDataSet.hasNext()) {
                Row row = pdmBomDataSet.next();
                if (row == null) continue;
                fBomIds.add(row.getLong("id"));
            }
        }
        return fBomIds;
    }

    public static List<QFilter> getQFiltersBySyncRule(List<Long> orgList, DynamicObject syncRuleMS, List<QFilter> clearCadBomList) {
        String matFilterStr;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        QFilter qFOrg = new QFilter("createorg", "in", orgList);
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        QFilter qFEnable = new QFilter("enable", "=", (Object)"1");
        qFilterList.add(qFOrg);
        qFilterList.add(qFilter);
        qFilterList.add(qFEnable);
        Boolean isIncrementSync = syncRuleMS.getBoolean("isincrementsync");
        Boolean isReplace = syncRuleMS.getBoolean("isreplace");
        Boolean isJumpLevel = syncRuleMS.getBoolean("isjumplevel");
        Long bomType = syncRuleMS.getLong("bomtype");
        if (!CadEmptyUtils.isEmpty(bomType)) {
            QFilter bomtypefilter = new QFilter("type", "=", (Object)bomType);
            qFilterList.add(bomtypefilter);
            clearCadBomList.add(bomtypefilter);
        }
        if (!CadEmptyUtils.isEmpty(matFilterStr = syncRuleMS.getString("matfilter_tag"))) {
            QFilter bomfilter = CostBomImportHelper.getMatQfilter((FilterCondition)SerializationUtils.fromJsonString((String)matFilterStr, FilterCondition.class));
            qFilterList.add(bomfilter);
            clearCadBomList.add(bomfilter);
        }
        QFilter matTypeFilter = new QFilter("material.masterid.configproperties", "!=", (Object)"2");
        qFilterList.add(matTypeFilter);
        if (isIncrementSync.booleanValue()) {
            HashSet<String> existMatNum = new HashSet<String>(16);
            Set<Long> sourceIdSet = CostBomImportHelper.getCadBomNum(existMatNum);
            if (!CadEmptyUtils.isEmpty(sourceIdSet)) {
                QFilter idQf = new QFilter("id", "not in", sourceIdSet);
                qFilterList.add(idQf);
            }
            if (!CadEmptyUtils.isEmpty(existMatNum)) {
                QFilter numQf = new QFilter("number", "not in", existMatNum);
                qFilterList.add(numQf);
            }
        }
        if (!isReplace.booleanValue()) {
            qFilterList.add(new QFilter("entry.entryisreplace", "=", (Object)false));
        }
        if (!isJumpLevel.booleanValue()) {
            qFilterList.add(new QFilter("entry.entryisjumplevel", "=", (Object)false));
        }
        return qFilterList;
    }

    private static Map<String, Date> getCadBomSyncDate(List<Long> manuOrgIds) {
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        QFilter[] qFilters = new QFilter[]{};
        if (CadEmptyUtils.isEmpty(manuOrgIds)) {
            qFilters = new QFilter[]{new QFilter("manuorg", "in", manuOrgIds)};
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_costbom", (String)"number,sourceid,synctime", (QFilter[])qFilters, (String)"synctime DESC");
        for (DynamicObject result : results) {
            String number = result.getString("number");
            Long sourceid = result.getLong("sourceid");
            if (CadEmptyUtils.isEmpty(sourceid)) {
                if (map.containsKey(number)) continue;
                map.put(number, result.getDate("synctime"));
                continue;
            }
            String sourceidStr = String.valueOf(sourceid);
            if (map.containsKey(sourceidStr)) continue;
            map.put(sourceidStr, result.getDate("synctime"));
        }
        return map;
    }

    private static void removeInValidData(DynamicObject[] mfgbomBill, Boolean isRePlace, Boolean isjumplevel) {
        if (CadEmptyUtils.isEmpty(mfgbomBill)) {
            return;
        }
        for (DynamicObject dynamicObject : mfgbomBill) {
            DynamicObjectCollection entryTity = dynamicObject.getDynamicObjectCollection("entry");
            Iterator iterator = entryTity.iterator();
            while (iterator.hasNext()) {
                boolean entryisjumplevel;
                boolean entryisreplace;
                DynamicObject entry = (DynamicObject)iterator.next();
                if (!isRePlace.booleanValue() && (entryisreplace = entry.getBoolean("entryisreplace"))) {
                    iterator.remove();
                    continue;
                }
                if (isjumplevel.booleanValue() || !(entryisjumplevel = entry.getBoolean("entryisjumplevel"))) continue;
                iterator.remove();
            }
        }
    }

    private static QFilter getMatQfilter(FilterCondition filterCondition) {
        QFilter qFilter = null;
        if (filterCondition != null) {
            MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_material");
            FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter matFilter = filterBuilder.getQFilter();
            if (matFilter != null) {
                DataSet matDataSet = QueryServiceHelper.queryDataSet((String)"getMatQfilter", (String)"bd_material", (String)"id", (QFilter[])new QFilter[]{matFilter}, null);
                HashSet<Long> matIds = null;
                while (matDataSet.hasNext()) {
                    Row row = matDataSet.next();
                    if (matIds == null) {
                        matIds = new HashSet<Long>(200);
                    }
                    matIds.add(row.getLong("id"));
                    if (matIds.size() < 200000) continue;
                    qFilter = qFilter == null ? new QFilter("material.masterid", "in", matIds) : qFilter.or(new QFilter("material.masterid", "in", matIds));
                    matIds = null;
                }
                if (!CadEmptyUtils.isEmpty(matIds)) {
                    qFilter = qFilter == null ? new QFilter("material.masterid", "in", matIds) : qFilter.or(new QFilter("material.masterid", "in", matIds));
                } else if (qFilter == null) {
                    qFilter = new QFilter("material.masterid", "=", (Object)-1L);
                }
            }
        }
        return qFilter;
    }

    private static Set<Long> getCadBomNum(Set<String> existedNum) {
        HashSet<Long> sourceIdSet = new HashSet<Long>();
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_costbom", (String)"number,sourceid", null);
        for (DynamicObject result : results) {
            long sourceid = result.getLong("sourceid");
            if (!CadEmptyUtils.isEmpty(sourceid)) {
                sourceIdSet.add(sourceid);
                continue;
            }
            existedNum.add(result.getString("number"));
        }
        return sourceIdSet;
    }

    private static void clearCadBom(Long useOrg, List<Long> manuOrgIds, List<QFilter> clearCadBomList) {
        if (CadEmptyUtils.isEmpty(useOrg)) {
            return;
        }
        clearCadBomList.add(new QFilter("createorg", "=", (Object)useOrg));
        if (!CadEmptyUtils.isEmpty(manuOrgIds)) {
            clearCadBomList.add(new QFilter("manuorg", "in", manuOrgIds));
        }
        ArrayList<Long> cadBomIds = new ArrayList<Long>(200);
        DataSet cadExistBomDataSet = QueryServiceHelper.queryDataSet((String)"clearCadBom", (String)"cad_costbom", (String)"id,auditdate", (QFilter[])clearCadBomList.toArray(new QFilter[0]), null);
        DataSet cpCadExistBomDataSet = cadExistBomDataSet.copy();
        while (cpCadExistBomDataSet.hasNext()) {
            Row row = cpCadExistBomDataSet.next();
            cadBomIds.add(row.getLong("id"));
        }
        if (CadEmptyUtils.isEmpty(cadBomIds)) {
            return;
        }
        DataSet cadBomSettings = QueryServiceHelper.queryDataSet((String)"clearCadBom", (String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{new QFilter("bom", "in", cadBomIds)}, null);
        HashSet<Long> usedIdSet = new HashSet<Long>();
        while (cadBomSettings.hasNext()) {
            Row row = cadBomSettings.next();
            usedIdSet.add(row.getLong("bom"));
        }
        cadBomIds.removeAll(usedIdSet);
        if (CadEmptyUtils.isEmpty(cadBomIds)) {
            return;
        }
        DataSet dataSet = cadExistBomDataSet.groupBy(new String[]{"id"}).max("auditdate").finish();
        ArrayList<Long> existBomIds = new ArrayList<Long>(200);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            existBomIds.add(row.getLong("id"));
        }
        cadBomIds.removeAll(existBomIds);
        int deleteNum = DeleteServiceHelper.delete((String)"cad_costbom", (QFilter[])new QFilter[]{new QFilter("id", "in", cadBomIds)});
        logger.info("\u6e05\u9664\u6570\u636e{}\u6761", (Object)deleteNum);
    }

    private static Map<Long, Date> getPdm_eco() {
        HashMap<Long, Date> map = new HashMap<Long, Date>(16);
        CostBomImportHelper.setPdm_eco(map, "pdm_bom_eco");
        CostBomImportHelper.setPdm_eco(map, "pdm_eco");
        return map;
    }

    private static void setPdm_eco(Map<Long, Date> map, String dataName) {
        QFilter statusQF = new QFilter("billstatus", "=", (Object)"C");
        QFilter enableQF = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection pdmEcos = QueryServiceHelper.query((String)dataName, (String)"type,pentry.pentrybom.id,auditdate", (QFilter[])new QFilter[]{statusQF, enableQF});
        for (DynamicObject pdmEco : pdmEcos) {
            if (!map.containsKey(pdmEco.getLong("pentry.pentrybom.id"))) {
                map.put(pdmEco.getLong("pentry.pentrybom.id"), pdmEco.getDate("auditdate"));
                continue;
            }
            if (!map.get(pdmEco.getLong("pentry.pentrybom.id")).before(pdmEco.getDate("auditdate"))) continue;
            map.put(pdmEco.getLong("pentry.pentrybom.id"), pdmEco.getDate("auditdate"));
        }
    }
}

