/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.dto.Bom;
import kd.macc.cad.common.dto.Router;
import kd.macc.cad.common.dto.RouterSetting;
import kd.macc.cad.common.enums.BillBaseEnum;
import kd.macc.cad.common.helper.MatBaseDataFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class CostBomRouteRefreshHelper {
    private static Log logger = LogFactory.getLog(CostBomRouteRefreshHelper.class);
    private static String[] leftStr = new String[]{"id", "material", "isenablematerialversion", "auditdate", "type", "version", "auxproperty", "keycol", "manuorg"};
    private static final String MATERIAL_ROUTER_TYPE = "A";

    public static int refreshBom(Long calOrgId) {
        int size = 0;
        Map<Long, Map<String, List<DynamicObject>>> autoExecRuleMap = CostBomRouteRefreshHelper.getAutoExecRuleMap(calOrgId);
        for (Map.Entry<Long, Map<String, List<DynamicObject>>> autoExecRule : autoExecRuleMap.entrySet()) {
            List<DynamicObject> matgroupList;
            Long costTypeId = autoExecRule.getKey();
            Map<String, List<DynamicObject>> ruleDetailsMap = autoExecRule.getValue();
            HashSet<Long> classifiedMaterials = new HashSet<Long>();
            if (ruleDetailsMap.containsKey("matgroup")) {
                matgroupList = ruleDetailsMap.get("matgroup");
                for (DynamicObject matGroup : matgroupList) {
                    DynamicObjectCollection dcs = new DynamicObjectCollection();
                    DynamicObject matGroupStdObj = matGroup.getDynamicObject("matgroupstd");
                    DynamicObject matGroupObj = matGroup.getDynamicObject("matgroup");
                    long sourceOrg = matGroup.getLong("sourceorg.id");
                    long sourceManuOrg = matGroup.getLong("sourcemanuorg.id");
                    boolean refreshNewMat = matGroup.getBoolean("refreshnewmat");
                    boolean refreshMatAttr = matGroup.getBoolean("refreshMatAttr");
                    dcs.add((Object)matGroupObj);
                    Set<Long> classifiedMaterialIds = MaterialGroupHelper.getClassifiedMaterialId(dcs, false, matGroupStdObj);
                    if (!CadEmptyUtils.isEmpty(classifiedMaterialIds)) {
                        classifiedMaterials.addAll(classifiedMaterialIds);
                    }
                    for (List materialIdList : Lists.partition(new ArrayList<Long>(classifiedMaterialIds), (int)100000)) {
                        size += CostBomRouteRefreshHelper.refreshBom(sourceOrg, sourceManuOrg, costTypeId, new HashSet<Long>(materialIdList), refreshNewMat, refreshMatAttr);
                    }
                }
            }
            if (ruleDetailsMap.containsKey("matgroupstd")) {
                matgroupList = ruleDetailsMap.get("matgroupstd");
                for (DynamicObject matGroup : matgroupList) {
                    DynamicObject matGroupStdObj = matGroup.getDynamicObject("matgroupstd");
                    long sourceOrg = matGroup.getLong("sourceorg.id");
                    long sourceManuOrg = matGroup.getLong("sourcemanuorg.id");
                    boolean refreshNewMat = matGroup.getBoolean("refreshnewmat");
                    boolean refreshMatAttr = matGroup.getBoolean("refreshMatAttr");
                    Set<Long> classifiedMaterialIds = MaterialGroupHelper.getClassifiedMaterialId(null, false, matGroupStdObj);
                    classifiedMaterialIds.removeAll(classifiedMaterials);
                    if (!CadEmptyUtils.isEmpty(classifiedMaterialIds)) {
                        classifiedMaterials.addAll(classifiedMaterialIds);
                    }
                    for (List materialIdList : Lists.partition(new ArrayList<Long>(classifiedMaterialIds), (int)100000)) {
                        size += CostBomRouteRefreshHelper.refreshBom(sourceOrg, sourceManuOrg, costTypeId, new HashSet<Long>(materialIdList), refreshNewMat, refreshMatAttr);
                    }
                }
            }
            if (!ruleDetailsMap.containsKey("nogroup")) continue;
            matgroupList = ruleDetailsMap.get("nogroup");
            for (DynamicObject matGroup : matgroupList) {
                long sourceOrg = matGroup.getLong("sourceorg.id");
                long sourceManuOrg = matGroup.getLong("sourcemanuorg.id");
                boolean refreshNewMat = matGroup.getBoolean("refreshnewmat");
                boolean refreshMatAttr = matGroup.getBoolean("refreshMatAttr");
                Set<Long> classifiedMaterialIds = OrgHelper.getMaterialByCalOrgId(Collections.singleton(sourceOrg));
                classifiedMaterialIds.removeAll(classifiedMaterials);
                for (List materialIdList : Lists.partition(new ArrayList<Long>(classifiedMaterialIds), (int)100000)) {
                    size += CostBomRouteRefreshHelper.refreshBom(sourceOrg, sourceManuOrg, costTypeId, new HashSet<Long>(materialIdList), refreshNewMat, refreshMatAttr);
                }
            }
        }
        return size;
    }

    public static int refreshRoute(Long calOrgId) {
        int size = 0;
        Map<Long, Map<String, List<DynamicObject>>> autoExecRuleMap = CostBomRouteRefreshHelper.getAutoExecRuleMap(calOrgId);
        for (Map.Entry<Long, Map<String, List<DynamicObject>>> autoExecRule : autoExecRuleMap.entrySet()) {
            List<DynamicObject> matgroupList;
            Long costTypeId = autoExecRule.getKey();
            Map<String, List<DynamicObject>> ruleDetailsMap = autoExecRule.getValue();
            HashSet<Long> classifiedMaterials = new HashSet<Long>();
            if (ruleDetailsMap.containsKey("matgroup")) {
                matgroupList = ruleDetailsMap.get("matgroup");
                for (DynamicObject matGroup : matgroupList) {
                    DynamicObjectCollection dcs = new DynamicObjectCollection();
                    DynamicObject matGroupStdObj = matGroup.getDynamicObject("matgroupstd");
                    DynamicObject matGroupObj = matGroup.getDynamicObject("matgroup");
                    long sourceOrg = matGroup.getLong("sourceorg.id");
                    long sourceManuOrg = matGroup.getLong("sourcemanuorg.id");
                    boolean refreshNewMat = matGroup.getBoolean("refreshnewmat");
                    dcs.add((Object)matGroupObj);
                    Set<Long> classifiedMaterialIds = MaterialGroupHelper.getClassifiedMaterialId(dcs, false, matGroupStdObj);
                    if (!CadEmptyUtils.isEmpty(classifiedMaterialIds)) {
                        classifiedMaterials.addAll(classifiedMaterialIds);
                    }
                    for (List materialIdList : Lists.partition(new ArrayList<Long>(classifiedMaterialIds), (int)100000)) {
                        size += CostBomRouteRefreshHelper.refreshRoute(sourceOrg, sourceManuOrg, costTypeId, new HashSet<Long>(materialIdList), refreshNewMat);
                    }
                }
            }
            if (ruleDetailsMap.containsKey("matgroupstd")) {
                matgroupList = ruleDetailsMap.get("matgroupstd");
                for (DynamicObject matGroup : matgroupList) {
                    DynamicObject matGroupStdObj = matGroup.getDynamicObject("matgroupstd");
                    long sourceOrg = matGroup.getLong("sourceorg.id");
                    long sourceManuOrg = matGroup.getLong("sourcemanuorg.id");
                    boolean refreshNewMat = matGroup.getBoolean("refreshnewmat");
                    Set<Long> classifiedMaterialIds = MaterialGroupHelper.getClassifiedMaterialId(null, false, matGroupStdObj);
                    classifiedMaterialIds.removeAll(classifiedMaterials);
                    if (!CadEmptyUtils.isEmpty(classifiedMaterialIds)) {
                        classifiedMaterials.addAll(classifiedMaterialIds);
                    }
                    for (List materialIdList : Lists.partition(new ArrayList<Long>(classifiedMaterialIds), (int)100000)) {
                        size += CostBomRouteRefreshHelper.refreshRoute(sourceOrg, sourceManuOrg, costTypeId, new HashSet<Long>(materialIdList), refreshNewMat);
                    }
                }
            }
            if (!ruleDetailsMap.containsKey("nogroup")) continue;
            matgroupList = ruleDetailsMap.get("nogroup");
            for (DynamicObject matGroup : matgroupList) {
                long sourceOrg = matGroup.getLong("sourceorg.id");
                long sourceManuOrg = matGroup.getLong("sourcemanuorg.id");
                boolean refreshNewMat = matGroup.getBoolean("refreshnewmat");
                Set<Long> classifiedMaterialIds = OrgHelper.getMaterialByCalOrgId(Collections.singleton(sourceOrg));
                classifiedMaterialIds.removeAll(classifiedMaterials);
                for (List materialIdList : Lists.partition(new ArrayList<Long>(classifiedMaterialIds), (int)100000)) {
                    size += CostBomRouteRefreshHelper.refreshRoute(sourceOrg, sourceManuOrg, costTypeId, new HashSet<Long>(materialIdList), refreshNewMat);
                }
            }
        }
        return size;
    }

    private static Map<Long, Map<String, List<DynamicObject>>> getAutoExecRuleMap(Long calOrgId) {
        HashMap<Long, Map<String, List<DynamicObject>>> autoExecRuleMap = new HashMap<Long, Map<String, List<DynamicObject>>>(16);
        QFilter filter = new QFilter("autoexecorg", "=", (Object)calOrgId);
        Object[] autoExecRuleSettings = BusinessDataServiceHelper.load((String)"cad_autoexecrulesetting", (String)"costtype,entryentity.matgroupstd,entryentity.matgroup,entryentity.sourceorg,entryentity.sourcemanuorg,entryentity.refreshnewmat,entryentity.refreshmatattr", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(autoExecRuleSettings)) {
            return autoExecRuleMap;
        }
        for (Object autoExecRuleSetting : autoExecRuleSettings) {
            DynamicObjectCollection entryentity = autoExecRuleSetting.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryentity) {
                Map costtypeMap = autoExecRuleMap.computeIfAbsent(autoExecRuleSetting.getLong("costtype.id"), p -> new HashMap());
                if (!CadEmptyUtils.isEmpty(entry.getLong("matgroup.id"))) {
                    costtypeMap.computeIfAbsent("matgroup", p -> new ArrayList()).add(entry);
                    continue;
                }
                if (!CadEmptyUtils.isEmpty(entry.getLong("matgroupstd.id"))) {
                    costtypeMap.computeIfAbsent("matgroupstd", p -> new ArrayList()).add(entry);
                    continue;
                }
                costtypeMap.computeIfAbsent("nogroup", p -> new ArrayList()).add(entry);
            }
        }
        return autoExecRuleMap;
    }

    public static int refreshBom(Long calOrgId, Long manuorgId, Long costTypeId, Set<Long> materialIds, Boolean isOnlyRefreshNewMat, Boolean refreshMatAttr) {
        int size = 0;
        if (CadEmptyUtils.isEmpty(calOrgId) || CadEmptyUtils.isEmpty(costTypeId) || CadEmptyUtils.isEmpty(materialIds)) {
            return size;
        }
        HashSet<String> matIdsForNewBomSetting = new HashSet<String>(16);
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter matFilter = new QFilter("material", "in", materialIds);
        QFilter[] qFilters = new QFilter[]{costTypeFilter, enableFilter, matFilter};
        DataSet bomSettings = QueryServiceHelper.queryDataSet((String)"cad.bomsetting.query", (String)"cad_bomsetting", (String)"id,bom,material,bomversion,auxprop,keycol", (QFilter[])qFilters, null);
        QFilter statusFilter = new QFilter("status", "=", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
        if (!CadEmptyUtils.isEmpty(manuorgId)) {
            enableFilter.and(new QFilter("manuorg", "=", (Object)manuorgId));
        }
        QFilter calOrgIdQf = new QFilter("createorg", "=", (Object)calOrgId);
        QFilter[] filters = new QFilter[]{calOrgIdQf, matFilter, statusFilter, enableFilter};
        DataSet bomRows = QueryServiceHelper.queryDataSet((String)"cad.bom.query", (String)"cad_costbom", (String)"id,keycol,auditdate,type,version,version.number versionnumber", (QFilter[])filters, null);
        bomRows = bomRows.orderBy(new String[]{"auditdate desc", "versionnumber desc"});
        HashSet<String> existKcs = new HashSet<String>(10);
        ArrayList<Long> bomIds = new ArrayList<Long>(10);
        while (bomRows.hasNext()) {
            Row row = bomRows.next();
            String keycol = row.getString("keycol");
            if (!existKcs.add(keycol)) continue;
            bomIds.add(row.getLong("id"));
        }
        QFilter idFilter = new QFilter("id", "in", bomIds);
        bomRows = QueryServiceHelper.queryDataSet((String)"cad.bom.query", (String)"cad_costbom", (String)"id,manuorg,material,keycol,material.isenablematerialversion as isenablematerialversion,auditdate,type,version,auxproperty,configuredcode", (QFilter[])new QFilter[]{idFilter}, null);
        Boolean isUseVersion = CostBomRouteRefreshHelper.getIsuseVersionCal(costTypeId);
        DataSet resultDataSet = bomRows.copy().leftJoin(bomSettings).on("keycol", "keycol").select(leftStr, new String[]{"id as setid", "bom as bomid"}).finish();
        DataSet newDataSet = resultDataSet.filter("setid is null");
        DataSet updataDataSet = resultDataSet.filter("setid is not null and id != bomid");
        DataSet refreshMatAttrDataSet = resultDataSet.filter("manuorg !=0 and setid is not null and id = bomid");
        HashSet<Long> materials = new HashSet<Long>(10);
        while (newDataSet.hasNext()) {
            Row row = newDataSet.next();
            String keycol = row.getString("keycol");
            matIdsForNewBomSetting.add(keycol);
            materials.add(row.getLong("material"));
        }
        HashSet<Long> bomSetIds = new HashSet<Long>(16);
        while (updataDataSet.hasNext()) {
            Row next = updataDataSet.next();
            Long setid = next.getLong("setid");
            bomSetIds.add(setid);
            materials.add(next.getLong("material"));
        }
        Object[] bomSettingsForUpdate = null;
        if (bomSetIds.size() > 0) {
            bomSettingsForUpdate = BusinessDataServiceHelper.load((Object[])bomSetIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_bomsetting"));
        }
        Map<Long, String> matProduceInfoAttrMap = CostBomRouteRefreshHelper.getMatProduceInfoAttr(calOrgId, manuorgId, materials);
        logger.info("\u5237\u65b0\u6210\u672cBOM\u8bbe\u7f6e\u3002\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u4e2a\u6570\uff1a{}\u3002\u6761\u4ef6\uff1a\u6838\u7b97\u7ec4\u7ec7\uff1a{}\uff0c\u751f\u4ea7\u7ec4\u7ec7\uff1a{}\uff0c\u7269\u6599\uff1a{}", new Object[]{matProduceInfoAttrMap.size(), calOrgId, manuorgId, SerializationUtils.toJsonString(materials)});
        Map<String, Bom> matIdAndMaxAudDateBom = CostBomRouteRefreshHelper.getMaxAuditDateBom(bomRows, isUseVersion);
        if (!isOnlyRefreshNewMat.booleanValue() && !CadEmptyUtils.isEmpty(bomSettingsForUpdate)) {
            int updCount = CostBomRouteRefreshHelper.updateBomSettings((DynamicObject[])bomSettingsForUpdate, matIdAndMaxAudDateBom, isUseVersion, matProduceInfoAttrMap);
            logger.info("\u5237\u65b0\u6210\u672cBOM\u8bbe\u7f6e\u3002\u66f4\u65b0\u4e2a\u6570\uff1a{}", (Object)updCount);
            size += updCount;
        }
        if (!CadEmptyUtils.isEmpty(matIdsForNewBomSetting)) {
            int newCount = CostBomRouteRefreshHelper.newBomSettings(costTypeId, matIdAndMaxAudDateBom, matIdsForNewBomSetting, isUseVersion, matProduceInfoAttrMap);
            logger.info("\u5237\u65b0\u6210\u672cBOM\u8bbe\u7f6e\u3002\u65b0\u589e\u4e2a\u6570\uff1a{}", (Object)newCount);
            size += newCount;
        }
        if (refreshMatAttr.booleanValue()) {
            int updateMatAttr = CostBomRouteRefreshHelper.updateBomSettingMatAttr(calOrgId, manuorgId, refreshMatAttrDataSet);
            size += updateMatAttr;
        }
        return size;
    }

    private static int updateBomSettingMatAttr(Long calOrgId, Long manuorgId, DataSet resultDataSet) {
        HashSet<Long> bomIds = new HashSet<Long>(16);
        HashSet<Long> matIds = new HashSet<Long>(10);
        while (resultDataSet.hasNext()) {
            Row row = resultDataSet.next();
            bomIds.add(row.getLong("setid"));
            matIds.add(row.getLong("material"));
        }
        Object[] bomSettingsForUpdates = BusinessDataServiceHelper.load((String)"cad_bomsetting", (String)"material,matcalcprop,isdowncalc", (QFilter[])new QFilter[]{new QFilter("id", "in", bomIds)});
        if (CadEmptyUtils.isEmpty(bomSettingsForUpdates)) {
            return 0;
        }
        Map<Long, String> matProduceInfoAttrMap = CostBomRouteRefreshHelper.getMatProduceInfoAttr(calOrgId, manuorgId, matIds);
        ArrayList<Object> updateObjs = new ArrayList<Object>(10);
        for (Object bomSettingsForUpdate : bomSettingsForUpdates) {
            long material = bomSettingsForUpdate.getLong("material.masterid");
            String matcalcprop = bomSettingsForUpdate.getString("matcalcprop");
            if (matProduceInfoAttrMap.containsKey(material) && matProduceInfoAttrMap.get(material).equals(matcalcprop)) continue;
            bomSettingsForUpdate.set("matcalcprop", (Object)matProduceInfoAttrMap.getOrDefault(material, "B"));
            if ("B".equals(matProduceInfoAttrMap.getOrDefault(material, "B"))) {
                bomSettingsForUpdate.set("isdowncalc", (Object)Boolean.FALSE);
            } else {
                bomSettingsForUpdate.set("isdowncalc", (Object)Boolean.TRUE);
            }
            updateObjs.add(bomSettingsForUpdate);
        }
        if (CadEmptyUtils.isEmpty(updateObjs)) {
            return 0;
        }
        SaveServiceHelper.update((DynamicObject[])updateObjs.toArray(new DynamicObject[0]));
        return updateObjs.size();
    }

    private static Map<Long, String> getMatProduceInfoAttr(Long org, Long manuOrg, Set<Long> materialIds) {
        ArrayList<Long> productOrgs = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty(manuOrg)) {
            OrgRelationParam param = new OrgRelationParam();
            param.setFromViewType("10");
            param.setToViewType("04");
            param.setOrgId(org.longValue());
            param.setIncludeSelf(true);
            productOrgs.addAll(OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param));
        } else {
            productOrgs.add(manuOrg);
        }
        logger.info("\u5237\u65b0\u6210\u672cBOM\u8bbe\u7f6e\u3002\u83b7\u53d6\u7269\u6599\u751f\u4ea7\u4fe1\u606f\uff0c\u59d4\u6258\u7684\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", (Object)SerializationUtils.toJsonString(productOrgs));
        QFilter orgFilter = MatBaseDataFilterHelper.getOrgCtrlQfilter(new ArrayList<Long>(productOrgs), "bd_materialmftinfo");
        QFilter matInfoFilter = new QFilter("masterid", "in", materialIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DataSet materialmftinfos = QueryServiceHelper.queryDataSet((String)"getMatProduceInfo#1", (String)"bd_materialmftinfo", (String)"id,masterid,materialattr,ctrlstrategy,case when materialattr = '10030' then '1' when materialattr = '10020' then '2' when materialattr = '10050' then '3' when materialattr = '10040' then '4' else '4' end level", (QFilter[])new QFilter[]{orgFilter, matInfoFilter, statusFilter, enableFilter}, null);
        materialmftinfos = materialmftinfos.select("id,masterid,materialattr,ctrlstrategy,level").orderBy(new String[]{"ctrlstrategy desc", "level asc"});
        HashMap<Long, String> matAttrMap = new HashMap<Long, String>(16);
        while (materialmftinfos.hasNext()) {
            Row row = materialmftinfos.next();
            Long material = row.getLong("masterid");
            String materialAttr = row.getString("materialattr");
            if (matAttrMap.containsKey(material)) continue;
            if ("10020".equals(materialAttr) || "10030".equals(materialAttr)) {
                matAttrMap.put(material, MATERIAL_ROUTER_TYPE);
                continue;
            }
            if ("10050".equals(materialAttr)) {
                matAttrMap.put(material, "C");
                continue;
            }
            if ("10040".equals(materialAttr)) {
                matAttrMap.put(material, "B");
                continue;
            }
            matAttrMap.put(material, "B");
        }
        return matAttrMap;
    }

    private static int newBomSettings(Long costTypeId, Map<String, Bom> matIdAndMaxAudDateBom, Set<String> matIdsForNewBomSetting, Boolean isUseVersion, Map<Long, String> matProduceInfoAttrMap) {
        int size = 0;
        if (CadEmptyUtils.isEmpty(matIdsForNewBomSetting)) {
            return size;
        }
        String userId = RequestContext.get().getUserId();
        Date now = TimeServiceHelper.now();
        ArrayList<DynamicObject> bomSettingObjForNew = new ArrayList<DynamicObject>(10);
        String[] batchNumber = CostBomRouteRefreshHelper.getBatchBillNumbers(matIdAndMaxAudDateBom, matIdsForNewBomSetting);
        boolean isNeedNew = false;
        int count = 0;
        for (String bomMatId : matIdsForNewBomSetting) {
            Bom bom = matIdAndMaxAudDateBom.get(bomMatId);
            if (bom == null) continue;
            DynamicObject bomSettingObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_bomsetting");
            bomSettingObj.set("costtype", (Object)costTypeId);
            bomSettingObj.set("number", (Object)batchNumber[count]);
            bomSettingObj.set("material", (Object)bom.getMaterialId());
            bomSettingObj.set("bomtype", (Object)bom.getType());
            if (isUseVersion.booleanValue()) {
                bomSettingObj.set("bomversion", (Object)bom.getVersion());
            }
            bomSettingObj.set("isdowncalc", (Object)1);
            bomSettingObj.set("consideryieldrate", (Object)1);
            bomSettingObj.set("considersubmaterialloss", (Object)1);
            bomSettingObj.set("considervalidperiod", (Object)1);
            bomSettingObj.set("lossrateformula", (Object)"1");
            bomSettingObj.set("bom", (Object)bom.getId());
            bomSettingObj.set("creator", (Object)userId);
            bomSettingObj.set("createtime", (Object)now);
            bomSettingObj.set("modifier", (Object)userId);
            bomSettingObj.set("modifytime", (Object)now);
            bomSettingObj.set("auditor", (Object)userId);
            bomSettingObj.set("auditdate", (Object)now);
            bomSettingObj.set("enable", (Object)"1");
            bomSettingObj.set("status", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
            bomSettingObj.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
            bomSettingObj.set("expdate", (Object)DateUtils.getDeFaultExpDate());
            bomSettingObj.set("auxprop", (Object)bom.getAuxProperty());
            bomSettingObj.set("configuredcode", (Object)bom.getConfiguredcode());
            bomSettingObj.set("keycol", (Object)bom.getKeycol());
            bomSettingObj.set("matcalcprop", (Object)matProduceInfoAttrMap.getOrDefault(bom.getMaterialId(), "B"));
            if ("B".equals(bomSettingObj.getString("matcalcprop"))) {
                bomSettingObj.set("isdowncalc", (Object)Boolean.FALSE);
            } else {
                bomSettingObj.set("isdowncalc", (Object)Boolean.TRUE);
            }
            bomSettingObjForNew.add(bomSettingObj);
            isNeedNew = true;
            ++count;
        }
        if (isNeedNew) {
            Object[] result = SaveServiceHelper.save((DynamicObject[])bomSettingObjForNew.toArray(new DynamicObject[0]));
            size = CostBomRouteRefreshHelper.recordChangedData(result, "cad_bomsetting");
        }
        return size;
    }

    private static int recordChangedData(Object[] result, String entity) {
        ArrayList<Object> successPks = new ArrayList<Object>(16);
        for (Object obj : result) {
            if (!(obj instanceof DynamicObject)) continue;
            successPks.add(((DynamicObject)obj).getPkValue());
        }
        String opKey = "refreshdata";
        logger.info("\u5f53\u524d\u5b9e\u4f53\uff1a" + entity + "\u901a\u8fc7\u64cd\u4f5c" + opKey + "\u53d8\u66f4\u6570\u636e\u6761\u6570\uff1a" + successPks.size());
        int size = 0;
        if (successPks.size() > 0) {
            size = (Integer)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"RecordCalcDataChangeService", (String)"recordCalcChangedData", (Object[])new Object[]{entity, successPks, opKey});
            logger.info("\u4fdd\u5b58\u5b9e\u4f53\uff1a" + entity + "\u53d8\u66f4\u8bb0\u5f55\u6210\u529f\u6761\u6570\uff1a" + size);
        }
        return size;
    }

    private static String[] getBatchBillNumbers(Map<String, Bom> matIdAndMaxAudDateBom, Set<String> matIdsForNewBomSetting) {
        int billNoCount = 0;
        for (String bomMatId : matIdsForNewBomSetting) {
            Bom bom = matIdAndMaxAudDateBom.get(bomMatId);
            if (bom == null) continue;
            ++billNoCount;
        }
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"cad_bomsetting");
        return CodeRuleServiceHelper.getBatchNumber((String)"cad_bomsetting", (DynamicObject)dataInfo, (String)RequestContext.get().getLoginOrg(), (int)billNoCount);
    }

    private static int updateBomSettings(DynamicObject[] bomSettingsForUpdate, Map<String, Bom> matIdAndMaxAudDateBom, Boolean isUseVersion, Map<Long, String> matProduceInfoAttrMap) {
        int size = 0;
        if (CadEmptyUtils.isEmpty(bomSettingsForUpdate)) {
            return size;
        }
        try {
            String userId = RequestContext.get().getUserId();
            Date now = TimeServiceHelper.now();
            ArrayList<DynamicObject> needUpdates = new ArrayList<DynamicObject>(10);
            for (DynamicObject bomSetting : bomSettingsForUpdate) {
                long existBomId = bomSetting.get("bom.id") == null ? 0L : bomSetting.getLong("bom.id");
                String keycol = bomSetting.getString("keycol");
                Bom maxAuditDateBom = matIdAndMaxAudDateBom.get(keycol);
                if (matIdAndMaxAudDateBom == null && (maxAuditDateBom == null || existBomId == maxAuditDateBom.getId())) continue;
                Long bomId = maxAuditDateBom.getId() == null ? Long.valueOf(0L) : maxAuditDateBom.getId();
                bomSetting.set("bom", (Object)bomId);
                bomSetting.set("material", (Object)maxAuditDateBom.getMaterialId());
                bomSetting.set("auxprop", (Object)maxAuditDateBom.getAuxProperty());
                bomSetting.set("configuredcode", (Object)maxAuditDateBom.getConfiguredcode());
                bomSetting.set("keycol", (Object)maxAuditDateBom.getKeycol());
                bomSetting.set("modifier", (Object)userId);
                bomSetting.set("modifytime", (Object)now);
                bomSetting.set("auditdate", (Object)now);
                bomSetting.set("auditor", (Object)userId);
                bomSetting.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                bomSetting.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                bomSetting.set("matcalcprop", (Object)matProduceInfoAttrMap.getOrDefault(maxAuditDateBom.getMaterialId(), "B"));
                if ("B".equals(bomSetting.getString("matcalcprop"))) {
                    bomSetting.set("isdowncalc", (Object)Boolean.FALSE);
                } else {
                    bomSetting.set("isdowncalc", (Object)Boolean.TRUE);
                }
                bomSetting.set("bomtype", (Object)maxAuditDateBom.getType());
                needUpdates.add(bomSetting);
            }
            if (!CadEmptyUtils.isEmpty(needUpdates)) {
                Object[] result = SaveServiceHelper.save((DynamicObject[])needUpdates.toArray(new DynamicObject[0]));
                size = CostBomRouteRefreshHelper.recordChangedData(result, "cad_bomsetting");
            }
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0BOM\u8bbe\u7f6e\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return size;
    }

    private static Map<String, Bom> getMaxAuditDateBom(DataSet rows, Boolean isUseVersion) {
        HashMap<String, List> matIdAndBomListMap = new HashMap<String, List>(16);
        for (Row row : rows) {
            Long bomId;
            Date auditDate = row.getDate("auditdate");
            if (auditDate == null || (bomId = row.getLong("id")) == null) continue;
            Long materialId = row.getLong("material");
            Long type = row.getLong("type");
            Long version = row.getLong("version");
            Long auxproperty = row.getLong("auxproperty");
            Long configCode = row.getLong("configuredcode");
            String keycol = row.getString("keycol");
            Bom bom = new Bom();
            bom.setMaterialId(materialId);
            bom.setId(bomId);
            bom.setAuditDate(auditDate);
            bom.setType(type);
            bom.setVersion(version);
            bom.setAuxProperty(auxproperty);
            bom.setConfiguredcode(configCode);
            bom.setKeycol(keycol);
            matIdAndBomListMap.computeIfAbsent(keycol, v -> new ArrayList(10)).add(bom);
        }
        HashMap<String, Bom> matIdAndMaxAudDateBom = new HashMap<String, Bom>(16);
        for (Map.Entry entry : matIdAndBomListMap.entrySet()) {
            String keycol = (String)entry.getKey();
            Bom maxAuditDateRouter = ((List)entry.getValue()).stream().max(Comparator.comparing(Bom::getAuditDate)).get();
            matIdAndMaxAudDateBom.put(keycol, maxAuditDateRouter);
        }
        return matIdAndMaxAudDateBom;
    }

    private static Boolean getIsuseVersionCal(Long costTypeLongId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)costTypeLongId, (String)"cad_costtype", (String)"isuseversion");
        return !dynamicObject.getBoolean("isuseversion");
    }

    public static int refreshRoute(Long calOrgId, Long manuorgId, Long costTypeId, Set<Long> materialIds, Boolean isOnlyRefreshNewMat) {
        int size = 0;
        if (CadEmptyUtils.isEmpty(calOrgId) || CadEmptyUtils.isEmpty(costTypeId) || CadEmptyUtils.isEmpty(materialIds)) {
            return size;
        }
        Map<String, List<RouterSetting>> matIdsForRouterSettingRefresh = CostBomRouteRefreshHelper.filterRouterSettingForRefresh(costTypeId, materialIds);
        Map<String, Router> matIdAndMaxAudDateRouter = CostBomRouteRefreshHelper.getMaxAuditDateRouterForMaterial(calOrgId, materialIds, manuorgId);
        if (!CadEmptyUtils.isEmpty(matIdsForRouterSettingRefresh)) {
            List<DynamicObject> routerSettingsForUpdate = CostBomRouteRefreshHelper.constructRouterSettingForUpdate(matIdsForRouterSettingRefresh, matIdAndMaxAudDateRouter);
            if (!isOnlyRefreshNewMat.booleanValue() && !CadEmptyUtils.isEmpty(routerSettingsForUpdate)) {
                Object[] result = SaveServiceHelper.save((DynamicObject[])routerSettingsForUpdate.toArray(new DynamicObject[0]));
                size += CostBomRouteRefreshHelper.recordChangedData(result, "cad_routersetting");
            }
        }
        HashMap<String, Router> matIdAndMaxAudDateRouterMap = new HashMap<String, Router>();
        for (Map.Entry<String, Router> entry : matIdAndMaxAudDateRouter.entrySet()) {
            Router router = entry.getValue();
            String processType = router.getProcessType();
            if (!MATERIAL_ROUTER_TYPE.equals(processType)) continue;
            matIdAndMaxAudDateRouterMap.put(entry.getKey(), router);
        }
        List<DynamicObject> routerSettingsForNew = CostBomRouteRefreshHelper.constructRouterSettingForNew(costTypeId, matIdAndMaxAudDateRouterMap, manuorgId);
        if (!CadEmptyUtils.isEmpty(routerSettingsForNew)) {
            Object[] result = SaveServiceHelper.save((DynamicObject[])routerSettingsForNew.toArray(new DynamicObject[0]));
            size += CostBomRouteRefreshHelper.recordChangedData(result, "cad_routersetting");
            CostBomRouteRefreshHelper.removeDuplicatedRouteSettingForPerMat(costTypeId, routerSettingsForNew);
            CostBomRouteRefreshHelper.removeDuplicatedRouteSettingForRouter(costTypeId, routerSettingsForNew);
        }
        return size;
    }

    private static void removeDuplicatedRouteSettingForRouter(Long costTypeId, List<DynamicObject> routerSettingsForNew) {
        ArrayList<Long> routerIds = new ArrayList<Long>(10);
        for (DynamicObject routerSetting : routerSettingsForNew) {
            routerIds.add(routerSetting.getLong("router"));
        }
        QFilter filter = new QFilter("router", "in", routerIds);
        filter.and("costtype", "=", (Object)costTypeId);
        filter.and("routertype", "in", (Object)new String[]{"B", "C"});
        DeleteServiceHelper.delete((String)"cad_routersetting", (QFilter[])new QFilter[]{filter});
    }

    private static void removeDuplicatedRouteSettingForPerMat(Long costTypeId, List<DynamicObject> routerSettingsForNew) {
        HashSet<Long> materialIdForNew = new HashSet<Long>(16);
        HashSet<String> matAndAuxptySet = new HashSet<String>();
        for (DynamicObject entry : routerSettingsForNew) {
            DynamicObjectCollection materialEntry = entry.getDynamicObjectCollection("materialentry");
            for (DynamicObject item2 : materialEntry) {
                long material = item2.getLong("material.id");
                long auxpty = item2.getLong("auxpty.id");
                materialIdForNew.add(material);
                matAndAuxptySet.add(material + "@" + auxpty);
            }
        }
        for (List matIds : Lists.partition(new ArrayList(materialIdForNew), (int)10000)) {
            QFilter matIdFilter = new QFilter("materialentry.material", "in", (Object)matIds);
            QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
            DynamicObjectCollection routerSettings = QueryServiceHelper.query((String)"cad_routersetting", (String)"id", (QFilter[])new QFilter[]{matIdFilter, costTypeFilter});
            Set<Object> routerSettingIds = routerSettings.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] routerSettingsObj = BusinessDataServiceHelper.load((Object[])routerSettingIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_routersetting"));
            ArrayList<DynamicObject> routerSettingForSave = new ArrayList<DynamicObject>(10);
            for (DynamicObject routerSetting : routerSettingsObj) {
                DynamicObjectCollection entry = routerSetting.getDynamicObjectCollection("materialentry");
                if (entry.size() <= 1) continue;
                List materialToRemove = entry.stream().filter(item -> matAndAuxptySet.contains(item.getLong("material.id") + "@" + item.getLong("auxpty.id"))).collect(Collectors.toList());
                entry.removeAll(materialToRemove);
                routerSettingForSave.add(routerSetting);
            }
            if (CadEmptyUtils.isEmpty(routerSettingForSave)) continue;
            SaveServiceHelper.save((DynamicObject[])routerSettingForSave.toArray(new DynamicObject[0]));
        }
    }

    private static List<DynamicObject> constructRouterSettingForNew(Long costTypeId, Map<String, Router> matIdAndMaxAudDateRouter, Object manuorgId) {
        ArrayList<DynamicObject> routerSettingsForNew = new ArrayList<DynamicObject>(10);
        String[] batchNumber = CostBomRouteRefreshHelper.getBatchBillNumbers(matIdAndMaxAudDateRouter.size());
        String userId = RequestContext.get().getUserId();
        if (!CadEmptyUtils.isEmpty(matIdAndMaxAudDateRouter)) {
            int count = 0;
            for (Map.Entry<String, Router> mapEntry : matIdAndMaxAudDateRouter.entrySet()) {
                Router maxAuditDateRouter = mapEntry.getValue();
                if (maxAuditDateRouter == null) continue;
                DynamicObject routerSettingObj = BusinessDataServiceHelper.newDynamicObject((String)"cad_routersetting");
                DynamicObjectCollection entryEntity = routerSettingObj.getDynamicObjectCollection("materialentry");
                routerSettingObj.set("costtype", (Object)costTypeId);
                String num = batchNumber == null ? "null" : batchNumber.length + "";
                logger.info("\u8def\u7ebf\u8bbe\u7f6e\u6570\u636e\u6570\u91cf:" + count + "  \u7f16\u53f7\u6570\u7ec4\u957f\u5ea6:" + num);
                if (batchNumber == null || batchNumber != null && count >= batchNumber.length) {
                    String[] batchNumberAgain = CodeRuleServiceHelper.getBatchNumber((String)"cad_routersetting", (DynamicObject)routerSettingObj, (String)RequestContext.get().getLoginOrg(), (int)1);
                    if (batchNumberAgain == null || batchNumberAgain.length == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u201c\u6210\u672c\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e\u201d\u5b9e\u4f53\u83b7\u53d6\u7f16\u53f7\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"CostBomRouteRefreshHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
                    }
                    routerSettingObj.set("number", (Object)batchNumberAgain[0]);
                } else {
                    routerSettingObj.set("number", (Object)batchNumber[count]);
                }
                routerSettingObj.set("router", (Object)maxAuditDateRouter.getId());
                routerSettingObj.set("routertype", (Object)maxAuditDateRouter.getProcessType());
                routerSettingObj.set("considerpreparetime", (Object)1);
                DynamicObject entry = entryEntity.addNew();
                entry.set("material", (Object)maxAuditDateRouter.getMaterial());
                entry.set("auxpty", (Object)maxAuditDateRouter.getAuxproperty());
                entry.set("keycol", (Object)maxAuditDateRouter.getKeycol());
                routerSettingObj.set("status", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
                routerSettingObj.set("enable", (Object)1);
                routerSettingObj.set("creator", (Object)userId);
                routerSettingObj.set("createtime", (Object)TimeServiceHelper.now());
                routerSettingObj.set("modifier", (Object)userId);
                routerSettingObj.set("modifytime", (Object)TimeServiceHelper.now());
                routerSettingObj.set("auditor", (Object)userId);
                routerSettingObj.set("auditdate", (Object)TimeServiceHelper.now());
                routerSettingObj.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                routerSettingObj.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                routerSettingsForNew.add(routerSettingObj);
                ++count;
            }
        }
        return routerSettingsForNew;
    }

    private static String[] getBatchBillNumbers(int billNoCount) {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)"cad_routersetting");
        return CodeRuleServiceHelper.getBatchNumber((String)"cad_routersetting", (DynamicObject)dataInfo, (String)RequestContext.get().getLoginOrg(), (int)billNoCount);
    }

    private static List<DynamicObject> constructRouterSettingForUpdate(Map<String, List<RouterSetting>> matIdsForRouterSettingRefresh, Map<String, Router> matIdAndMaxAudDateRouter) {
        ArrayList<DynamicObject> routerSettingsForUpdate = new ArrayList<DynamicObject>(10);
        String userId = RequestContext.get().getUserId();
        Map<Long, Router> settingIdAndMaxAudDateRouterMap = CostBomRouteRefreshHelper.getSettingIdAndMaxAudDateRouterMap(matIdsForRouterSettingRefresh, matIdAndMaxAudDateRouter);
        Set<Long> settingIdsForUpdate = settingIdAndMaxAudDateRouterMap.keySet();
        for (List settingIds : Lists.partition(new ArrayList<Long>(settingIdsForUpdate), (int)10000)) {
            DynamicObject[] routerSettings;
            for (DynamicObject routerSetting : routerSettings = BusinessDataServiceHelper.load((Object[])settingIds.toArray(new Object[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cad_routersetting"))) {
                Object id = routerSetting.getPkValue();
                Router maxAuditDateRouter = settingIdAndMaxAudDateRouterMap.get(id);
                if (maxAuditDateRouter == null) continue;
                routerSetting.set("router", (Object)maxAuditDateRouter.getId());
                routerSetting.set("modifier", (Object)userId);
                routerSetting.set("modifytime", (Object)TimeServiceHelper.now());
                routerSetting.set("auditor", (Object)userId);
                routerSetting.set("status", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
                routerSetting.set("auditdate", (Object)TimeServiceHelper.now());
                routerSetting.set("effectdate", (Object)DateUtils.getDefaultEffectDate());
                routerSetting.set("expdate", (Object)DateUtils.getDeFaultExpDate());
                routerSettingsForUpdate.add(routerSetting);
            }
        }
        return routerSettingsForUpdate;
    }

    private static Map<Long, Router> getSettingIdAndMaxAudDateRouterMap(Map<String, List<RouterSetting>> matIdsForRouterSettingRefresh, Map<String, Router> matIdAndMaxAudDateRouter) {
        HashMap<Long, Router> settingIdAndMaxAudDateRouterMap = new HashMap<Long, Router>(16);
        for (Map.Entry<String, List<RouterSetting>> entry : matIdsForRouterSettingRefresh.entrySet()) {
            String keycol = entry.getKey();
            List<RouterSetting> routerSettingsForRefresh = entry.getValue();
            for (RouterSetting settingsForRefresh : routerSettingsForRefresh) {
                Long auxptyId = settingsForRefresh.getAuxptyId();
                Router maxAudDateRouter = matIdAndMaxAudDateRouter.get(keycol);
                if (maxAudDateRouter == null) continue;
                if (settingsForRefresh.getRouterId().equals(maxAudDateRouter.getId())) {
                    matIdAndMaxAudDateRouter.remove(keycol);
                    continue;
                }
                Long settingIdForUpdate = settingsForRefresh.getId();
                settingIdAndMaxAudDateRouterMap.put(settingIdForUpdate, maxAudDateRouter);
                matIdAndMaxAudDateRouter.remove(keycol);
            }
        }
        return settingIdAndMaxAudDateRouterMap;
    }

    private static Map<String, Router> getMaxAuditDateRouterForMaterial(Long calOrgId, Set<Long> materialIds, Long manuorgId) {
        HashMap<String, Router> matIdAndMaxAudDateRouter = new HashMap<String, Router>(16);
        for (List matIds : Lists.partition(new ArrayList<Long>(materialIds), (int)10000)) {
            QFilter matFilter = new QFilter("material", "in", (Object)matIds);
            QFilter statusFilter = new QFilter("status", "in", (Object)BillBaseEnum.BILL_STATUS_AUDITED.getValue());
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            if (!CadEmptyUtils.isEmpty(manuorgId)) {
                enableFilter.and(new QFilter("manuorg", "=", (Object)manuorgId));
            }
            QFilter calOrgIdQf = new QFilter("createorg", "=", (Object)calOrgId);
            QFilter[] qFilters = new QFilter[]{calOrgIdQf, matFilter, statusFilter, enableFilter};
            DataSet routerDs = QueryServiceHelper.queryDataSet((String)"cad.form.queryrouter", (String)"cad_router", (String)"id,keycol,audittime,version,version.number versionnumber,routeversion,routeversion.number routeversionnumber", (QFilter[])qFilters, null);
            routerDs = routerDs.orderBy(new String[]{"audittime desc", "versionnumber desc", "routeversionnumber desc"});
            HashSet<String> existKcs = new HashSet<String>(10);
            ArrayList<Long> routeIds = new ArrayList<Long>(10);
            while (routerDs.hasNext()) {
                Row row = routerDs.next();
                String keycol = row.getString("keycol");
                if (!existKcs.add(keycol)) continue;
                routeIds.add(row.getLong("id"));
            }
            QFilter idFilter = new QFilter("id", "in", routeIds);
            routerDs = QueryServiceHelper.queryDataSet((String)"cad.form.queryrouter", (String)"cad_router", (String)"id,processtype,material,auxproperty,keycol,audittime", (QFilter[])new QFilter[]{idFilter}, null);
            for (Row row : routerDs) {
                Date auditTime = row.getDate("audittime");
                if (auditTime == null) continue;
                Long materialId = row.getLong("material");
                Long auxpropertyId = row.getLong("auxproperty");
                String keycol = row.getString("keycol");
                Router router = (Router)matIdAndMaxAudDateRouter.get(keycol);
                if (router != null && auditTime.compareTo(router.getAuditDate()) <= 0) continue;
                router = new Router();
                router.setId(row.getLong("id"));
                router.setAuditDate(auditTime);
                router.setProcessType(row.getString("processtype"));
                router.setMaterial(materialId);
                router.setAuxproperty(auxpropertyId);
                router.setKeycol(row.getString("keycol"));
                matIdAndMaxAudDateRouter.put(keycol, router);
            }
        }
        return matIdAndMaxAudDateRouter;
    }

    private static Map<String, List<RouterSetting>> filterRouterSettingForRefresh(Long costTypeId, Set<Long> matIdsWhichUserHasPermission) {
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)costTypeId);
        QFilter materialFilter = new QFilter("materialentry.material", "in", matIdsWhichUserHasPermission);
        QFilter routerTypeFilter = new QFilter("routertype", "=", (Object)MATERIAL_ROUTER_TYPE);
        DataSet routerSettingDs = QueryServiceHelper.queryDataSet((String)"cad.common.filterRouterSettingForRefresh", (String)"cad_routersetting", (String)"id,router,materialentry.material material,materialentry.auxpty auxpty,materialentry.keycol keycol", (QFilter[])new QFilter[]{costTypeFilter, materialFilter, routerTypeFilter}, null);
        if (routerSettingDs == null) {
            return new HashMap<String, List<RouterSetting>>(16);
        }
        return CostBomRouteRefreshHelper.getRouterSettingWhichEntryIsOneMaterial(routerSettingDs);
    }

    private static Map<String, List<RouterSetting>> getRouterSettingWhichEntryIsOneMaterial(DataSet routerSettingDs) {
        HashMap<String, List<RouterSetting>> matIdsForRouterSettingRefresh = new HashMap<String, List<RouterSetting>>(16);
        HashMap<Long, List> settingIdAndMatIdMap = new HashMap<Long, List>(16);
        for (Row row : routerSettingDs.copy()) {
            Long id = row.getLong("id");
            Long materialId = row.getLong("material");
            Long auxpty = row.getLong("auxpty");
            String keycol = row.getString("keycol");
            settingIdAndMatIdMap.computeIfAbsent(id, s -> new ArrayList()).add(new ThreeTuple((Object)materialId, (Object)auxpty, (Object)keycol));
        }
        DataSet routerSettingIdDs = routerSettingDs.groupBy(new String[]{"id", "router"}).count("totalcount").finish().select("id,router,totalcount");
        for (Row row : routerSettingIdDs) {
            Long totalCount = row.getLong("totalcount");
            Long routerSettingId = row.getLong("id");
            Long routerId = row.getLong("router");
            List settingIdAndMatIdList = (List)settingIdAndMatIdMap.get(routerSettingId);
            for (ThreeTuple settingIdAndMatTuple : settingIdAndMatIdList) {
                if (totalCount > 1L) continue;
                Long materialId = (Long)settingIdAndMatTuple.item1;
                Long auxptyId = (Long)settingIdAndMatTuple.item2;
                String keycol = (String)settingIdAndMatTuple.item3;
                ArrayList<RouterSetting> routerSettings = (ArrayList<RouterSetting>)matIdsForRouterSettingRefresh.get(keycol);
                RouterSetting routerSetting = new RouterSetting();
                routerSetting.setId(routerSettingId);
                routerSetting.setRouterId(routerId);
                routerSetting.setAuxptyId(auxptyId);
                routerSetting.setMaterialId(materialId);
                routerSetting.setKeycol(keycol);
                if (CadEmptyUtils.isEmpty(routerSettings)) {
                    routerSettings = new ArrayList<RouterSetting>(10);
                    routerSettings.add(routerSetting);
                    matIdsForRouterSettingRefresh.put(keycol, routerSettings);
                    continue;
                }
                routerSettings.add(routerSetting);
            }
        }
        return matIdsForRouterSettingRefresh;
    }

    public static Set<Long> getMaterialIds(Long calOrgId, String materialStr, String entity) {
        Set<Object> materialIds = new HashSet(10);
        if (!CadEmptyUtils.isEmpty(materialStr)) {
            String[] mats = materialStr.split("\n");
            QFilter filter = new QFilter("number", "in", (Object)mats);
            DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"masterid id", (QFilter[])new QFilter[]{filter});
            materialIds = materials.stream().map(item -> item.getLong("id")).collect(Collectors.toSet());
            materialIds.retainAll(CostBomRouteRefreshHelper.getMaterialIdByBaseEntity(calOrgId, entity));
        } else {
            materialIds = CostBomRouteRefreshHelper.getMaterialIdByBaseEntity(calOrgId, entity);
        }
        return materialIds;
    }

    private static Set<Long> getMaterialIdByBaseEntity(Long calOrgId, String entity) {
        HashSet<Long> materialIds = new HashSet<Long>(10);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)entity, (Long)calOrgId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getMaterialIdByBaseEntity", (String)entity, (String)"material", (QFilter[])new QFilter[]{orgFilter}, null);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            Long material = row.getLong("material");
            if (CadEmptyUtils.isEmpty(material)) continue;
            materialIds.add(material);
        }
        return materialIds;
    }
}

