/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CostCenterHelper {
    public static List<Long> getCostCenterByUser(String entityId, String appNum) {
        List<ComboItem> accountOrgs = OrgHelper.getAccountOrg(entityId, appNum);
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (ComboItem ComboItem2 : accountOrgs) {
            ids.add(Long.valueOf(ComboItem2.getValue()));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!accountOrgs.isEmpty()) {
            filters.add(new QFilter("accountorg", "in", ids));
        }
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty(costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    public static List<Long> getWorkCenter(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate, CollectReport collectReport) {
        ArrayList<Long> workCenter = new ArrayList<Long>(1000);
        if (costCenterIds != null && costCenterIds.size() != 0) {
            HashMap costCenterWcMap = Maps.newHashMapWithExpectedSize((int)costCenterIds.size());
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcetype sourcetype,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> {
                workCenter.add(s.getLong("sourcedata"));
                costCenterWcMap.computeIfAbsent(s.getLong("costcenter"), wc -> new ArrayList()).add(s.getLong("sourcedata"));
            });
            collectReport.logWorkCenterMap(costCenterWcMap);
        }
        return workCenter;
    }

    public static List<Long> getWorkCenter(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate) {
        ArrayList<Long> workCenter = new ArrayList<Long>(1000);
        if (costCenterIds != null && costCenterIds.size() != 0) {
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> workCenter.add(s.getLong("sourcedata")));
        }
        return workCenter;
    }

    public static List<Long> getAdminOrg(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate, CollectReport collectReport) {
        ArrayList<Long> adminOrgIds = new ArrayList<Long>(1000);
        if (CollectionUtils.isNotEmpty(costCenterIds)) {
            HashMap ccAdminMap = Maps.newHashMapWithExpectedSize((int)costCenterIds.size());
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"bos_adminorg");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcetype sourcetype,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> {
                adminOrgIds.add(s.getLong("sourcedata"));
                ccAdminMap.computeIfAbsent(s.getLong("costcenter"), wc -> new ArrayList()).add(s.getLong("sourcedata"));
            });
            collectReport.logAdminMap(ccAdminMap);
        }
        return adminOrgIds;
    }

    public static List<Long> getAdminOrg(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate) {
        ArrayList<Long> adminOrgIds = new ArrayList<Long>(1000);
        if (CollectionUtils.isNotEmpty(costCenterIds)) {
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"bos_adminorg");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> adminOrgIds.add(s.getLong("sourcedata")));
        }
        return adminOrgIds;
    }

    public static QFilter getCostCenterByMultFactory(long orgId, List<Long> manuOrgList, String appId) {
        Set<Long> centerIds;
        if (CadEmptyUtils.isEmpty(orgId)) {
            return new QFilter("id", "=", (Object)-1);
        }
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory(orgId);
        QFilter qFilter = isEnableMultiFactory ? (CadEmptyUtils.isEmpty(centerIds = OrgHelper.getCenterIdsByManuOrgIds(orgId, manuOrgList, appId)) ? new QFilter("id", "=", (Object)-1) : new QFilter("id", "in", centerIds)) : new QFilter("accountorg", "=", (Object)orgId);
        return qFilter;
    }

    public static QFilter getCostCenterByMultFactoryForList(long orgId, List<Long> manuOrgList, String appId, String entityId) {
        QFilter qFilter;
        if (CadEmptyUtils.isEmpty(orgId)) {
            return new QFilter("id", "=", (Object)-1);
        }
        boolean isEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory(orgId);
        if (isEnableMultiFactory) {
            Set<Long> centerIds;
            if (CadEmptyUtils.isEmpty(manuOrgList)) {
                manuOrgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, entityId, appId);
            }
            qFilter = CadEmptyUtils.isEmpty(centerIds = OrgHelper.getCenterIdsByManuOrgIds(orgId, manuOrgList, appId)) ? new QFilter("id", "=", (Object)-1) : new QFilter("id", "in", centerIds);
        } else {
            qFilter = new QFilter("accountorg", "=", (Object)orgId);
        }
        return qFilter;
    }

    public static Map<Long, Long> getWorkCenterAndCostCenter(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate) {
        HashMap<Long, Long> resultMap = new HashMap<Long, Long>(16);
        if (costCenterIds != null && costCenterIds.size() != 0) {
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> resultMap.put(s.getLong("entryentity.sourcedata"), s.getLong("costcenter")));
        }
        return resultMap;
    }

    public static List<Long> getOrderEntry(List<Long> costCenterIds) {
        HashSet entryIds = new HashSet(5000);
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            return new ArrayList<Long>();
        }
        QFilter workCenterQf = new QFilter("oprentryentity.oprworkcenter", "in", costCenterIds);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection manfTechs = QueryServiceHelper.query((String)"sfc_manftech", (String)"id,mftentryseq.id entryid", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        manfTechs.forEach(s -> entryIds.add(s.getLong("entryid")));
        return new ArrayList<Long>(entryIds);
    }

    public static List<Long> getOrderEntryIds(List<Long> workCenters) {
        HashSet entryIds = new HashSet(5000);
        if (CadEmptyUtils.isEmpty(workCenters)) {
            return new ArrayList<Long>(entryIds);
        }
        QFilter workCenterQf = new QFilter("oprentryentity.oprworkcenter", "in", workCenters);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection manfTechs = QueryServiceHelper.query((String)"sfc_manftech", (String)"id,mftentryseq.id entryid", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        DynamicObjectCollection manfTechnics = QueryServiceHelper.query((String)"om_mfttechnics", (String)"id,mftentryseq.id entryid", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        if (!CadEmptyUtils.isEmpty(manfTechnics)) {
            manfTechs.addAll((Collection)manfTechnics);
        }
        manfTechs.forEach(s -> entryIds.add(s.getLong("entryid")));
        return new ArrayList<Long>(entryIds);
    }

    public static List<Long> getOrderEntryIds(List<Long> workCenters, String manfethEntity, Map<Long, Long> entryIdWorkCenterMap, List<Long> mftOrderEntryIds) {
        HashSet<Long> entryIds = new HashSet<Long>(5000);
        if (CadEmptyUtils.isEmpty(workCenters)) {
            return new ArrayList<Long>(entryIds);
        }
        QFilter workCenterQf = new QFilter("oprentryentity.oprworkcenter", "in", workCenters);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            billStatusQf.and("mftentryseq.id", "in", mftOrderEntryIds);
        }
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        DataSet manftechsDataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.CostCenterHelper.getOrderEntryIds", (String)manfethEntity, (String)"id,mftentryseq.id mftentryid,oprentryentity.id processentryid,oprentryentity.oprworkcenter oprworkcenter,oprentryentity.oprno oprno,oprentryentity.machiningtype machiningtype", (QFilter[])new QFilter[]{billStatusQf, oprinvalQf, workCenterQf}, null);
        if (CadBgParamUtils.getBgParamBoolean(BgParamEnum.QUERY_TECH_NX).booleanValue()) {
            manftechsDataSet = manftechsDataSet.copy().filter("machiningtype='1001'");
        }
        DataSet groupbyDataSet = manftechsDataSet.copy().select("id,mftentryid,processentryid,oprworkcenter,cast(oprno as Long) as oprno").groupBy(new String[]{"id"}).minP("oprno", "processentryid").finish();
        DataSet manfTechs = groupbyDataSet.join(manftechsDataSet, JoinType.LEFT).on("id", "id").on("processentryid", "processentryid").select(manftechsDataSet.getRowMeta().getFieldNames()).finish();
        if ((manfTechs = manfTechs.filter("oprworkcenter in (" + StringUtils.join(workCenters, (String)",") + ")")).isEmpty()) {
            return new ArrayList<Long>(entryIds);
        }
        while (manfTechs.hasNext()) {
            Row row = manfTechs.next();
            entryIds.add(row.getLong("mftentryid"));
            entryIdWorkCenterMap.put(row.getLong("mftentryid"), row.getLong("oprworkcenter"));
        }
        return new ArrayList<Long>(entryIds);
    }

    public static List<Long> getBosOrgs(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate, CollectReport collectReport) {
        ArrayList<Long> list = new ArrayList<Long>(10);
        if (CollectionUtils.isNotEmpty(costCenterIds)) {
            HashMap costCenterOrgMap = Maps.newHashMapWithExpectedSize((int)costCenterIds.size());
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"bos_org");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcetype sourcetype,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> {
                list.add(s.getLong("sourcedata"));
                costCenterOrgMap.computeIfAbsent(s.getLong("costcenter"), wc -> new ArrayList()).add(s.getLong("sourcedata"));
            });
            collectReport.logOrgMap(costCenterOrgMap);
        }
        return list;
    }

    public static QFilter getImportScopeDateFilter(List<Map<String, Date>> importScopeDate) {
        QFilter dateFilter = null;
        if (!CadEmptyUtils.isEmpty(importScopeDate)) {
            Date startDate = importScopeDate.get(0).get("start");
            Date endDate = importScopeDate.get(0).get("end");
            dateFilter = new QFilter("effectdate", "<", (Object)endDate).and(new QFilter("expdate", ">", (Object)startDate));
            if (importScopeDate.size() > 1) {
                Date nextStartDate = importScopeDate.get(1).get("start");
                Date nextEndDate = importScopeDate.get(1).get("end");
                QFilter nextDateFilter = new QFilter("effectdate", "<", (Object)nextEndDate).and(new QFilter("expdate", ">", (Object)nextStartDate));
                dateFilter = dateFilter.or(nextDateFilter);
            }
        }
        return dateFilter;
    }

    public static List<Long> getBosOrgs(Collection<Long> costCenterIds, List<Map<String, Date>> importScopeDate) {
        ArrayList<Long> list = new ArrayList<Long>(10);
        if (CollectionUtils.isNotEmpty(costCenterIds)) {
            QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
            QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
            QFilter workCenterFilter = new QFilter("entryentity.sourcetype", "=", (Object)"bos_org");
            DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,entryentity.sourcedata sourcedata", (QFilter[])new QFilter[]{ccFilter, workCenterFilter, dateFilter});
            centerSourceMap.forEach(s -> list.add(s.getLong("sourcedata")));
        }
        return list;
    }

    private static List<String[]> getManfTech(List<Long> workCenter) {
        ArrayList<String[]> sourceBillnos = new ArrayList<String[]>(10);
        if (CadEmptyUtils.isEmpty(workCenter)) {
            return sourceBillnos;
        }
        QFilter workCenterQf = new QFilter("oprentryentity.oprworkcenter", "in", workCenter);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection manfTechs = QueryServiceHelper.query((String)"sfc_manftech", (String)"id,mftentryseq.headbillno billno,mftentryseq.entryseq seq", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        DynamicObjectCollection manfTechnics = QueryServiceHelper.query((String)"om_mfttechnics", (String)"id,mftentryseq.headbillno billno,mftentryseq.entryseq seq", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        if (!CadEmptyUtils.isEmpty(manfTechnics)) {
            manfTechs.addAll((Collection)manfTechnics);
        }
        HashSet idSet = new HashSet(16);
        manfTechs.forEach(s -> {
            if (idSet.add(s.getLong("id"))) {
                String[] sourceBillno = new String[]{s.getString("billno"), String.valueOf(s.getLong("seq"))};
                sourceBillnos.add(sourceBillno);
            }
        });
        return sourceBillnos;
    }

    private static List<Long> getSourceEntryId(List<String[]> sourceBillnos) {
        ArrayList<Long> entryIds = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty(sourceBillnos)) {
            return entryIds;
        }
        ArrayList billnos = new ArrayList(10);
        sourceBillnos.forEach(s -> billnos.add(s[0]));
        QFilter billnoQf = new QFilter("billno", "in", billnos);
        DynamicObjectCollection srcs = QueryServiceHelper.query((String)"pom_mftorder", (String)"id,billno,treeentryentity.id entryid,treeentryentity.seq seq", (QFilter[])new QFilter[]{billnoQf});
        srcs.forEach(s -> {
            for (String[] billnoSeqs : sourceBillnos) {
                if (billnoSeqs[0] == null || CadEmptyUtils.isEmpty(billnoSeqs[0]) || billnoSeqs[1] == null || CadEmptyUtils.isEmpty(billnoSeqs[1]) || !billnoSeqs[0].equals(s.getString("billno")) || !billnoSeqs[1].equals(String.valueOf(s.getLong("seq")))) continue;
                entryIds.add(s.getLong("entryid"));
            }
        });
        return entryIds;
    }

    public static List<Long> getCostCenterByOrg(Long orgId, Long[] orgduty) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        filters.add(new QFilter("orgduty", "in", (Object)orgduty));
        Object[] costCenter = BusinessDataServiceHelper.load((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty(costCenter)) {
            return null;
        }
        ArrayList<Long> centerIds = new ArrayList<Long>();
        for (Object center : costCenter) {
            Long id = center.getLong("id");
            if (centerIds.contains(id)) continue;
            centerIds.add(id);
        }
        return centerIds;
    }

    public static List<ComboItem> getCostCenterByOrg(String orgId) {
        QFilter orgdutyFilter;
        QFilter enableFilter;
        if (orgId == null || StringUtils.isBlank((CharSequence)orgId)) {
            return Collections.emptyList();
        }
        QFilter orgQf = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{orgQf, enableFilter = new QFilter("enable", "=", (Object)"1"), orgdutyFilter = new QFilter("orgduty", "=", (Object)4L)});
        if (CadEmptyUtils.isEmpty(ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    public static Map<Long, Long> getCostCenterBySource(Long orgId, List<DynamicObject> sourceBills, String appNum) {
        HashMap<Long, Long> resultCenter = new HashMap<Long, Long>(32);
        ArrayList orgs = Lists.newArrayListWithCapacity((int)32);
        ArrayList workCenters = Lists.newArrayListWithCapacity((int)32);
        ArrayList adminOrgs = Lists.newArrayListWithCapacity((int)32);
        if (sourceBills != null && !sourceBills.isEmpty()) {
            for (DynamicObject sourceBill : sourceBills) {
                long manuOrg = sourceBill.getLong("manuorg");
                long workCenter = sourceBill.getLong("workcenter");
                long adminOrg = sourceBill.getLong("adminorg");
                orgs.add(manuOrg);
                workCenters.add(workCenter);
                adminOrgs.add(adminOrg);
            }
        }
        if (CadEmptyUtils.isEmpty(orgs) && CadEmptyUtils.isEmpty(workCenters) && CadEmptyUtils.isEmpty(adminOrgs)) {
            return resultCenter;
        }
        HashMap costCenterSourceDataListMap = new HashMap(16);
        List<Map<String, Date>> importScopeDate = SysParamHelper.getImportScopeDate(orgId, appNum);
        QFilter qfDataId = new QFilter("entryentity.sourcedata", "in", (Object)orgs.toArray());
        qfDataId.and("entryentity.sourcetype", "=", (Object)"bos_org");
        if (CollectionUtils.isNotEmpty((Collection)workCenters)) {
            QFilter qfWorkCenter = new QFilter("entryentity.sourcedata", "in", (Object)workCenters.toArray());
            qfWorkCenter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            qfDataId.or(qfWorkCenter);
        }
        if (CollectionUtils.isNotEmpty((Collection)adminOrgs)) {
            QFilter qfAdminOrg = new QFilter("entryentity.sourcedata", "in", (Object)adminOrgs.toArray());
            qfAdminOrg.and("entryentity.sourcetype", "=", (Object)"bos_adminorg");
            qfDataId.or(qfAdminOrg);
        }
        QFilter orgFilter = new QFilter("costcenter.accountorg", "=", (Object)orgId);
        QFilter enableFilter = new QFilter("costcenter.enable", "=", (Object)Boolean.TRUE);
        QFilter qfOrgduty = new QFilter("costcenter.orgduty", "=", (Object)4L);
        QFilter dateFilter = CostCenterHelper.getImportScopeDateFilter(importScopeDate);
        DynamicObjectCollection centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"costcenter as id,costcenter.accountorg orgid,effectdate,expdate,entryentity.sourcetype,entryentity.sourcedata", (QFilter[])new QFilter[]{qfDataId, orgFilter, dateFilter, enableFilter, qfOrgduty});
        centerSourceMap.forEach(s -> costCenterSourceDataListMap.computeIfAbsent(s.getLong("entryentity.sourcedata"), t -> new ArrayList()).add(s));
        if (sourceBills != null && !sourceBills.isEmpty()) {
            for (DynamicObject sourceBill : sourceBills) {
                long manuOrg = sourceBill.getLong("manuorg");
                long workCenter = sourceBill.getLong("workcenter");
                long adminOrg = sourceBill.getLong("adminorg");
                Date bizDate = sourceBill.getDate("bookdate");
                if (costCenterSourceDataListMap.containsKey(manuOrg)) {
                    resultCenter.put(sourceBill.getLong("id"), CostCenterHelper.getCostCenterBySrcBillDate(bizDate, (List)costCenterSourceDataListMap.get(manuOrg)));
                    continue;
                }
                if (costCenterSourceDataListMap.containsKey(workCenter)) {
                    resultCenter.put(sourceBill.getLong("id"), CostCenterHelper.getCostCenterBySrcBillDate(bizDate, (List)costCenterSourceDataListMap.get(workCenter)));
                    continue;
                }
                if (!costCenterSourceDataListMap.containsKey(adminOrg)) continue;
                resultCenter.put(sourceBill.getLong("id"), CostCenterHelper.getCostCenterBySrcBillDate(bizDate, (List)costCenterSourceDataListMap.get(adminOrg)));
            }
        }
        return resultCenter;
    }

    private static Long getCostCenterBySrcBillDate(Date bizDate, List<DynamicObject> costCenterSourceList) {
        Long costCenter = 0L;
        if (CadEmptyUtils.isEmpty(costCenterSourceList)) {
            return costCenter;
        }
        if (bizDate == null) {
            bizDate = new Date();
        }
        for (DynamicObject costCenterSource : costCenterSourceList) {
            if (costCenterSource.getDate("effectdate").getTime() > bizDate.getTime() || costCenterSource.getDate("expdate").getTime() <= bizDate.getTime()) continue;
            costCenter = costCenterSource.getLong("id");
            break;
        }
        return costCenter;
    }

    public static List<Long> getCostCenterByCCGroup(Long costCenterGroupId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        ArrayList<Long> centerIds = new ArrayList<Long>(10);
        filters.add(new QFilter("id", "=", (Object)costCenterGroupId));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id,entryentity.costcenter costcenter", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty(costCenters)) {
            return null;
        }
        for (DynamicObject center : costCenters) {
            Long costcenterId = center.getLong("costcenter");
            if (centerIds.contains(costcenterId)) continue;
            centerIds.add(costcenterId);
        }
        return centerIds;
    }
}

