/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostChangeRecHelper {
    private static final Log logger = LogFactory.getLog(CostChangeRecHelper.class);
    public static String QUERY_FIELDS = "id, billno, org, costcenter, costaccount, costobject, bizdate, appnum, material, matcollect";

    public static void writeCostChangeRecForAllocDel(Set<Long> ids) {
        if (ids != null && ids.size() > 0) {
            try {
                DynamicObjectCollection matUseBills = QueryServiceHelper.query((String)"sca_matalloc", (String)QUERY_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                if (matUseBills != null) {
                    DynamicObjectCollection costObjectAccounts = CostChangeRecHelper.getCostObjectAccount(matUseBills, "costobject");
                    HashMap costObjectAccountMap = new HashMap();
                    costObjectAccounts.forEach(e -> costObjectAccountMap.computeIfAbsent(e.getLong("costobject"), s -> new HashSet()).add(e.getLong("costaccount")));
                    ArrayList<Long> srcbillIds = new ArrayList<Long>(10);
                    matUseBills.forEach(p -> srcbillIds.add(p.getLong("matcollect")));
                    List<Long> settlChangeRecords = CostChangeRecHelper.getChangeRecordBySettled(srcbillIds);
                    CostChangeRecHelper.delChangeRecordBySettled(srcbillIds);
                    ArrayList<DynamicObject> costUpdateResList = new ArrayList<DynamicObject>(10);
                    for (DynamicObject matUseBill : matUseBills) {
                        Long costAccountId;
                        Long costobjectId = matUseBill.getLong("costobject");
                        if (CadEmptyUtils.isEmpty(costobjectId) || CadEmptyUtils.isEmpty(costAccountId = Long.valueOf(matUseBill.getLong("costaccount"))) || costObjectAccountMap.get(costobjectId) == null || !((Set)costObjectAccountMap.get(costobjectId)).contains(costAccountId) || !settlChangeRecords.contains(matUseBill.getLong("matcollect"))) continue;
                        DynamicObject costChangeObject = CostChangeRecHelper.getCostChangeObject(matUseBill);
                        costChangeObject.set("costobject", (Object)costobjectId);
                        costChangeObject.set("costaccount", (Object)costAccountId);
                        costUpdateResList.add(costChangeObject);
                    }
                    if (!costUpdateResList.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])costUpdateResList.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception e2) {
                logger.error("\u8bb0\u5f55\u5220\u9664\u7684\u5206\u914d\u5355\u7684\u6210\u672c\u53d8\u66f4\u8bb0\u5f55\u51fa\u9519\u3002" + e2.getMessage());
            }
        }
    }

    private static DynamicObject getCostChangeObject(DynamicObject bill) {
        DynamicObject costChange = BusinessDataServiceHelper.newDynamicObject((String)"sca_costchangerecord");
        costChange.set("org", (Object)bill.getLong("org"));
        costChange.set("costcenter", (Object)bill.getLong("costcenter"));
        costChange.set("businessbill", (Object)"sca_matalloc");
        costChange.set("sourcebill", (Object)bill.getLong("matcollect"));
        costChange.set("creator", (Object)RequestContext.get().getUserId());
        costChange.set("createtime", (Object)TimeServiceHelper.now());
        costChange.set("sourcebiztime", (Object)bill.getDate("bizdate"));
        return costChange;
    }

    private static DynamicObjectCollection getCostObjectAccount(DynamicObjectCollection existCostObjects, String field) {
        Set<Long> costObjectIds = DynamicObjectHelper.getIdSet(existCostObjects, field);
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("costobject", "in", costObjectIds));
        qfList.add(new QFilter("bizstatus", "=", (Object)"B"));
        DynamicObjectCollection costObjectAccounts = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"costobject, costaccount", (QFilter[])qfList.toArray(new QFilter[0]));
        return costObjectAccounts;
    }

    private static List<Long> getChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "=", (Object)"B");
        DynamicObjectCollection sourceBills = QueryServiceHelper.query((String)"sca_costchangerecord", (String)"sourcebill", (QFilter[])new QFilter[]{filter});
        srcbillIds.clear();
        sourceBills.forEach(p -> srcbillIds.add(p.getLong("sourcebill")));
        return srcbillIds;
    }

    private static void delChangeRecordBySettled(List<Long> srcbillIds) {
        QFilter filter = new QFilter("sourcebill", "in", srcbillIds);
        filter.and("bizstatus", "!=", (Object)"B");
        filter.and("businessbill", "=", (Object)"sca_matalloc");
        DeleteServiceHelper.delete((String)"sca_costchangerecord", (QFilter[])new QFilter[]{filter});
    }

    public static void wrapRecs(List<DynamicObject> billList) {
        if (billList == null || billList.isEmpty()) {
            return;
        }
        try {
            DynamicObjectCollection matUseBills = new DynamicObjectCollection();
            billList.forEach(p -> matUseBills.add(p));
            DynamicObjectCollection costObjectAccounts = CostChangeRecHelper.getCostObjectAccount(matUseBills, "costobject");
            HashMap costObjectAccountMap = new HashMap();
            costObjectAccounts.forEach(e -> costObjectAccountMap.computeIfAbsent(e.getLong("costobject"), s -> new HashSet()).add(e.getLong("costaccount")));
            ArrayList<DynamicObject> costChangedRecs = new ArrayList<DynamicObject>(10);
            for (DynamicObject newBill : billList) {
                DynamicObject rec;
                Long costAccountId;
                Long costobjectId = newBill.getLong("costobject");
                if (CadEmptyUtils.isEmpty(costobjectId) || CadEmptyUtils.isEmpty(costAccountId = Long.valueOf(newBill.getLong("costaccount"))) || costObjectAccountMap.get(costobjectId) == null || !((Set)costObjectAccountMap.get(costobjectId)).contains(costAccountId) || (rec = CostChangeRecHelper.generateRec(newBill)) == null) continue;
                rec.set("costobject", (Object)costobjectId);
                rec.set("costaccount", (Object)costAccountId);
                costChangedRecs.add(rec);
            }
            if (!costChangedRecs.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])costChangedRecs.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e2) {
            logger.error("\u751f\u6210\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u8bb0\u5f55\u51fa\u9519\u3002" + e2.getMessage());
        }
    }

    private static DynamicObject generateRec(DynamicObject newBill) {
        DynamicObject costChange = CostChangeRecHelper.getCostChangeObject(newBill);
        if (newBill != null) {
            String changeText = CostChangeRecHelper.getChangeText(newBill);
            costChange.set("changecontext", (Object)(changeText + "||"));
        }
        return costChange;
    }

    private static String getChangeText(DynamicObject bill) {
        String join = "@";
        StringBuilder sg = new StringBuilder(bill.getString("billno"));
        sg.append(join);
        sg.append(bill.getDate("bizdate"));
        sg.append(join);
        sg.append(bill.getString("matversion.id"));
        sg.append(join);
        sg.append(bill.getString("unit.id"));
        sg.append(join);
        sg.append(bill.getString("useqty"));
        sg.append(join);
        return sg.toString();
    }
}

