/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;
import org.apache.commons.collections4.CollectionUtils;

public class CostObjectHelper {
    private static final Log logger = LogFactory.getLog(CostObjectHelper.class);
    public static final String PNO_DEF_VALUE = "000001";
    private static List<String> relatedBlacklist = Arrays.asList("cad_costobjectf7", "cad_costobjectaccount");

    public static DynamicObject getRuleBy(Object acctOrgId, Object costCenterId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)Long.valueOf(String.valueOf(acctOrgId))));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("status", "=", (Object)"C"));
        QFilter costCenterQf = new QFilter("costcenter", "=", (Object)Long.valueOf(String.valueOf(costCenterId)));
        filters.add(costCenterQf);
        DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass,rulenumberext,rulenameext", (QFilter[])filters.toArray(new QFilter[0]));
        if (rule == null) {
            filters.remove(costCenterQf);
            costCenterQf = new QFilter("costcenter", "=", (Object)0L);
            filters.add(costCenterQf);
            rule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass,rulenumberext,rulenameext", (QFilter[])filters.toArray(new QFilter[0]));
        }
        return rule;
    }

    public static Map<String, List<Long>> groupCostCenterByRules(Long acctOrgId, List<Long> enableCostCenters, Map<String, DynamicObject> objRules) {
        HashMap<String, List<Long>> acctOrgCalmethodCostCentersMap = new HashMap<String, List<Long>>(16);
        for (Long costCenterId : enableCostCenters) {
            String key = String.valueOf(acctOrgId).concat(String.valueOf(costCenterId));
            DynamicObject rule = objRules.get(key);
            if (rule == null) {
                rule = objRules.get(String.valueOf(acctOrgId));
            }
            if (rule == null) continue;
            String costCalMethod = rule.getString("biztype");
            acctOrgCalmethodCostCentersMap.computeIfAbsent(acctOrgId + costCalMethod, p -> new ArrayList()).add(costCenterId);
        }
        return acctOrgCalmethodCostCentersMap;
    }

    public static Map<String, DynamicObject> getRulesMap(Long acctOrgId, List<Long> costCenterIds) {
        HashMap<String, DynamicObject> acctOrgRulesMap = new HashMap<String, DynamicObject>(16);
        ArrayList<Long> costCenter0 = new ArrayList<Long>(costCenterIds);
        costCenter0.add(0L);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)acctOrgId));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("status", "=", (Object)"C"));
        QFilter costCenterQf = new QFilter("costcenter", "in", costCenter0);
        filters.add(costCenterQf);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,costcalcdimension,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass,rulenumberext,rulenameext", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject rule : rules) {
            String accountOrg = rule.getString("accountorg");
            String costCenter = rule.getString("costcenter");
            if (CadEmptyUtils.isEmpty(costCenter)) {
                acctOrgRulesMap.put(accountOrg, rule);
                continue;
            }
            acctOrgRulesMap.put(accountOrg.concat(costCenter), rule);
        }
        return acctOrgRulesMap;
    }

    public static Map<String, List<Long>> groupCostCenterByRules(List<Long> enableCostCenters, Map<String, DynamicObject> objRules) {
        Long costCenterId;
        Long accountOrg;
        String calMethod;
        DynamicObject rule;
        HashMap<String, List<Long>> acctOrgCalmethodCostCentersMap = new HashMap<String, List<Long>>(16);
        ArrayList<Long> costCenterIds = new ArrayList<Long>(enableCostCenters);
        ArrayList<Long> hashRuleCostCenters = new ArrayList<Long>(10);
        for (Map.Entry<String, DynamicObject> objectEntry : objRules.entrySet()) {
            rule = objectEntry.getValue();
            calMethod = rule.getString("biztype");
            accountOrg = rule.getLong("accountorg");
            costCenterId = rule.getLong("costcenter");
            if (!costCenterIds.contains(costCenterId)) continue;
            acctOrgCalmethodCostCentersMap.computeIfAbsent(accountOrg + calMethod, p -> new ArrayList()).add(costCenterId);
            hashRuleCostCenters.add(costCenterId);
        }
        costCenterIds.removeAll(hashRuleCostCenters);
        for (Map.Entry<String, DynamicObject> objectEntry : objRules.entrySet()) {
            rule = objectEntry.getValue();
            calMethod = rule.getString("biztype");
            accountOrg = rule.getLong("accountorg");
            costCenterId = rule.getLong("costcenter");
            if (!CadEmptyUtils.isEmpty(costCenterId)) continue;
            costCenterIds.forEach(ccs -> acctOrgCalmethodCostCentersMap.computeIfAbsent(accountOrg + calMethod, p -> new ArrayList()).add(ccs));
        }
        return acctOrgCalmethodCostCentersMap;
    }

    public static Map<String, DynamicObject> getCostObjectRulesMap(Long acctOrgId, List<Long> costCenterIds) {
        HashMap<String, DynamicObject> acctOrgRulesMap = new HashMap<String, DynamicObject>(16);
        ArrayList<Long> costCenter0 = new ArrayList<Long>(costCenterIds);
        costCenter0.add(0L);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)acctOrgId));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("status", "=", (Object)"C"));
        QFilter costCenterQf = new QFilter("costcenter", "in", costCenter0);
        filters.add(costCenterQf);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,costcalcdimension,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass,rulenumberext,rulenameext", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject rule : rules) {
            String key;
            String accountOrg = rule.getString("accountorg");
            String costCenter = rule.getString("costcenter");
            String bizType = rule.getString("biztype");
            String costCalcDimension = rule.getString("costcalcdimension");
            if (CadEmptyUtils.isEmpty(costCenter)) {
                key = accountOrg.concat("@").concat(bizType).concat("@").concat(costCalcDimension);
                acctOrgRulesMap.put(key, rule);
                continue;
            }
            key = accountOrg.concat("@").concat(costCenter).concat("@").concat(bizType).concat("@").concat(costCalcDimension);
            acctOrgRulesMap.put(key, rule);
        }
        return acctOrgRulesMap;
    }

    public static DynamicObject wrapBillObject4Save(Long costCenterId, DynamicObject rule, DynamicObject proBill, Map<String, Set<Long>> existCostObjectManuEntryIdsMap) {
        Set<Long> manuEntryIds;
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter");
        String ruleAss = rule.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = rule.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        String[] ruleNumberExt = rule.getString("rulenumberext").split(",");
        String[] ruleNameExt = rule.getString("rulenameext").split(",");
        String srcNum = proBill.getString("billno");
        String srcRow = proBill.getString("entryseq");
        String materialNumber = proBill.getString("materialNumber");
        String materialName = proBill.getString("materialName");
        String materialModelnum = proBill.getString("materialModelnum");
        String billNo = ruleAss + srcNum + "-" + srcRow;
        if (Arrays.asList(ruleNumberExt).contains("CR_CPBM") && !CadEmptyUtils.isEmpty(materialNumber)) {
            billNo = billNo + "-" + materialNumber;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty(materialModelnum)) {
            billNo = billNo + "-" + materialModelnum;
        }
        if (!CadEmptyUtils.isEmpty(manuEntryIds = existCostObjectManuEntryIdsMap.get(rule.getString("accountorg"))) && manuEntryIds.contains(proBill.getLong("entryId"))) {
            return null;
        }
        DynamicObject costObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costobject");
        costObject.set("id", (Object)DB.genLongId((String)"cad_costobject"));
        costObject.set("costobjectrule", rule.get("id"));
        costObject.set("org", rule.get("accountorg"));
        costObject.set("billstatus", (Object)"C");
        costObject.set("costcenter", (Object)costCenterId);
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)rule.getString("sotype"));
        costObject.set("rule", (Object)rule.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_EXCEL.getValue());
        costObject.set("biztype", (Object)rule.getString("biztype"));
        costObject.set("probill", proBill.get("entryId"));
        costObject.set("srcbillnumber", proBill.get("billno"));
        costObject.set("srcbillrow", proBill.get("entryseq"));
        costObject.set("material", proBill.get("material"));
        costObject.set("producttype", proBill.get("producttype"));
        costObject.set("manuorg", proBill.get("org"));
        costObject.set("isoutsource", (Object)Boolean.FALSE);
        costObject.set("weight", (Object)1);
        costObject.set("configuredcode", proBill.get("configuredcode"));
        costObject.set("tracknumber", proBill.get("tracknumber"));
        costObject.set("isrework", (Object)proBill.getBoolean("isrework"));
        String billtype = proBill.getString("billtype");
        if ("om_mftorder".equals(billtype)) {
            costObject.set("isoutsource", (Object)Boolean.TRUE);
        }
        if (proBill.getBoolean("isenablematerialversion")) {
            costObject.set("bomversion", (Object)proBill.getLong("bom"));
        }
        DynamicObject srcAuxpty = CostObjectHelper.getAuxptyByManuBill(billtype, proBill.getLong("entryId"));
        costObject.set("auxpty", (Object)CostObjectHelper.getEffectCostAuxpty(CostObjectHelper.getMaterialById(proBill.getLong("material")), srcAuxpty));
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String billName = ruleNameAss + srcNum + "-" + srcRow;
        if (Arrays.asList(ruleNameExt).contains("CRN_CPMC") && !CadEmptyUtils.isEmpty(materialName)) {
            billName = billName + "-" + materialName;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty(materialModelnum)) {
            billName = billName + "-" + materialModelnum;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)billName);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)proBill.getDate("transmittime"));
        costObject.set("auditor", (Object)RequestContext.get().getUserId());
        costObject.set("auditdate", (Object)new Date());
        return costObject;
    }

    public static DynamicObject wrapMaterialObject4Save(Map<Long, Long> costCenterAndManuOrgMap, Long costCenterId, DynamicObject ruleItem, Map<String, Object> params, DynamicObject mat) {
        QFilter billNoFiler;
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter");
        String ruleAss = ruleItem.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = ruleItem.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        String matNumber = mat.getString("number");
        String modelnum = mat.getString("modelnum");
        String[] ruleNumberExt = ruleItem.getString("rulenumberext").split(",");
        String[] ruleNameExt = ruleItem.getString("rulenameext").split(",");
        String billNo = ruleAss + matNumber;
        String srcNo = "";
        if (!CadEmptyUtils.isEmpty(params) && !CadEmptyUtils.isEmpty(params.get("producenum").toString())) {
            srcNo = params.get("producenum").toString();
        }
        if (!CadEmptyUtils.isEmpty(srcNo)) {
            billNo = billNo + "-" + srcNo;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty(modelnum)) {
            billNo = billNo + "-" + modelnum;
        }
        if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{billNoFiler = new QFilter("billno", "=", (Object)billNo)})) {
            return null;
        }
        DynamicObject costObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costobject");
        costObject.set("costobjectrule", ruleItem.get("id"));
        costObject.set("org", ruleItem.get("accountorg"));
        costObject.set("billstatus", (Object)"C");
        costObject.set("costcenter", costCenter.getPkValue());
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)ruleItem.getString("sotype"));
        costObject.set("rule", (Object)ruleItem.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_EXCEL.getValue());
        costObject.set("biztype", (Object)ruleItem.getString("biztype"));
        Long manuOrg = costCenterAndManuOrgMap.get(costCenterId) == null ? Long.valueOf(0L) : costCenterAndManuOrgMap.get(costCenterId);
        costObject.set("manuorg", (Object)manuOrg);
        if (StringUtils.isEmpty((String)srcNo) && CostObjectEnum.BIZTYPE_SO.getValue().equals(ruleItem.getString("biztype"))) {
            srcNo = PNO_DEF_VALUE;
        }
        if (CostObjectEnum.BIZTYPE_SO.getValue().equals(ruleItem.getString("biztype"))) {
            costObject.set("producenum", (Object)srcNo);
        } else {
            costObject.set("producenum", null);
        }
        costObject.set("material", mat.get("masterid"));
        if (!CadEmptyUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                costObject.set(key, value);
            }
        }
        DynamicObject auxptyObj = costObject.getDynamicObject("auxpty");
        costObject.set("auxpty", (Object)CostObjectHelper.getEffectCostAuxpty(CostObjectHelper.getMaterialById(mat.getLong("masterid")), auxptyObj));
        Long auxpty = 0L;
        if (!CadEmptyUtils.isEmpty(auxptyObj)) {
            auxpty = auxptyObj.getLong("id");
        }
        String auxptyIdStr = "";
        if (!CadEmptyUtils.isEmpty(auxpty) && !CostObjectEnum.BIZTYPE_RO.getValue().equals(ruleItem.getString("biztype")) && (auxptyIdStr = String.valueOf(auxpty)).length() > 5) {
            auxptyIdStr = auxptyIdStr.substring(auxptyIdStr.length() - 5);
        }
        if (!CadEmptyUtils.isEmpty(auxptyIdStr)) {
            billNo = billNo + "-" + auxptyIdStr;
        }
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String matName = mat.getString("name");
        String billName = ruleNameAss + matName;
        if (!CadEmptyUtils.isEmpty(srcNo)) {
            billName = billName + "-" + srcNo;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty(modelnum)) {
            billName = billName + "-" + modelnum;
        }
        if (!CadEmptyUtils.isEmpty(auxptyIdStr)) {
            billName = billName + "-" + auxptyIdStr;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)billName);
        costObject.set("producttype", (Object)"C");
        costObject.set("weight", (Object)1);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if (CostObjectEnum.BIZTYPE_FL.getValue().equals(ruleItem.getString("biztype")) || mat.getBoolean("isenablematerialversion")) {
            costObject.set("billstatus", (Object)"A");
        } else if (!mat.getBoolean("isenablematerialversion") && mat.getBoolean("isuseauxpty") && !CadEmptyUtils.isEmpty(costObject.getLong("auxpty"))) {
            costObject.set("billstatus", (Object)"C");
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        } else {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    public static DynamicObject wrapMaterialObject4Save(Long costCenterId, DynamicObject ruleItem, DynamicObject srcBill) {
        QFilter billNoFiler;
        DynamicObject costCenter = BusinessDataServiceHelper.loadSingleFromCache((Object)costCenterId, (String)"bos_costcenter");
        String ruleAss = ruleItem.getString("objruleass");
        String ccNumber = costCenter.getString("number") + "-";
        ruleAss = StringUtils.isEmpty((String)ruleAss) ? ccNumber : ruleAss + "-" + ccNumber;
        String ruleNameAss = ruleItem.getString("objrulenameass");
        String ccName = costCenter.getLocaleString("name").getLocaleValue() + "-";
        ruleNameAss = StringUtils.isEmpty((String)ruleNameAss) ? ccName : ruleNameAss + "-" + ccName;
        DynamicObject costObject = BusinessDataServiceHelper.newDynamicObject((String)"cad_costobject");
        costObject.set("id", (Object)DB.genGlobalLongId());
        costObject.set("costobjectrule", ruleItem.get("id"));
        costObject.set("org", ruleItem.get("accountorg"));
        costObject.set("billstatus", (Object)"C");
        costObject.set("costcenter", costCenter.getPkValue());
        costObject.set("bizstatus", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue());
        costObject.set("sotype", (Object)ruleItem.getString("sotype"));
        costObject.set("rule", (Object)ruleItem.getString("rule"));
        costObject.set("originype", (Object)CostObjectEnum.ORIGINYPE_RULE.getValue());
        costObject.set("biztype", (Object)ruleItem.getString("biztype"));
        costObject.set("manuorg", (Object)srcBill.getLong("org"));
        String srcNo = "";
        if (CostObjectEnum.BIZTYPE_SO.getValue().equals(ruleItem.getString("biztype"))) {
            costObject.set("producenum", (Object)srcBill.getString("productnum"));
            srcNo = srcBill.getString("productnum");
        } else {
            costObject.set("producenum", null);
        }
        costObject.set("material", (Object)srcBill.getLong("material"));
        String matNumber = srcBill.getString("materialNumber");
        String modelnum = srcBill.getString("materialModelnum");
        String[] ruleNumberExt = ruleItem.getString("rulenumberext").split(",");
        String[] ruleNameExt = ruleItem.getString("rulenameext").split(",");
        String billNo = ruleAss + matNumber;
        if (!CadEmptyUtils.isEmpty(srcNo)) {
            billNo = billNo + "-" + srcNo;
        }
        if (Arrays.asList(ruleNumberExt).contains("CR_GGXH") && !CadEmptyUtils.isEmpty(modelnum)) {
            billNo = billNo + "-" + modelnum;
        }
        if (QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{billNoFiler = new QFilter("billno", "=", (Object)billNo)})) {
            return null;
        }
        if (billNo.length() > 255) {
            billNo = billNo.substring(0, 255);
        }
        costObject.set("billno", (Object)billNo);
        String matName = srcBill.getString("materialName");
        String billName = ruleNameAss + matName;
        if (!CadEmptyUtils.isEmpty(srcNo)) {
            billName = billName + "-" + srcNo;
        }
        if (Arrays.asList(ruleNameExt).contains("CRN_GGXH") && !CadEmptyUtils.isEmpty(modelnum)) {
            billName = billName + "-" + modelnum;
        }
        if (billName.length() > 255) {
            billName = billName.substring(0, 255);
        }
        costObject.set("name", (Object)billName);
        costObject.set("producttype", (Object)"C");
        costObject.set("weight", (Object)1);
        costObject.set("creator", (Object)RequestContext.get().getUserId());
        costObject.set("createtime", (Object)new Date());
        if (srcBill.getBoolean("isenablematerialversion")) {
            costObject.set("bomversion", (Object)srcBill.getLong("bomversion"));
        }
        String billtype = srcBill.getString("billtype");
        DynamicObject srcAuxpty = CostObjectHelper.getAuxptyByManuBill(billtype, srcBill.getLong("entryId"));
        costObject.set("auxpty", (Object)CostObjectHelper.getEffectCostAuxpty(CostObjectHelper.getMaterialById(srcBill.getLong("material")), srcAuxpty));
        if (CostObjectEnum.BIZTYPE_FL.getValue().equals(ruleItem.getString("biztype"))) {
            costObject.set("billstatus", (Object)"A");
        } else {
            costObject.set("auditor", (Object)RequestContext.get().getUserId());
            costObject.set("auditdate", (Object)new Date());
        }
        return costObject;
    }

    public static Long getEffectCostAuxpty(DynamicObject mat, DynamicObject srcAuxpty) {
        DynamicObject[] auxproperty;
        logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat == null ? "null" : mat.getPkValue(), srcAuxpty == null ? "null" : srcAuxpty.getPkValue());
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        if (srcAuxpty == null || mat == null) {
            return 0L;
        }
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            if (price.getBoolean("isaffectprice")) continue;
            auxptyIdSet.add(auxptyId);
        }
        if (CadEmptyUtils.isEmpty(isaffectprices)) {
            return 0L;
        }
        if (CadEmptyUtils.isEmpty(auxptyIdSet)) {
            return srcAuxpty.getLong("id");
        }
        logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027-\u79fb\u9664\u4e0d\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat.getPkValue(), srcAuxpty.getPkValue());
        String auxStr = (String)srcAuxpty.get(1);
        JSONObject auxptyJsonObject = (JSONObject)JSON.parse((String)auxStr);
        for (DynamicObject aux : auxproperty = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIdSet)})) {
            auxptyJsonObject.remove((Object)aux.getString("flexfield"));
        }
        if (auxptyJsonObject.size() == 0) {
            return 0L;
        }
        String jsonString = auxptyJsonObject.toJSONString();
        DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_flexauxprop", (String)"id", (QFilter[])new QFilter[]{new QFilter("value", "=", (Object)jsonString)});
        if (auxptyObj != null) {
            return auxptyObj.getLong("id");
        }
        auxptyObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_flexauxprop");
        auxptyObj.set("id", (Object)DB.genLongId((String)"t_bd_flexauxpropdata"));
        auxptyObj.set("value", (Object)jsonString);
        auxptyObj.set("createtime", (Object)new Date());
        try (TXHandle txHandle = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{auxptyObj});
        }
        return auxptyObj.getLong("id");
    }

    public static Long getAuxpty(DynamicObject mat, DynamicObject srcAuxpty) {
        logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat == null ? "null" : mat.getPkValue(), srcAuxpty == null ? "null" : srcAuxpty.getPkValue());
        if (srcAuxpty == null || mat == null) {
            return 0L;
        }
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        if (CadEmptyUtils.isEmpty(isaffectprices)) {
            return 0L;
        }
        return srcAuxpty.getLong("id");
    }

    public static Long getEffectCostAuxptyNew(DynamicObject mat, DynamicObject srcAuxpty, Map<Long, Boolean> materialMap, String calmethod) {
        logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat == null ? "null" : mat.getPkValue(), srcAuxpty == null ? "null" : srcAuxpty.getPkValue());
        HashSet<Long> auxptyIdSet = new HashSet<Long>(16);
        if (srcAuxpty == null || mat == null) {
            return 0L;
        }
        long id = mat.getLong("id");
        DynamicObjectCollection isaffectprices = mat.getDynamicObjectCollection("auxptyentry");
        Boolean isAffectPriceFlag = Boolean.FALSE;
        Boolean isAffectPrice = Boolean.FALSE;
        for (DynamicObject price : isaffectprices) {
            Long auxptyId = price.getLong("auxpty.id");
            boolean isaffectprice = price.getBoolean("isaffectprice");
            if (!isaffectprice) {
                auxptyIdSet.add(auxptyId);
                continue;
            }
            isAffectPriceFlag = isaffectprice;
            isAffectPrice = isaffectprice;
        }
        if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(calmethod) && !CadEmptyUtils.isEmpty(materialMap) && materialMap.containsKey(id)) {
            isAffectPriceFlag = materialMap.get(id);
        }
        if (CadEmptyUtils.isEmpty(isaffectprices) || !CostObjectEnum.BIZTYPE_RO.getValue().equals(calmethod) && !isAffectPriceFlag.booleanValue()) {
            return 0L;
        }
        if (CostObjectEnum.BIZTYPE_RO.getValue().equals(calmethod) && !isAffectPriceFlag.booleanValue()) {
            return srcAuxpty.getLong("id");
        }
        if (!CostObjectEnum.BIZTYPE_RO.getValue().equals(calmethod)) {
            return srcAuxpty.getLong("id");
        }
        if (CadEmptyUtils.isEmpty(auxptyIdSet)) {
            return srcAuxpty.getLong("id");
        }
        if (isAffectPrice.booleanValue()) {
            DynamicObject[] auxproperty;
            logger.info("\u83b7\u53d6\u8f85\u52a9\u5c5e\u6027-\u79fb\u9664\u4e0d\u5f71\u54cd\u6210\u672c\u7684\u8f85\u52a9\u5c5e\u6027\u3002\u53c2\u6570\uff1a\u7269\u6599{}\uff0c\u6e90\u5355\u8f85\u52a9\u5c5e\u6027{}", mat.getPkValue(), srcAuxpty.getPkValue());
            String auxStr = (String)srcAuxpty.get(1);
            JSONObject auxptyJsonObject = (JSONObject)JSON.parse((String)auxStr);
            for (DynamicObject aux : auxproperty = BusinessDataServiceHelper.load((String)"bd_auxproperty", (String)"flexfield", (QFilter[])new QFilter[]{new QFilter("id", "in", auxptyIdSet)})) {
                auxptyJsonObject.remove((Object)aux.getString("flexfield"));
            }
            if (auxptyJsonObject.size() == 0) {
                return 0L;
            }
            String jsonString = auxptyJsonObject.toJSONString();
            DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_flexauxprop", (String)"id", (QFilter[])new QFilter[]{new QFilter("value", "=", (Object)jsonString)});
            if (auxptyObj != null) {
                return auxptyObj.getLong("id");
            }
            auxptyObj = BusinessDataServiceHelper.newDynamicObject((String)"bd_flexauxprop");
            auxptyObj.set("id", (Object)DB.genLongId((String)"t_bd_flexauxpropdata"));
            auxptyObj.set("value", (Object)jsonString);
            auxptyObj.set("createtime", (Object)new Date());
            try (TXHandle txHandle = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{auxptyObj});
            }
            return auxptyObj.getLong("id");
        }
        return 0L;
    }

    public static QFilter getWcOrOrgOrAoQFByWay(List<Long> entryIdsForWorkCenter, List<Long> orgs, List<Long> adminOrgIds, Boolean isConsiderWorkCenters) {
        QFilter wcOrOrgOrAoQF = null;
        if (isConsiderWorkCenters.booleanValue() && !CadEmptyUtils.isEmpty(entryIdsForWorkCenter)) {
            List partition = Lists.partition(entryIdsForWorkCenter, (int)30000);
            for (List list : partition) {
                if (wcOrOrgOrAoQF == null) {
                    wcOrOrgOrAoQF = new QFilter("treeentryentity.id", "in", (Object)list);
                    wcOrOrgOrAoQF.or("treeentryentity.pid", "in", (Object)list);
                    continue;
                }
                wcOrOrgOrAoQF = wcOrOrgOrAoQF.or(new QFilter("treeentryentity.id", "in", (Object)list));
                wcOrOrgOrAoQF.or("treeentryentity.pid", "in", (Object)list);
            }
        }
        if (!CadEmptyUtils.isEmpty(orgs)) {
            wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? new QFilter("org", "in", orgs) : wcOrOrgOrAoQF.or(new QFilter("org", "in", orgs));
        }
        if (!CadEmptyUtils.isEmpty(adminOrgIds)) {
            wcOrOrgOrAoQF = wcOrOrgOrAoQF == null ? new QFilter("treeentryentity.producedept", "in", adminOrgIds) : wcOrOrgOrAoQF.or(new QFilter("treeentryentity.producedept", "in", adminOrgIds));
        }
        return wcOrOrgOrAoQF;
    }

    public static String getCostCalMethod(Long accountOrg, Long costcenter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter costcenterQF = new QFilter("costcenter", "=", (Object)costcenter);
        filters.add(new QFilter("accountorg", "=", (Object)accountOrg));
        filters.add(costcenterQF);
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass", (QFilter[])filters.toArray(new QFilter[0]));
        if (rule != null) {
            return rule.getString("biztype");
        }
        filters.remove(costcenterQF);
        costcenterQF = new QFilter("costcenter", "=", (Object)0L);
        filters.add(costcenterQF);
        rule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass", (QFilter[])filters.toArray(new QFilter[0]));
        if (rule != null) {
            return rule.getString("biztype");
        }
        return null;
    }

    public static boolean isExistCostObjectRule(Long accountOrg) {
        QFilter filter = new QFilter("accountorg", "=", (Object)accountOrg);
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject rule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"id", (QFilter[])new QFilter[]{filter});
        return rule != null;
    }

    public static Map<ExtendedDataEntity, String> getCostObjectRelatedInfo(Map<Long, ExtendedDataEntity> dataEntitys) {
        String sql = "SELECT FObjectTypeId, FTableName, FFieldName FROM T_META_OBJECTTYPEREF WHERE FREFOBJECTTYPEID = 'cad_costobjectf7'";
        ResultSetHandler<Map<String, Map<String, String>>> handler = new ResultSetHandler<Map<String, Map<String, String>>>(){

            public Map<String, Map<String, String>> handle(ResultSet rs) throws Exception {
                HashMap<String, Map<String, String>> dataMapAll = new HashMap<String, Map<String, String>>(16);
                while (rs.next()) {
                    String objectId = rs.getString("FObjectTypeId");
                    if (StringUtils.isEmpty((String)objectId) || relatedBlacklist.contains(objectId)) continue;
                    String table = rs.getString("FTableName");
                    Map itemMap = dataMapAll.computeIfAbsent(table, s -> new HashMap());
                    if (itemMap.get("entity") == null || objectId.length() < ((String)itemMap.get("entity")).length()) {
                        itemMap.put("entity", objectId);
                        itemMap.put("table", table);
                    }
                    dataMapAll.put(table, itemMap);
                }
                return dataMapAll;
            }
        };
        Map dataMapAll = (Map)DB.query((DBRoute)DBRoute.meta, (String)sql, (ResultSetHandler)handler);
        logger.info("\u83b7\u53d6\u5f15\u7528\u4e86\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u5355\u636e\u540d\u7684\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + dataMapAll.size());
        if (CadEmptyUtils.isEmpty(dataMapAll)) {
            return null;
        }
        HashMap<ExtendedDataEntity, String> infoMap = new HashMap<ExtendedDataEntity, String>(16);
        for (Map.Entry entry : dataMapAll.entrySet()) {
            Map dataMap = (Map)entry.getValue();
            String entity = (String)dataMap.get("entity");
            DynamicObjectCollection costobjects = null;
            try {
                QFilter filter;
                if ("cad_factnedoutputbill".equals(entity) || "sca_resourceuse".equals(entity) || "aca_matusecollect".equals(entity) || "sca_matusecollect".equals(entity)) {
                    filter = new QFilter("entryentity.costobject", "in", dataEntitys.keySet());
                    costobjects = QueryServiceHelper.query((String)entity, (String)"entryentity.costobject costobject", (QFilter[])new QFilter[]{filter});
                } else {
                    filter = new QFilter("costobject", "in", dataEntitys.keySet());
                    costobjects = QueryServiceHelper.query((String)entity, (String)"costobject", (QFilter[])new QFilter[]{filter});
                }
                MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entity);
                if (CadEmptyUtils.isEmpty(costobjects)) continue;
                for (DynamicObject costobject : costobjects) {
                    StringBuilder sb = new StringBuilder();
                    infoMap.put(dataEntitys.get(costobject.getLong("costobject")), sb.append('\u3010').append(type.getDisplayName()).append('\u3011').toString());
                }
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5f15\u7528\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u7684\u5355\u636e\u9519\u8bef\u3002\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a", (Throwable)e);
            }
        }
        return infoMap;
    }

    public static Map<Boolean, Set<Long>> getProbillEntryIds(Object[] objIds) {
        HashMap<Boolean, Set<Long>> probillEntryIdMap = new HashMap<Boolean, Set<Long>>(10);
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_costobject", (String)"id,probill,isoutsource", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(rows)) {
            return probillEntryIdMap;
        }
        for (DynamicObject row : rows) {
            probillEntryIdMap.computeIfAbsent(row.getBoolean("isoutsource"), p -> new HashSet(10)).add(row.getLong("probill"));
        }
        return probillEntryIdMap;
    }

    public static void uplook(IFormView view, Map<Boolean, Set<Long>> probillEntryIdMap) {
        if (CadEmptyUtils.isEmpty(probillEntryIdMap)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u6570\u636e\u3002", (String)"CostObjectHelper_9", (String)"macc-cad-common", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry<Boolean, Set<Long>> probill : probillEntryIdMap.entrySet()) {
            if (!probill.getKey().booleanValue()) {
                CostObjectHelper.uplookBySource(view, probill.getValue(), "pom_mftorder");
                continue;
            }
            CostObjectHelper.uplookBySource(view, probill.getValue(), "om_mftorder");
        }
    }

    public static void uplookBySource(IFormView view, Set<Long> probillEntryIds, String entity) {
        String msg = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostObjectHelper_10", (String)"macc-cad-common", (Object[])new Object[0]);
        if ("om_mftorder".equals(entity)) {
            msg = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u6ca1\u6709\u6743\u9650\u67e5\u770b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostObjectHelper_11", (String)"macc-cad-common", (Object[])new Object[0]);
        }
        try {
            MetadataServiceHelper.getDataEntityType((String)entity);
        }
        catch (Exception e) {
            logger.error("\u6ca1\u6709\u6743\u9650\u67e5\u770b", (Throwable)e);
            view.showErrorNotification(msg);
            return;
        }
        QFilter filter = new QFilter("treeentryentity.id", "in", probillEntryIds);
        DynamicObjectCollection rows = QueryServiceHelper.query((String)entity, (String)"id,org,treeentryentity.id entryid", (QFilter[])new QFilter[]{filter});
        if (CadEmptyUtils.isEmpty(rows)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u7684\u6570\u636e\u3002", (String)"CostObjectHelper_9", (String)"macc-cad-common", (Object[])new Object[0]));
            return;
        }
        HashMap probillIds = new HashMap();
        rows.forEach(s -> probillIds.put(s.get("id"), s.get("org")));
        SrcBillShowerUtils.showSearchUpBillOrList(view, entity, Lists.newArrayList(probillIds.keySet()), null);
    }

    public static boolean isSettlement(Long costObject) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("costobject", "=", (Object)costObject));
        qfList.add(new QFilter("bizstatus", "=", (Object)"B"));
        return QueryServiceHelper.exists((String)"cad_costobjectaccount", (QFilter[])qfList.toArray(new QFilter[0]));
    }

    public static List<Long> getSettlCostObject(List<Long> costObjects) {
        QFilter bizFilter = new QFilter("bizstatus", "=", (Object)"B");
        List splitLists = Lists.partition(costObjects, (int)50000);
        ArrayList<Long> costObjectIds = new ArrayList<Long>(10);
        for (List list : splitLists) {
            QFilter objFiler = new QFilter("costobject", "in", (Object)list);
            DynamicObjectCollection costObjectAccounts = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"costobject", (QFilter[])new QFilter[]{objFiler, bizFilter});
            for (DynamicObject costObject : costObjectAccounts) {
                costObjectIds.add(costObject.getLong("costobject"));
            }
        }
        return costObjectIds;
    }

    public static Set<Long> getSettlCostObject(Long costAccountId) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("costaccount", "=", (Object)costAccountId));
        qfList.add(new QFilter("bizstatus", "=", (Object)"B"));
        DynamicObjectCollection costObjectAccounts = QueryServiceHelper.query((String)"cad_costobjectaccount", (String)"costobject", (QFilter[])qfList.toArray(new QFilter[0]));
        HashSet<Long> costObjectIds = new HashSet<Long>(16);
        for (DynamicObject costObject : costObjectAccounts) {
            costObjectIds.add(costObject.getLong("costobject"));
        }
        return costObjectIds;
    }

    public static Map<String, List<DynamicObject>> getCenterByManuBill(DynamicObject[] manuBills, List<Long> costCenters, Map<Long, Long> manuEntryIdAndWorkCenterMap, List<Map<String, Date>> importScopeDate) {
        HashMap<String, List<DynamicObject>> costCenterSourceDataListMap = new HashMap<String, List<DynamicObject>>(16);
        HashSet<Long> org = new HashSet<Long>(50);
        HashSet<Long> workCenters = new HashSet<Long>(50);
        HashSet<Long> adminOrgs = new HashSet<Long>(50);
        for (DynamicObject manu : manuBills) {
            org.add(manu.getLong("org"));
            adminOrgs.add(manu.getLong("producedept"));
            boolean isprocedure = manu.getBoolean("isprocedure");
            if (isprocedure) {
                workCenters.add(manuEntryIdAndWorkCenterMap.get(manu.getLong("entryId")));
                continue;
            }
            workCenters.add(manu.getLong("workcenter"));
        }
        if (CadEmptyUtils.isEmpty(org) && CadEmptyUtils.isEmpty(workCenters) && CadEmptyUtils.isEmpty(adminOrgs)) {
            return costCenterSourceDataListMap;
        }
        QFilter qfDataId = new QFilter("entryentity.sourcedata", "in", (Object)org.toArray());
        qfDataId.and("entryentity.sourcetype", "=", (Object)"bos_org");
        if (CollectionUtils.isNotEmpty(workCenters)) {
            QFilter qfWorkCenter = new QFilter("entryentity.sourcedata", "in", (Object)workCenters.toArray());
            qfWorkCenter.and("entryentity.sourcetype", "=", (Object)"mpdm_workcentre");
            qfDataId.or(qfWorkCenter);
        }
        if (CollectionUtils.isNotEmpty(adminOrgs)) {
            QFilter qfAdminOrg = new QFilter("entryentity.sourcedata", "in", (Object)adminOrgs.toArray());
            qfAdminOrg.and("entryentity.sourcetype", "=", (Object)"bos_adminorg");
            qfDataId.or(qfAdminOrg);
        }
        QFilter ccFilter = new QFilter("costcenter", "in", costCenters);
        QFilter enableFilter = new QFilter("costcenter.enable", "=", (Object)Boolean.TRUE);
        QFilter qfOrgduty = new QFilter("costcenter.orgduty", "=", (Object)4L);
        if (!CadEmptyUtils.isEmpty(importScopeDate)) {
            DynamicObjectCollection centerSourceMap;
            Date startDate = importScopeDate.get(0).get("start");
            Date endDate = importScopeDate.get(0).get("end");
            QFilter dateFilter = new QFilter("effectdate", "<", (Object)endDate).and(new QFilter("expdate", ">", (Object)startDate));
            if (importScopeDate.size() > 1) {
                Date nextStartDate = importScopeDate.get(1).get("start");
                Date nextEndDate = importScopeDate.get(1).get("end");
                QFilter nextDateFilter = new QFilter("effectdate", "<", (Object)nextEndDate).and(new QFilter("expdate", ">", (Object)nextStartDate));
                dateFilter = dateFilter.or(nextDateFilter);
            }
            if (CadEmptyUtils.isEmpty(centerSourceMap = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter,costcenter.accountorg org,effectdate,expdate,entryentity.sourcetype,entryentity.sourcedata", (QFilter[])new QFilter[]{qfDataId, ccFilter, enableFilter, qfOrgduty, dateFilter}))) {
                return costCenterSourceDataListMap;
            }
            for (DynamicObject sourceMap : centerSourceMap) {
                String mapKey = sourceMap.getLong("entryentity.sourcedata") + "@" + sourceMap.getString("entryentity.sourcetype");
                costCenterSourceDataListMap.computeIfAbsent(mapKey, s -> new ArrayList()).add(sourceMap);
            }
        }
        return costCenterSourceDataListMap;
    }

    public static DynamicObject getCostCenter(DynamicObject manuBill, Map<String, List<DynamicObject>> costInfo, Map<Long, Long> manuEntryIdAndWorkCenterMap) {
        Date bizDate = manuBill.getDate("transmittime");
        DynamicObject costCenter = CostObjectHelper.getCostCenterBySrcBillDate(bizDate, costInfo.get(manuBill.getLong("org") + "@" + "bos_org"));
        boolean isprocedure = manuBill.getBoolean("isprocedure");
        if (costCenter == null) {
            if (isprocedure) {
                costCenter = CostObjectHelper.getCostCenterBySrcBillDate(bizDate, costInfo.get(manuEntryIdAndWorkCenterMap.get(manuBill.getLong("entryId")) + "@" + "mpdm_workcentre"));
                if (costCenter == null) {
                    costCenter = CostObjectHelper.getCostCenterBySrcBillDate(bizDate, costInfo.get(manuEntryIdAndWorkCenterMap.get(manuBill.getLong("pnodeId")) + "@" + "mpdm_workcentre"));
                }
            } else {
                costCenter = CostObjectHelper.getCostCenterBySrcBillDate(bizDate, costInfo.get(manuBill.getLong("workcenter") + "@" + "mpdm_workcentre"));
            }
        }
        if (costCenter == null) {
            costCenter = CostObjectHelper.getCostCenterBySrcBillDate(bizDate, costInfo.get(manuBill.getLong("producedept") + "@" + "bos_adminorg"));
        }
        return costCenter;
    }

    public static DynamicObject getCostCenterBySrcBillDate(Date bizDate, List<DynamicObject> costCenterSourceList) {
        if (CadEmptyUtils.isEmpty(costCenterSourceList)) {
            return null;
        }
        if (bizDate == null) {
            bizDate = new Date();
        }
        for (DynamicObject costCenterSource : costCenterSourceList) {
            if (costCenterSource.getDate("effectdate").getTime() > bizDate.getTime() || costCenterSource.getDate("expdate").getTime() <= bizDate.getTime()) continue;
            return costCenterSource;
        }
        return null;
    }

    public static Map<Long, Long> getManuEntryIdAndWorkCenterMap(DynamicObjectCollection manuBills) {
        HashMap<Long, Long> manuEntryIdAndWorkCenterMap = new HashMap<Long, Long>(200);
        if (CadEmptyUtils.isEmpty(manuBills)) {
            return manuEntryIdAndWorkCenterMap;
        }
        HashSet<Long> entryIds = new HashSet<Long>(200);
        for (DynamicObject manuBill : manuBills) {
            if (!manuBill.getBoolean("isprocedure")) continue;
            entryIds.add(manuBill.getLong("entryId"));
        }
        if (CadEmptyUtils.isEmpty(entryIds)) {
            return manuEntryIdAndWorkCenterMap;
        }
        QFilter workCenterQf = new QFilter("mftentryseq.id", "in", entryIds);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter oprinvalQf = new QFilter("oprentryentity.oprinvalid", "=", (Object)Boolean.FALSE);
        DynamicObjectCollection manfTechs = QueryServiceHelper.query((String)"sfc_manftech", (String)"id,mftentryseq.id entryid,oprentryentity.oprworkcenter oprworkcenter", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        DynamicObjectCollection manfTechnics = QueryServiceHelper.query((String)"om_mfttechnics", (String)"id,mftentryseq.id entryid,oprentryentity.oprworkcenter oprworkcenter", (QFilter[])new QFilter[]{workCenterQf, billStatusQf, oprinvalQf});
        if (!CadEmptyUtils.isEmpty(manfTechnics)) {
            manfTechs.addAll((Collection)manfTechnics);
        }
        manfTechs.forEach(p -> {
            if (!CadEmptyUtils.isEmpty(p.getLong("entryid"))) {
                manuEntryIdAndWorkCenterMap.put(p.getLong("entryid"), p.getLong("oprworkcenter"));
            }
        });
        return manuEntryIdAndWorkCenterMap;
    }

    public static Set<Object> getMainMatIds(List<DynamicObject> proBills) {
        HashSet<Object> matIds = new HashSet<Object>();
        for (DynamicObject proBill : proBills) {
            if (!"C".equals(proBill.getString("producttype"))) continue;
            matIds.add(proBill.get("material"));
        }
        return matIds;
    }

    public static DynamicObject getMaterialById(Long matId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)matId, (String)"bd_material");
    }

    public static DynamicObject getPropertyBySrcbill(String entity, String propertyField, QFilter qFilter) {
        return BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)propertyField, (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject getAuxptyByManuBill(String entity, Long entryId) {
        DynamicObjectCollection treeEntryEntity;
        QFilter filter = new QFilter("treeentryentity.id", "=", (Object)entryId);
        DynamicObject srcAuxpty = CostObjectHelper.getPropertyBySrcbill(entity, "treeentryentity.auxproperty", filter);
        if (srcAuxpty != null && (treeEntryEntity = srcAuxpty.getDynamicObjectCollection("treeentryentity")) != null && !treeEntryEntity.isEmpty()) {
            for (DynamicObject dynamicObject : treeEntryEntity) {
                if (entryId.longValue() != dynamicObject.getLong("id")) continue;
                return dynamicObject.getDynamicObject("auxproperty");
            }
        }
        return null;
    }

    public static Map<String, Set<Long>> getExistCostObjectManuEntryIdsMap(Long org, List<Long> costCenters, List<Long> mftOrderEntryIds) {
        return CostObjectHelper.getExistCostObjectManuEntryIdsMap(org, costCenters, mftOrderEntryIds, null);
    }

    public static Map<String, Set<Long>> getExistCostObjectManuEntryIdsMap(Long org, List<Long> costCenters, List<Long> mftOrderEntryIds, Map<Long, Long> probillCostcenterMap) {
        HashMap<String, Set<Long>> existCostObjectManuEntryIdsMap = new HashMap<String, Set<Long>>(16);
        QFilter filters = new QFilter("org", "=", (Object)org);
        filters.and(new QFilter("biztype", "in", (Object)"RO"));
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            filters.and(InFilterHelper.getQFilterByBachSize("probill", new ArrayList<Object>(mftOrderEntryIds), "in", 20000));
        }
        DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,probill", (QFilter[])new QFilter[]{filters});
        costObjects.forEach(costObject -> {
            existCostObjectManuEntryIdsMap.computeIfAbsent(costObject.getString("org"), p -> new HashSet()).add(costObject.getLong("probill"));
            if (probillCostcenterMap != null) {
                probillCostcenterMap.put(costObject.getLong("probill"), costObject.getLong("costcenter"));
            }
        });
        return existCostObjectManuEntryIdsMap;
    }

    public static Map<String, Set<Long>> getExistCostObjectProBillEntryids(Long acctOrgId, Set<Long> costCenterIds) {
        QFilter filter = new QFilter("org", "=", (Object)acctOrgId);
        filter.and(new QFilter("costcenter", "in", costCenterIds));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,probill", (QFilter[])new QFilter[]{filter});
        HashMap<String, Set<Long>> proBIllIds = new HashMap<String, Set<Long>>(16);
        rows.forEach(p -> proBIllIds.computeIfAbsent(p.getString("org") + p.getString("costcenter"), r -> new HashSet()).add(p.getLong("probill")));
        return proBIllIds;
    }

    public static Map<String, List<String>> getExistCostObjectMaterialMap(Long acctOrgId, List<Long> costCenterIds, Boolean isUnSettle) {
        DynamicObjectCollection rows;
        HashMap<String, List<String>> matMap = new HashMap<String, List<String>>(200);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)acctOrgId));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        if (isUnSettle.booleanValue()) {
            filters.add(new QFilter("bizstatus", "=", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue()));
        }
        if (CadEmptyUtils.isEmpty(rows = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,material,bomversion,auxpty", (QFilter[])filters.toArray(new QFilter[0])))) {
            return matMap;
        }
        for (DynamicObject row : rows) {
            matMap.computeIfAbsent(row.getString("org") + row.getString("costcenter"), p -> new ArrayList(1000)).add(row.getString("material").concat("@").concat(row.getString("bomversion")).concat("@").concat(row.getString("auxpty")));
        }
        return matMap;
    }

    public static Map<String, DynamicObject> getExistCostObjectMapForMaterial(Long acctOrgId, List<Long> costCenterIds, String appNum) {
        DynamicObjectCollection rows;
        HashMap<String, DynamicObject> matMap = new HashMap<String, DynamicObject>(200);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)acctOrgId));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        if ("sca".equals(appNum)) {
            filters.add(new QFilter("bizstatus", "=", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue()));
        }
        if (CadEmptyUtils.isEmpty(rows = QueryServiceHelper.query((String)"cad_costobject", (String)"id,org,costcenter,producenum,material,bomversion,auxpty", (QFilter[])filters.toArray(new QFilter[0])))) {
            return matMap;
        }
        for (DynamicObject row : rows) {
            matMap.put(row.getString("costcenter").concat("@").concat(row.getString("material")).concat("@").concat(row.getString("bomversion")).concat("@").concat(row.getString("auxpty")), row);
        }
        return matMap;
    }

    public static Map<String, List<String>> getExistCostObjectMaterialMapForFP(Long acctOrgId, List<Long> costCenterIds, String appNum) {
        DynamicObjectCollection rows;
        HashMap<String, List<String>> matMap = new HashMap<String, List<String>>(200);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)acctOrgId));
        filters.add(new QFilter("costcenter", "in", costCenterIds));
        if ("sca".equals(appNum)) {
            filters.add(new QFilter("bizstatus", "=", (Object)CostObjectEnum.BIZSTATUS_UNSETTLE.getValue()));
        }
        if (CadEmptyUtils.isEmpty(rows = QueryServiceHelper.query((String)"cad_costobject", (String)"org,costcenter,producenum,material,bomversion,auxpty", (QFilter[])filters.toArray(new QFilter[0])))) {
            return matMap;
        }
        for (DynamicObject row : rows) {
            matMap.computeIfAbsent(row.getString("org") + row.getString("costcenter"), p -> new ArrayList(1000)).add(row.getString("material").concat("@").concat(row.getString("bomversion")).concat("@").concat(row.getString("auxpty")).concat("@").concat(row.getString("producenum")));
        }
        return matMap;
    }

    public static Map<String, Map<String, DynamicObject>> getExistCostObjectMap(Long acctOrgId, List<Long> costCenterIds, String selectFields, String appNum) {
        return CostObjectHelper.getExistCostObjectMap(acctOrgId, costCenterIds, selectFields, appNum, null);
    }

    public static Map<String, Map<String, DynamicObject>> getEcaExistCostObjectMap(Long acctOrgId, List<Long> costCenterIds, String selectFields, String calcMethod) {
        DynamicObjectCollection costObjects;
        HashMap<String, Map<String, DynamicObject>> existCostObjectMap = new HashMap<String, Map<String, DynamicObject>>(200);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)acctOrgId));
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            filters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(calcMethod)) {
            filters.add(new QFilter("biztype", "=", (Object)calcMethod));
        }
        String otherFields = "id,org,costcenter,calckeycol";
        if (!selectFields.contains("configuredcode")) {
            otherFields = otherFields + ",configuredcode";
        }
        if (!selectFields.contains("tracknumber")) {
            otherFields = otherFields + ",tracknumber";
        }
        if (!selectFields.contains("projectnumber")) {
            otherFields = otherFields + ",projectnumber";
        }
        if (!selectFields.contains("lot")) {
            otherFields = otherFields + ",lot";
        }
        if (!selectFields.contains("material")) {
            otherFields = otherFields + ",material";
        }
        if (!selectFields.contains("bomversion")) {
            otherFields = otherFields + ",bomversion";
        }
        if (!selectFields.contains("auxpty")) {
            otherFields = otherFields + ",auxpty";
        }
        if (!selectFields.contains("isoutsource")) {
            otherFields = otherFields + ",isoutsource";
        }
        if (!selectFields.contains("biztype")) {
            otherFields = otherFields + ",biztype";
        }
        if (CadEmptyUtils.isEmpty(costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)(otherFields + "," + selectFields), (QFilter[])filters.toArray(new QFilter[0])))) {
            return existCostObjectMap;
        }
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            for (DynamicObject costObject : costObjects) {
                String strKey = CostObjectHelper.getCostObjectStr(costObject, selectFields, ",");
                existCostObjectMap.computeIfAbsent(costObject.getString("org"), p -> new HashMap(200)).put(strKey, costObject);
            }
            return existCostObjectMap;
        }
        for (DynamicObject costObject : costObjects) {
            String strKey = CostObjectHelper.getCostObjectStr(costObject, selectFields, ",");
            existCostObjectMap.computeIfAbsent(costObject.getString("org") + costObject.getString("costcenter") + costObject.getString("biztype"), p -> new HashMap(200)).put(strKey, costObject);
        }
        return existCostObjectMap;
    }

    public static Map<String, Map<String, DynamicObject>> getExistCostObjectMap(Long acctOrgId, List<Long> costCenterIds, String selectFields, String appNum, List<Long> mftOrderEntryIds) {
        DynamicObjectCollection costObjects;
        HashMap<String, Map<String, DynamicObject>> existCostObjectMap = new HashMap<String, Map<String, DynamicObject>>(200);
        if (CadEmptyUtils.isEmpty(selectFields)) {
            return existCostObjectMap;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)acctOrgId));
        filters.add(new QFilter("billstatus", "=", (Object)"C"));
        if (!CadEmptyUtils.isEmpty(costCenterIds)) {
            filters.add(new QFilter("costcenter", "in", costCenterIds));
        }
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            filters.add(new QFilter("probill", "in", mftOrderEntryIds));
        }
        String otherFields = "id,org,costcenter,calckeycol,keycolfield";
        if (!selectFields.contains("configuredcode")) {
            otherFields = otherFields + ",configuredcode";
        }
        if (!selectFields.contains("tracknumber")) {
            otherFields = otherFields + ",tracknumber";
        }
        if (!selectFields.contains("projectnumber")) {
            otherFields = otherFields + ",projectnumber";
        }
        if (!selectFields.contains("lot")) {
            otherFields = otherFields + ",lot";
        }
        if (!selectFields.contains("material")) {
            otherFields = otherFields + ",material";
        }
        if (!selectFields.contains("bomversion")) {
            otherFields = otherFields + ",bomversion";
        }
        if (!selectFields.contains("auxpty")) {
            otherFields = otherFields + ",auxpty";
        }
        if (!selectFields.contains("isoutsource")) {
            otherFields = otherFields + ",isoutsource";
        }
        if (CadEmptyUtils.isEmpty(costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)(otherFields + "," + selectFields), (QFilter[])filters.toArray(new QFilter[0])))) {
            return existCostObjectMap;
        }
        if (CadEmptyUtils.isEmpty(costCenterIds)) {
            for (DynamicObject costObject : costObjects) {
                String strkey = CostObjectHelper.getCostObjectStr(costObject, selectFields, ",");
                existCostObjectMap.computeIfAbsent(costObject.getString("org"), p -> new HashMap(200)).put(strkey, costObject);
            }
            return existCostObjectMap;
        }
        for (DynamicObject costObject : costObjects) {
            String strkey = CostObjectHelper.getCostObjectStr(costObject, selectFields, ",");
            existCostObjectMap.computeIfAbsent(costObject.getString("org") + costObject.getString("costcenter"), p -> new HashMap(200)).put(strkey, costObject);
        }
        return existCostObjectMap;
    }

    public static String getCostObjectStr(DynamicObject row, String str, String split) {
        String strRes = "";
        if (CadEmptyUtils.isEmpty(str)) {
            return strRes;
        }
        String[] strings = str.split(split);
        Long materialId = 0L;
        Long auxpt = 0L;
        Long version = 0L;
        for (String s : strings) {
            if (row.get(s) == null || !"material".equals(s)) continue;
            materialId = row.get("material") instanceof DynamicObject ? Long.valueOf(row.getLong("material.id")) : Long.valueOf(row.getLong("material"));
            long auxId = row.getLong("auxpty");
            DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)auxId, (String)"bd_flexauxprop");
            auxpt = CostObjectHelper.getEffectCostAuxpty(CostObjectHelper.getMaterialById(materialId), auxptyObj);
            version = row.getLong("bomversion");
        }
        for (String s : strings) {
            if (row.get(s) == null) continue;
            if (CadEmptyUtils.isEmpty(strRes)) {
                if ("material".equals(s)) {
                    strRes = String.valueOf(materialId);
                    continue;
                }
                if ("bomversion".equals(s)) {
                    strRes = String.valueOf(version);
                    continue;
                }
                if ("auxpty".equals(s)) {
                    strRes = String.valueOf(auxpt);
                    continue;
                }
                strRes = row.getString(s);
                continue;
            }
            strRes = "material".equals(s) ? strRes + "@" + materialId : ("bomversion".equals(s) ? strRes + "@" + version : ("auxpty".equals(s) ? strRes + "@" + auxpt : strRes + "@" + row.getString(s)));
        }
        return strRes;
    }

    public static String getCostObjectHashCodeBySrcBill(DynamicObject srcBill, TreeMap<String, String> collConfigRuleMappingMap) {
        String material1Field;
        String strRes = "";
        if (CadEmptyUtils.isEmpty(collConfigRuleMappingMap)) {
            return strRes;
        }
        Long materialId = 0L;
        Long version = 0L;
        Long auxpty = 0L;
        if (collConfigRuleMappingMap.containsKey("material") && !CadEmptyUtils.isEmpty(material1Field = collConfigRuleMappingMap.get("material"))) {
            materialId = Long.parseLong(srcBill.get(material1Field).toString());
            String versionField = collConfigRuleMappingMap.get("bomversion");
            String auxptyField = collConfigRuleMappingMap.get("auxpty");
            DynamicObject material = CostObjectHelper.getMaterialById(materialId);
            if (material != null) {
                boolean isenablematerialversion;
                boolean isuseauxpty = material.getBoolean("isuseauxpty");
                if (isuseauxpty && !CadEmptyUtils.isEmpty(auxptyField)) {
                    long auxId = srcBill.getLong(auxptyField);
                    DynamicObject auxptyObj = BusinessDataServiceHelper.loadSingleFromCache((Object)auxId, (String)"bd_flexauxprop");
                    auxpty = CostObjectHelper.getEffectCostAuxpty(material, auxptyObj);
                }
                if ((isenablematerialversion = material.getBoolean("isenablematerialversion")) && !CadEmptyUtils.isEmpty(versionField)) {
                    version = srcBill.getLong(versionField);
                }
            }
        }
        for (Map.Entry<String, String> configRule : collConfigRuleMappingMap.entrySet()) {
            String costField = configRule.getKey();
            String srcField = configRule.getValue();
            if (CadEmptyUtils.isEmpty(strRes)) {
                if ("material".equals(costField)) {
                    strRes = String.valueOf(materialId);
                    continue;
                }
                if ("bomversion".equals(costField)) {
                    strRes = String.valueOf(version);
                    continue;
                }
                if ("auxpty".equals(costField)) {
                    strRes = String.valueOf(auxpty);
                    continue;
                }
                if (!srcBill.containsProperty(srcField)) continue;
                strRes = srcBill.getString(srcField);
                continue;
            }
            if ("material".equals(costField)) {
                strRes = strRes + "@" + materialId;
                continue;
            }
            if ("bomversion".equals(costField)) {
                strRes = strRes + "@" + version;
                continue;
            }
            if ("auxpty".equals(costField)) {
                strRes = strRes + "@" + auxpty;
                continue;
            }
            strRes = strRes + "@" + srcBill.getString(srcField);
        }
        return strRes;
    }

    public static Map<String, String> getCollConfigRuleMappingMap(DynamicObject config, Boolean isOnlyParseField) {
        HashMap<String, String> collConfigRuleMappingMap = new HashMap<String, String>(16);
        DynamicObjectCollection costRuleInfoEntity = config.getDynamicObjectCollection("costruleinfoentity");
        if (CadEmptyUtils.isEmpty(costRuleInfoEntity)) {
            return collConfigRuleMappingMap;
        }
        for (DynamicObject field : costRuleInfoEntity) {
            if (isOnlyParseField.booleanValue() && !field.getBoolean("parsefield")) continue;
            String costfield = field.getString("costobjfield");
            String sourcefield = field.getString("srcbillfield");
            if (CadEmptyUtils.isEmpty(sourcefield)) continue;
            collConfigRuleMappingMap.put(costfield, sourcefield);
        }
        return collConfigRuleMappingMap;
    }

    public static Set<String> getCostObjectFields(String dimension) {
        String[] dimensionStr;
        HashSet<String> costObjectFields = new HashSet<String>(10);
        if (CadEmptyUtils.isEmpty(dimension)) {
            return costObjectFields;
        }
        String[] stringArray = dimensionStr = dimension.split(",");
        int n = stringArray.length;
        block20: for (int i = 0; i < n; ++i) {
            String dim;
            switch (dim = stringArray[i]) {
                case "YDDH": {
                    costObjectFields.add("srcbillnumber");
                    continue block20;
                }
                case "YDHH": {
                    costObjectFields.add("srcbillrow");
                    continue block20;
                }
                case "CP": {
                    costObjectFields.add("material");
                    costObjectFields.add("bomversion");
                    costObjectFields.add("auxpty");
                    continue block20;
                }
                case "XMH": {
                    costObjectFields.add("projectnumber");
                    continue block20;
                }
                case "GZH": {
                    costObjectFields.add("tracknumber");
                    continue block20;
                }
                case "PZH": {
                    costObjectFields.add("configuredcode");
                    continue block20;
                }
                case "SCBH": {
                    costObjectFields.add("producenum");
                    continue block20;
                }
                case "PH": {
                    costObjectFields.add("lot");
                    continue block20;
                }
                default: {
                    if (CadEmptyUtils.isEmpty(dim)) continue block20;
                    costObjectFields.add(dim);
                }
            }
        }
        return costObjectFields;
    }

    public static List<ComboItem> getCalMthodComboItem(String appId) {
        LinkedHashMap<String, LocaleString> itemMap = new LinkedHashMap<String, LocaleString>(3);
        if ("sca".equals(appId)) {
            itemMap.put(CostObjectEnum.BIZTYPE_RO.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_RO.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_CU.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_CU.getValue())));
        } else if ("eca".equals(appId)) {
            itemMap.put(CostObjectEnum.BIZTYPE_SW.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_SW.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_SP.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_SP.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_CU.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_CU.getValue())));
        } else {
            itemMap.put(CostObjectEnum.BIZTYPE_RO.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_RO.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_SO.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_SO.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_PZ.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_PZ.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_FL.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_FL.getValue())));
            itemMap.put(CostObjectEnum.BIZTYPE_CU.getValue(), new LocaleString(CostObjectEnum.getName(CostObjectEnum.BIZTYPE_CU.getValue())));
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(itemMap.size());
        for (Map.Entry entry : itemMap.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue((String)entry.getKey());
            item.setCaption((LocaleString)entry.getValue());
            comboItems.add(item);
        }
        return comboItems;
    }

    public static Set<Long> getCalDimensionIds(Long orgId, List<Long> enableCostCenters, Map<String, DynamicObject> objRules) {
        String key;
        HashSet<Long> calDimensionIds = new HashSet<Long>(16);
        HashMap<String, Set> orgCcsDimenMap = new HashMap<String, Set>(16);
        for (Map.Entry<String, DynamicObject> rule : objRules.entrySet()) {
            key = rule.getKey();
            String[] split = key.split("@");
            if (split.length == 3) {
                orgCcsDimenMap.computeIfAbsent(split[0], p -> new HashSet()).add(Long.parseLong(split[2]));
            }
            if (split.length != 4) continue;
            orgCcsDimenMap.computeIfAbsent(split[0].concat(split[1]), p -> new HashSet()).add(Long.parseLong(split[3]));
        }
        for (Long enableCostCenter : enableCostCenters) {
            key = String.valueOf(orgId).concat(String.valueOf(enableCostCenter));
            if (!orgCcsDimenMap.containsKey(key)) {
                key = String.valueOf(orgId);
            }
            if (orgCcsDimenMap.get(key) == null) continue;
            calDimensionIds.addAll((Collection)orgCcsDimenMap.get(key));
        }
        return calDimensionIds;
    }

    public static void updateCostObject(Set<String> centerObjs) {
        if (centerObjs == null || centerObjs.isEmpty()) {
            return;
        }
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(centerObjs.size());
        for (String centerObj : centerObjs) {
            String[] centerObjArray = org.apache.commons.lang3.StringUtils.split((String)centerObj, (String)"@");
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fcostcenterid", -5, (Object)centerObjArray[0]), new SqlParameter("fid", -5, (Object)centerObjArray[1])};
            paramsList.add(params);
        }
        String sql = "update t_cad_costobject set fcostcenterid=? where fid = ?";
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)sql, paramsList);
    }

    public static Map<Long, Boolean> getAssistAffectPriceMatMap(Set<Long> materialIds, Long orgId) {
        HashMap<Long, Boolean> assistAffectPriceMatMap = new HashMap<Long, Boolean>(10);
        Set<Long> affectPriceDs = CostObjectHelper.getAffectPriceDs(materialIds);
        if (!CadEmptyUtils.isEmpty(affectPriceDs)) {
            for (Long affectPriceD : affectPriceDs) {
                assistAffectPriceMatMap.put(affectPriceD, Boolean.TRUE);
            }
        }
        HashSet<Long> newMatIds = new HashSet<Long>(10);
        newMatIds.addAll(materialIds);
        newMatIds.removeAll(assistAffectPriceMatMap.keySet());
        if (CadEmptyUtils.isEmpty(newMatIds)) {
            return assistAffectPriceMatMap;
        }
        Map<Long, Boolean> assistMap = CostObjectHelper.getAssistMap(newMatIds, orgId);
        if (!CadEmptyUtils.isEmpty(assistMap)) {
            assistAffectPriceMatMap.putAll(assistMap);
        }
        return assistAffectPriceMatMap;
    }

    public static Set<Long> getAffectPriceDs(Set<Long> materialIdSet) {
        QFilter filter = new QFilter("id", "in", materialIdSet);
        filter.and("isuseauxpty", "=", (Object)Boolean.TRUE);
        filter.and("auxptyentry.isaffectprice", "=", (Object)Boolean.TRUE);
        DataSet ds = QueryServiceHelper.queryDataSet((String)"effectpricemat", (String)"bd_material", (String)"id as effectpricemat", (QFilter[])new QFilter[]{filter}, null).distinct();
        HashSet<Long> auxptyAffectPriceIds = new HashSet<Long>(10);
        for (Row row : ds) {
            auxptyAffectPriceIds.add(row.getLong("effectpricemat"));
        }
        return auxptyAffectPriceIds;
    }

    public static Map<Long, Boolean> getAssistMap(Set<Long> materialIds, Long orgId) {
        HashSet<Long> groupIds = new HashSet<Long>(10);
        QFilter matQf = new QFilter("id", "in", materialIds);
        DynamicObjectCollection groupIdDyn = QueryServiceHelper.query((String)"bd_material", (String)"group", (QFilter[])new QFilter[]{matQf});
        if (!CadEmptyUtils.isEmpty(groupIdDyn)) {
            groupIdDyn.forEach(p -> groupIds.add(p.getLong("group")));
        }
        return CostObjectHelper.getAssistMapByMatOrGroup(materialIds, groupIds, orgId);
    }

    public static Map<Long, Boolean> getAssistMapByMatOrGroup(Set<Long> materialIds, Set<Long> groupIds, Long orgId) {
        DynamicObjectCollection dimensionObjByGroup;
        HashMap<Long, Boolean> materialMap = new HashMap<Long, Boolean>(10);
        QFilter matQf = new QFilter("calorg", "=", (Object)orgId);
        if (!CadEmptyUtils.isEmpty(materialIds)) {
            matQf.and("entry.material", "in", materialIds);
            DynamicObjectCollection dimensionObjByMat = QueryServiceHelper.query((String)"cal_bd_materialdimension", (String)"entry.material material,entry.caldimension.caldimension caldimension", (QFilter[])new QFilter[]{matQf});
            if (!CadEmptyUtils.isEmpty(dimensionObjByMat)) {
                dimensionObjByMat.forEach(x -> {
                    String caldimension = x.getString("caldimension");
                    if (!CadEmptyUtils.isEmpty(caldimension)) {
                        materialMap.put(x.getLong("material"), caldimension.contains("assist"));
                    }
                });
            }
        }
        if (!CadEmptyUtils.isEmpty(groupIds) && !CadEmptyUtils.isEmpty(dimensionObjByGroup = QueryServiceHelper.query((String)"cal_bd_materialdimension", (String)"entry.material material,entry.caldimension.caldimension caldimension", (QFilter[])new QFilter[]{new QFilter("entry.material.group.id", "in", groupIds)}))) {
            dimensionObjByGroup.forEach(x -> {
                String caldimension = x.getString("caldimension");
                if (!CadEmptyUtils.isEmpty(caldimension) && !materialMap.containsKey(x.getLong("material"))) {
                    materialMap.put(x.getLong("material"), caldimension.contains("assist"));
                }
            });
        }
        return materialMap;
    }

    public static String[] getCostObjectName(DynamicObject costObject, String dimension) {
        StringBuilder sbNumber = new StringBuilder();
        StringBuilder sbName = new StringBuilder();
        DynamicObject costcenter = costObject.getDynamicObject("costcenter");
        if (costcenter == null) {
            return new String[]{sbNumber.toString(), sbName.toString()};
        }
        sbNumber.append(costcenter.getString("number"));
        sbName.append(costcenter.getString("name"));
        try {
            String[] dimensionStr;
            String[] stringArray = dimensionStr = dimension.split(",");
            int n = stringArray.length;
            block23: for (int i = 0; i < n; ++i) {
                String dim;
                switch (dim = stringArray[i]) {
                    case "YDDH": {
                        sbNumber.append("-").append(costObject.get("srcbillnumber") == null ? "null" : costObject.getString("srcbillnumber"));
                        sbName.append("-").append(costObject.get("srcbillnumber") == null ? "null" : costObject.getString("srcbillnumber"));
                        continue block23;
                    }
                    case "YDHH": {
                        sbNumber.append("-").append(costObject.get("srcbillrow") == null ? "null" : costObject.getString("srcbillrow"));
                        sbName.append("-").append(costObject.get("srcbillrow") == null ? "null" : costObject.getString("srcbillrow"));
                        continue block23;
                    }
                    case "CP": {
                        DynamicObject material = costObject.getDynamicObject("material");
                        if (material == null) continue block23;
                        sbNumber.append("-").append(material.getString("number"));
                        sbName.append("-").append(material.getString("name"));
                        continue block23;
                    }
                    case "CRN_XMH": 
                    case "XMH": {
                        DynamicObject projectnumber = costObject.getDynamicObject("projectnumber");
                        if (projectnumber == null) continue block23;
                        sbNumber.append("-").append(projectnumber.getString("number"));
                        sbName.append("-").append(projectnumber.getString("name"));
                        continue block23;
                    }
                    case "GZH": {
                        DynamicObject tracknumber = costObject.getDynamicObject("tracknumber");
                        if (tracknumber == null) continue block23;
                        sbNumber.append("-").append(tracknumber.getString("number"));
                        sbName.append("-").append(tracknumber.getString("number"));
                        continue block23;
                    }
                    case "PZH": {
                        DynamicObject configuredcode = costObject.getDynamicObject("configuredcode");
                        if (configuredcode == null) continue block23;
                        sbNumber.append("-").append(configuredcode.getString("number"));
                        sbName.append("-").append(configuredcode.getString("number"));
                        continue block23;
                    }
                    case "SCBH": {
                        sbNumber.append("-").append(costObject.getString("producenum"));
                        sbName.append("-").append(costObject.getString("producenum"));
                        continue block23;
                    }
                    case "PH": {
                        sbNumber.append("-").append(costObject.getString("lot"));
                        sbName.append("-").append(costObject.getString("lot"));
                        continue block23;
                    }
                    default: {
                        Object dyn;
                        if (CadEmptyUtils.isEmpty(dim) || (dyn = costObject.get(dim)) == null) continue block23;
                        String number = "";
                        String name = "";
                        if (dyn instanceof DynamicObject) {
                            DynamicObject dynObj = (DynamicObject)dyn;
                            if (dynObj.containsProperty("number")) {
                                number = dynObj.getString("number");
                            } else if (dynObj.containsProperty("billno")) {
                                number = dynObj.getString("billno");
                            }
                            name = dynObj.containsProperty("name") ? dynObj.getString("name") : number;
                        } else {
                            number = costObject.getString(dim);
                            name = costObject.getString(dim);
                        }
                        sbNumber.append("-").append(number);
                        sbName.append("-").append(name);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u751f\u6210\u6210\u672c\u5bf9\u8c61\u540d\u79f0\u5931\u8d25", (Throwable)ex);
        }
        return new String[]{sbNumber.toString(), sbName.toString()};
    }
}

