/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.EntityUtil;

public class CostRouterImportHelper {
    private static final Log logger = LogFactory.getLog(CostRouterImportHelper.class);
    private static final int LIST_INITIAL_CAPACITY = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> syncRoute(Long useOrgId, List<Long> manuOrgIds, String progressId) {
        String tip;
        logger.info("\u81ea\u52a8\u6267\u884c-\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u5f00\u59cb\u3002\u6838\u7b97\u7ec4\u7ec7\uff1a{}", (Object)useOrgId);
        HashMap<String, String> resultMsgMap = new HashMap<String, String>(16);
        try {
            if (CadEmptyUtils.isEmpty(useOrgId)) {
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"\u6570\u636e\u9884\u5904\u7406", (String)"CostRouterImportHelper_4", (String)"macc-cad-common", (Object[])new Object[0]), 1, 4, Boolean.FALSE, progressId);
            resultMsgMap.put("status", "success");
            resultMsgMap.put("qty", "0");
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            if (CadEmptyUtils.isEmpty(manuOrgIds)) {
                OrgRelationParam param = new OrgRelationParam();
                param.setFromViewType("10");
                param.setToViewType("04");
                param.setOrgId(useOrgId.longValue());
                param.setDirectViewType("toorg");
                param.setIncludeSelf(true);
                orgList.addAll(OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param));
            } else {
                orgList.addAll(manuOrgIds);
            }
            logger.info("\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\uff0c\u83b7\u53d6\u7684\u751f\u4ea7\u7ec4\u7ec7\uff1a{}", (Object)SerializationUtils.toJsonString(orgList));
            if (CollectionUtils.isEmpty(orgList)) {
                logger.info("\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u627e\u5230\u59d4\u6258\u65b9\u751f\u4ea7\u7ec4\u7ec7\uff0c\u9700\u8981\u4ece\u7cfb\u7edf\u4e91-\u57fa\u7840\u670d\u52a1-\u7ba1\u63a7\u7b56\u7565-\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7ef4\u62a4\u59d4\u6258\u53d7\u6258\u5173\u7cfb\u3002");
                tip = ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u672a\u627e\u5230\u59d4\u6258\u65b9\u751f\u4ea7\u7ec4\u7ec7\uff0c\u9700\u8981\u4ece\u201c\u7cfb\u7edf\u4e91>\u57fa\u7840\u670d\u52a1>\u7ba1\u63a7\u7b56\u7565>\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u201d\u7ef4\u62a4\u59d4\u6258\u53d7\u6258\u5173\u7cfb\u3002", (String)"CostRouterImportHelper_0", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip);
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            Long user = Long.valueOf(RequestContext.get().getUserId());
            QFilter userFilter = new QFilter("user", "=", (Object)user);
            QFilter saveTypeFilter = new QFilter("savetype", "=", (Object)"B");
            DynamicObject syncRuleMS = QueryServiceHelper.queryOne((String)"cad_syncrulesave", (String)"isincrementsync,islatestaudittime,ismainprocroute,processtype,matfilter_tag", (QFilter[])new QFilter[]{userFilter, saveTypeFilter});
            if (syncRuleMS == null) {
                logger.info("\u672a\u8bbe\u7f6e\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u89c4\u5219\uff0c\u8bf7\u70b9\u51fb\u6309\u94ae\uff1a\u66f4\u591a-\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u89c4\u5219\u6765\u8bbe\u7f6e\u3002");
                String tip2 = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u89c4\u5219\uff0c\u8bf7\u5148\u5728\u201c\u66f4\u591a>\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u89c4\u5219\u201d\u4e2d\u8bbe\u7f6e\u540e\u518d\u8fdb\u884c\u540c\u6b65\u3002", (String)"CostRouterImportHelper_1", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip2);
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"\u83b7\u53d6\u9700\u8981\u540c\u6b65\u7684\u5236\u9020\u5de5\u827a\u8def\u7ebf", (String)"CostRouterImportHelper_5", (String)"macc-cad-common", (Object[])new Object[0]), 2, 4, Boolean.FALSE, progressId);
            List<QFilter> qFilters = CostRouterImportHelper.getQFiltersBySyncRule(orgList, syncRuleMS);
            Boolean isLatestAuditTime = syncRuleMS.getBoolean("islatestaudittime");
            Boolean isIncrementSync = syncRuleMS.getBoolean("isincrementsync");
            List<Long> routeIds = CostRouterImportHelper.getRouteIds(qFilters, isLatestAuditTime);
            Map<String, Date> existCadRoute = CostRouterImportHelper.getCadRoute(manuOrgIds);
            HashSet needSyncRouteIds = new HashSet(10);
            Lists.partition(routeIds, (int)10000).forEach(routeList -> {
                QFilter filter = new QFilter("id", "in", routeList);
                DynamicObject[] routes = BusinessDataServiceHelper.load((String)"pdm_route", (String)"id,number,audittime", (QFilter[])new QFilter[]{filter});
                needSyncRouteIds.addAll(CostRouterImportHelper.getToSyncIds(routes, existCadRoute, isIncrementSync));
            });
            logger.info("\u9700\u8981\u540c\u6b65\u7684\u5236\u9020\u5de5\u827a\u8def\u7ebf\u4e2a\u6570\uff1a{}", (Object)needSyncRouteIds.size());
            if (CadEmptyUtils.isEmpty(needSyncRouteIds)) {
                String tip3 = ResManager.loadKDString((String)"\u5df2\u7ecf\u540c\u6b65\u5230\u6700\u65b0\u4e86\u3002", (String)"CostRouterImportHelper_2", (String)"macc-cad-common", (Object[])new Object[0]);
                resultMsgMap.put("tip", tip3);
                HashMap<String, String> hashMap = resultMsgMap;
                return hashMap;
            }
            int index = 1;
            OperationResult msgResult = null;
            ArrayList successPkIds = new ArrayList(200);
            int syncRouteBatchSize = CadBgParamUtils.getCadParamForInt("syncRouteBatchSize", 5000);
            for (List routeIdSubList : Lists.partition(new ArrayList(needSyncRouteIds), (int)syncRouteBatchSize)) {
                ProgressHelper.refreshProgress(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6279\u5236\u9020\u5de5\u827a\u8def\u7ebf\u6b63\u5728\u540c\u6b65", (String)"CostRouterImportHelper_6", (String)"macc-cad-common", (Object[])new Object[0]), index), 1, 0, Boolean.TRUE, progressId);
                List<DynamicObject> res = CostRouterImportHelper.syncPdmProcessRoute(routeIdSubList, useOrgId);
                OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"cad_router", (DynamicObject[])res.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (!CadEmptyUtils.isEmpty(operateResult.getSuccessPkIds())) {
                    successPkIds.addAll(operateResult.getSuccessPkIds());
                }
                if (!operateResult.isSuccess()) {
                    if (msgResult == null) {
                        msgResult = operateResult;
                    } else {
                        msgResult.mergeOperateResult(operateResult);
                    }
                }
                ++index;
            }
            if (msgResult != null) {
                resultMsgMap.put("msg", SerializationUtils.toJsonString(msgResult));
            } else {
                logger.info("\u540c\u6b65\u5b8c\u6210\uff0c\u5df2\u6210\u529f\u540c\u6b65%s\u6761\u6570\u636e\u3002");
                String tip4 = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5b8c\u6210\uff0c\u5df2\u6210\u529f\u540c\u6b65%s\u6761\u6570\u636e\u3002", (String)"CostRouterImportHelper_3", (String)"macc-cad-common", (Object[])new Object[0]), successPkIds.size());
                resultMsgMap.put("tip", tip4);
            }
            resultMsgMap.put("qty", String.valueOf(successPkIds.size()));
        }
        catch (Exception ex) {
            logger.error("\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u62a5\u9519\u3002", (Throwable)ex);
            tip = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5236\u9020\u5de5\u827a\u8def\u7ebf\u62a5\u9519\uff1a%s", (String)"CostRouterImportHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), ex.toString());
            resultMsgMap.put("status", "fail");
            resultMsgMap.put("tip", tip);
        }
        finally {
            ProgressHelper.refreshProgress(ResManager.loadKDString((String)"", (String)"CostRouterImportHelper_8", (String)"macc-cad-common", (Object[])new Object[0]), -1, 0, Boolean.FALSE, progressId);
        }
        return resultMsgMap;
    }

    private static List<Long> getRouteIds(List<QFilter> qFilters, Boolean isLatestAuditTime) {
        ArrayList<Long> routeIds = new ArrayList<Long>(10);
        if (isLatestAuditTime.booleanValue()) {
            DataSet results = QueryServiceHelper.queryDataSet((String)"getRouteIds#1", (String)"pdm_route", (String)"id,material,auxproperty,materialgroup,processtype,group,createorg,audittime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"audittime DESC");
            ArrayList<String> existMatKey = new ArrayList<String>(10);
            while (results.hasNext()) {
                Row row = results.next();
                if (row == null) continue;
                Long createOrg = row.getLong("createorg");
                Long material = row.getLong("material");
                Long auxproperty = row.getLong("auxproperty");
                Long materialGroup = row.getLong("materialgroup");
                Long group = row.getLong("group");
                String processType = row.getString("processtype");
                String key = createOrg + "@" + material + "@" + auxproperty + "@" + materialGroup + "@" + group + "@" + processType;
                if (existMatKey.contains(key)) continue;
                routeIds.add(row.getLong("id"));
                existMatKey.add(key);
            }
        } else {
            DataSet results = QueryServiceHelper.queryDataSet((String)"getRouteIds#2", (String)"pdm_route", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), null);
            while (results.hasNext()) {
                Row row = results.next();
                if (row == null) continue;
                routeIds.add(row.getLong("id"));
            }
        }
        return routeIds;
    }

    private static List<DynamicObject> syncPdmProcessRoute(List<Long> routeIds, Long createOrg) {
        ArrayList<DynamicObject> cadrouters = new ArrayList<DynamicObject>(10);
        Object[] processroutes = BusinessDataServiceHelper.load((Object[])routeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pdm_route"));
        if (CadEmptyUtils.isEmpty(processroutes)) {
            return cadrouters;
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter auxptFilter = new QFilter("isuseauxpty", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid as masterId", (QFilter[])new QFilter[]{statusFilter, enableFilter, auxptFilter});
        HashSet<Long> matWithAuxpt = new HashSet<Long>(10);
        for (DynamicObject material : materials) {
            matWithAuxpt.add(material.getLong("masterId"));
        }
        logger.info("\u540c\u6b65\u5236\u9020\u5236\u9020\u5de5\u827a\u8def\u7ebf-\u67e5\u627e\u542f\u7528\u8f85\u52a9\u5c5e\u6027\u7684\u7269\u6599\uff0c\u4e2a\u6570{}", (Object)matWithAuxpt.size());
        for (Object processroute : processroutes) {
            DynamicObject cadrouter = BusinessDataServiceHelper.newDynamicObject((String)"cad_router");
            EntityUtil.copyPropertiesWithOutId(cadrouter, (DynamicObject)processroute);
            CostRouterImportHelper.fillBaseInfo(createOrg, cadrouter, (DynamicObject)processroute, matWithAuxpt);
            DynamicObjectCollection processentry = processroute.getDynamicObjectCollection("processentry");
            DynamicObjectCollection cadroutprocessentry = cadrouter.getDynamicObjectCollection("processentry");
            if (processentry != null && processentry.size() > 0) {
                for (int i = 0; i < processentry.size(); ++i) {
                    DynamicObjectCollection actentryentity = ((DynamicObject)processentry.get(i)).getDynamicObjectCollection("actentryentity");
                    DynamicObjectCollection cadroutentity = ((DynamicObject)cadroutprocessentry.get(i)).getDynamicObjectCollection("actentryentity");
                    if (actentryentity == null || actentryentity.size() < 1) continue;
                    for (int j = 0; j < actentryentity.size(); ++j) {
                        DynamicObject activity = ((DynamicObject)actentryentity.get(j)).getDynamicObject("activity");
                        if (activity == null) continue;
                        ((DynamicObject)cadroutentity.get(j)).set("processstage", activity.get("processstage"));
                    }
                }
            }
            cadrouters.add(cadrouter);
        }
        return cadrouters;
    }

    private static List<Long> getToSyncIds(DynamicObject[] routes, Map<String, Date> existCadRoute, Boolean isIncrementSync) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (CadEmptyUtils.isEmpty(routes)) {
            return ids;
        }
        Set<String> existNumbers = existCadRoute.keySet();
        if (isIncrementSync.booleanValue()) {
            for (DynamicObject route : routes) {
                String number = route.getString("number");
                if (existNumbers.contains(number)) continue;
                ids.add(route.getLong("id"));
            }
        } else {
            for (DynamicObject route : routes) {
                String number = route.getString("number");
                if (!existNumbers.contains(number)) {
                    ids.add(route.getLong("id"));
                    continue;
                }
                Date auditTime = route.getDate("audittime");
                Date syncTime = existCadRoute.get(number);
                if (auditTime == null || auditTime.equals(syncTime)) continue;
                ids.add(route.getLong("id"));
            }
        }
        return ids;
    }

    private static Map<String, Date> getCadRoute(List<Long> manuOrgs) {
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        QFilter[] qFilters = new QFilter[]{};
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            qFilters = new QFilter[]{new QFilter("manuorg", "in", manuOrgs)};
        }
        DynamicObjectCollection results = QueryServiceHelper.query((String)"cad_router", (String)"number,synctime", (QFilter[])qFilters, (String)"synctime DESC");
        for (DynamicObject result : results) {
            String number = result.getString("number");
            if (map.containsKey(number)) continue;
            map.put(number, result.getDate("synctime"));
        }
        return map;
    }

    private static void fillBaseInfo(Long createOrg, DynamicObject cadrouter, DynamicObject processRoute, Set<Long> matWithAuxpt) {
        DynamicObject bomversion;
        cadrouter.set("status", (Object)"C");
        cadrouter.set("creator", (Object)RequestContext.getOrCreate().getUserId());
        cadrouter.set("creator_id", (Object)RequestContext.getOrCreate().getUserId());
        cadrouter.set("createtime", (Object)new Date());
        cadrouter.set("auditor", (Object)RequestContext.getOrCreate().getUserId());
        cadrouter.set("auditor_id", (Object)RequestContext.getOrCreate().getUserId());
        cadrouter.set("audittime", (Object)new Date());
        cadrouter.set("synctime", (Object)processRoute.getDate("audittime"));
        cadrouter.set("sourceid", (Object)processRoute.getLong("id"));
        if (processRoute.getDate("audittime") != null) {
            cadrouter.set("synctimestamp", (Object)processRoute.getDate("audittime").getTime());
        }
        if ((bomversion = processRoute.getDynamicObject("bomversion")) != null) {
            String number = bomversion.getString("number");
            DynamicObject[] costbomData = BusinessDataServiceHelper.load((String)"cad_costbom", (String)"id,synctime", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
            DynamicObject recentId = null;
            Date recentDate = null;
            for (DynamicObject costbomDatum : costbomData) {
                Date synctime = costbomDatum.getDate("synctime");
                if (synctime == null) continue;
                if (recentDate == null) {
                    recentDate = synctime;
                    recentId = costbomDatum;
                    continue;
                }
                if (recentDate.compareTo(synctime) >= 0) continue;
                recentDate = synctime;
                recentId = costbomDatum;
            }
            cadrouter.set("bomversion", recentId);
        }
        cadrouter.set("ctrlstrategy", (Object)BaseDataServiceHelper.getBdCtrlStrgy((String)"cad_router", (String)String.valueOf(createOrg)));
        DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        org.set("id", (Object)createOrg);
        cadrouter.set("createorg", (Object)org);
        cadrouter.set("manuorg", processRoute.get("createorg"));
        if (cadrouter.getDynamicObject("material") != null) {
            Object materialId = cadrouter.getDynamicObject("material").getPkValue();
            DynamicObject material = BusinessDataServiceHelper.loadSingle((Object)materialId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_material"));
            cadrouter.set("material", (Object)material);
            if (matWithAuxpt.contains(material.getLong("masterid")) && (processRoute.getDynamicObject("auxproperty") == null || processRoute.getDynamicObject("auxproperty").getLong("id") == 0L)) {
                cadrouter.set("status", (Object)"A");
                cadrouter.set("auditor", (Object)0L);
                cadrouter.set("auditor_id", (Object)0L);
                cadrouter.set("audittime", null);
            }
            cadrouter.set("auxproperty", (Object)CalcDimenHelper.getAffectAuxpty(cadrouter.get("material"), cadrouter.get("auxproperty")));
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", cadrouter.get("material.masterid"));
            keycolMap.put("auxproperty", cadrouter.get("auxproperty"));
            cadrouter.set("keycol", (Object)CalcKeyHelper.getCalcKey(keycolMap, new ArrayList<String>(), true).getKeycol());
        }
    }

    private static List<QFilter> getQFiltersBySyncRule(List<Long> productOrgs, DynamicObject syncRuleMS) {
        Boolean isMainProcRoute = syncRuleMS.getBoolean("ismainprocroute");
        String processType = syncRuleMS.getString("processtype");
        String matFilterStr = syncRuleMS.getString("matfilter_tag");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("createorg", "in", productOrgs));
        qFilters.add(new QFilter("processtype", "=", (Object)processType));
        qFilters.add(new QFilter("ismainprocess", "=", (Object)isMainProcRoute));
        qFilters.add(new QFilter("status", "=", (Object)Character.valueOf('C')));
        qFilters.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
        if (!CadEmptyUtils.isEmpty(matFilterStr)) {
            QFilter matFilter = CostRouterImportHelper.getMatQfilter((FilterCondition)SerializationUtils.fromJsonString((String)matFilterStr, FilterCondition.class));
            qFilters.add(matFilter);
        }
        QFilter matTypeFilter = new QFilter("material.configproperties", "!=", (Object)"2");
        qFilters.add(matTypeFilter);
        return qFilters;
    }

    private static QFilter getMatQfilter(FilterCondition filterCondition) {
        QFilter qFilter = null;
        if (filterCondition != null) {
            MainEntityType bizEntityType = MetadataServiceHelper.getDataEntityType((String)"bd_material");
            FilterBuilder filterBuilder = new FilterBuilder(bizEntityType, filterCondition);
            filterBuilder.buildFilter();
            QFilter matFilter = filterBuilder.getQFilter();
            if (matFilter != null) {
                DataSet matDataSet = QueryServiceHelper.queryDataSet((String)"getMatQfilter", (String)"bd_material", (String)"id", (QFilter[])new QFilter[]{matFilter}, null);
                HashSet<Long> matIds = null;
                while (matDataSet.hasNext()) {
                    Row row = matDataSet.next();
                    if (matIds == null) {
                        matIds = new HashSet<Long>(200);
                    }
                    matIds.add(row.getLong("id"));
                    if (matIds.size() < 200000) continue;
                    qFilter = qFilter == null ? new QFilter("material.masterid", "in", matIds) : qFilter.or(new QFilter("material.masterid", "in", matIds));
                    matIds = null;
                }
                if (!CadEmptyUtils.isEmpty(matIds)) {
                    qFilter = qFilter == null ? new QFilter("material.masterid", "in", matIds) : qFilter.or(new QFilter("material.masterid", "in", matIds));
                } else if (qFilter == null) {
                    qFilter = new QFilter("material.masterid", "=", (Object)-1L);
                }
            }
        }
        return qFilter;
    }
}

