/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class CostTypeHelper {
    private static final int batSize = 10000;
    private static final Log logger = LogFactory.getLog(CostTypeHelper.class);

    public static DynamicObject[] getCostTypes() {
        return CostTypeHelper.getCostTypesBy("0");
    }

    public static DynamicObject[] getCostTypesBy(String type) {
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            qfilters.add(new QFilter("type", "=", (Object)type));
        }
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        HasPermOrgResult permOrgList = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.getOrCreate().getUserId()));
        List<Long> orgs = OrgHelper.getOrgRangBy(permOrgList.getHasPermOrgs(), "5");
        if (!CadEmptyUtils.isEmpty(orgs)) {
            qfilters.add(new QFilter("createorg", "in", orgs));
        }
        DynamicObject[] costTypes = BusinessDataServiceHelper.load((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        return costTypes;
    }

    public static QFilter getCtrlBaseDataFilter() {
        Long currAcctOrg = RequestContext.getOrCreate().getOrgId();
        return BaseDataServiceHelper.getBaseDataFilter((String)"cad_costtype", (Long)currAcctOrg);
    }

    public static DynamicObject getCostTypesById(Long costTypeId) {
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(new QFilter("id", "=", (Object)costTypeId));
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        return costType;
    }

    public static DynamicObject[] getCostType(int type) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        if (type != -1) {
            qfilters.add(new QFilter("type", "=", (Object)String.valueOf(type)));
        }
        qfilters.add(CostTypeHelper.getScaCostType());
        qfilters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        return BusinessDataServiceHelper.load((String)"cad_costtype", (String)"number,name,id", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"type asc");
    }

    public static DynamicObject[] getCostType(IFormView view) {
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        qfilters.add(CostTypeHelper.getCostTypeByAppNum(view));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        return BusinessDataServiceHelper.load((String)"cad_costtype", (String)"number,name,id", (QFilter[])qfilters.toArray(new QFilter[0]), (String)"type asc");
    }

    public static QFilter getCostTypeByAppNum(IFormView view) {
        String appNum = AppIdHelper.getCurAppNum(view);
        if ("aca".equals(appNum)) {
            return new QFilter("type", "=", (Object)"1");
        }
        QFilter scaQFilter = new QFilter("type", "in", (Object)new String[]{"0", "1"});
        return scaQFilter.and(CostTypeHelper.getScaCostType());
    }

    public static void sortByType(List<DynamicObject> costTypeList) {
        Collections.sort(costTypeList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                return o2.getInt("type") - o1.getInt("type");
            }
        });
    }

    public static DynamicObject getCostType(Long costTypeId, String queryFields) {
        String qFields = "id,number,name,status,enable,createtime,masterid,ctrlstrategy,type,isupdate,issystem,currency,elementtype";
        if (queryFields != null) {
            qFields = queryFields;
        }
        QFilter filter = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject costType = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costtype", (String)qFields, (QFilter[])new QFilter[]{filter});
        return costType;
    }

    public static int getPriceprecision(Long costTypeId) {
        DynamicObject costType = CostTypeHelper.getCostType(costTypeId, "id,currency.priceprecision");
        if (costType == null) {
            return 6;
        }
        return costType.getInt("currency.priceprecision");
    }

    public static boolean isUseMatVersion(Long costTypeId) {
        DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"isuseversion", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)costTypeId)});
        if (costType == null) {
            return true;
        }
        return !costType.getBoolean("isuseversion");
    }

    public static List<Long> getCalcOrgByCostType(Long costTypeId) {
        QFilter costtypeFilter = new QFilter("id", "=", (Object)costTypeId);
        DynamicObjectCollection costtypes = QueryServiceHelper.query((String)"cad_costtype", (String)"masterid,createorg.masterid,ctrlstrategy", (QFilter[])new QFilter[]{costtypeFilter});
        if (costtypes == null || costtypes.size() < 1) {
            return null;
        }
        DynamicObject costtype = (DynamicObject)costtypes.get(0);
        Long orgId = costtype.getLong("createorg.masterid");
        String strategy = costtype.getString("ctrlstrategy");
        List<Long> orgs = ElementRelationHelper.getOrgRangBy(Collections.singletonList(orgId), strategy);
        return orgs;
    }

    public static QFilter getCurrUserUsableCostTypeFilter() {
        DynamicObject[] costType = CostTypeHelper.getCostType(-1);
        if (costType != null && costType.length > 0) {
            List list = Arrays.stream(costType).map(e -> e.getLong("id")).collect(Collectors.toList());
            return new QFilter("id", "in", list);
        }
        return new QFilter("id", "=", (Object)-1);
    }

    public static Set<Long> getMaterialByCostType(Long costTypeId) {
        HashSet<Long> mats = new HashSet<Long>();
        QFilter costtypeFilter = new QFilter("id", "=", (Object)costTypeId);
        DynamicObject costType = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costtype", (String)"masterid,createorg.masterid,ctrlstrategy", (QFilter[])new QFilter[]{costtypeFilter});
        if (costType == null) {
            return mats;
        }
        Long orgId = costType.getLong("createorg.masterid");
        String strategy = costType.getString("ctrlstrategy");
        List<Long> orgs = ElementRelationHelper.getOrgRangBy(Collections.singletonList(orgId), strategy);
        if (orgs == null || orgs.size() < 1) {
            return mats;
        }
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u7684\u7269\u6599\uff0c\u7ec4\u7ec7\u6570\u91cf\uff1a" + orgs.size() + "\u63a7\u5236\u7b56\u7565\uff1a" + strategy);
        if ("5".equals(strategy)) {
            QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)true)};
            List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])filters, null, (int)-1);
            Lists.partition((List)primaryKeys, (int)10000).forEach(list -> mats.addAll(CostTypeHelper.getMasterId("bd_material", list)));
        } else {
            for (Long org : orgs) {
                QFilter qfMat = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)org);
                Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"masterid", (QFilter[])new QFilter[]{qfMat});
                materials.values().forEach(p -> mats.add(p.getLong("masterid")));
            }
        }
        logger.info("\u83b7\u53d6\u7ec4\u7ec7\u7684\u7269\u6599-\u7ed3\u675f");
        return mats;
    }

    public static List<QFilter> getMatFiltersByCostType(DynamicObject costType) {
        Long orgId;
        QFilter matOrgFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        if (costType != null && (matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)(orgId = Long.valueOf(costType.getLong("createorg.id"))))) != null) {
            filters.add(matOrgFilter);
        }
        return filters;
    }

    private static Set<Long> getMasterId(String entityName, List<Object> ids) {
        HashSet<Long> mats = new HashSet<Long>(10);
        String algoKey = "kd.macc.cad.common.helper.CostTypeHelper.getMasterId";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DataSet data = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)"masterid", (QFilter[])filters, null);
        for (Row row : data) {
            mats.add(row.getLong("masterid"));
        }
        DataSetUtils.colse(data);
        return mats;
    }

    public static QFilter getScaCostType() {
        return new QFilter("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
    }

    public static Set<Long> getCostTypeIdByManuOrgIdFromCal(Long costAccountId, Long calOrgId, Long manuOrgId, Set<Long> invOrgs) {
        HashSet<Long> costTypes = new HashSet<Long>(16);
        if (costAccountId == null) {
            return costTypes;
        }
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costAccountId);
        Date now = TimeServiceHelper.now();
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("bizstatus", "=", (Object)Character.valueOf('1'));
        filter.and("effectdate", "<=", (Object)now);
        filter.and("invaliddate", ">", (Object)now);
        if (isMulFactory && manuOrgId != null && manuOrgId > 0L) {
            if (!CadEmptyUtils.isEmpty(invOrgs)) {
                logger.info("\u627e\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u4e0a\u7684\u5e93\u5b58\u7ec4\u7ec7\uff0c\u901a\u8fc7\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u7684\u5165\u5e93\u5e93\u5b58\u7ec4\u7ec7\u67e5\u8be2\u6210\u672c\u7c7b\u578b");
                filter.and("storageorgunit", "in", invOrgs);
            } else {
                logger.info("\u672a\u627e\u5230\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u4e0a\u7684\u5165\u5e93\u5e93\u5b58\u7ec4\u7ec7\uff0c\u901a\u8fc7\u534f\u4f5c\u5173\u7cfb\u67e5\u8be2\u5e93\u5b58\u7ec4\u7ec7");
                List invList = OrgUnitServiceHelper.getAllToOrg((String)"04", (String)"05", (Long)manuOrgId, (boolean)true);
                if (invList != null && invList.size() > 0) {
                    filter.and("storageorgunit", "=", invList.get(0));
                }
            }
        } else {
            filter.and("calorg", "=", (Object)calOrgId);
        }
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filter.toArray());
        if (dos != null && dos.length > 0) {
            for (DynamicObject aDo : dos) {
                long costTypeId = aDo.getLong("costtype.id");
                if (CadEmptyUtils.isEmpty(costTypeId)) continue;
                costTypes.add(costTypeId);
            }
        }
        if (CadEmptyUtils.isEmpty(costTypes)) {
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"costtype");
            DynamicObject costType = costAccount.getDynamicObject("costtype");
            if (costType == null) {
                return null;
            }
            costTypes.add((Long)costType.getPkValue());
        }
        return costTypes;
    }

    public static Long getCostTypeIdByManuOrgIdFromCal(Long costAccountId, Long calOrgId, Long manuOrgId) {
        if (costAccountId == null) {
            return null;
        }
        boolean isMulFactory = CostAccountHelper.isEnableMulFactory(costAccountId);
        Long costTypeId = null;
        Date now = TimeServiceHelper.now();
        QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
        filter.and("bizstatus", "=", (Object)Character.valueOf('1'));
        filter.and("effectdate", "<=", (Object)now);
        filter.and("invaliddate", ">", (Object)now);
        if (isMulFactory && manuOrgId != null && manuOrgId > 0L) {
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(manuOrgId.longValue());
            param.setFromViewType("04");
            param.setToViewType("05");
            param.setDirectViewType("toorg");
            param.setIncludeSelf(true);
            List invList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            if (invList != null && invList.size() > 0) {
                filter.and("storageorgunit", "in", (Object)invList);
                DynamicObject[] costTypeOrgs = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"storageorgunit,costtype", (QFilter[])filter.toArray());
                if (costTypeOrgs != null && costTypeOrgs.length > 0) {
                    for (DynamicObject costTypeOrg : costTypeOrgs) {
                        long storageId = costTypeOrg.getLong("storageorgunit.id");
                        long storedCostTypeId = costTypeOrg.getLong("costtype.id");
                        costTypeId = storedCostTypeId;
                        if (storageId != manuOrgId) continue;
                        costTypeId = storedCostTypeId;
                        break;
                    }
                }
            }
        } else {
            filter.and("calorg", "=", (Object)calOrgId);
            DynamicObject[] dos = BusinessDataServiceHelper.load((String)"cal_bd_costtypeorg", (String)"costtype", (QFilter[])filter.toArray());
            if (dos != null && dos.length > 0) {
                costTypeId = dos[0].getLong("costtype.id");
            }
        }
        if (costTypeId == null) {
            DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"costtype");
            DynamicObject costType = costAccount.getDynamicObject("costtype");
            if (costType == null) {
                return null;
            }
            return (Long)costType.getPkValue();
        }
        return costTypeId;
    }

    public static Long getCostTypeIdByCostAccountIdFromCal(Long costAccountId) {
        if (costAccountId == null) {
            return null;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costAccountId, (String)"cal_bd_costaccount", (String)"costtype");
        DynamicObject costType = costAccount.getDynamicObject("costtype");
        if (costType == null) {
            return null;
        }
        return (Long)costType.getPkValue();
    }

    public static Set<Long> getCostAcctIdSetFromCostType(Set<Long> costTypeIds) {
        HashSet<Long> accountIds = new HashSet<Long>(16);
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">=", (Object)date)};
        DynamicObjectCollection costTypeOrg = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"costaccount.id costaccount", (QFilter[])filters);
        costTypeOrg.forEach(p -> accountIds.add(p.getLong("costaccount")));
        return accountIds;
    }

    public static Boolean costAccountIsExistMult(List<Object> costTypeIds) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">=", (Object)date)};
        DynamicObjectCollection costTypeOrg = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg", (QFilter[])filters);
        HashSet orgIds = new HashSet(16);
        costTypeOrg.forEach(p -> orgIds.add(p.getLong("calorg")));
        HashSet<Boolean> multifactoryaccount = new HashSet<Boolean>(2);
        for (Long orgId : orgIds) {
            multifactoryaccount.add(false);
            if (multifactoryaccount.size() != 2) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Boolean isMultFactoryByCostType(Set<Long> costTypeIds) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeIds), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrg = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg", (QFilter[])filters);
        HashSet orgIds = new HashSet(16);
        costTypeOrg.forEach(p -> orgIds.add(p.getLong("calorg")));
        for (Long orgId : orgIds) {
            if (!OrgHelper.isOrgEnableMultiFactory(orgId)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static Long getCostTypeByOrgAndCostAccount(Long orgId, Long costAccountId, boolean isMulFactory) {
        String selectFields = null;
        Date date = TimeServiceHelper.now();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(new QFilter("costaccount", "=", (Object)costAccountId));
        filters.add(new QFilter("bizstatus", "=", (Object)"1"));
        filters.add(new QFilter("effectdate", "<=", (Object)date));
        filters.add(new QFilter("invaliddate", ">=", (Object)date));
        if (isMulFactory) {
            selectFields = "storageorgunit invorg,costaccount,costtype";
            filters.add(new QFilter("storageorgunit", "=", (Object)orgId));
        } else {
            selectFields = "calorg org,costaccount,costtype";
            filters.add(new QFilter("calorg", "=", (Object)orgId));
        }
        DynamicObject costTypeDataSet = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costtypeorg", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]));
        if (costTypeDataSet == null) {
            return 0L;
        }
        return costTypeDataSet.getDynamicObject("costtype").getLong("id");
    }

    public static List<Long> getCostTypeIdsByOrg(long orgId) {
        ArrayList<Long> costTypeIdSet = new ArrayList<Long>();
        if (CadEmptyUtils.isEmpty(orgId)) {
            costTypeIdSet.add(-1L);
            return costTypeIdSet;
        }
        QFilter[] filters = new QFilter[]{new QFilter("createorg", "=", (Object)orgId), new QFilter("type", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1"), new QFilter("status", "=", (Object)"C")};
        DynamicObjectCollection costTypeIds = QueryServiceHelper.query((String)"cad_costtype", (String)"id", (QFilter[])filters);
        if (!CadEmptyUtils.isEmpty(costTypeIds)) {
            for (DynamicObject dynamicObject : costTypeIds) {
                costTypeIdSet.add(dynamicObject.getLong("id"));
            }
        } else {
            costTypeIdSet.add(-1L);
        }
        return costTypeIdSet;
    }

    public static List<Long> getHsCostByMn(Long costType) {
        ArrayList<Long> list = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "=", (Object)costType);
        filter.and("type", "=", (Object)"1");
        filter.and("enable", "=", (Object)true);
        filter.and("costtypeentry.costtypeattr", "=", (Object)"0");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            list.add(dynamicObject.getLong("costtype"));
        }
        return list;
    }

    public static List<Long> getMnCostByHs(Long costType) {
        ArrayList<Long> list = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "=", (Object)costType);
        filter.and("type", "=", (Object)"0");
        filter.and("enable", "=", (Object)true);
        filter.and("costtypeentry.costtypeattr", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            list.add(dynamicObject.getLong("costtype"));
        }
        return list;
    }

    public static List<Long> getMnCostByHs(List<Long> costTypeIds) {
        ArrayList<Long> list = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "in", costTypeIds);
        filter.and("type", "=", (Object)"0");
        filter.and("enable", "=", (Object)true);
        filter.and("costtypeentry.costtypeattr", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            list.add(dynamicObject.getLong("costtype"));
        }
        return list;
    }

    public static List<Long> getOrgByCostType(Long costType) {
        Long orgId;
        DynamicObject costTypeDyn;
        HashSet<Long> ids = new HashSet<Long>(10);
        List<Long> costTypes = CostTypeHelper.getHsCostByMn(costType);
        if (!costTypes.isEmpty()) {
            Date date = new Date();
            QFilter filter = new QFilter("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)date);
            filter.and("invaliddate", ">", (Object)date);
            filter.and("costtype", "in", costTypes);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg", (QFilter[])new QFilter[]{filter});
            for (DynamicObject dynamicObject : dynamicObjects) {
                long org = dynamicObject.getLong("calorg");
                ids.add(org);
            }
        }
        if (ids.isEmpty() && (costTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)costType, (String)"cad_costtype")) != null && !CadEmptyUtils.isEmpty(orgId = Long.valueOf(costTypeDyn.getLong("createorg.id")))) {
            ids.add(orgId);
        }
        return new ArrayList<Long>(ids);
    }

    public static Set<Long> getOrgByCostType(Long costType, Boolean isSim) {
        HashSet<Long> ids = new HashSet<Long>(10);
        List<Object> costTypes = new ArrayList<Long>(10);
        if (!isSim.booleanValue()) {
            costTypes.add(costType);
        } else {
            costTypes = CostTypeHelper.getHsCostByMn(costType);
        }
        if (!costTypes.isEmpty()) {
            long org;
            Date date = new Date();
            QFilter filter = new QFilter("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)date);
            filter.and("invaliddate", ">", (Object)date);
            filter.and("costtype", "in", costTypes);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,storageorgunit", (QFilter[])new QFilter[]{filter});
            HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>(16);
            for (DynamicObject result : dynamicObjects) {
                org = result.getLong("calorg");
                if (orgMap.containsKey(org)) continue;
                boolean enableFactory = OrgHelper.isOrgEnableMultiFactory(org);
                orgMap.put(org, enableFactory);
            }
            for (DynamicObject result : dynamicObjects) {
                org = result.getLong("calorg");
                if (orgMap.containsKey(org) && ((Boolean)orgMap.get(org)).booleanValue()) {
                    ids.add(result.getLong("storageorgunit"));
                    continue;
                }
                OrgRelationParam param = new OrgRelationParam();
                param.setOrgId(org);
                param.setToViewType("04");
                param.setFromViewType("10");
                param.setDirectViewType("toorg");
                param.setIncludeSelf(true);
                List bizRelationOrgIds = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                if (CadEmptyUtils.isEmpty(bizRelationOrgIds)) continue;
                ids.addAll(bizRelationOrgIds);
            }
        }
        return ids;
    }

    public static Map<Long, Long> getMnHsCostMapByMn(List<Long> costTypes) {
        HashMap<Long, Long> mnHsCostMap = new HashMap<Long, Long>();
        QFilter filter = new QFilter("id", "in", costTypes);
        filter.and("type", "=", (Object)"1");
        filter.and("enable", "=", (Object)true);
        filter.and("costtypeentry.costtypeattr", "=", (Object)"0");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"id,costtypeentry.costtype as costtype", (QFilter[])new QFilter[]{filter});
        for (DynamicObject dynamicObject : dynamicObjects) {
            long mnCostType = dynamicObject.getLong("id");
            long hsCostType = dynamicObject.getLong("costtype");
            if (mnHsCostMap.containsKey(mnCostType)) continue;
            mnHsCostMap.put(mnCostType, hsCostType);
        }
        return mnHsCostMap;
    }

    public static Map<Long, Long> getHsCostTypeByOrg(Long orgId, Set<Long> manuOrgIds) {
        HashMap<Long, Long> manuOrgCostTypeMap = new HashMap<Long, Long>(16);
        boolean enableFactory = OrgHelper.isOrgEnableMultiFactory(orgId);
        for (Long manuOrgId : manuOrgIds) {
            QFilter filter = new QFilter("costtype.type", "=", (Object)"0");
            filter.and("bizstatus", "=", (Object)"1");
            filter.and("effectdate", "<=", (Object)new Date());
            filter.and("invaliddate", ">", (Object)new Date());
            if (enableFactory) {
                OrgRelationParam param = new OrgRelationParam();
                param.setFromViewType("04");
                param.setToViewType("05");
                param.setOrgId(manuOrgId.longValue());
                param.setIncludeSelf(true);
                param.setDirectViewType("toorg");
                List allToOrg = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
                if (!CadEmptyUtils.isEmpty(allToOrg) && allToOrg.contains(manuOrgId)) {
                    filter.and("storageorgunit", "=", (Object)manuOrgId);
                } else {
                    filter.and("storageorgunit", "=", (Object)(CadEmptyUtils.isEmpty(allToOrg) ? Long.valueOf(0L) : (Long)allToOrg.get(0)));
                }
            } else {
                filter.and("calorg", "=", (Object)orgId);
            }
            DynamicObject dynamicObjects = QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"costtype.id as costType", (QFilter[])new QFilter[]{filter});
            if (dynamicObjects == null) {
                return manuOrgCostTypeMap;
            }
            long costType = dynamicObjects.getLong("costType");
            manuOrgCostTypeMap.put(manuOrgId, costType);
        }
        return manuOrgCostTypeMap;
    }

    public static Set<Long> getCostAccountIds(Long costType, String appNum) {
        Set<Long> costAccounts = new HashSet<Long>(10);
        if ("sca".equals(appNum)) {
            QFilter costFilter = new QFilter("id", "=", (Object)costType);
            costFilter.and("costtypeentry.costtypeattr", "=", (Object)"0");
            ArrayList costTypeList = new ArrayList(16);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costtype", (String)"costtypeentry.costtype as costtypeId", (QFilter[])new QFilter[]{costFilter});
            if (dynamicObjects.isEmpty()) {
                return costAccounts;
            }
            dynamicObjects.forEach(r -> costTypeList.add(r.getLong("costtypeId")));
            Date date = TimeServiceHelper.now();
            QFilter[] filters = new QFilter[]{new QFilter("costtype", "in", costTypeList), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
            DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount,storageorgunit", (QFilter[])filters);
            costAccounts = DynamicObjectHelper.getIdSet(costTypeOrgs, "costaccount");
        } else {
            DynamicObject createOrg = CostTypeHelper.getCostType(costType, "createorg.id");
            if (createOrg == null) {
                return new HashSet<Long>();
            }
            List<Long> costAccountIds = CostAccountHelper.getOrgStdCostAccount(createOrg.getLong("createorg.id"), "aca");
            costAccounts.addAll(costAccountIds);
        }
        return costAccounts;
    }
}

