/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.constants.CostInfoRptParam;
import kd.macc.cad.common.constants.ProductInfoRptParam;
import kd.macc.cad.common.constants.StorageInfoRptParam;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;
import kd.macc.cad.common.utils.DateUtils;

public class CostUpdateHelper {
    private static Log logger = LogFactory.getLog(CostUpdateHelper.class);
    private static final String algoKey = "kd.macc.cad.common.helper.CostUpdateHelper";
    public static final String CLOSECALLBACK_LISTCLASS = "kd.macc.cad.formplugin.costupdatebill.CostUpdateNewListPlugin";
    public static final String CLOSECALLBACK_FROMCLASS = "kd.macc.cad.formplugin.costupdatebill.CostUpdateNewEditPlugin";
    public static final Long AUTOENDCAL_USERID = 1L;

    public static boolean isAuditToUpdateConfirmPage() {
        QFilter userIdFilter = new QFilter("user", "=", (Object)RequestContext.getOrCreate().getCurrUserId());
        DynamicObject userRecord = QueryServiceHelper.queryOne((String)"cad_userdatarecord", (String)"audittoconfirm", (QFilter[])new QFilter[]{userIdFilter});
        return userRecord != null && userRecord.getBoolean("audittoconfirm");
    }

    public static void showUpdateWizard(IFormView view, Map<String, Object> customParams, Object costUpdateId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_updatewizard");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u66f4\u65b0\u5411\u5bfc", (String)"CostUpdateHelper_4", (String)"macc-cad-common", (Object[])new Object[0]));
        formShowParameter.setCustomParams(customParams);
        formShowParameter.setCustomParam("costupdateid", costUpdateId);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setParentPageId(view.getPageId());
        view.showForm(formShowParameter);
    }

    public static boolean isAutoEndPeriodCalPage() {
        return Boolean.FALSE;
    }

    public static Boolean isEqualFields(DynamicObject sourceBill, DynamicObject targetResource) {
        String tar;
        String SPLIT = "#";
        String src = sourceBill.getLong("element.id") + SPLIT + sourceBill.getLong("subelement.id") + SPLIT + sourceBill.getBigDecimal("qty") + SPLIT + sourceBill.getBigDecimal("amount");
        if (!src.equals(tar = targetResource.getLong("element.id") + SPLIT + targetResource.getLong("subelement.id") + SPLIT + targetResource.getBigDecimal("qty") + SPLIT + targetResource.getBigDecimal("amount"))) {
            return false;
        }
        HashSet srcEntrys = new HashSet(10);
        HashSet tarEntrys = new HashSet(10);
        DynamicObjectCollection srcEntryEntities = sourceBill.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection tarEntryEntities = targetResource.getDynamicObjectCollection("entryentity");
        srcEntryEntities.forEach(p -> srcEntrys.add(p.getLong("attaelement.id") + SPLIT + p.getLong("attasubelement.id") + SPLIT + p.getBigDecimal("attaqty") + SPLIT + p.getBigDecimal("attaamt")));
        tarEntryEntities.forEach(p -> tarEntrys.add(p.getLong("attaelement.id") + SPLIT + p.getLong("attasubelement.id") + SPLIT + p.getBigDecimal("attaqty") + SPLIT + p.getBigDecimal("attaamt")));
        if (srcEntrys.size() != tarEntrys.size()) {
            return false;
        }
        srcEntrys.removeAll(tarEntrys);
        if (!CadEmptyUtils.isEmpty(srcEntrys)) {
            return false;
        }
        return true;
    }

    public static boolean isUpdateByPeriod(Long costTypeId) {
        String statu = CostUpdateHelper.getIsUpdateByPeriod(costTypeId);
        return Boolean.TRUE.toString().equals(statu);
    }

    public static Long getCostAccountByCostType(Long costTypeId) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObject costTypeOrgs = QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"costaccount", (QFilter[])filters);
        if (costTypeOrgs == null) {
            return 0L;
        }
        return costTypeOrgs.getLong("costaccount");
    }

    public static Long getCurPeriodId(Long costTypeId) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("org", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("entryentity.costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return null;
        }
        filters = new QFilter[]{filter, new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org,entryentity.costaccount costaccount,entryentity.calpolicy.periodtype periodtype,entryentity.startperiod startperiod", (QFilter[])filters);
        Long startPeriodId = 0L;
        HashSet<Long> typeIds = new HashSet<Long>(16);
        filter = null;
        for (DynamicObject startStdCost : startStdCosts) {
            startPeriodId = startStdCost.getLong("startperiod");
            typeIds.add(startStdCost.getLong("periodtype"));
            QFilter f = new QFilter("org", "=", (Object)startStdCost.getLong("org"));
            f.and("entry.costaccount", "=", (Object)startStdCost.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (typeIds.isEmpty() || CadEmptyUtils.isEmpty(startPeriodId)) {
            return null;
        }
        filters = new QFilter[]{filter, new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE), new QFilter("entry.startperiod", "!=", (Object)0L), new QFilter("entry.startperiod", "is not null", (Object)"null")};
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod", (QFilter[])filters);
        if (curPeriod == null) {
            return null;
        }
        return curPeriod.getLong("currentperiod");
    }

    public static List<Long> getPeriodIds(Long costTypeId) {
        boolean isGetCurrPeriod;
        boolean bl = isGetCurrPeriod = CadBgParamUtils.getCadParamForInt("costUpdateGetCurrPeriod", 0) == 1;
        if (isGetCurrPeriod) {
            return CostUpdateHelper.getPeriodIdsForOld(costTypeId);
        }
        if (CostUpdateHelper.isEndInit(costTypeId).booleanValue()) {
            return CostUpdateHelper.getPeriodIdsForSysDate(costTypeId);
        }
        return CostUpdateHelper.getPeriodIdsForOld(costTypeId);
    }

    public static List<Long> getPeriodIdsForSysDate(Long costTypeId) {
        ArrayList<Long> result = new ArrayList<Long>(1);
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        if (costTypeOrgs == null || costTypeOrgs.size() == 0) {
            return result;
        }
        Long costAccountId = ((DynamicObject)costTypeOrgs.get(0)).getLong("costaccount");
        DynamicObject curPeriod = PeriodHelper.getPeriodByDate(new Date(), costAccountId);
        DynamicObject nextPeriod = PeriodHelper.getNextPeriod(curPeriod.getLong("id"));
        result.add(curPeriod.getLong("id"));
        if (nextPeriod != null) {
            result.add(nextPeriod.getLong("id"));
        }
        return result;
    }

    public static Boolean isEndInit(Long costTypeId) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        if (CadEmptyUtils.isEmpty(costTypeOrgs)) {
            return Boolean.FALSE;
        }
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("org", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("entryentity.costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return Boolean.FALSE;
        }
        filters = new QFilter[]{filter, new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org,entryentity.costaccount costaccount,entryentity.calpolicy.periodtype periodtype,entryentity.startperiod startperiod", (QFilter[])filters);
        Long startPeriodId = 0L;
        HashSet<Long> typeIds = new HashSet<Long>(16);
        filter = null;
        for (DynamicObject startStdCost : startStdCosts) {
            if (startPeriodId == 0L || startPeriodId < startStdCost.getLong("startperiod")) {
                startPeriodId = startStdCost.getLong("startperiod");
            }
            typeIds.add(startStdCost.getLong("periodtype"));
            QFilter f = new QFilter("org", "=", (Object)startStdCost.getLong("org"));
            f.and("entry.costaccount", "=", (Object)startStdCost.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (typeIds.isEmpty() || CadEmptyUtils.isEmpty(startPeriodId)) {
            return Boolean.FALSE;
        }
        filters = new QFilter[]{filter, new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE), new QFilter("entry.startperiod", "!=", (Object)0L), new QFilter("entry.startperiod", "is not null", (Object)"null")};
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod", (QFilter[])filters);
        if (curPeriod == null) {
            return Boolean.FALSE;
        }
        Long currentPeriodId = curPeriod.getLong("currentperiod");
        if (CadEmptyUtils.isEmpty(currentPeriodId)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static List<Long> getPeriodIdsForOld(Long costTypeId) {
        DynamicObject previousPeriod;
        Date[] dates;
        ArrayList<Long> result = new ArrayList<Long>(1);
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("org", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("entryentity.costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return result;
        }
        filters = new QFilter[]{filter, new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org,entryentity.costaccount costaccount,entryentity.calpolicy.periodtype periodtype,entryentity.startperiod startperiod", (QFilter[])filters);
        Long startPeriodId = 0L;
        HashSet<Long> typeIds = new HashSet<Long>(16);
        filter = null;
        for (DynamicObject startStdCost : startStdCosts) {
            startPeriodId = startStdCost.getLong("startperiod");
            typeIds.add(startStdCost.getLong("periodtype"));
            QFilter f = new QFilter("org", "=", (Object)startStdCost.getLong("org"));
            f.and("entry.costaccount", "=", (Object)startStdCost.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (typeIds.isEmpty() || CadEmptyUtils.isEmpty(startPeriodId)) {
            return result;
        }
        filters = new QFilter[]{filter, new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE), new QFilter("entry.startperiod", "!=", (Object)0L), new QFilter("entry.startperiod", "is not null", (Object)"null")};
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod", (QFilter[])filters);
        if (curPeriod == null) {
            return result;
        }
        Long currentPeriodId = curPeriod.getLong("currentperiod");
        if (CadEmptyUtils.isEmpty(currentPeriodId)) {
            dates = PeriodHelper.getPeriodStartAndEndTime(startPeriodId);
            if (dates == null || dates.length != 2) {
                return result;
            }
            ArrayList<Long> periodIds = new ArrayList<Long>(3);
            DynamicObject previousPeriod2 = PeriodHelper.getPreviousPeriod(startPeriodId);
            if (previousPeriod2 != null) {
                periodIds.add(previousPeriod2.getLong("id"));
            }
            periodIds.addAll(CostUpdateHelper.getPeriodIds(typeIds, dates[0]));
            return periodIds;
        }
        dates = PeriodHelper.getPeriodStartAndEndTime(currentPeriodId);
        if (dates == null || dates.length != 2) {
            return result;
        }
        ArrayList<Long> periodIds = new ArrayList<Long>(3);
        if (startPeriodId.equals(currentPeriodId) && (previousPeriod = PeriodHelper.getPreviousPeriod(currentPeriodId)) != null) {
            periodIds.add(previousPeriod.getLong("id"));
        }
        periodIds.addAll(CostUpdateHelper.getPeriodIds(typeIds, dates[0]));
        return periodIds;
    }

    public static List<Long> getPeriodIds(Long orgId, Long costAccountId) {
        ArrayList<Long> result = new ArrayList<Long>(1);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("entryentity.costaccount", "=", (Object)costAccountId), new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection startStdCost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype", (QFilter[])filters);
        HashSet<Long> typeIds = new HashSet<Long>(16);
        startStdCost.forEach(p -> typeIds.add(p.getLong("periodtype")));
        if (typeIds.isEmpty()) {
            return result;
        }
        filters = new QFilter[]{new QFilter("org.id", "=", (Object)orgId), new QFilter("entry.costaccount", "=", (Object)costAccountId), new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE), new QFilter("entry.startperiod", "!=", (Object)0L), new QFilter("entry.startperiod", "is not null", (Object)"null")};
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod", (QFilter[])filters);
        if (curPeriod == null) {
            return result;
        }
        Date[] dates = PeriodHelper.getPeriodStartAndEndTime(curPeriod.getLong("currentperiod"));
        if (dates == null || dates.length != 2) {
            return result;
        }
        return CostUpdateHelper.getPeriodIds(typeIds, dates[0]);
    }

    public static QFilter getRptPeriodQFilter(Long costTypeId) {
        QFilter result = new QFilter("id", "=", (Object)-1L);
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("org", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("entryentity.costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return result;
        }
        filters = new QFilter[]{filter, new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)"org,entryentity.costaccount costaccount,entryentity.calpolicy.periodtype periodtype,entryentity.startperiod startperiod", (QFilter[])filters, (String)"entryentity.startperiod asc", (int)1);
        if (CadEmptyUtils.isEmpty(startStdCosts)) {
            return result;
        }
        DynamicObject startStd = (DynamicObject)startStdCosts.get(0);
        Long startPeriodId = startStd.getLong("startperiod");
        filter = null;
        QFilter f = new QFilter("org", "=", (Object)startStd.getLong("org"));
        f.and("entry.costaccount", "=", (Object)startStd.getLong("costaccount"));
        if (filter == null) {
            filter = f;
        }
        if (CadEmptyUtils.isEmpty(startPeriodId)) {
            return result;
        }
        filters = new QFilter[]{filter, new QFilter("entry.costaccount.enable", "=", (Object)Boolean.TRUE), new QFilter("entry.startperiod", "!=", (Object)0L), new QFilter("entry.startperiod", "is not null", (Object)"null")};
        DynamicObject curPeriod = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod as currentperiod", (QFilter[])filters);
        if (curPeriod == null) {
            return result;
        }
        Long currentPeriod = curPeriod.getLong("currentperiod");
        result = new QFilter("periodtype", "in", (Object)startStd.getLong("periodtype"));
        if (startPeriodId.equals(currentPeriod)) {
            DynamicObject previousPeriod = PeriodHelper.getPreviousPeriod(currentPeriod);
            if (previousPeriod != null) {
                result.and("id", ">=", (Object)previousPeriod.getLong("id"));
            } else {
                result.and("id", ">=", (Object)startStd.getLong("startperiod"));
            }
        } else {
            result.and("id", ">=", (Object)startStd.getLong("startperiod"));
        }
        return result;
    }

    public static QFilter getRptPeriodQFilter(Long orgId, Long costAccountId) {
        QFilter result = new QFilter("id", "=", (Object)-1L);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("entryentity.costaccount", "=", (Object)costAccountId), new QFilter("appnum", "=", (Object)"sca"), new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection startStdCost = QueryServiceHelper.query((String)"sca_startstdcost", (String)"entryentity.calpolicy.periodtype periodtype,entryentity.startperiod startperiod", (QFilter[])filters, (String)"entryentity.startperiod asc", (int)1);
        if (startStdCost.isEmpty()) {
            return result;
        }
        DynamicObject startStd = (DynamicObject)startStdCost.get(0);
        result = new QFilter("periodtype", "=", (Object)startStd.getLong("periodtype"));
        result.and(new QFilter("isadjustperiod", "=", (Object)false));
        result.and("id", ">=", (Object)startStd.getLong("startperiod"));
        return result;
    }

    private static List<Long> getPeriodIds(Set<Long> typeIds, Date date) {
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "in", typeIds), new QFilter("enddate", ">", (Object)date), new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE)};
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodtype", (QFilter[])filters, (String)"enddate asc");
        HashMap mapTypes = new HashMap(16);
        for (DynamicObject period : periods) {
            Long periodType = period.getLong("periodtype");
            ArrayList<Long> periodIds = (ArrayList<Long>)mapTypes.get(periodType);
            if (periodIds == null) {
                periodIds = new ArrayList<Long>(1);
            }
            if (periodIds.size() > 1) continue;
            periodIds.add(period.getLong("id"));
            mapTypes.put(periodType, periodIds);
        }
        ArrayList<Long> periodIds = new ArrayList<Long>(16);
        for (Map.Entry mapType : mapTypes.entrySet()) {
            periodIds.addAll((Collection)mapType.getValue());
        }
        periodIds.sort(Comparator.naturalOrder());
        return periodIds;
    }

    public static Boolean isUpdateCurLevel(Long srcCostTypeId, Long targetCostTypeId) {
        QFilter[] filters = new QFilter[]{new QFilter("srccosttype", "=", (Object)srcCostTypeId), new QFilter("targetcosttype", "=", (Object)targetCostTypeId), new QFilter("updatestatus", "=", (Object)Character.valueOf('N')), new QFilter("iscalccurlevel", "=", (Object)Boolean.TRUE)};
        return QueryServiceHelper.exists((String)"cad_costupdatenew", (QFilter[])filters);
    }

    public static List<QFilter> getPeriodQFilter(List<QFilter> filters, Date[] periodtime) {
        QFilter allFilters = null;
        for (QFilter f : filters) {
            if (allFilters == null) {
                allFilters = f;
                continue;
            }
            allFilters.and(f);
        }
        if (allFilters == null) {
            return filters;
        }
        allFilters.and(QFilter.of((String)"effectdate != expdate", null));
        QFilter filter1 = allFilters.copy();
        QFilter filter2 = allFilters.copy();
        Date startDate = periodtime[0];
        Date endDate = DateUtils.getLastSecond(periodtime[1], -1);
        filter1.and(new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate)));
        filter2.and(new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate)));
        filters.clear();
        filters.add(filter1.or(filter2));
        return filters;
    }

    public static List<QFilter> getPeriodQF(List<QFilter> filters, Date[] periodtime) {
        filters.add(QFilter.of((String)"effectdate != expdate", null));
        Date startDate = periodtime[0];
        Date endDate = periodtime[1];
        QFilter filter1 = new QFilter("effectdate", "<=", (Object)endDate).and(new QFilter("expdate", ">", (Object)startDate));
        filters.add(filter1);
        return filters;
    }

    public static QFilter getPeriodQFilter(Date[] periodtime) {
        QFilter allFilters = QFilter.of((String)"effectdate != expdate", null);
        QFilter filter1 = allFilters.copy();
        QFilter filter2 = allFilters.copy();
        Date startDate = periodtime[0];
        Date endDate = DateUtils.getLastSecond(periodtime[1], -1);
        filter1.and(new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate)));
        filter2.and(new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate)));
        return filter1.or(filter2);
    }

    public static Boolean isUpdateByPeriod(Long orgId, Long costAccountId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("tab", "=", (Object)"costaccounttabpage"), new QFilter("appnum", "=", (Object)"sca"), new QFilter("isupdatebyperiod", "=", (Object)Boolean.TRUE)};
        return QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])filters);
    }

    public static Boolean isQueryPeriod(ReportQueryParam param) {
        FilterInfo filterInfo = param.getFilter();
        DynamicObject queryPeriod = filterInfo.getDynamicObject("queryperiod");
        if (queryPeriod != null && queryPeriod.getLong("id") != 0L) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String getIsUpdateByPeriod(Long costTypeId) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("org", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return Boolean.FALSE.toString();
        }
        filters = new QFilter[]{filter, new QFilter("tab", "=", (Object)"costaccounttabpage"), new QFilter("appnum", "=", (Object)"sca")};
        DynamicObjectCollection sysParam = QueryServiceHelper.query((String)"cad_sysparam", (String)"isupdatebyperiod", (QFilter[])filters);
        if (sysParam.isEmpty()) {
            return Boolean.FALSE.toString();
        }
        HashSet isPeriods = new HashSet(2);
        sysParam.forEach(p -> isPeriods.add(p.getBoolean("isupdatebyperiod")));
        if (isPeriods.size() == 1 && isPeriods.contains(Boolean.TRUE)) {
            return Boolean.TRUE.toString();
        }
        if (isPeriods.size() == 2) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u6210\u672c\u7c7b\u578b\u5173\u8054\u4e86\u591a\u4e2a\u8d26\u7c3f\uff0c\u4e14\u90e8\u5206\u542f\u7528\u6309\u671f\u8fdb\u884c\u6210\u672c\u66f4\u65b0\uff0c\u90e8\u5206\u6ca1\u6709\u542f\u7528\u6309\u671f\u8fdb\u884c\u6210\u672c\u66f4\u65b0\u3002", (String)"CostUpdateHelper_2", (String)"macc-cad-common", (Object[])new Object[0]);
        }
        return Boolean.FALSE.toString();
    }

    public static Boolean getIsAllUpdate(Long costTypeId) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        DynamicObjectCollection costTypeOrgs = QueryServiceHelper.query((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
        QFilter filter = null;
        for (DynamicObject costTypeOrg : costTypeOrgs) {
            QFilter f = new QFilter("org", "=", (Object)costTypeOrg.getLong("calorg"));
            f.and("costaccount", "=", (Object)costTypeOrg.getLong("costaccount"));
            if (filter == null) {
                filter = f;
                continue;
            }
            filter.or(f);
        }
        if (filter == null) {
            return Boolean.FALSE;
        }
        filters = new QFilter[]{filter, new QFilter("tab", "=", (Object)"costaccounttabpage"), new QFilter("appnum", "=", (Object)"sca")};
        DynamicObjectCollection sysParam = QueryServiceHelper.query((String)"cad_sysparam", (String)"isallupdate", (QFilter[])filters);
        if (sysParam.isEmpty()) {
            return Boolean.FALSE;
        }
        HashSet isAllUpdates = new HashSet(2);
        sysParam.forEach(p -> isAllUpdates.add(p.getBoolean("isallupdate")));
        return isAllUpdates.size() == 1 && isAllUpdates.contains(Boolean.TRUE);
    }

    public static Map<Long, String> getRelatedKeyCols(DynamicObject updateBill) {
        QFilter keyColFilter;
        HashMap<Long, String> relatedKeyColMap = new HashMap<Long, String>(16);
        HashMap<Long, String> relateCalcPurKeyColMap = new HashMap<Long, String>(16);
        DynamicObjectCollection entrys = updateBill.getDynamicObjectCollection("entryentity");
        if (entrys.isEmpty()) {
            return relatedKeyColMap;
        }
        HashSet<Long> matGrpIds = new HashSet<Long>(16);
        HashMap<String, Object> values = new HashMap<String, Object>(7);
        Boolean isTrackUpdate = Boolean.FALSE;
        for (DynamicObject entry : entrys) {
            Long tracknumber = entry.getLong("tracknumber.id");
            if (!CadEmptyUtils.isEmpty(tracknumber)) {
                isTrackUpdate = Boolean.TRUE;
            }
            Long matId = entry.getLong("material.id");
            Long matGrpId = entry.getLong("matgrp.id");
            if (!CadEmptyUtils.isEmpty(matId)) {
                values.clear();
                values.put("material", entry.getLong("material.id"));
                values.put("matvers", entry.getLong("matversion.id"));
                values.put("auxproperty", entry.getLong("auxprop.id"));
                values.put("project", entry.getLong("project.id"));
                values.put("tracknumber", entry.getLong("tracknumber.id"));
                values.put("configuredcode", entry.getLong("configuredcode.id"));
                values.put("lot", entry.getString("lot"));
                Long keyColId = CalcKeyHelper.getCalcKey(values, new ArrayList<String>(), Boolean.FALSE).getId();
                if (CadEmptyUtils.isEmpty(keyColId)) {
                    logger.info("\u66f4\u65b0\u7533\u8bf7\u5355keycol= {}", (Object)keyColId);
                    continue;
                }
                relatedKeyColMap.put(keyColId, "1");
                continue;
            }
            if (CadEmptyUtils.isEmpty(matGrpId)) continue;
            matGrpIds.add(matGrpId);
        }
        if (!CadEmptyUtils.isEmpty(matGrpIds)) {
            QFilter[] filters = new QFilter[]{new QFilter("group.masterid", "in", matGrpIds)};
            ArrayList materialIds = new ArrayList(16);
            DynamicObjectCollection matGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material", (QFilter[])filters);
            matGroups.forEach(p -> materialIds.add(p.getLong("material")));
            if (!CadEmptyUtils.isEmpty(materialIds)) {
                QFilter filter = new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id"));
                filter.and("material", "in", materialIds);
                filter.and("calcrecord", "=", (Object)(CadEmptyUtils.isEmpty(updateBill.getLong("calcrecord.id")) ? Long.parseLong("0") : updateBill.getLong("calcrecord.id")));
                filter.and("ismaindata", "=", (Object)1);
                filter.and("isleaf", "=", (Object)"0");
                DynamicObjectCollection calcs = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"keycolid", (QFilter[])new QFilter[]{filter});
                for (Object calc : calcs) {
                    relatedKeyColMap.put(calc.getLong("keycolid"), "1");
                }
                filter = new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id"));
                filter.and("material", "in", materialIds);
                DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_calcpurprices", (String)"keycolid", (QFilter[])new QFilter[]{filter});
                for (DynamicObject purPrice : purPrices) {
                    relateCalcPurKeyColMap.put(purPrice.getLong("keycolid"), "1");
                }
            }
            if (CadEmptyUtils.isEmpty(relatedKeyColMap)) {
                relatedKeyColMap.put(1L, "1");
            }
        }
        logger.info(String.format("relatedKeyColMap:%s", relatedKeyColMap));
        if (updateBill.getBoolean("iscalccurlevel")) {
            relatedKeyColMap.putAll(relateCalcPurKeyColMap);
            return relatedKeyColMap;
        }
        HashSet keyColIds = new HashSet(16);
        keyColIds.addAll(relatedKeyColMap.keySet());
        DataSet calcData = null;
        QFilter costTypeFilter = new QFilter("costtype", "=", (Object)updateBill.getLong("srccosttype.id"));
        QFilter entryQFilter = new QFilter("entryentity.entrylevel", "=", (Object)0);
        logger.info("isTrackUpdate:{}", (Object)isTrackUpdate);
        if (Boolean.FALSE.equals(isTrackUpdate)) {
            keyColFilter = new QFilter("keycolid", "in", keyColIds);
            keyColFilter.or("entryentity.subkeycolid", "in", keyColIds);
            calcData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_calcsimulationresult", (String)"rootnode", (QFilter[])new QFilter[]{costTypeFilter, keyColFilter}, null);
        } else {
            keyColFilter = new QFilter("keycolid", "in", keyColIds);
            keyColFilter.and("ismaindata", "=", (Object)1);
            keyColFilter.and("isleaf", "=", (Object)"0");
            keyColFilter.and("effectdate", "is null", null);
            calcData = QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_trackstdcalcresult", (String)"rootnode", (QFilter[])new QFilter[]{costTypeFilter, entryQFilter, keyColFilter}, null);
        }
        HashSet<String> rootnodesIds = new HashSet<String>(10);
        Iterator it = calcData.iterator();
        while (it.hasNext()) {
            rootnodesIds.add(((Row)it.next()).getString("rootnode"));
        }
        DataSetUtils.colse(new DataSet[]{calcData});
        relatedKeyColMap.putAll(relateCalcPurKeyColMap);
        if (CadEmptyUtils.isEmpty(rootnodesIds)) {
            return relatedKeyColMap;
        }
        QFilter rootNodesIsFilter = new QFilter("rootnode", "in", rootnodesIds);
        DataSet relateDataSet = null;
        relateDataSet = Boolean.FALSE.equals(isTrackUpdate) ? QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_calcsimulationresult", (String)"keycolid,entryentity.subkeycolid subkeycolid", (QFilter[])new QFilter[]{costTypeFilter, rootNodesIsFilter}, null) : QueryServiceHelper.queryDataSet((String)algoKey, (String)"cad_trackstdcalcresult", (String)"keycolid,0L subkeycolid", (QFilter[])new QFilter[]{costTypeFilter, rootNodesIsFilter, entryQFilter}, null);
        for (Row row : relateDataSet) {
            Long subKeyColId;
            Long keyColId = row.getLong("keycolid");
            if (!relatedKeyColMap.containsKey(keyColId) && !CadEmptyUtils.isEmpty(keyColId)) {
                relatedKeyColMap.put(keyColId, "2");
            }
            if (relatedKeyColMap.containsKey(subKeyColId = row.getLong("subkeycolid")) || CadEmptyUtils.isEmpty(subKeyColId)) continue;
            relatedKeyColMap.put(subKeyColId, "2");
        }
        DataSetUtils.colse(new DataSet[]{relateDataSet});
        logger.info(String.format("relatedKeyColMap\uff1a%s", relatedKeyColMap));
        return relatedKeyColMap;
    }

    public static Map<String, Long> getUpdateIds(Set<Long> tarCostTypeIds) {
        HashMap<String, Long> result = new HashMap<String, Long>(16);
        if (CadEmptyUtils.isEmpty(tarCostTypeIds)) {
            return result;
        }
        QFilter costTypeFilter = new QFilter("targetcosttype", "in", tarCostTypeIds);
        costTypeFilter.or(new QFilter("attachtargetcosttype.fbasedataid", "in", tarCostTypeIds));
        QFilter[] filters = new QFilter[]{costTypeFilter, new QFilter("updatestatus", "=", (Object)"Y")};
        DataSet updateNewDataSet = QueryServiceHelper.queryDataSet((String)"CostUpdateHelper.getUpdateNumbers.updateNew", (String)"cad_costupdatenew", (String)"id updateid, updatebillid establishedid", (QFilter[])filters, null);
        if (updateNewDataSet.isEmpty()) {
            return result;
        }
        DataSet establishedDataSet = updateNewDataSet.copy();
        ArrayList<Long> establishedIds = new ArrayList<Long>(16);
        Iterator it = establishedDataSet.iterator();
        while (it.hasNext()) {
            establishedIds.add(((Row)it.next()).getLong("establishedid"));
        }
        filters = new QFilter[]{new QFilter("id", "in", establishedIds)};
        establishedDataSet = QueryServiceHelper.queryDataSet((String)"CostUpdateHelper.getUpdateNumbers.updateEtablished", (String)"cad_costupdateestablished", (String)"id,billno establishedno", (QFilter[])filters, null);
        if (establishedDataSet.isEmpty()) {
            return result;
        }
        DataSet data = updateNewDataSet.leftJoin(establishedDataSet).on("establishedid", "id").select(new String[]{"updateid", "establishedno"}).finish();
        for (Row row : data) {
            String establishedNo = row.getString("establishedno");
            Long updateId = row.getLong("updateid");
            if (CadEmptyUtils.isEmpty(establishedNo) || CadEmptyUtils.isEmpty(updateId)) continue;
            result.put(establishedNo, updateId);
        }
        return result;
    }

    public static ReportShowParameter getReportShowParameter(String key, Long updateBillId) {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String selectFields = "id,targetcosttype,updatetime";
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)updateBillId)};
        DynamicObject updateBill = QueryServiceHelper.queryOne((String)"cad_costupdatenew", (String)selectFields, (QFilter[])filters);
        Long tarCostTypeId = updateBill.getLong("targetcosttype");
        DynamicObject costTypeOrg = CostUpdateHelper.getCostTypeOrgInfo(tarCostTypeId);
        switch (key) {
            case "costinforpt": {
                showParameter.setFormId("cad_costinforpt");
                CostInfoRptParam costParam = new CostInfoRptParam();
                costParam.setTargetCostTypeIds(Collections.singletonList(tarCostTypeId));
                costParam.setUpdateIds(CostUpdateHelper.getUpdateIds(Collections.singleton(tarCostTypeId)));
                costParam.setUpdateBillIds(Lists.newArrayList((Object[])new Long[]{updateBillId}));
                showParameter.setCustomParam(CostInfoRptParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)costParam));
                break;
            }
            case "storageinforpt": {
                showParameter.setFormId("cad_storageinforpt");
                if (costTypeOrg == null) {
                    return null;
                }
                StorageInfoRptParam storageParam = new StorageInfoRptParam();
                storageParam.setOrgId(costTypeOrg.getLong("calorg"));
                storageParam.setCostAccountId(costTypeOrg.getLong("costaccount"));
                DynamicObject period = PeriodHelper.getPeriodByDate(updateBill.getDate("updatetime"), costTypeOrg.getLong("costaccount"));
                storageParam.setStartPeriodId(period.getLong("id"));
                storageParam.setEndPeriodId(period.getLong("id"));
                storageParam.setUpdateBillIds(Lists.newArrayList((Object[])new Long[]{updateBill.getLong("id")}));
                showParameter.setCustomParam(StorageInfoRptParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)storageParam));
                break;
            }
            case "productinforpt": {
                showParameter.setFormId("cad_productinforpt");
                if (costTypeOrg == null) {
                    return null;
                }
                ProductInfoRptParam productParam = new ProductInfoRptParam();
                productParam.setOrgId(costTypeOrg.getLong("calorg"));
                productParam.setCostAccountId(costTypeOrg.getLong("costaccount"));
                DynamicObject period = PeriodHelper.getPeriodByDate(updateBill.getDate("updatetime"), costTypeOrg.getLong("costaccount"));
                productParam.setStartPeriodId(period.getLong("id"));
                productParam.setEndPeriodId(period.getLong("id"));
                productParam.setUpdateBillIds(Lists.newArrayList((Object[])new Long[]{updateBillId}));
                showParameter.setCustomParam(ProductInfoRptParam.class.getName(), (Object)SerializationUtils.toJsonString((Object)productParam));
                break;
            }
        }
        showParameter.setCustomParam("source", (Object)"HyperLink");
        showParameter.setHasRight(true);
        return showParameter;
    }

    private static DynamicObject getCostTypeOrgInfo(Long tarCostTypeId) {
        Date date = TimeServiceHelper.now();
        QFilter[] filters = new QFilter[]{new QFilter("costtype", "=", (Object)tarCostTypeId), new QFilter("bizstatus", "=", (Object)"1"), new QFilter("effectdate", "<=", (Object)date), new QFilter("invaliddate", ">", (Object)date)};
        return QueryServiceHelper.queryOne((String)"cal_bd_costtypeorg", (String)"calorg,costaccount", (QFilter[])filters);
    }

    public static List<String> getNumberByIds(String entityName, List<Long> ids) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection tracks = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filters);
        ArrayList<String> numbers = new ArrayList<String>(tracks.size());
        tracks.forEach(p -> numbers.add(p.getString("number")));
        return numbers;
    }

    public static boolean isEnabledUpdate(Long establishedId) {
        String algoKey = "kd.macc.cad.common.helper.CostUpdateHelper.isEnableUpdate";
        int maxSize = CadBgParamUtils.getScmParamForInt("costupdate_maxsize", 200000);
        int size = 0;
        String sql = "SELECT COUNT(1) FSIZE FROM T_CAD_COSTUPESTBISH_COST WHERE FID = " + establishedId;
        DataSet sizeData = DB.queryDataSet((String)algoKey, (DBRoute)new DBRoute("cal"), (String)sql);
        Iterator it = sizeData.iterator();
        if (it.hasNext()) {
            size = Integer.parseInt(((Row)it.next()).get("FSIZE").toString());
        }
        logger.info(String.format("T_IM_INVDBPARAM\u8868\u8bbe\u7f6e\u7684\u6700\u5927\u91cf\u4e3a%s\uff0c\u5f53\u524d\u201c\u6210\u672c\u66f4\u65b0\u201d\u9875\u7b7e\u6570\u636e\u91cf\u4e3a%s", maxSize, size));
        return maxSize < size;
    }

    public static String isUpdateByKeyCol(String entityName, List<Long> ids, String field) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids), new QFilter("lot", "!=", (Object)" ").or(new QFilter("configuredcode", ">", (Object)0L).or(new QFilter("tracknumber", ">", (Object)0L).or(new QFilter("project", ">", (Object)0L))))};
        DynamicObjectCollection datas = QueryServiceHelper.query((String)entityName, (String)field, (QFilter[])filters);
        if (datas.isEmpty()) {
            return null;
        }
        StringBuilder sg = new StringBuilder();
        for (DynamicObject data : datas) {
            sg.append("\u3001");
            sg.append(data.getString(field));
        }
        return sg.substring(1);
    }

    public static boolean hasUpdatePerm(String entityName) {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = "sca";
        String permItemId = "0+QWS0TKCRIL";
        return PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)permItemId);
    }
}

