/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.enums.CostTypePtyEnum;

public class CostUpdateRptHelper {
    public static List<QFilter> getFilters(FilterInfo filter) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject targetCostType = filter.getDynamicObject("targetcosttype");
        if (targetCostType == null) {
            return filters;
        }
        DynamicObject updatebillinfo = BusinessDataServiceHelper.loadSingle((Object)filter.getDynamicObject("billno").getPkValue(), (String)"cad_costupdatenew");
        if (CostTypePtyEnum.SIMULATED.getValue().equals(targetCostType.getString("type"))) {
            if (filter.getDynamicObject("billno") != null) {
                filters.add(new QFilter("id", "=", (Object)updatebillinfo.getLong("updatebillid")));
            }
            if (filter.getDynamicObject("querymaterial") != null) {
                filters.add(new QFilter("costupdateentry.material", "=", filter.getDynamicObject("querymaterial").getPkValue()));
            }
        } else if ("2".equals(filter.getString("querytype"))) {
            if (filter.getDynamicObject("billno") != null) {
                filters.add(new QFilter("id", "=", (Object)updatebillinfo.getLong("updatebillid")));
            }
            if (filter.getDynamicObject("querymaterial") != null) {
                filters.add(new QFilter("storagecostentry.stormaterial", "=", filter.getDynamicObject("querymaterial").getPkValue()));
            }
            if (filter.getDynamicObject("acctorg") != null) {
                filters.add(new QFilter("storagecostentry.accountorg", "=", filter.getDynamicObject("acctorg").getPkValue()));
            }
            if (filter.getDynamicObject("costaccount") != null) {
                filters.add(new QFilter("storagecostentry.costaccount", "=", filter.getDynamicObject("costaccount").getPkValue()));
            }
            if (filter.getDynamicObject("warehouse") != null) {
                filters.add(new QFilter("storagecostentry.warehouse", "=", filter.getDynamicObject("warehouse").getPkValue()));
            }
        } else {
            if (filter.getDynamicObject("billno") != null) {
                filters.add(new QFilter("id", "=", (Object)updatebillinfo.getLong("updatebillid")));
            }
            if (filter.getDynamicObject("querymaterial") != null) {
                filters.add(new QFilter("acctentry.acctmaterial", "=", filter.getDynamicObject("querymaterial").getPkValue()));
            }
            if (filter.getDynamicObject("acctorg") != null) {
                filters.add(new QFilter("acctentry.acctaccountorg", "=", filter.getDynamicObject("acctorg").getPkValue()));
            }
            if (filter.getDynamicObject("costaccount") != null) {
                filters.add(new QFilter("acctentry.acctcostaccount", "=", filter.getDynamicObject("costaccount").getPkValue()));
            }
        }
        return filters;
    }

    public static DynamicObjectCollection getDynamicColumnsData(ReportQueryParam reportQueryParam) {
        DynamicObjectCollection coll = null;
        FilterInfo filter = reportQueryParam.getFilter();
        List<QFilter> filters = CostUpdateRptHelper.getFilters(filter);
        String queryType = filter.getString("querytype");
        coll = "1".equals(queryType) ? QueryServiceHelper.query((String)"cad_costupdateestablished", (String)"acctentry.acctaccountorg.name,acctentry.acctaccountorg.number,acctentry.acctaccountorg.id,acctentry.acctcostaccount.name,acctentry.acctcostaccount.number,acctentry.acctcostaccount.id", (QFilter[])filters.toArray(new QFilter[0])) : QueryServiceHelper.query((String)"cad_costupdateestablished", (String)"storagecostentry.accountorg.name,storagecostentry.accountorg.number,storagecostentry.accountorg.id,storagecostentry.costaccount.name,storagecostentry.costaccount.number,storagecostentry.costaccount.id,storagecostentry.warehouse.name,storagecostentry.warehouse.number,storagecostentry.warehouse.id", (QFilter[])filters.toArray(new QFilter[0]));
        return coll;
    }

    public static String getDynamicSql(ReportQueryParam reportQueryParam) {
        StringBuilder dySql = new StringBuilder();
        FilterInfo filter = reportQueryParam.getFilter();
        DynamicObjectCollection coll = CostUpdateRptHelper.getDynamicColumnsData(reportQueryParam);
        String queryType = filter.getString("querytype");
        if ("1".equals(queryType)) {
            for (int index = 0; index < coll.size(); ++index) {
                DynamicObject costUpdateInfo = (DynamicObject)coll.get(index);
                String costaccountNumber = costUpdateInfo.getString("acctentry.acctcostaccount.number");
                String costaccountId = costUpdateInfo.getString("acctentry.acctcostaccount.id");
                String accountorgNumber = costUpdateInfo.getString("acctentry.acctaccountorg.number");
                String accountorgId = costUpdateInfo.getString("acctentry.acctaccountorg.id");
                String dyfieldKey = (costaccountNumber + accountorgNumber).replaceAll("\\.", "s");
                if (dySql.indexOf(dyfieldKey) > 0) continue;
                dySql.append(",case when facctaccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and facctcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("     then facctoldcost").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'foldCost").append(dyfieldKey).append("' \n");
                dySql.append(",case when facctaccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and facctcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("     then facctnewcost").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'fnewCost").append(dyfieldKey).append("' \n");
                dySql.append(",case when facctaccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and facctcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("     then facctqty").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'fqty").append(dyfieldKey).append("' \n");
                dySql.append(",case when facctaccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and facctcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("     then facctoldcost- facctnewcost").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'fdiffCost").append(dyfieldKey).append("' \n");
            }
        } else {
            for (int index = 0; index < coll.size(); ++index) {
                DynamicObject costUpdateInfo = (DynamicObject)coll.get(index);
                String costaccountNumber = costUpdateInfo.getString("storagecostentry.costaccount.number");
                String costaccountId = costUpdateInfo.getString("storagecostentry.costaccount.id");
                String accountorgNumber = costUpdateInfo.getString("storagecostentry.accountorg.number");
                String accountorgId = costUpdateInfo.getString("storagecostentry.accountorg.id");
                String warehouseNumber = costUpdateInfo.getString("storagecostentry.warehouse.number");
                String warehouseId = costUpdateInfo.getString("storagecostentry.warehouse.id");
                String dyfieldKey = (costaccountNumber + accountorgNumber + warehouseNumber).replaceAll("\\.", "s");
                if (dySql.indexOf(dyfieldKey) > 0) continue;
                dySql.append(",case when faccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and fcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("       and fwarehouseid = ").append(warehouseId).append(" \n");
                dySql.append("     then foldcost").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'foldCost").append(dyfieldKey).append("' \n");
                dySql.append(",case when faccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and fcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("       and fwarehouseid = ").append(warehouseId).append(" \n");
                dySql.append("     then fnewcost ").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'fnewCost").append(dyfieldKey).append("' \n");
                dySql.append(",case when faccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and fcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("       and fwarehouseid = ").append(warehouseId).append(" \n");
                dySql.append("     then fqty").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'fqty").append(dyfieldKey).append("' \n");
                dySql.append(",case when faccountorgid = ").append(accountorgId).append(" \n");
                dySql.append("       and fcostaccountid = ").append(costaccountId).append(" \n");
                dySql.append("       and fwarehouseid = ").append(warehouseId).append(" \n");
                dySql.append("     then foldcost - fnewcost").append(" \n");
                dySql.append("     else 0 ").append(" \n");
                dySql.append(" end as 'fdiffcost").append(dyfieldKey).append("' \n");
            }
        }
        return dySql.toString();
    }

    public static QFilter getMaterialByCostType(String costtypeid, String matField) {
        QFilter costtypeFilter = new QFilter("id", "=", (Object)costtypeid);
        DynamicObjectCollection costtypes = QueryServiceHelper.query((String)"cad_costtype", (String)"masterid,createorg.masterid,ctrlstrategy", (QFilter[])new QFilter[]{costtypeFilter});
        if (costtypes == null || costtypes.size() < 1) {
            return null;
        }
        DynamicObject costtype = (DynamicObject)costtypes.get(0);
        Long orgId = costtype.getLong("createorg.masterid");
        return BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)orgId);
    }
}

