/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CurrencyHelper {
    public static void setCurrency(IDataModel model, IFormView view) {
        DynamicObject costAccount = model.getDataEntity().getDynamicObject("costaccount");
        model.setValue("currency", (Object)CurrencyHelper.getCurrency(costAccount));
        view.updateView("currency");
        model.setDataChanged(false);
    }

    public static Long getCurrency(Long costaccountId) {
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costaccountId, (String)"cal_bd_costaccount");
        return CurrencyHelper.getCurrency(costAccount);
    }

    public static Integer getAmtprecision(Long costaccountId) {
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingleFromCache((Object)costaccountId, (String)"cal_bd_costaccount");
        DynamicObject currencyDyn = CurrencyHelper.getCurrencyDyn(costAccount);
        if (currencyDyn != null) {
            return currencyDyn.getInt("amtprecision");
        }
        return null;
    }

    public static Long getCurrency(DynamicObject costAccount) {
        if (costAccount == null) {
            return null;
        }
        DynamicObject calpolicy = costAccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return null;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        if (result == null) {
            return null;
        }
        return result.getLong("currency");
    }

    public static DynamicObject getCurrencyDyn(DynamicObject costaccount) {
        if (costaccount == null) {
            return null;
        }
        DynamicObject calpolicy = costaccount.getDynamicObject("calpolicy");
        if (calpolicy == null) {
            return null;
        }
        DynamicObject result = QueryServiceHelper.queryOne((String)"cal_bd_calpolicy", (String)"currency, currency.amtprecision AS amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calpolicy.getLong("id"))});
        return result;
    }

    public static Long getCurrency(String costAccountNumber) {
        if (CadEmptyUtils.isEmpty(costAccountNumber)) {
            return null;
        }
        QFilter costAccountNumberFilter = new QFilter("number", "=", (Object)costAccountNumber);
        List ids = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])new QFilter[]{costAccountNumberFilter}, null, (int)1);
        if (CadEmptyUtils.isEmpty(ids)) {
            return null;
        }
        DynamicObject costAccount = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)"cal_bd_costaccount");
        return CurrencyHelper.getCurrency(costAccount);
    }
}

