/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class DiffHelper {
    private static Set<Long> getAllProCostCenters(Long orgId) {
        if (CadEmptyUtils.isEmpty(orgId)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)orgId));
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        filters.add(new QFilter("orgduty", "=", (Object)4L));
        DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (CadEmptyUtils.isEmpty(costCenters)) {
            return Sets.newHashSetWithExpectedSize((int)0);
        }
        HashSet centerIds = Sets.newHashSetWithExpectedSize((int)costCenters.size());
        for (DynamicObject center : costCenters) {
            Long id = center.getLong("id");
            centerIds.add(id);
        }
        return centerIds;
    }

    private static Map<String, DynamicObject> getRulesMap(Long acctOrgId, List<Long> costCenterIds) {
        HashMap<String, DynamicObject> acctOrgRulesMap = new HashMap<String, DynamicObject>(16);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("accountorg", "=", (Object)acctOrgId));
        filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
        filters.add(new QFilter("status", "=", (Object)"C"));
        QFilter costCenterQf = new QFilter("costcenter", "in", costCenterIds).or(new QFilter("costcenter", "=", (Object)0L));
        filters.add(costCenterQf);
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass,rulenumberext,rulenameext", (QFilter[])filters.toArray(new QFilter[0]));
        for (DynamicObject rule : rules) {
            String accountOrg = rule.getString("accountorg");
            String costCenter = rule.getString("costcenter");
            if (CadEmptyUtils.isEmpty(costCenter)) {
                acctOrgRulesMap.put(accountOrg, rule);
                continue;
            }
            acctOrgRulesMap.put(accountOrg.concat(costCenter), rule);
        }
        return acctOrgRulesMap;
    }

    public static List<Long> getEnableCostCenters(Long acctOrgId, String entityId, String appNum) {
        Set<Long> allProCostCenters = DiffHelper.getAllProCostCenters(acctOrgId);
        List<Long> enableCostCenters = ImportServiceHelper.getCostCenterByDataRule(Long.parseLong(RequestContext.get().getUserId()), Collections.singletonList(acctOrgId), Sets.newHashSet(allProCostCenters), entityId, appNum);
        if (CadEmptyUtils.isEmpty(enableCostCenters)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        return enableCostCenters;
    }

    public static Map<String, List<Long>> getCalMethodCostCenters(Long acctOrgId, String entityId, String appNum) {
        if (CadEmptyUtils.isEmpty(acctOrgId) || StringUtils.isEmpty((String)entityId) || StringUtils.isEmpty((String)appNum)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        List<Long> enableCostCenters = DiffHelper.getEnableCostCenters(acctOrgId, entityId, appNum);
        Map<String, DynamicObject> objRules = DiffHelper.getRulesMap(acctOrgId, enableCostCenters);
        if (CadEmptyUtils.isEmpty(objRules) || enableCostCenters.size() == 1 && !objRules.containsKey(acctOrgId.toString().concat(enableCostCenters.get(0).toString())) && !objRules.containsKey(acctOrgId.toString())) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        return CostObjectHelper.groupCostCenterByRules(acctOrgId, enableCostCenters, objRules);
    }

    public static QFilter getCollectTimeRange(Long orgId, String field, String appNum, CollectReport collectReport) {
        if (CadEmptyUtils.isEmpty(orgId) || StringUtils.isEmpty((String)field) || StringUtils.isEmpty((String)appNum) || collectReport == null) {
            return null;
        }
        return SysParamHelper.getImportTimeScope(orgId, field, appNum, collectReport);
    }

    public static Map<String, Set<Long>> getUnNeedBillTransactionsMap(Long orgId, String collectionBillType, String appNum) {
        if (CadEmptyUtils.isEmpty(orgId) || CadEmptyUtils.isEmpty(collectionBillType) || CadEmptyUtils.isEmpty(appNum)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionBillType);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.SysParamHelper#getNotNeedCollectBillBizIdsMap", (String)"cad_costcollectionsetting", (String)"bizsettingentry.sourcebill sourcebill,bizsettingentry.transactiontype.fbasedataid.id transaction", (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        for (Row row : ccSetting) {
            String sourceBill = row.getString("sourceBill");
            Long transaction = row.getLong("transaction");
            resultMap.computeIfAbsent(sourceBill, tran -> new HashSet()).add(transaction);
        }
        return resultMap;
    }

    public static Map<String, Set<Long>> getUnNeedBillBizTypesMap(Long orgId, String collectionBillType, String appNum) {
        if (CadEmptyUtils.isEmpty(orgId) || StringUtils.isEmpty((String)collectionBillType) || StringUtils.isEmpty((String)appNum)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionBillType);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.SysParamHelper#getNotNeedCollectBillBizIdsMap", (String)"cad_costcollectionsetting", (String)"bizsettingentry.sourcebill sourcebill,bizsettingentry.biztype.fbasedataid.id biztype", (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        for (Row row : ccSetting) {
            String sourceBill = row.getString("sourceBill");
            Long bizType = row.getLong("biztype");
            resultMap.computeIfAbsent(sourceBill, tran -> new HashSet()).add(bizType);
        }
        return resultMap;
    }

    public static Map<String, Set<Long>> getUnNeedBillInvSchemesMap(Long orgId, String collectionBillType, String appNum) {
        if (CadEmptyUtils.isEmpty(orgId) || StringUtils.isEmpty((String)collectionBillType) || StringUtils.isEmpty((String)appNum)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(16);
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("bizsettingentry.collectionbill", "=", (Object)collectionBillType);
        filter.and("appnum", "=", (Object)appNum);
        DataSet ccSetting = QueryServiceHelper.queryDataSet((String)"kd.macc.cad.common.helper.SysParamHelper#getNotNeedCollectBillBizIdsMap", (String)"cad_costcollectionsetting", (String)"bizsettingentry.sourcebill sourcebill,bizsettingentry.invscheme.fbasedataid.id invscheme", (QFilter[])new QFilter[]{filter}, null);
        if (ccSetting == null) {
            return resultMap;
        }
        for (Row row : ccSetting) {
            String sourceBill = row.getString("sourceBill");
            Long invScheme = row.getLong("invscheme");
            resultMap.computeIfAbsent(sourceBill, tran -> new HashSet()).add(invScheme);
        }
        return resultMap;
    }

    public static Map<Long, String> getCostCenterCalTypeMap(Long orgId, Set<Long> costCenters) {
        HashMap resultMap;
        block6: {
            DynamicObject orgRule;
            HashSet copy;
            block5: {
                if (CadEmptyUtils.isEmpty(orgId) || costCenters == null || costCenters.isEmpty()) {
                    return Maps.newHashMapWithExpectedSize((int)0);
                }
                resultMap = Maps.newHashMapWithExpectedSize((int)0);
                copy = Sets.newHashSet(costCenters);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                QFilter costcenterQF = new QFilter("costcenter", "in", costCenters);
                filters.add(new QFilter("accountorg", "=", (Object)orgId));
                filters.add(costcenterQF);
                filters.add(new QFilter("enable", "=", (Object)Boolean.TRUE));
                filters.add(new QFilter("status", "=", (Object)"C"));
                DynamicObjectCollection rules = QueryServiceHelper.query((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass", (QFilter[])filters.toArray(new QFilter[0]));
                filters.remove(costcenterQF);
                costcenterQF = new QFilter("costcenter", "=", (Object)0L);
                filters.add(costcenterQF);
                orgRule = QueryServiceHelper.queryOne((String)"cad_costobjectrule", (String)"id,accountorg,costcenter,biztype,sotype,rule,objrule,objruleass,objrulename,objrulenameass,pnorule,pnoruleass", (QFilter[])filters.toArray(new QFilter[0]));
                if (rules == null || rules.isEmpty()) break block5;
                for (DynamicObject rule : rules) {
                    long costCenter = rule.getLong("costcenter");
                    String bizType = rule.getString("biztype");
                    resultMap.put(costCenter, bizType);
                    copy.remove(costCenter);
                }
                if (orgRule == null) break block6;
                for (Long costCenter : copy) {
                    resultMap.put(costCenter, orgRule.getString("biztype"));
                }
                break block6;
            }
            if (orgRule != null) {
                for (Long costCenter : copy) {
                    resultMap.put(costCenter, orgRule.getString("biztype"));
                }
            }
        }
        return resultMap;
    }

    public static Map<Long, String> getCostCenterRangeBillMap(Long orgId, List<Long> costCenters, String billType, String appNum) {
        HashMap ccRangeMap;
        block8: {
            DynamicObject orgSysParam;
            ArrayList costCentersCopy;
            block7: {
                if (CadEmptyUtils.isEmpty(orgId) || costCenters == null || costCenters.size() == 0 || StringUtils.isEmpty((String)billType) || StringUtils.isEmpty((String)appNum)) {
                    return Maps.newHashMapWithExpectedSize((int)0);
                }
                costCentersCopy = Lists.newArrayList(costCenters);
                ccRangeMap = Maps.newHashMapWithExpectedSize((int)8);
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
                if (!CadEmptyUtils.isEmpty(orgId)) {
                    filters.add(orgQf);
                }
                if (!CadEmptyUtils.isEmpty(costCentersCopy)) {
                    filters.add(new QFilter("costcenter", "in", (Object)costCentersCopy));
                }
                filters.add(new QFilter("appnum", "=", (Object)appNum));
                DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)"costcenter,".concat(billType), (QFilter[])filters.toArray(new QFilter[0]));
                filters.clear();
                filters.add(orgQf);
                filters.add(new QFilter("appnum", "=", (Object)appNum));
                filters.add(new QFilter("costcenter", "=", (Object)0L));
                orgSysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"costcenter,".concat(billType), (QFilter[])filters.toArray(new QFilter[0]));
                if (sysParams == null || sysParams.size() <= 0) break block7;
                for (DynamicObject sysParam : sysParams) {
                    String completeCollectRange = sysParam.getString(billType);
                    long costCenter = sysParam.getLong("costcenter");
                    ccRangeMap.put(costCenter, completeCollectRange);
                    costCentersCopy.remove(costCenter);
                }
                if (costCentersCopy.isEmpty() || orgSysParam == null) break block8;
                String completeCollectRange = orgSysParam.getString(billType);
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, completeCollectRange);
                }
                break block8;
            }
            if (!costCentersCopy.isEmpty() && orgSysParam != null) {
                String completeCollectRange = orgSysParam.getString(billType);
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, completeCollectRange);
                }
            }
        }
        return ccRangeMap;
    }

    public static Map<Long, String> getCostCenterNameMap(List<Long> allCostCenters) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)0);
        if (!CollectionUtils.isEmpty(allCostCenters)) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "in", allCostCenters));
            filters.add(new QFilter("status", "=", (Object)"C"));
            filters.add(new QFilter("enable", "=", (Object)true));
            DynamicObjectCollection costCenters = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])filters.toArray(new QFilter[0]));
            if (costCenters != null && !costCenters.isEmpty()) {
                for (DynamicObject costCenter : costCenters) {
                    resultMap.put(costCenter.getLong("id"), costCenter.getString("name"));
                }
            }
        }
        return resultMap;
    }
}

