/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.MainEntityType;
import kd.bos.form.field.ComboItem;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class DynamicObjectHelper {
    public static List<Object> getFieldList(DynamicObjectCollection collec, String field) {
        ArrayList<Object> list = new ArrayList<Object>(16);
        if (collec == null || collec.isEmpty()) {
            return list;
        }
        for (DynamicObject dy : collec) {
            list.add(dy.get(field));
        }
        return list;
    }

    public static Set<Object> getFieldSet(DynamicObjectCollection collec, String field) {
        HashSet<Object> set = new HashSet<Object>(16);
        if (collec == null || collec.isEmpty()) {
            return set;
        }
        for (DynamicObject dy : collec) {
            set.add(dy.get(field));
        }
        return set;
    }

    public static List<Long> getIdList(DynamicObjectCollection collec, String field) {
        ArrayList<Long> list = new ArrayList<Long>();
        for (DynamicObject dy : collec) {
            list.add(dy.getLong(field));
        }
        return list;
    }

    public static Set<Long> getIdSet(DynamicObjectCollection collec, String field) {
        HashSet<Long> set = new HashSet<Long>(16);
        for (DynamicObject dy : collec) {
            set.add(dy.getLong(field));
        }
        return set;
    }

    public static List<ComboItem> toComboItem(DynamicObjectCollection collec) {
        ArrayList<ComboItem> comboList = new ArrayList<ComboItem>();
        if (CadEmptyUtils.isEmpty(collec)) {
            return comboList;
        }
        for (DynamicObject dynamicObject : collec) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(dynamicObject.getString("name")));
            item.setValue(dynamicObject.getString("id"));
            if (comboList.contains(item)) continue;
            comboList.add(item);
        }
        return comboList;
    }

    public static DynamicObject fromDynamicString(String value, MainEntityType entityType) {
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)entityType);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return (DynamicObject)jser.deserializeFromString(value, null);
    }

    public static String toDynamicObjectJson(DynamicObject obj) {
        DynamicObjectType type = obj.getDynamicObjectType();
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(type);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        jser.setIsLocaleValueFull(true);
        jser.setSerializeComplexProperty(true);
        binder.setOnlyDbProperty(false);
        return jser.serializeToString((Object)obj, null);
    }
}

