/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EffectiveHelper {
    private EffectiveHelper() {
    }

    public boolean isEffective(long orgId, String entityId, String appNum) {
        QFilter acctOrgFilter = new QFilter("actorg", "=", (Object)orgId);
        acctOrgFilter.and("tab", "=", (Object)"settingtabpage");
        acctOrgFilter.and("appnum", "=", (Object)appNum);
        DynamicObject sysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)"id,actorg,effectcontrol,appnum", (QFilter[])new QFilter[]{acctOrgFilter});
        if (sysParam == null) {
            return false;
        }
        String effectControl = sysParam.getString("effectcontrol");
        return effectControl.contains(entityId);
    }

    public static void buildEffectStatusFilterColumn(FilterContainerInitArgs args) {
        CommonFilterColumn effectStatusCol;
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (!filterColumnList.contains(effectStatusCol = EffectiveHelper.buildEffectStatusCol())) {
            filterColumnList.add(effectStatusCol);
        }
        for (FilterColumn filterColumn : filterColumnList) {
            String fieldName = filterColumn.getFieldName();
            if (!fieldName.equals("effectstatus")) continue;
            filterColumn.setDefaultValue("1");
        }
    }

    private static CommonFilterColumn buildEffectStatusCol() {
        CommonFilterColumn commonFilterColumn = new CommonFilterColumn();
        commonFilterColumn.setFieldName("effectstatus");
        commonFilterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001", (String)"EffectiveHelper_0", (String)"macc-cad-common", (Object[])new Object[0])));
        commonFilterColumn.setKey("effectstatus");
        commonFilterColumn.setType("enum");
        commonFilterColumn.setComboItems((List)Lists.newArrayList((Object[])new ComboItem[]{new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4e0d\u9650", (String)"EffectiveHelper_1", (String)"macc-cad-common", (Object[])new Object[0])), ""), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6709\u6548", (String)"EffectiveHelper_2", (String)"macc-cad-common", (Object[])new Object[0])), "1"), new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5931\u6548", (String)"EffectiveHelper_3", (String)"macc-cad-common", (Object[])new Object[0])), "0")}));
        return commonFilterColumn;
    }
}

