/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.olap.util.Pair;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.ElementConstant;
import kd.macc.cad.common.dto.SubElementAndMatParam;
import kd.macc.cad.common.dto.SubElementAndMatReturnDataParam;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ElementHelper {
    private static final Log logger = LogFactory.getLog(ElementHelper.class);

    public static void setElement(PropertyChangedArgs e, IFormView formView) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject subEle = (DynamicObject)formView.getModel().getValue("subelement", rowIndex);
        if (subEle == null) {
            return;
        }
        long subElementId = subEle.getLong("id");
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject dySubElement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{qfSubElement});
        if (dySubElement != null) {
            formView.getModel().setValue("element", (Object)dySubElement.getLong("element"), rowIndex);
        }
    }

    public static void elementAndSubEleF7Setting(IDataModel model, AbstractBillPlugIn billPlugIn, Set<Long> selectedSubElementIds) {
        BasedataEdit elementCtrl = (BasedataEdit)billPlugIn.getControl("element");
        elementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject subElement = (DynamicObject)model.getValue("subelement", beforeF7SelectEvent.getRow());
            if (subElement != null) {
                ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)ElementRelationHelper.getElement(subElement.getLong("id"))));
            }
        });
        BasedataEdit subElementCtrl = (BasedataEdit)billPlugIn.getControl("subelement");
        subElementCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = showParameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject element = (DynamicObject)model.getValue("element", beforeF7SelectEvent.getRow());
            if (element != null) {
                Set<Long> subElementIds = ElementRelationHelper.getSubElement(element);
                if (selectedSubElementIds != null && selectedSubElementIds.size() > 0) {
                    subElementIds.removeAll(selectedSubElementIds);
                }
                qList.add(new QFilter("id", "in", subElementIds));
            } else if (selectedSubElementIds != null && selectedSubElementIds.size() > 0) {
                qList.add(new QFilter("id", "not in", (Object)selectedSubElementIds));
            }
        });
    }

    public static Map<Long, Long[]> getDefSubEles(Long orgId, Set<Long> matIds) {
        return ElementHelper.getDefSubEles(orgId, matIds, true);
    }

    public static Map<Long, Long[]> getDefSubEles(Long orgId, Set<Long> matIds, boolean isGetDefSubElement) {
        HashMap<Long, Long[]> matToSubEleMap = new HashMap<Long, Long[]>(16);
        if (matIds == null || matIds.isEmpty()) {
            return matToSubEleMap;
        }
        return (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"SubElementAndMatService", (String)"getSubElementByOrg", (Object[])new Object[]{orgId, matIds, new Date(), isGetDefSubElement});
    }

    public static SubElementAndMatReturnDataParam getAcaSubElementByOrg(Long orgId, Long manuorgId, Set<Long> matIdSet, Date startBookDate, Date endBookDate) {
        if (CollectionUtils.isEmpty(matIdSet) || startBookDate == null || endBookDate == null) {
            return null;
        }
        ArrayList<QFilter> qf = new ArrayList<QFilter>(10);
        qf.add(new QFilter("org", "=", (Object)orgId));
        qf.add(new QFilter("expdate", ">=", (Object)startBookDate));
        qf.add(new QFilter("effectdate", "<=", (Object)endBookDate));
        qf.add(new QFilter("status", "=", (Object)"C"));
        if (manuorgId != null && manuorgId != 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            ids.add(manuorgId);
            qf.add(new QFilter("manuorg", "in", ids));
        } else {
            List<Long> manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, "aca_subelementandmat", "aca");
            manuorgList.add(0L);
            qf.add(new QFilter("manuorg", "in", manuorgList));
        }
        DataSet subEleMatDataSet = QueryServiceHelper.queryDataSet((String)"getAcaSubElementByOrg", (String)"aca_subelementandmat", (String)"manuorg,subelement,effectdate,expdate,entryentity.material as materialId, entryentity.matversion as matversionId,entryentity.auxpty as auxptyId, entryentity.materialgroup as materialgroupId", (QFilter[])qf.toArray(new QFilter[0]), (String)"manuorg,effectdate");
        HashMap<String, SubElementAndMatParam> subEle2MatRelMap = new HashMap<String, SubElementAndMatParam>(matIdSet.size());
        HashMap<String, List<Tuple<Integer, SubElementAndMatParam>>> subEle2GroupMatRelMap = new HashMap<String, List<Tuple<Integer, SubElementAndMatParam>>>(matIdSet.size());
        DataSet materialGroupDataSet = subEleMatDataSet.copy().filter("materialgroupId is not null and materialgroupId !=0");
        Map<Long, Tuple<Integer, Set<Long>>> groupToMatIdMap = ElementHelper.getGroupToMatIdMap(materialGroupDataSet, matIdSet);
        logger.info("\u7269\u6599\u5206\u7c7b\u6807\u51c6\u7684\u5c42\u7ea7\u7ed3\u6784\u7684\u5b50\u8981\u7d20\u6570\u636e {}", groupToMatIdMap);
        HashSet<Long> subElementSetIds = new HashSet<Long>(64);
        for (Row row : subEleMatDataSet) {
            Tuple<Integer, Set<Long>> levelMatIdsSetTuple;
            Long subelement = row.getLong("subelement");
            if (subelement != null && subelement != 0L) {
                subElementSetIds.add(subelement);
            }
            String materialId = row.getString("materialId");
            Long materialgroupId = row.getLong("materialgroupId");
            if (!StringUtils.isEmpty((String)materialId) && !"0".equals(materialId)) {
                ElementHelper.setMatSubElementAndMatParam(row, subEle2MatRelMap, materialId);
                continue;
            }
            if (materialgroupId == null || 0L == materialgroupId || (levelMatIdsSetTuple = groupToMatIdMap.get(materialgroupId)) == null) continue;
            Set groupMaterialIdSet = (Set)levelMatIdsSetTuple.item2;
            Integer level = (Integer)levelMatIdsSetTuple.item1;
            for (Long groupMaterialId : groupMaterialIdSet) {
                ElementHelper.setGroupMatSubElementAndMatParam(row, subEle2GroupMatRelMap, String.valueOf(groupMaterialId), level);
            }
        }
        HashMap<Long, Long> subEleToEleMap = new HashMap<Long, Long>(64);
        QFilter subQf = new QFilter("subelement", "in", subElementSetIds);
        if (!subElementSetIds.isEmpty()) {
            DynamicObjectCollection subEleRels = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element, subelement", (QFilter[])new QFilter[]{subQf});
            subEleRels.forEach(s -> subEleToEleMap.put(s.getLong("subelement"), s.getLong("element")));
        }
        Long defaultSubElementId = null;
        Long defaultElementId = null;
        QFilter defSubEleQf = new QFilter("element", "=", (Object)ElementConstant.MATERIAL_ID);
        defSubEleQf.and(new QFilter("subelement.defaultvalue", "=", (Object)true));
        DynamicObjectCollection subEleRels = QueryServiceHelper.query((String)"cad_elementdetail", (String)"element, subelement", (QFilter[])new QFilter[]{defSubEleQf});
        if (!subEleRels.isEmpty()) {
            DynamicObject subEleRel = (DynamicObject)subEleRels.get(0);
            defaultSubElementId = subEleRel.getLong("subelement");
            defaultElementId = subEleRel.getLong("element");
        }
        return new SubElementAndMatReturnDataParam(defaultSubElementId, defaultElementId, subEleToEleMap, subEle2MatRelMap, subEle2GroupMatRelMap);
    }

    private static void setMatSubElementAndMatParam(Row row, Map<String, SubElementAndMatParam> subEle2MatRelMap, String materialId) {
        Long subelement = row.getLong("subelement");
        Long matVersionId = row.getLong("matversionId");
        Long auxptyId = row.getLong("auxptyId");
        Long manuorg = row.getLong("manuorg");
        Date effectdate = row.getDate("effectdate");
        Date expdate = row.getDate("expdate");
        materialId = ElementHelper.getStrKey(materialId, matVersionId, auxptyId, manuorg, null);
        SubElementAndMatParam subElementAndMatParam = subEle2MatRelMap.get(materialId);
        SubElementAndMatParam subElementAndMatParamNow = new SubElementAndMatParam(subelement, effectdate, expdate);
        subEle2MatRelMap.put(materialId, ElementHelper.nextTimeMatParamSetParam(subElementAndMatParam, subElementAndMatParamNow));
    }

    private static void setGroupMatSubElementAndMatParam(Row row, Map<String, List<Tuple<Integer, SubElementAndMatParam>>> subEle2GroupMatRelMap, String materialId, Integer level) {
        Long subelement = row.getLong("subelement");
        Long manuorg = row.getLong("manuorg");
        Date effectdate = row.getDate("effectdate");
        Date expdate = row.getDate("expdate");
        materialId = ElementHelper.getStrKey(materialId, 0L, 0L, manuorg, null);
        List<Tuple<Integer, SubElementAndMatParam>> tuples = subEle2GroupMatRelMap.get(materialId);
        Boolean isAddFlag = false;
        if (tuples == null) {
            tuples = new ArrayList<Tuple<Integer, SubElementAndMatParam>>();
            isAddFlag = true;
        }
        SubElementAndMatParam subElementAndMatParam = null;
        for (Tuple<Integer, SubElementAndMatParam> tuple : tuples) {
            if (Integer.compare(level, (Integer)tuple.item1) != 0) continue;
            subElementAndMatParam = (SubElementAndMatParam)tuple.item2;
        }
        if (subElementAndMatParam == null) {
            isAddFlag = true;
        }
        SubElementAndMatParam subElementAndMatParamNow = new SubElementAndMatParam(subelement, effectdate, expdate);
        SubElementAndMatParam subElementAndMatParam1 = ElementHelper.nextTimeMatParamSetParam(subElementAndMatParam, subElementAndMatParamNow);
        if (isAddFlag.booleanValue()) {
            tuples.add((Tuple<Integer, SubElementAndMatParam>)new Tuple((Object)level, (Object)subElementAndMatParam1));
            subEle2GroupMatRelMap.put(materialId, tuples);
        }
    }

    public static String getStrKey(String materialId, Long matVersionId, Long auxptyId, Long manuorg, Date createDate) {
        materialId = CadEmptyUtils.isEmpty(matVersionId) ? materialId + "@0" : materialId + "@" + matVersionId;
        materialId = CadEmptyUtils.isEmpty(auxptyId) ? materialId + "@0" : materialId + "@" + auxptyId;
        String string = materialId = CadEmptyUtils.isEmpty(manuorg) ? materialId + "@0" : materialId + "@" + manuorg;
        if (createDate != null) {
            materialId = materialId + "@" + createDate.getTime();
        }
        return materialId;
    }

    private static Map<Long, Tuple<Integer, Set<Long>>> getGroupToMatIdMap(DataSet materialGroupDataSet, Set<Long> matIdSet) {
        HashSet<Long> materialGroupIdSet = new HashSet<Long>(32);
        materialGroupDataSet.forEach(o -> materialGroupIdSet.add(o.getLong("materialgroupId")));
        QFilter matIdFilter = new QFilter("id", "in", matIdSet);
        DataSet tmpDataSet = QueryServiceHelper.queryDataSet((String)"getGroupToMatIdMap", (String)"bd_material", (String)"id,group", (QFilter[])matIdFilter.toArray(), (String)"group");
        HashMap<Long, Tuple<Integer, Set<Long>>> groupIdToMatIdReturnMap = new HashMap<Long, Tuple<Integer, Set<Long>>>();
        HashMap<Long, Set<Long>> groupIdToMatIdMap = new HashMap<Long, Set<Long>>();
        HashSet<Long> nowGroupIds = new HashSet<Long>();
        tmpDataSet.forEach(o -> {
            nowGroupIds.add(o.getLong("group"));
            groupIdToMatIdMap.computeIfAbsent(o.getLong("group"), s -> new HashSet()).add(o.getLong("id"));
        });
        for (Map.Entry entry : groupIdToMatIdMap.entrySet()) {
            Long group = (Long)entry.getKey();
            if (!materialGroupIdSet.remove(group)) continue;
            groupIdToMatIdReturnMap.put(group, (Tuple<Integer, Set<Long>>)new Tuple((Object)0, new HashSet((Collection)entry.getValue())));
        }
        HashMap<Long, Set<Long>> parentToSonGroups = new HashMap<Long, Set<Long>>();
        ElementHelper.getParentGroupData(materialGroupIdSet, groupIdToMatIdMap, nowGroupIds, parentToSonGroups, groupIdToMatIdReturnMap);
        logger.info("\u672a\u5339\u914d\u4e0a\u7684\u7269\u6599\u5206\u7c7b\u8303\u56f4 {}", materialGroupIdSet);
        return groupIdToMatIdReturnMap;
    }

    private static void getParentGroupData(HashSet<Long> materialGroupIdSet, HashMap<Long, Set<Long>> groupIdToMatIdMap, HashSet<Long> nowGroupIds, HashMap<Long, Set<Long>> parentToSonGroups, HashMap<Long, Tuple<Integer, Set<Long>>> groupIdToMatIdReturnMap) {
        if (CadEmptyUtils.isEmpty(materialGroupIdSet) || CadEmptyUtils.isEmpty(nowGroupIds)) {
            return;
        }
        DataSet nowGroupAndParentDataSet = QueryServiceHelper.queryDataSet((String)"getParentGroupData", (String)"bd_materialgroup", (String)"id,parent", (QFilter[])new QFilter[]{new QFilter("id", "in", nowGroupIds)}, null);
        nowGroupIds.clear();
        for (Row row : nowGroupAndParentDataSet) {
            Long id = row.getLong("id");
            Long parent = row.getLong("parent");
            if (CadEmptyUtils.isEmpty(parent)) continue;
            Set<Long> sonGroupSet = parentToSonGroups.get(parent);
            if (sonGroupSet == null) {
                sonGroupSet = new HashSet<Long>();
            }
            sonGroupSet.add(id);
            parentToSonGroups.put(parent, sonGroupSet);
            nowGroupIds.add(parent);
        }
        if (nowGroupIds.size() > 0) {
            logger.info("\u5f53\u524d\u5c42\u7684\u7269\u6599\u5206\u7c7b{}  \u7236\u5b50\u5173\u7cfb\u7ed3\u6784 {}", nowGroupIds, parentToSonGroups);
            for (Long nowGroupId : nowGroupIds) {
                if (!materialGroupIdSet.remove(nowGroupId)) continue;
                HashSet<Long> minSonGroup = new HashSet<Long>();
                int level = ElementHelper.getNowGroupIdToMinSonGroup(nowGroupId, parentToSonGroups, minSonGroup, 0);
                Set<Long> materialFromGroup = ElementHelper.getMaterialFromGroup(minSonGroup, groupIdToMatIdMap);
                if (!CadEmptyUtils.isEmpty(materialFromGroup)) {
                    groupIdToMatIdReturnMap.put(nowGroupId, (Tuple<Integer, Set<Long>>)new Tuple((Object)level, materialFromGroup));
                    continue;
                }
                logger.error("\u5f53\u524d\u7269\u6599\u5206\u7c7b{}\uff0c\u672a\u627e\u5230\u5e95\u5c42\u7269\u6599,\u8bf7\u68c0\u67e5\u6570\u636e,\u548c\u5206\u7c7b\u7236\u5b50\u5173\u7cfb", (Object)nowGroupId, parentToSonGroups);
            }
            ElementHelper.getParentGroupData(materialGroupIdSet, groupIdToMatIdMap, nowGroupIds, parentToSonGroups, groupIdToMatIdReturnMap);
        }
    }

    private static Set<Long> getMaterialFromGroup(Set<Long> minSonGroup, Map<Long, Set<Long>> groupIdToMatIdMap) {
        if (minSonGroup.size() < 1) {
            return null;
        }
        HashSet<Long> returnMatIds = new HashSet<Long>();
        for (Long minSonGroupId : minSonGroup) {
            Set<Long> matIds = groupIdToMatIdMap.get(minSonGroupId);
            if (CadEmptyUtils.isEmpty(matIds)) {
                logger.error("getMaterialFromGroup \u901a\u8fc7\u6700\u5e95\u5c42\u7684\u7269\u6599\u5206\u7c7b{}\u672a\u83b7\u53d6\u5230 \u7269\u6599 ,\u68c0\u67e5 \u7269\u6599\u5173\u7cfb\u9519\u8bef. groupIdToMatIdMap{}", (Object)minSonGroupId, groupIdToMatIdMap);
                continue;
            }
            returnMatIds.addAll(matIds);
        }
        return returnMatIds;
    }

    private static int getNowGroupIdToMinSonGroup(Long nowGroupId, HashMap<Long, Set<Long>> parentToSonGroups, Set<Long> minSonGroup, int level) {
        Set<Long> sonGroups = parentToSonGroups.get(nowGroupId);
        int count = level++;
        if (sonGroups != null) {
            for (Long sonGroup : sonGroups) {
                count = ElementHelper.getNowGroupIdToMinSonGroup(sonGroup, parentToSonGroups, minSonGroup, level);
            }
        } else {
            minSonGroup.add(nowGroupId);
        }
        return count;
    }

    private static SubElementAndMatParam nextTimeMatParamSetParam(SubElementAndMatParam manuorgToMatMapParam, SubElementAndMatParam subElementAndMatParamNow) {
        if (manuorgToMatMapParam == null) {
            return subElementAndMatParamNow;
        }
        SubElementAndMatParam nexTimeMatParam = manuorgToMatMapParam.getNexTimeMatParam();
        SubElementAndMatParam subElementAndMatParam = ElementHelper.nextTimeMatParamSetParam(nexTimeMatParam, subElementAndMatParamNow);
        manuorgToMatMapParam.setNexTimeMatParam(subElementAndMatParam);
        return manuorgToMatMapParam;
    }

    public static Pair<Long, Long> matToSubEleAndEle(Long materialId, Long matVersionId, Long auxptyId, Long manuorgId, Date bookdate, SubElementAndMatReturnDataParam acaSubElementByOrg) {
        if (materialId != null && materialId != 0L && bookdate != null) {
            Map<String, SubElementAndMatParam> subEle2MatRelMap = acaSubElementByOrg.getSubEle2MatRelMap();
            Map<String, List<Tuple<Integer, SubElementAndMatParam>>> subEle2GroupMatRelMap = acaSubElementByOrg.getSubEle2GroupMatRelMap();
            Map<Long, Long> subEleToEleMap = acaSubElementByOrg.getSubEleToEleMap();
            String materialIdStr = String.valueOf(materialId);
            String materialManuorgStr = ElementHelper.getStrKey(materialIdStr, matVersionId, auxptyId, 0L, null);
            SubElementAndMatParam subElementAndMatParam = subEle2MatRelMap.get(materialManuorgStr);
            Long subElementId = ElementHelper.getSubEleForSubElementAndMat(bookdate, subElementAndMatParam);
            if (subElementId == null) {
                String strKeyWithOutAuxpty = ElementHelper.getStrKey(materialIdStr, 0L, 0L, 0L, null);
                subElementAndMatParam = subEle2MatRelMap.get(strKeyWithOutAuxpty);
                subElementId = ElementHelper.getSubEleForSubElementAndMat(bookdate, subElementAndMatParam);
            }
            if (subElementId == null) {
                String strGroupKey = ElementHelper.getStrKey(materialIdStr, 0L, 0L, 0L, null);
                subElementId = ElementHelper.getSubEleIdByGroup(bookdate, subEle2GroupMatRelMap, strGroupKey);
            }
            Long elementId = null;
            if (!CadEmptyUtils.isEmpty(manuorgId)) {
                String keyStrByOrg = ElementHelper.getStrKey(materialIdStr, matVersionId, auxptyId, 0L, null);
                if (subElementId == null) {
                    subElementAndMatParam = subEle2MatRelMap.get(keyStrByOrg);
                    subElementId = ElementHelper.getSubEleForSubElementAndMat(bookdate, subElementAndMatParam);
                }
                if (subElementId == null) {
                    String strGroupKey = ElementHelper.getStrKey(materialIdStr, 0L, 0L, 0L, null);
                    subElementId = ElementHelper.getSubEleIdByGroup(bookdate, subEle2GroupMatRelMap, strGroupKey);
                }
            }
            if (subElementId == null) {
                subElementId = acaSubElementByOrg.getDefaultSubElementId();
                elementId = acaSubElementByOrg.getDefaultElementId();
            } else {
                elementId = subEleToEleMap.get(subElementId);
            }
            if (elementId == null) {
                elementId = acaSubElementByOrg.getDefaultElementId();
                subElementId = acaSubElementByOrg.getDefaultSubElementId();
                logger.info("\u6210\u672c\u8981\u7d20\u4e3a\u7a7a,\u68c0\u67e5\u6210\u672c\u8981\u7d20\u4e0e\u5b50\u8981\u7d20\u5173\u7cfb" + (subElementId == null ? 0L : subElementId));
            }
            return new Pair((Object)elementId, (Object)subElementId);
        }
        return null;
    }

    private static Long getSubEleIdByGroup(Date bookdate, Map<String, List<Tuple<Integer, SubElementAndMatParam>>> subEle2GroupMatRelMap, String strGroupKey) {
        List<Tuple<Integer, SubElementAndMatParam>> tuples = subEle2GroupMatRelMap.get(strGroupKey);
        Long subElementId = null;
        if (tuples != null) {
            Collections.sort(tuples, (o1, o2) -> ((Integer)o1.item1).compareTo((Integer)o2.item1));
            for (Tuple<Integer, SubElementAndMatParam> tuple : tuples) {
                SubElementAndMatParam subElementAndMatParam = (SubElementAndMatParam)tuple.item2;
                subElementId = ElementHelper.getSubEleForSubElementAndMat(bookdate, subElementAndMatParam);
                if (subElementId == null) continue;
                break;
            }
            logger.info("\u4ece strGroupKey{} \u83b7\u53d6\u83b7\u53d6\u7684\u5bf9\u5e94 \u5c42\u7ea7\u7ed3\u6784\u4e3a{}", (Object)strGroupKey, tuples);
        } else {
            logger.info("\u4ece strGroupKey{} \u83b7\u53d6\u83b7\u53d6\u7684\u5bf9\u5e94 \u5c42\u7ea7\u7ed3\u6784\u4e3a\u7a7a", (Object)strGroupKey);
        }
        return subElementId;
    }

    private static Long getSubEleForSubElementAndMat(Date bookdate, SubElementAndMatParam subElementAndMatParam) {
        if (subElementAndMatParam == null || bookdate == null) {
            return null;
        }
        Date effectdate = subElementAndMatParam.getEffectdate();
        Date expdate = subElementAndMatParam.getExpdate();
        if (bookdate.compareTo(effectdate) >= 0 && bookdate.compareTo(expdate) < 0) {
            return subElementAndMatParam.getSubElementId();
        }
        return ElementHelper.getSubEleForSubElementAndMat(bookdate, subElementAndMatParam.getNexTimeMatParam());
    }

    public static Set<Long> getMatSubElementIds() {
        HashSet subElementIds = Sets.newHashSetWithExpectedSize((int)16);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeFilter = new QFilter("type", "=", (Object)"001");
        QFilter syncFilter = new QFilter("syncflag", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection costSubElements = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{typeFilter, enableFilter, syncFilter});
        if (costSubElements != null) {
            for (DynamicObject costSubElement : costSubElements) {
                if (costSubElement == null) continue;
                subElementIds.add(costSubElement.getLong("id"));
            }
        }
        return subElementIds;
    }
}

