/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ElementRelationHelper {
    public static List<Long> getOrgRangBy(List<Long> orgIds, String strage) {
        List<Long> list = new ArrayList<Long>();
        switch (strage) {
            case "1": 
            case "2": {
                list = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("10"), orgIds, (boolean)true);
                break;
            }
            case "5": {
                list = OrgUnitServiceHelper.getAllOrgByViewId((long)Long.parseLong("10"), (boolean)true);
                break;
            }
            case "6": {
                List listSub = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.parseLong("10"), orgIds, (boolean)true);
                if (CadEmptyUtils.isEmpty(listSub)) break;
                list.addAll(listSub);
                break;
            }
            case "7": {
                list.addAll(orgIds);
                break;
            }
        }
        return list;
    }

    public static DynamicObject[] getCostTypes() {
        return ElementRelationHelper.getCostTypesBy("0");
    }

    public static DynamicObject[] getModeCostTypes() {
        return ElementRelationHelper.getCostTypesBy("1");
    }

    public static DynamicObject[] getAllCostTypes() {
        return ElementRelationHelper.getCostTypesBy("2");
    }

    public static DynamicObject[] getCostTypesBy(String type) {
        String selectProperties = "number,name,id,type";
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(16);
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            qfilters.add(new QFilter("type", "=", (Object)type));
        } else {
            qfilters.add(new QFilter("type", "in", (Object)new String[]{"0", "1"}));
        }
        qfilters.add(new QFilter("enable", "=", (Object)true));
        qfilters.add(new QFilter("status", "=", (Object)"C"));
        QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
        if (baseDataFilter != null) {
            qfilters.add(baseDataFilter);
        }
        DynamicObject[] costTypes = BusinessDataServiceHelper.load((String)"cad_costtype", (String)selectProperties, (QFilter[])qfilters.toArray(new QFilter[0]));
        return costTypes;
    }

    public static Set<Object> getCostTypeIds(DynamicObject[] costs) {
        if (CadEmptyUtils.isEmpty(costs)) {
            return null;
        }
        TreeSet<Object> set = new TreeSet<Object>();
        for (DynamicObject cost : costs) {
            set.add(cost.getPkValue());
        }
        return set;
    }

    public static List<QFilter> getMatFiltersBy(DynamicObject ct, DynamicObject matVer) {
        Long orgId;
        QFilter matOrgFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        if (ct != null && (matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)(orgId = Long.valueOf(ct.getDynamicObject("createorg").getLong("id"))))) != null) {
            filters.add(matOrgFilter);
        }
        if (matVer != null && matVer.getDynamicObject("material") != null) {
            filters.add(new QFilter("id", "=", matVer.getDynamicObject("material").getPkValue()));
        }
        return filters;
    }

    public static List<Long> getMatIdsBy(Long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        QFilter matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)orgId);
        if (matOrgFilter != null) {
            filters.add(matOrgFilter);
        }
        DynamicObjectCollection mats = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid", (QFilter[])filters.toArray(new QFilter[0]));
        ArrayList<Long> matIds = new ArrayList<Long>();
        if (!CadEmptyUtils.isEmpty(mats)) {
            mats.forEach(s -> matIds.add(s.getLong("masterid")));
        }
        return matIds;
    }

    public static Set<Long> getSubElement(DynamicObject element) {
        Long elementId = element.getLong("id");
        HashSet<Long> subElementIds = new HashSet<Long>(16);
        QFilter elementIdFilter = new QFilter("element", "=", (Object)elementId);
        QFilter elementTypeFilter = new QFilter("elementtype", "=", (Object)element.getLong("elementtype.id"));
        QFilter typeFilter = new QFilter("subelement.type", "=", (Object)element.getString("type"));
        DynamicObjectCollection subElementIdList = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement.id", (QFilter[])new QFilter[]{elementIdFilter, elementTypeFilter, typeFilter});
        for (DynamicObject subElement : subElementIdList) {
            subElementIds.add(subElement.getLong("subelement.id"));
        }
        return subElementIds;
    }

    public static long getElement(long subElementId) {
        QFilter subElementIdFilter = new QFilter("subelement", "=", (Object)subElementId);
        DynamicObject elementRelation = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subElementIdFilter});
        return elementRelation != null ? elementRelation.getLong("element") : 0L;
    }

    public static Map<Long, Long> getSubElementIdAndElementIdMap(Set<Long> subElementIds) {
        QFilter subElementIdFilter = new QFilter("subelement", "in", subElementIds);
        DynamicObjectCollection elementRelation = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement,element", (QFilter[])new QFilter[]{subElementIdFilter});
        if (elementRelation.size() > 0) {
            return elementRelation.stream().collect(Collectors.toMap(item -> item.getLong("subelement"), item -> item.getLong("element")));
        }
        return new HashMap<Long, Long>(16);
    }

    public static DynamicObject getElement(DynamicObject subElement) {
        if (subElement == null) {
            return null;
        }
        QFilter subElementIdFilter = new QFilter("subelement", "=", subElement.getPkValue());
        DynamicObject elementRelation = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element,element.type type", (QFilter[])new QFilter[]{subElementIdFilter});
        return elementRelation;
    }

    public static DynamicObjectCollection getDefaultSubElement(QFilter elementIdFilter) {
        QFilter defaultSubElementFilter = new QFilter("subelement.defaultvalue", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection defaultSubElement = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement AS subElementId", (QFilter[])new QFilter[]{elementIdFilter, defaultSubElementFilter});
        return defaultSubElement;
    }

    public static Map<Long, Long> getMatDefSubEle(Long costTypeId, Set<Long> matIds) {
        QFilter commonQf = new QFilter("costtype", "=", (Object)costTypeId);
        commonQf.and("material", "in", matIds);
        String fields = "subelement, material";
        DynamicObjectCollection matSubEles = QueryServiceHelper.query((String)"cad_subelement_material", (String)fields, (QFilter[])new QFilter[]{commonQf});
        HashMap<Long, Long> matSubEleMap = new HashMap<Long, Long>(16);
        matSubEles.forEach(e -> matSubEleMap.put(e.getLong("material"), e.getLong("subelement")));
        matIds.removeAll(matSubEleMap.keySet());
        Long defaultMatPropSubEleId = ElementRelationHelper.getDefaultMatPropSubEleId();
        matIds.forEach(matId -> matSubEleMap.put((Long)matId, defaultMatPropSubEleId));
        return matSubEleMap;
    }

    private static Long getDefaultMatPropSubEleId() {
        DynamicObjectCollection subelements = QueryServiceHelper.query((String)"cad_elementdetail", (String)"subelement", (QFilter[])new QFilter[]{new QFilter("element.id", "=", (Object)773126985240072192L)});
        Set<Long> subElementIds = DynamicObjectHelper.getIdSet(subelements, "subelement");
        QFilter subEleQf = new QFilter("id", "in", subElementIds);
        subEleQf.and(new QFilter("enable", "=", (Object)true));
        subEleQf.and(new QFilter("status", "=", (Object)"C"));
        subEleQf.and(new QFilter("defaultvalue", "=", (Object)true));
        DynamicObjectCollection subelement = QueryServiceHelper.query((String)"cad_subelement", (String)"id", (QFilter[])new QFilter[]{subEleQf});
        if (subelement.isEmpty()) {
            return 0L;
        }
        return ((DynamicObject)subelement.get(0)).getLong("id");
    }
}

