/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.common.constants.FinalStdAnalysisRptParam;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class FinalStdAnalysisRptHelper {
    public static FinalStdAnalysisRptParam getRptParam(ReportQueryParam reportQueryParam) {
        String lots;
        String calcRecordB;
        String calcRecordA;
        DynamicObject materialgrpstd;
        FilterInfo filter = reportQueryParam.getFilter();
        FinalStdAnalysisRptParam rptParam = new FinalStdAnalysisRptParam();
        rptParam.setCostType_a(filter.getDynamicObject("costtype_a"));
        rptParam.setCostType_b(filter.getDynamicObject("costtype_b"));
        rptParam.setMaterial(filter.getDynamicObject("querymat"));
        rptParam.setVersion(filter.getDynamicObject("version"));
        rptParam.setQueryDate(filter.getDate("querydate"));
        DynamicObject queryPeriod = filter.getDynamicObject("queryperiod");
        if (queryPeriod != null && queryPeriod.getLong("id") != 0L) {
            rptParam.setQueryPeriodId(queryPeriod.getLong("id"));
        }
        if ((materialgrpstd = filter.getDynamicObject("materialgrpstd")) == null) {
            materialgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
        }
        if (!CadEmptyUtils.isEmpty(calcRecordA = filter.getString("calcrecord_a"))) {
            rptParam.setCalcRecordAName(calcRecordA);
        }
        if (!CadEmptyUtils.isEmpty(calcRecordB = filter.getString("calcrecord_b"))) {
            rptParam.setCalcRecordBName(calcRecordB);
        }
        rptParam.setMaterialgrpstd(materialgrpstd);
        rptParam.setMulmaterialgroup(filter.getDynamicObjectCollection("mulmaterialgroup"));
        rptParam.setMulgroupmaterial(filter.getDynamicObjectCollection("mulgroupmaterial"));
        rptParam.setDateial(filter.getBoolean("issubmaterial"));
        rptParam.setShowsum(filter.getBoolean("showsum"));
        rptParam.setShowgroup(filter.getBoolean("showgroup"));
        DynamicObjectCollection mulConfiguredCode = filter.getDynamicObjectCollection("mulconfiguredcode");
        if (mulConfiguredCode != null) {
            List<Long> configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            rptParam.setConfiguredCodeIds(configuredCodeIds);
        } else if (!CadEmptyUtils.isEmpty(rptParam.getMaterial())) {
            rptParam.setConfiguredCodeIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulTracknumber = filter.getDynamicObjectCollection("multracknumber");
        if (mulTracknumber != null) {
            List<Long> trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            rptParam.setTrackNumberIds(trackNumberIds);
        } else if (!CadEmptyUtils.isEmpty(rptParam.getMaterial())) {
            rptParam.setTrackNumberIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulProjectNumber = filter.getDynamicObjectCollection("mulprojectnumber");
        if (mulProjectNumber != null) {
            List<Long> projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            rptParam.setProjectNumberIds(projectNumberIds);
        }
        if (!CadEmptyUtils.isEmpty(lots = filter.getString("mullot"))) {
            rptParam.setLots(lots);
        }
        return rptParam;
    }

    public static List<QFilter> getCommonFiltersBy(FinalStdAnalysisRptParam param, String category, boolean isAnalogCost) {
        String lots;
        List<Long> projectNumberIds;
        List<Long> trackNumberIds;
        List<QFilter> filters = FinalStdAnalysisRptHelper.getCommonFiltersBy(param);
        HashSet<Long> costTypeIds = new HashSet<Long>(2);
        if ("A".equals(category)) {
            if (!isAnalogCost && !CadEmptyUtils.isEmpty(param.getTrackKeyColsA())) {
                costTypeIds.add(param.getCostType_a().getLong("id"));
                costTypeIds.add(param.getSimCosttypeIdA());
                filters.add(new QFilter("costtype", "in", costTypeIds));
            } else {
                filters.add(new QFilter("costtype", "=", (Object)param.getCostType_a().getLong("id")));
            }
        } else if (!isAnalogCost && !CadEmptyUtils.isEmpty(param.getTrackKeyColsB())) {
            costTypeIds.add(param.getCostType_b().getLong("id"));
            costTypeIds.add(param.getSimCosttypeIdB());
            filters.add(new QFilter("costtype", "in", costTypeIds));
        } else {
            filters.add(new QFilter("costtype", "=", (Object)param.getCostType_b().getLong("id")));
        }
        List<Long> configuredCodeIds = param.getConfiguredCodeIds();
        if (!CadEmptyUtils.isEmpty(configuredCodeIds)) {
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = param.getTrackNumberIds())) {
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = param.getProjectNumberIds())) {
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(lots = param.getLots())) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        return filters;
    }

    public static List<QFilter> getCommonFiltersBy(FinalStdAnalysisRptParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (param.getMaterial() != null) {
            filters.add(new QFilter("material", "=", param.getMaterial().getPkValue()));
        }
        if (param.getVersion() != null) {
            filters.add(new QFilter("matvers", "=", param.getVersion().getPkValue()));
        }
        return filters;
    }

    public static boolean getItemsIsEqual(Row row, Row secdRow, String field, int type) {
        if (type == 1) {
            return row.getLong(field) == null ? secdRow.getLong(field) == null : row.getLong(field).equals(secdRow.getLong(field));
        }
        if (type == 2) {
            return row.getBigDecimal(field) == null ? secdRow.getBigDecimal(field) == null : row.getBigDecimal(field).equals(secdRow.getBigDecimal(field));
        }
        return row.getString(field) == null ? secdRow.getString(field) == null : row.getString(field).equals(secdRow.getString(field));
    }
}

