/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ImportInitCostHelper {
    protected static final Log logger = LogFactory.getLog(ImportInitCostHelper.class);
    private static final String ENTITY_BD_PERIOD = "bd_period";
    private static final String ENTITY_CAL_BD_CALPOLICY = "cal_bd_calpolicy";
    private static final String ENTITY_SCA_START_STD_COST = "sca_startstdcost";
    private static final String ENTITY_ENTRY_ENTITY = "entryentity";
    private static final String ENTITY_ENTRY_COST = "entrycost";
    private static final String FIELD_BASE_ORG = "org";
    private static final String FIELD_BASE_COST_ACCOUNT = "costaccount";
    private static final String FIELD_BASE_ELEMENT = "element";
    private static final String FIELD_BASE_SUB_ELEMENT = "subelement";
    private static final String FIELD_BASE_PERIOD = "period";
    private static final String FIELD_DATE_EFFECT_DATE = "effectdate";
    private static final String FIELD_DATE_EXP_DATE = "expdate";
    private static final String FIELD_DATE_BEGIN_DATE = "begindate";
    private static final String FIELD_DATE_END_DATE = "enddate";
    private static final String FIELD_DATE_BIZ_DATE = "bizdate";
    private static final String FIELD_DATE_SRC_SYNC_DATE = "srcsyncdate";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_BIZ_BILL_ID = "bizbillid";
    private static final String BIZ_BILL_ENTRY_ID = "bizbillentryid";
    private static final String FIELD_STD_PRICE = "stdprice";
    private static final String FIELD_APP_NUM = "appnum";
    private static final String FIELD_ID = "id";
    private static final String FIELD_IS_ENABLED = "isenabled";
    private static final String FIELD_COMPLETE_QTY = "completeqty";
    private static final String FIELD_CAL_POLICY = "calpolicy";
    private static final String FIELD_PERIOD_TYPE = "periodtype";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_MATERIAL = "material";
    private static final String ENUM_COST_TYPE = "costtype";
    private static final String ENUM_SCA = "sca";

    public static Map<Long, List<DynamicObject>> getCostRecordMap(DynamicObject[] sourceBills) {
        return ImportInitCostHelper.doGetCostRecordMap(sourceBills);
    }

    public static Map<Long, List<DynamicObject>> doGetCostRecordMap(DynamicObject[] sourceBills) {
        HashMap<Long, List<DynamicObject>> costRecordMap = new HashMap<Long, List<DynamicObject>>(16);
        if (sourceBills == null || sourceBills.length == 0) {
            return costRecordMap;
        }
        ArrayList<Long> srcEntryIds = new ArrayList<Long>(10);
        for (DynamicObject sourceBill : sourceBills) {
            srcEntryIds.add(sourceBill.getLong("entryId"));
        }
        String fields = "bizdate, costaccount, costaccount.costtype AS costtype, bizbillid, entry.bizbillentryid bizbillentryid,entry.caldimension.caldimension caldimension,entry.noupdatecalfields noupdatecalfields";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("entry.bizbillentryid", "in", (Object)srcEntryIds.toArray()));
        qfList.add(new QFilter("billstatus", "=", (Object)"C"));
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])qfList.toArray(new QFilter[0]));
        for (DynamicObject costRecord : costRecords) {
            long entryId = costRecord.getLong(BIZ_BILL_ENTRY_ID);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)costRecordMap.get(entryId);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
            }
            list.add(costRecord);
            costRecordMap.put(entryId, list);
        }
        return costRecordMap;
    }

    public static void createEntryCost(DynamicObject factned, List<DynamicObject> costSyncInfos, Map<Long, String> outSourcePrice, Map<Long, Boolean> outSourceMaterialMap, Map<Long, List<DynamicObject>> orgCostaccountMap) {
        costSyncInfos = ImportInitCostHelper.fillCostSyncInfos(factned, costSyncInfos, orgCostaccountMap);
        for (DynamicObject costSyncInfo : costSyncInfos) {
            ImportInitCostHelper.initEntryCost(factned, costSyncInfo, outSourcePrice, outSourceMaterialMap);
        }
    }

    private static void initEntryCost(DynamicObject factnedObject, DynamicObject costSyncInfo, Map<Long, String> outSourcePrice, Map<Long, Boolean> outSourceMaterialMap) {
        Long material = factnedObject.getLong(FIELD_MATERIAL.concat("_id"));
        DynamicObject costAccountObject = costSyncInfo.getDynamicObject(FIELD_BASE_COST_ACCOUNT);
        Date srcSyncDate = factnedObject.getDate("srcauditdate");
        boolean enableMulFactory = CostAccountHelper.isEnableMulFactory(Long.parseLong(costAccountObject.getPkValue().toString()));
        Long manuOrg = factnedObject.getLong("manuorg".concat("_id"));
        if (CadEmptyUtils.isEmpty(manuOrg) && factnedObject.get("manuorg") instanceof Long) {
            manuOrg = factnedObject.getLong("manuorg");
        }
        String calcDimenKey = ImportInitCostHelper.getCalcDimenStr(factnedObject);
        Long org = factnedObject.getLong(FIELD_BASE_ORG.concat("_id"));
        if (CadEmptyUtils.isEmpty(org) && factnedObject.get(FIELD_BASE_ORG) instanceof Long) {
            org = factnedObject.getLong(FIELD_BASE_ORG);
        }
        if (enableMulFactory) {
            long invOrgId = factnedObject.getLong("invorg");
            if (CadEmptyUtils.isEmpty(invOrgId)) {
                logger.info("\u672a\u67e5\u8be2\u5230\u6e90\u5355\u5e93\u5b58\u7ec4\u7ec7\uff0c\u5982\u975e\u9884\u5236\u65b9\u6848\u8bf7\u5728\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u914d\u7f6e\u5e93\u5b58\u7ec4\u7ec7");
                return;
            }
            Map<String, Object> params = ImportInitCostHelper.buildMatCostParams(factnedObject, invOrgId, calcDimenKey);
            Map<String, List<Map<String, Object>>> matCostMap = ImportServiceHelper.getMatCost(Collections.singletonList(params), org, costAccountObject.getLong(FIELD_ID), "1");
            List<Map<String, Object>> matCostList = matCostMap.get(calcDimenKey);
            ImportInitCostHelper.initEntryCost(factnedObject, costAccountObject, srcSyncDate, matCostList, true);
        } else {
            Map<String, Object> params = ImportInitCostHelper.buildMatCostParams(factnedObject, 0L, calcDimenKey);
            Map<String, List<Map<String, Object>>> matCostMap = ImportServiceHelper.getMatCost(Collections.singletonList(params), org, costAccountObject.getLong(FIELD_ID), "1");
            List<Map<String, Object>> matCostList = matCostMap.get(calcDimenKey);
            ImportInitCostHelper.initEntryCost(factnedObject, costAccountObject, srcSyncDate, matCostList, true);
        }
    }

    public static Map<String, Object> buildMatCostParams(DynamicObject factnedObject, Long invOrg, String uniqueID) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("uniqueID", uniqueID);
        params.put("invorg", invOrg);
        DynamicObjectCollection entryentity = factnedObject.getDynamicObjectCollection(ENTITY_ENTRY_ENTITY);
        Long costObject = CadEmptyUtils.isEmpty(entryentity) ? 0L : ((DynamicObject)entryentity.get(0)).getLong("costobject");
        DynamicObject costObjectDyo = ImportInitCostHelper.getCostObject(costObject);
        if (costObjectDyo == null) {
            logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5206\u5f55\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u83b7\u53d6\u5931\u8d25\uff0cid:{}", (Object)costObject);
            return params;
        }
        if (factnedObject.get(FIELD_MATERIAL) instanceof DynamicObject) {
            params.put(FIELD_MATERIAL, factnedObject.getLong("material.id"));
        } else {
            params.put(FIELD_MATERIAL, factnedObject.getLong(FIELD_MATERIAL));
        }
        if (factnedObject.get("auxpty") instanceof DynamicObject) {
            params.put("assist", factnedObject.getLong("auxpty.id"));
        } else {
            params.put("assist", factnedObject.getLong("auxpty"));
        }
        if (factnedObject.get("configuredcode") instanceof DynamicObject) {
            params.put("configuredcode", factnedObject.getLong("configuredcode.id"));
        } else {
            params.put("configuredcode", factnedObject.getLong("configuredcode"));
        }
        if (factnedObject.get("tracknumber") instanceof DynamicObject) {
            params.put("tracknumber", factnedObject.getLong("tracknumber.id"));
        } else {
            params.put("tracknumber", factnedObject.getLong("tracknumber"));
        }
        if (factnedObject.get("project") instanceof DynamicObject) {
            params.put("project", factnedObject.getLong("project.id"));
        } else {
            params.put("project", factnedObject.getLong("project"));
        }
        params.put("lot", factnedObject.getString("lot"));
        params.put("date", factnedObject.getDate("srcauditdate"));
        return params;
    }

    public static String getCalcDimenStr(DynamicObject dyo) {
        if (dyo == null) {
            return "";
        }
        DynamicObjectCollection entryentity = dyo.getDynamicObjectCollection(ENTITY_ENTRY_ENTITY);
        Long costObject = CadEmptyUtils.isEmpty(entryentity) ? 0L : ((DynamicObject)entryentity.get(0)).getLong("costobject");
        DynamicObject costObjectDyo = ImportInitCostHelper.getCostObject(costObject);
        if (costObjectDyo == null) {
            return "";
        }
        String noupdatecostfields = costObjectDyo.getString("noupdatecostfields");
        if (noupdatecostfields == null) {
            noupdatecostfields = "";
        }
        StringBuilder calcDimenStr = new StringBuilder();
        if (dyo.get(FIELD_MATERIAL) instanceof DynamicObject) {
            calcDimenStr.append(dyo.getString("material.id"));
        } else {
            calcDimenStr.append(dyo.getString(FIELD_MATERIAL));
        }
        calcDimenStr.append("@");
        if (costObjectDyo.get("auxpty") instanceof DynamicObject) {
            calcDimenStr.append(costObjectDyo.getString("auxpty.id"));
        } else {
            calcDimenStr.append(costObjectDyo.getString("auxpty"));
        }
        calcDimenStr.append("@");
        calcDimenStr.append(ImportInitCostHelper.getDimenStrField(costObjectDyo, "configuredcode", "configuredcode", noupdatecostfields));
        calcDimenStr.append("@");
        calcDimenStr.append(ImportInitCostHelper.getDimenStrField(costObjectDyo, "tracknumber", "tracknumber", noupdatecostfields));
        calcDimenStr.append("@");
        calcDimenStr.append(ImportInitCostHelper.getDimenStrField(costObjectDyo, "projectnumber", "project", noupdatecostfields));
        calcDimenStr.append("@");
        calcDimenStr.append(costObjectDyo.getString("lot"));
        calcDimenStr.append("@");
        calcDimenStr.append(dyo.getDate("srcauditdate"));
        return calcDimenStr.toString();
    }

    private static String getDimenStrField(DynamicObject costObjectDyo, String field, String setNullField, String noupdatecostfields) {
        if (noupdatecostfields.contains("\"" + setNullField + "\"")) {
            if (costObjectDyo.get(field) instanceof DynamicObject) {
                return costObjectDyo.getString(field + ".id");
            }
            return costObjectDyo.getString(field);
        }
        return "0";
    }

    private static DynamicObject getCostObject(Long costObjectId) {
        QFilter costObjectFilter = new QFilter(FIELD_ID, "=", (Object)costObjectId);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"cad_costobject", (String)"material,auxpty,configuredcode,tracknumber,projectnumber,lot,noupdatecostfields", (QFilter[])costObjectFilter.toArray());
    }

    public static Map<Object, Object[]> loadMatCostResult(Long material, Date srcSyncDate, DynamicObject costType) {
        HashMap<Object, Object[]> costElementGroup = new HashMap<Object, Object[]>(16);
        QFilter qFilter = new QFilter(ENUM_COST_TYPE, "=", costType.getPkValue());
        qFilter.and(new QFilter(FIELD_DATE_EFFECT_DATE, "<=", (Object)srcSyncDate));
        qFilter.and(new QFilter(FIELD_DATE_EXP_DATE, ">", (Object)srcSyncDate));
        qFilter.and(new QFilter(FIELD_MATERIAL, "=", (Object)material));
        DynamicObject result = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_matcostinfo", (QFilter[])qFilter.toArray());
        if (result == null) {
            return costElementGroup;
        }
        DynamicObjectCollection entryEntity = result.getDynamicObjectCollection(ENTITY_ENTRY_ENTITY);
        if (CadEmptyUtils.isEmpty(entryEntity)) {
            return costElementGroup;
        }
        for (DynamicObject entry : entryEntity) {
            Object[] costInfoArray = costElementGroup.computeIfAbsent(entry.get(FIELD_BASE_SUB_ELEMENT), p -> new Object[3]);
            costInfoArray[0] = entry;
            costInfoArray[1] = entry.getBigDecimal("standardcost");
            costInfoArray[2] = entry.getBigDecimal("stepamt");
        }
        return costElementGroup;
    }

    public static void initEntryCost(DynamicObject factnedObject, DynamicObject costAccountObject, Date srcSyncDate, List<Map<String, Object>> matCostList, Boolean isCostElement) {
        if (matCostList == null || matCostList.isEmpty()) {
            return;
        }
        BigDecimal completeQty = factnedObject.getBigDecimal(FIELD_COMPLETE_QTY);
        Date bizDate = factnedObject.getDate(FIELD_DATE_BIZ_DATE);
        DynamicObject calPolicyObject = costAccountObject.getDynamicObject(FIELD_CAL_POLICY);
        calPolicyObject = BusinessDataServiceHelper.loadSingleFromCache((Object)calPolicyObject.getPkValue(), (String)ENTITY_CAL_BD_CALPOLICY);
        DynamicObject currency = calPolicyObject.getDynamicObject(FIELD_CURRENCY);
        int amtprecision = calPolicyObject.getInt("currency.amtprecision");
        DynamicObject periodTypeObject = calPolicyObject.getDynamicObject(FIELD_PERIOD_TYPE);
        QFilter periodFilter = new QFilter(FIELD_PERIOD_TYPE, "=", periodTypeObject.getPkValue());
        periodFilter.and(new QFilter(FIELD_DATE_BEGIN_DATE, "<=", (Object)bizDate));
        periodFilter.and(new QFilter(FIELD_DATE_END_DATE, ">=", (Object)bizDate));
        periodTypeObject = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BD_PERIOD, (QFilter[])periodFilter.toArray());
        DynamicObjectCollection entryentity = factnedObject.getDynamicObjectCollection(ENTITY_ENTRY_COST);
        for (Map<String, Object> matCost : matCostList) {
            DynamicObject entryRowEntity = entryentity.addNew();
            BigDecimal stdPrice = (BigDecimal)matCost.get("standardcost");
            entryRowEntity.set(FIELD_BASE_COST_ACCOUNT, (Object)costAccountObject);
            entryRowEntity.set(FIELD_BASE_PERIOD, (Object)periodTypeObject);
            entryRowEntity.set(ENUM_COST_TYPE, matCost.get(ENUM_COST_TYPE));
            entryRowEntity.set(FIELD_CURRENCY, (Object)currency);
            entryRowEntity.set(FIELD_BASE_ELEMENT, matCost.get(FIELD_BASE_ELEMENT));
            entryRowEntity.set(FIELD_BASE_SUB_ELEMENT, matCost.get(FIELD_BASE_SUB_ELEMENT));
            entryRowEntity.set(FIELD_STD_PRICE, (Object)stdPrice);
            entryRowEntity.set(FIELD_AMOUNT, (Object)stdPrice.multiply(completeQty).setScale(amtprecision, RoundingMode.HALF_UP));
            entryRowEntity.set(FIELD_DATE_SRC_SYNC_DATE, (Object)srcSyncDate);
            entryRowEntity.set("entrykeycol", matCost.get("keycol"));
            entryRowEntity.set("entrykeycolid", matCost.get("keycolid"));
            entryRowEntity.set("matcostid", matCost.get("matcostinfoid"));
        }
    }

    public static void initEntryCost(DynamicObject factnedObject, List<Map<String, Object>> matCostList, Map<Long, Tuple2<Long, Integer>> accountCurrencyMap) {
        if (matCostList == null || matCostList.isEmpty()) {
            return;
        }
        BigDecimal completeQty = factnedObject.getBigDecimal(FIELD_COMPLETE_QTY);
        Date srcSyncDate = factnedObject.getDate("srcauditdate");
        DynamicObjectCollection entryentity = factnedObject.getDynamicObjectCollection(ENTITY_ENTRY_COST);
        for (Map<String, Object> matCost : matCostList) {
            Long costaccount = (Long)matCost.get(FIELD_BASE_COST_ACCOUNT);
            if (CadEmptyUtils.isEmpty(costaccount)) continue;
            if (!accountCurrencyMap.containsKey(costaccount)) {
                Long currencyId;
                logger.info("\u83b7\u53d6\u8d26\u7c3f\u5e01\u522b\u4fe1\u606f\uff1a{}", (Object)costaccount);
                ArrayList<String> selectFields = new ArrayList<String>(4);
                selectFields.add(FIELD_CAL_POLICY);
                MainEntityType subCostAcctType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)"cal_bd_costaccount", selectFields);
                DynamicObject costAcctObj = BusinessDataServiceHelper.loadSingleFromCache((Object)costaccount, (DynamicObjectType)subCostAcctType);
                Long calpolicy = costAcctObj.getLong("calpolicy.id");
                if (calpolicy == null || Long.compare(0L, calpolicy) == 0 || (currencyId = Long.valueOf(costAcctObj.getLong("calpolicy.currency.id"))) == null || Long.compare(0L, currencyId) == 0) continue;
                accountCurrencyMap.put(costaccount, (Tuple2<Long, Integer>)new Tuple2((Object)currencyId, (Object)costAcctObj.getInt("calpolicy.currency.amtprecision")));
            }
            Tuple2<Long, Integer> tuple = accountCurrencyMap.get(costaccount);
            List matcostinfoList = (List)matCost.get("matcostinfo");
            if (matcostinfoList == null) continue;
            for (Map matcostinfo : matcostinfoList) {
                DynamicObject entryRowEntity = entryentity.addNew();
                BigDecimal stdPrice = (BigDecimal)matcostinfo.get("standardcost");
                entryRowEntity.set(FIELD_BASE_COST_ACCOUNT, (Object)costaccount);
                entryRowEntity.set(FIELD_BASE_PERIOD, matCost.get(FIELD_BASE_PERIOD));
                entryRowEntity.set(ENUM_COST_TYPE, matcostinfo.get(ENUM_COST_TYPE));
                entryRowEntity.set(FIELD_CURRENCY, tuple.t1);
                entryRowEntity.set(FIELD_BASE_ELEMENT, matcostinfo.get(FIELD_BASE_ELEMENT));
                entryRowEntity.set(FIELD_BASE_SUB_ELEMENT, matcostinfo.get(FIELD_BASE_SUB_ELEMENT));
                entryRowEntity.set(FIELD_STD_PRICE, (Object)stdPrice);
                entryRowEntity.set(FIELD_AMOUNT, (Object)stdPrice.multiply(completeQty).setScale((int)((Integer)tuple.t2), RoundingMode.HALF_UP));
                entryRowEntity.set(FIELD_DATE_SRC_SYNC_DATE, (Object)srcSyncDate);
                entryRowEntity.set("entrykeycol", matcostinfo.get("keycol"));
                entryRowEntity.set("entrykeycolid", matcostinfo.get("keycolid"));
                entryRowEntity.set("matcostid", matCost.get("matcostinfoid"));
            }
        }
    }

    private static List<DynamicObject> fillCostSyncInfos(DynamicObject factned, List<DynamicObject> costSyncInfos, Map<Long, List<DynamicObject>> orgCostaccountMap) {
        try {
            List<DynamicObject> costaccountObjs;
            DynamicObject dynamicObject = costSyncInfos.get(0);
            costSyncInfos = new ArrayList<DynamicObject>(10);
            Long org = CadEmptyUtils.isEmpty(factned.getLong(FIELD_BASE_ORG.concat("_id"))) ? 0L : factned.getLong(FIELD_BASE_ORG.concat("_id"));
            if (!orgCostaccountMap.containsKey(org)) {
                logger.info("\u5b8c\u5de5\u5165\u5e93\u6570\u91cf\u5f52\u96c6-\u6210\u672c\u4fe1\u606f\u83b7\u53d6-\u6838\u7b97\u7ec4\u7ec7\uff1a" + org);
                costaccountObjs = new ArrayList<DynamicObject>(10);
                QFilter qFilter = new QFilter(FIELD_BASE_ORG, "=", (Object)org);
                qFilter.and(new QFilter(FIELD_APP_NUM, "=", (Object)ENUM_SCA));
                Map startStdCostMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_SCA_START_STD_COST, (QFilter[])qFilter.toArray());
                for (DynamicObject startStdCost : startStdCostMap.values()) {
                    DynamicObjectCollection costAccountEntries = startStdCost.getDynamicObjectCollection(ENTITY_ENTRY_ENTITY);
                    for (DynamicObject costAccountEntry : costAccountEntries) {
                        Boolean isEnabled = costAccountEntry.getBoolean(FIELD_IS_ENABLED);
                        if (!isEnabled.booleanValue()) continue;
                        Object costAccountId = costAccountEntry.getDynamicObject(FIELD_BASE_COST_ACCOUNT).getPkValue();
                        QFilter costAccountFilter = new QFilter(FIELD_ID, "=", costAccountId);
                        DynamicObject costAccountObject = BusinessDataServiceHelper.loadSingleFromCache((String)"cal_bd_costaccount", (QFilter[])costAccountFilter.toArray());
                        costaccountObjs.add(costAccountObject);
                    }
                }
                orgCostaccountMap.put(org, costaccountObjs);
            }
            costaccountObjs = orgCostaccountMap.get(org);
            for (DynamicObject costaccountObj : costaccountObjs) {
                DynamicObject costSyncInfo = BusinessDataServiceHelper.newDynamicObject((String)"cal_costrecord_subentity");
                costSyncInfo.set(FIELD_DATE_BIZ_DATE, (Object)dynamicObject.getDate(FIELD_DATE_BIZ_DATE));
                costSyncInfo.set(FIELD_BASE_COST_ACCOUNT, (Object)costaccountObj);
                costSyncInfos.add(costSyncInfo);
            }
        }
        catch (Exception e) {
            logger.error("\u586b\u5199\u6210\u672c\u4fe1\u606f\u62a5\u9519\u3002", (Throwable)e);
        }
        return costSyncInfos;
    }
}

