/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.SrcBillShowerUtils;

public class ImportServiceHelper {
    private static final Log logger = LogFactory.getLog(ImportServiceHelper.class);
    public static List<String> orgFields = Collections.unmodifiableList(Arrays.asList("org", "bizorg", "productionorg", "billentry.entryreqorg", "purorg"));
    public static List<String> adminOrgFields = Collections.unmodifiableList(Arrays.asList("bizdept", "treeentryentity.producedept", "billentry.producedept", "productworkshop"));
    public static List<String> workCenterFields = Collections.unmodifiableList(Arrays.asList("treeentryentity.workcenter", "billentry.oprworkcenter", "billentry.workcenter", "billentry.workcenterid", "sumentry.workcenter"));

    @Deprecated
    public static List<Long> getUserHasPermProOrgsByAccOrg(Long accOrg, String entityId) {
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)accOrg, (boolean)true);
        if (CadEmptyUtils.isEmpty(productOrgs)) {
            return productOrgs;
        }
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appInnerId = AppMetadataCache.getAppInfo((String)"cal").getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"04");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"04");
        }
        productOrgs.retainAll(hasPermOrgIds);
        return productOrgs;
    }

    public static List<Long> getUserHasPermProOrgsByAccOrg(Long accOrg, String entityId, String appNum) {
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)accOrg, (boolean)true);
        if (CadEmptyUtils.isEmpty(productOrgs)) {
            return productOrgs;
        }
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appNum)) {
            appNum = "sca";
        }
        String appInnerId = AppMetadataCache.getAppInfo((String)appNum).getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"04", (String)appInnerId, (String)entityId, (String)"47150e89000000ac");
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"04");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"04");
        }
        productOrgs.retainAll(hasPermOrgIds);
        return productOrgs;
    }

    public static List<Long> getUserHasPermProOrgsByAccOrg(Long accOrg, String entityId, String perm, String appNum) {
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"04", (Long)accOrg, (boolean)true);
        if (CadEmptyUtils.isEmpty(productOrgs)) {
            return productOrgs;
        }
        List hasPermOrgIds = Lists.newArrayListWithCapacity((int)16);
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        if (CadEmptyUtils.isEmpty(appNum)) {
            appNum = "sca";
        }
        String appInnerId = AppMetadataCache.getAppInfo((String)appNum).getId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"04", (String)appInnerId, (String)entityId, (String)perm);
        boolean hasAllOrgPerm = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIds = hasPermOrgResult.getHasPermOrgs();
        if (hasAllOrgPerm) {
            hasPermOrgIds = OrgUnitServiceHelper.getAllOrg((String)"04");
        } else if (!CadEmptyUtils.isEmpty(allOrgIds)) {
            hasPermOrgIds = OrgUnitServiceHelper.filterOrgDuty((List)allOrgIds, (String)"04");
        }
        productOrgs.retainAll(hasPermOrgIds);
        return productOrgs;
    }

    public static List<Long> getUserHasPermOrgsByAccOrg(Long accOrg) {
        List<Long> invOrgs = ImportServiceHelper.getUserHasPermOrgs(accOrg, "05");
        List<Long> proOrgs = ImportServiceHelper.getUserHasPermOrgs(accOrg, "04");
        invOrgs.removeAll(proOrgs);
        invOrgs.addAll(proOrgs);
        return invOrgs;
    }

    public static List<Long> getUserHasPermOrgs(Long accOrg, String type) {
        List productOrgs = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)type, (Long)accOrg, (boolean)true);
        if (CadEmptyUtils.isEmpty(productOrgs)) {
            return productOrgs;
        }
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)type);
        if (CadEmptyUtils.isEmpty(permOrgIds) && CadEmptyUtils.isEmpty(orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)type);
        }
        productOrgs.retainAll(orgIds);
        return productOrgs;
    }

    @Deprecated
    public static List<ComboItem> getPermProOrgsByAccOrg(Long accOrg, String entityId) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        List<Long> userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(accOrg, entityId);
        QFilter qfId = new QFilter("id", "in", userHasPermProOrgsByAccOrg);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qfId});
        for (DynamicObject acctOrg : org) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrg.getString("id"));
            if (orgItems.contains(item)) continue;
            orgItems.add(item);
        }
        return orgItems;
    }

    public static List<ComboItem> getPermProOrgsByAccOrg(Long accOrg, String entityId, String appNum) {
        ArrayList<ComboItem> orgItems = new ArrayList<ComboItem>();
        List<Long> userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(accOrg, entityId, appNum);
        QFilter qfId = new QFilter("id", "in", userHasPermProOrgsByAccOrg);
        DynamicObjectCollection org = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qfId});
        for (DynamicObject acctOrg : org) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(acctOrg.getString("name")));
            item.setValue(acctOrg.getString("id"));
            if (orgItems.contains(item)) continue;
            orgItems.add(item);
        }
        return orgItems;
    }

    public static List<Long> getHasPermOrgIdsByOrgViewType(String orgViewTyp) {
        List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
        List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)orgViewTyp);
        if (CadEmptyUtils.isEmpty(permOrgIds) && CadEmptyUtils.isEmpty(orgIds)) {
            orgIds = OrgUnitServiceHelper.getAllOrg((String)orgViewTyp);
        }
        return orgIds;
    }

    public static List<Long> getCostCenterByDataRule(Long userId, List<Long> accountOrgs, Set<Long> costCenters, String entity, String appNum) {
        ArrayList<Long> enableCostCenters = new ArrayList<Long>(10);
        Set<Long> dyDataRuleCostCenterIds = ImportServiceHelper.getDyDataRuleCostCenter(userId, appNum, entity, "4730fc9f000003ae", accountOrgs);
        if (!CadEmptyUtils.isEmpty(dyDataRuleCostCenterIds)) {
            costCenters.forEach(p -> {
                if (dyDataRuleCostCenterIds.contains(p)) {
                    enableCostCenters.add((Long)p);
                }
            });
        } else {
            enableCostCenters.addAll(costCenters);
        }
        return enableCostCenters;
    }

    public static Set<Long> getDyDataRuleCostCenter(Long userId, String appNum, String entityName, String permItemId, List<Long> orgIds) {
        HashSet<Long> dyDataRuleCostCenterIds = new HashSet<Long>(10);
        try {
            QFilter dataRuleFilter = ImportServiceHelper.getDataRuleFiltersByImport(userId, appNum, entityName, permItemId, orgIds);
            if (dataRuleFilter == null) {
                return dyDataRuleCostCenterIds;
            }
            DynamicObjectCollection dyDataRuleCostCenters = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"costcenter.id costcenterid", (QFilter[])new QFilter[]{dataRuleFilter});
            dyDataRuleCostCenters.forEach(p -> dyDataRuleCostCenterIds.add(p.getLong("costcenterid")));
            return dyDataRuleCostCenterIds;
        }
        catch (NumberFormatException e) {
            logger.info("\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e\u89c4\u5219\u4e2d\u7684\u6210\u672c\u4e2d\u5fc3" + e.getMessage());
            return dyDataRuleCostCenterIds;
        }
    }

    public static QFilter getDataRuleFiltersByImport(Long userId, String appId, String entityNum, String permItemId, List<Long> orgIds) {
        boolean hasPerm = PermissionServiceHelper.hasSpecificPerm((long)userId, (String)appId, (String)entityNum, (String)permItemId);
        if (!hasPerm) {
            return null;
        }
        return ImportServiceHelper.getDataRuleFilters(userId, appId, entityNum, permItemId, orgIds);
    }

    public static QFilter getDataRuleFilters(Long userId, String appId, String entityNum, String permItemId, List<Long> orgIds) {
        PermissionService permissionService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        return permissionService.getDataRuleWithoutDim(userId.longValue(), appId, entityNum, permItemId, orgIds);
    }

    public static void seachConfig(Object[] objIds, String costEntryEntity, IFormView view) {
        QFilter filter = new QFilter("id", "in", (Object)objIds);
        filter.and(new QFilter("collconfig", ">", (Object)0L));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)costEntryEntity, (String)"collconfig", (QFilter[])new QFilter[]{filter});
        HashSet collConfigIds = new HashSet(16);
        rows.forEach(row -> collConfigIds.add(row.getLong("collconfig")));
        if (CadEmptyUtils.isEmpty(collConfigIds)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u5f52\u96c6\u5355\u636e\u7684\u6765\u6e90\u5747\u4e3a\u975e\u6309\u914d\u7f6e\u65b9\u6848\u5f15\u5165\uff0c\u4e0d\u80fd\u8054\u67e5\u914d\u7f6e\u5355\u3002", (String)"ImportServiceHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            return;
        }
        SrcBillShowerUtils.showSearchUpBillOrList(view, "cad_costcollectconfig", new ArrayList<Object>(collConfigIds), null);
    }

    public static Boolean isStartCollConfigScheme() {
        QFilter filter = new QFilter("key", "=", (Object)"StartCollConfigScheme");
        DynamicObject param = QueryServiceHelper.queryOne((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param == null) {
            return Boolean.FALSE;
        }
        return param.getBoolean("value");
    }

    public static List<DynamicObject> getCollConfigs(Long calOrgId, Long costAccountId, Set<Long> calcDimensionIds, String targetEntity, String appNum) {
        return ImportServiceHelper.getCollConfigs(calOrgId, costAccountId, calcDimensionIds, targetEntity, appNum, null, null);
    }

    public static List<DynamicObject> getCollConfigs(Long calOrgId, Long costAccountId, Set<Long> calcDimensionIds, String targetEntity, String appNum, Set<Long> allCollConfigIds, Set<String> bizTypes) {
        Set<Long> configPlanIds;
        QFilter idFilter;
        DynamicObjectCollection collConfigSchemes;
        QFilter planFilter = new QFilter("costbill", "=", (Object)targetEntity);
        planFilter.and(new QFilter("costcalcdimension", "in", calcDimensionIds));
        if (!CadEmptyUtils.isEmpty(bizTypes)) {
            planFilter.and(new QFilter("calmethod", "in", bizTypes));
        }
        if (CadEmptyUtils.isEmpty(collConfigSchemes = QueryServiceHelper.query((String)"cad_costconfigplan", (String)"configinfoentity.usestatus usestatus,configinfoentity.costconfig costconfig", (QFilter[])new QFilter[]{idFilter = new QFilter("id", "in", configPlanIds = ImportServiceHelper.getConfigPlanIds(calOrgId, costAccountId, targetEntity, appNum, planFilter))}))) {
            return null;
        }
        HashSet<Long> collConfigIds = new HashSet<Long>(16);
        for (DynamicObject collConfig : collConfigSchemes) {
            Long costconfig = collConfig.getLong("costconfig");
            if ("1".equals(collConfig.getString("usestatus"))) {
                collConfigIds.add(costconfig);
            }
            if (allCollConfigIds == null) continue;
            allCollConfigIds.add(costconfig);
        }
        QFilter filter = new QFilter("id", "in", collConfigIds);
        DynamicObject[] collConfigs = BusinessDataServiceHelper.load((String)"cad_costcollectconfig", (String)"id,org,number,costbill,sourcebill,calmethod,costcalcdimension,costaccount,accountbook,accountviews,assgrp,assgrpcondition,srcdatatype,expenseitemamt,plugin,fieldmapentity.costfield,fieldmapentity.selectvalue,fieldmapentity.formuladesc,fieldmapentity.formula,fieldmapentity.sourcedata,fieldmapentity.sourcefield,filter_tag,costruleinfoentity.costobjfield,costruleinfoentity.srcbillfield,costruleinfoentity.parsefield,autogenerateobj,matchcostobj,modifytime,appnum,costdriver,ismergesource,workactivity,materialgroupstd", (QFilter[])new QFilter[]{filter});
        return collConfigs == null ? null : Arrays.asList(collConfigs);
    }

    public static List<DynamicObject> getCollConfigs(Long calOrgId, Long costAccountId, Set<String> calcMethodTypes, Set<Long> calcDimensionIds, String targetEntity, String appNum, Set<Long> allCollConfigIds) {
        QFilter planFilter = new QFilter("costbill", "=", (Object)targetEntity);
        planFilter.and(new QFilter("costcalcdimension", "in", calcDimensionIds));
        Set<Long> configPlanIds = ImportServiceHelper.getConfigPlanIds(calOrgId, costAccountId, targetEntity, appNum, planFilter);
        QFilter idFilter = new QFilter("id", "in", configPlanIds);
        idFilter.and(new QFilter("calmethod", "in", calcMethodTypes));
        DynamicObjectCollection collConfigSchemes = QueryServiceHelper.query((String)"cad_costconfigplan", (String)"configinfoentity.usestatus usestatus,configinfoentity.costconfig costconfig", (QFilter[])new QFilter[]{idFilter});
        if (CadEmptyUtils.isEmpty(collConfigSchemes)) {
            return null;
        }
        HashSet<Long> collConfigIds = new HashSet<Long>(16);
        for (DynamicObject collConfig : collConfigSchemes) {
            Long costconfig = collConfig.getLong("costconfig");
            if ("1".equals(collConfig.getString("usestatus"))) {
                collConfigIds.add(costconfig);
            }
            if (allCollConfigIds == null) continue;
            allCollConfigIds.add(costconfig);
        }
        QFilter filter = new QFilter("id", "in", collConfigIds);
        DynamicObject[] collConfigs = BusinessDataServiceHelper.load((String)"cad_costcollectconfig", (String)"id,org,number,costbill,sourcebill,calmethod,costcalcdimension,plugin,fieldmapentity.costfield,fieldmapentity.selectvalue,fieldmapentity.formuladesc,fieldmapentity.formula,fieldmapentity.sourcedata,fieldmapentity.sourcefield,filter_tag,costruleinfoentity.costobjfield,costruleinfoentity.srcbillfield,costruleinfoentity.parsefield,autogenerateobj,matchcostobj,modifytime,appnum,costdriver,ismergesource,workactivity,materialgroupstd", (QFilter[])new QFilter[]{filter});
        return collConfigs == null ? null : Arrays.asList(collConfigs);
    }

    public static Set<Long> getConfigPlanIds(Long calOrgId, Long costAccountId, String targetEntity, String appNum, QFilter qFilter) {
        Long upOrgId;
        ArrayList<Map<String, Long>> result = new ArrayList<Map<String, Long>>(20);
        HashMap<Long, List<Map<String, Long>>> orgCollConfigMap = new HashMap<Long, List<Map<String, Long>>>(16);
        List superiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)calOrgId);
        logger.info("\u3010getConfigPlanIds\u3011\u83b7\u53d6\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u7684\u6240\u6709\u4e0a\u7ea7\u7ec4\u7ec7,\u5f53\u524d\u7ec4\u7ec7==>{},\u4e0a\u7ea7\u7ec4\u7ec7==>{}", (Object)calOrgId, (Object)superiorOrgs);
        superiorOrgs.add(calOrgId);
        QFilter filter = new QFilter("org", "in", (Object)superiorOrgs);
        filter.and("appnum", "=", (Object)appNum);
        if (qFilter != null) {
            filter.and(qFilter);
        }
        DynamicObjectCollection collConfigSchemes = null;
        if (!CadEmptyUtils.isEmpty(costAccountId)) {
            QFilter costAccountQFilter = new QFilter("costaccount", "=", (Object)costAccountId);
            collConfigSchemes = QueryServiceHelper.query((String)"cad_costconfigplan", (String)"id,org,costbill,calmethod,costcalcdimension", (QFilter[])new QFilter[]{filter, costAccountQFilter});
        }
        if (CadEmptyUtils.isEmpty(collConfigSchemes)) {
            if ("aca_matalloc".equals(targetEntity) || "cad_mfgfeebill".equals(targetEntity) || "sca_diycostdriver".equals(targetEntity) || "cad_planresource".equals(targetEntity)) {
                filter.and("costaccount", "=", (Object)0L);
            }
            collConfigSchemes = QueryServiceHelper.query((String)"cad_costconfigplan", (String)"id,org,costbill,calmethod,costcalcdimension", (QFilter[])new QFilter[]{filter});
        }
        if (collConfigSchemes == null) {
            return null;
        }
        collConfigSchemes.forEach(collConfigScheme -> {
            HashMap<String, Long> map = new HashMap<String, Long>(16);
            String key = collConfigScheme.getString("costbill") + "@" + collConfigScheme.getString("calmethod") + "@" + collConfigScheme.getLong("costcalcdimension");
            map.put(key, collConfigScheme.getLong("id"));
            orgCollConfigMap.computeIfAbsent(collConfigScheme.getLong("org"), p -> new ArrayList()).add(map);
        });
        List maps = (List)orgCollConfigMap.get(calOrgId);
        if (maps != null) {
            result.addAll(maps);
        }
        if (!CadEmptyUtils.isEmpty(upOrgId = (Long)OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(calOrgId)).values().iterator().next())) {
            ImportServiceHelper.recursionGetPlan(upOrgId, result, orgCollConfigMap, 1);
        }
        if (CadEmptyUtils.isEmpty(result)) {
            return null;
        }
        HashSet<Long> resultIds = new HashSet<Long>(20);
        for (Map map : result) {
            for (Map.Entry entry : map.entrySet()) {
                resultIds.add((Long)entry.getValue());
            }
        }
        return resultIds;
    }

    private static void recursionGetPlan(Long id, List<Map<String, Long>> result, Map<Long, List<Map<String, Long>>> orgCollConfigMap, int count) {
        List<Map<String, Long>> list = orgCollConfigMap.get(id);
        if (list != null) {
            for (Map<String, Long> map : list) {
                boolean flag = true;
                String parentKey = "";
                for (Map.Entry<String, Long> entry : map.entrySet()) {
                    parentKey = entry.getKey();
                }
                for (Map map2 : result) {
                    String curreyKey = "";
                    for (Map.Entry entry : map2.entrySet()) {
                        curreyKey = (String)entry.getKey();
                    }
                    if (!parentKey.equals(curreyKey)) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                result.add(map);
            }
        }
        if (count == 30) {
            logger.info("\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u9012\u5f52\u6b21\u6570\u5df2\u8fbe\u5230\u6700\u5927\u503c ==>{}", (Object)count);
            return;
        }
        Map directSuperiorOrg = OrgUnitServiceHelper.getDirectSuperiorOrg((String)"10", Collections.singletonList(id));
        if (!CadEmptyUtils.isEmpty(directSuperiorOrg)) {
            Long upOrgId = (Long)directSuperiorOrg.values().iterator().next();
            ImportServiceHelper.recursionGetPlan(upOrgId, result, orgCollConfigMap, count++);
        }
    }

    public static Boolean isOldUserForSysParamBizRange() {
        QFilter filter = new QFilter("accountorg", ">", (Object)0L);
        return QueryServiceHelper.exists((String)"cad_sysparam", (QFilter[])new QFilter[]{filter});
    }

    public static Map<String, List<Long>> getInnerSys(Long accountOrg, List<Long> costCenters, String billRange, String appNum, CollectReport collectReport) {
        ArrayList costCentersCopy = Lists.newArrayList(costCenters);
        HashMap billCostCentersMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap ccRangeMap = Maps.newHashMapWithExpectedSize((int)8);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter orgQf = new QFilter("accountorg", "=", (Object)accountOrg);
        if (!CadEmptyUtils.isEmpty(accountOrg)) {
            filters.add(orgQf);
        }
        if (!CadEmptyUtils.isEmpty(costCentersCopy)) {
            filters.add(new QFilter("costcenter", "in", (Object)costCentersCopy));
        }
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        DynamicObjectCollection sysParams = QueryServiceHelper.query((String)"cad_sysparam", (String)("costcenter," + billRange), (QFilter[])filters.toArray(new QFilter[0]));
        filters.clear();
        filters.add(orgQf);
        filters.add(new QFilter("appnum", "=", (Object)appNum));
        filters.add(new QFilter("costcenter", "=", (Object)0L));
        DynamicObject orgSysParam = QueryServiceHelper.queryOne((String)"cad_sysparam", (String)("costcenter," + billRange), (QFilter[])filters.toArray(new QFilter[0]));
        Map<String, String> billRangeMap = ImportServiceHelper.getBillRangeMap();
        if (sysParams != null && sysParams.size() > 0) {
            for (DynamicObject sysParam : sysParams) {
                String[] completeCollectRange = sysParam.getString(billRange);
                long costCenter = sysParam.getLong("costcenter");
                if (StringUtils.isNotBlank((String)completeCollectRange)) {
                    String[] ranges;
                    ccRangeMap.put(costCenter, completeCollectRange);
                    for (String range : ranges = completeCollectRange.split(",")) {
                        if (!billRangeMap.containsKey(range)) continue;
                        billCostCentersMap.computeIfAbsent(billRangeMap.get(range), cc -> new ArrayList()).add(costCenter);
                        if ("WIPCOMPELETE".equals(range)) {
                            billCostCentersMap.computeIfAbsent("im_mdc_mftreturnbill", cc -> new ArrayList()).add(costCenter);
                            continue;
                        }
                        if ("PRO_GET".equals(range)) {
                            billCostCentersMap.computeIfAbsent("im_mdc_mftreturnorder", cc -> new ArrayList()).add(costCenter);
                            billCostCentersMap.computeIfAbsent("im_mdc_mftfeedorder", cc -> new ArrayList()).add(costCenter);
                            continue;
                        }
                        if ("WLL".equals(range)) {
                            billCostCentersMap.computeIfAbsent("im_mdc_omreturnbill", cc -> new ArrayList()).add(costCenter);
                            billCostCentersMap.computeIfAbsent("im_mdc_omfeedbill", cc -> new ArrayList()).add(costCenter);
                            continue;
                        }
                        if (!"CBTZ".equals(range)) continue;
                        billCostCentersMap.computeIfAbsent("cal_costadjust_subentity", cc -> new ArrayList()).add(costCenter);
                    }
                    costCentersCopy.remove(costCenter);
                    continue;
                }
                ccRangeMap.put(costCenter, completeCollectRange);
                billCostCentersMap.computeIfAbsent(billRangeMap.get(completeCollectRange), cc -> new ArrayList()).add(costCenter);
                costCentersCopy.remove(costCenter);
            }
            if (!costCentersCopy.isEmpty() && orgSysParam != null) {
                String completeCollectRange = orgSysParam.getString(billRange);
                if (StringUtils.isNotBlank((String)completeCollectRange)) {
                    String[] ranges = completeCollectRange.split(",");
                    for (String range : ranges) {
                        if (!billRangeMap.containsKey(range)) continue;
                        billCostCentersMap.computeIfAbsent(billRangeMap.get(range), cc -> new ArrayList()).addAll(costCentersCopy);
                        if ("WIPCOMPELETE".equals(range)) {
                            billCostCentersMap.computeIfAbsent("im_mdc_mftreturnbill", cc -> new ArrayList()).addAll(costCentersCopy);
                            continue;
                        }
                        if ("PRO_GET".equals(range)) {
                            billCostCentersMap.computeIfAbsent("im_mdc_mftreturnorder", cc -> new ArrayList()).addAll(costCentersCopy);
                            billCostCentersMap.computeIfAbsent("im_mdc_mftfeedorder", cc -> new ArrayList()).addAll(costCentersCopy);
                            continue;
                        }
                        if ("WLL".equals(range)) {
                            billCostCentersMap.computeIfAbsent("im_mdc_omreturnbill", cc -> new ArrayList()).addAll(costCentersCopy);
                            billCostCentersMap.computeIfAbsent("im_mdc_omfeedbill", cc -> new ArrayList()).addAll(costCentersCopy);
                            continue;
                        }
                        if (!"CBTZ".equals(range)) continue;
                        billCostCentersMap.computeIfAbsent("cal_costadjust_subentity", cc -> new ArrayList()).addAll(costCentersCopy);
                    }
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, completeCollectRange);
                    }
                } else {
                    for (Long costCenter : costCentersCopy) {
                        ccRangeMap.put(costCenter, completeCollectRange);
                    }
                }
            }
        } else if (!costCentersCopy.isEmpty() && orgSysParam != null) {
            String completeCollectRange = orgSysParam.getString(billRange);
            if (StringUtils.isNotBlank((String)completeCollectRange)) {
                String[] ranges = completeCollectRange.split(",");
                for (String range : ranges) {
                    if (!billRangeMap.containsKey(range)) continue;
                    billCostCentersMap.computeIfAbsent(billRangeMap.get(range), cc -> new ArrayList()).addAll(costCentersCopy);
                    if ("WIPCOMPELETE".equals(range)) {
                        billCostCentersMap.computeIfAbsent("im_mdc_mftreturnbill", cc -> new ArrayList()).addAll(costCentersCopy);
                        continue;
                    }
                    if ("PRO_GET".equals(range)) {
                        billCostCentersMap.computeIfAbsent("im_mdc_mftreturnorder", cc -> new ArrayList()).addAll(costCentersCopy);
                        billCostCentersMap.computeIfAbsent("im_mdc_mftfeedorder", cc -> new ArrayList()).addAll(costCentersCopy);
                        continue;
                    }
                    if ("WLL".equals(range)) {
                        billCostCentersMap.computeIfAbsent("im_mdc_omreturnbill", cc -> new ArrayList()).addAll(costCentersCopy);
                        billCostCentersMap.computeIfAbsent("im_mdc_omfeedbill", cc -> new ArrayList()).addAll(costCentersCopy);
                        continue;
                    }
                    if (!"CBTZ".equals(range)) continue;
                    billCostCentersMap.computeIfAbsent("cal_costadjust_subentity", cc -> new ArrayList()).addAll(costCentersCopy);
                }
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, completeCollectRange);
                }
            } else {
                billCostCentersMap.computeIfAbsent(billRangeMap.get(completeCollectRange), cc -> new ArrayList()).addAll(costCentersCopy);
                for (Long costCenter : costCentersCopy) {
                    ccRangeMap.put(costCenter, completeCollectRange);
                }
            }
        }
        collectReport.getCcRangeMap().putAll(ccRangeMap);
        return billCostCentersMap;
    }

    private static Map<String, String> getBillRangeMap() {
        HashMap<String, String> billRangeMap = new HashMap<String, String>(16);
        billRangeMap.put("SCGD", "pom_mftorder");
        billRangeMap.put("WWGD", "om_mftorder");
        billRangeMap.put("WGRK", "cad_factnedoutputbill");
        billRangeMap.put("WIPCOMPELETE", "im_mdc_mftmanuinbill");
        billRangeMap.put("PRODUCTCOMPELETE", "im_productinbill");
        billRangeMap.put("WWGRK", "im_mdc_omcmplinbill");
        billRangeMap.put("PROCESSREPORT", "sfc_processreportbill");
        billRangeMap.put("PROCESSADJUST", "sfc_reportresource_adjust");
        billRangeMap.put("MFTORDERREPORT", "pom_mftorderreport");
        billRangeMap.put("WGXHB", "om_processreport");
        billRangeMap.put("PRO_GET", "im_mdc_mftproorder");
        billRangeMap.put("GET_OUTSTORAGE", "im_materialreqoutbill");
        billRangeMap.put("WLL", "im_mdc_omoutbill");
        billRangeMap.put("CBTZ", "cal_costadjust_subentity");
        return billRangeMap;
    }

    public static Boolean isStartMatAllocSubEntry() {
        QFilter filter = new QFilter("key", "=", (Object)"isStartMatAllocSubEntry");
        DynamicObject param = BusinessDataServiceHelper.loadSingleFromCache((String)"cad_bgparam", (String)"value", (QFilter[])new QFilter[]{filter});
        if (param == null) {
            return Boolean.FALSE;
        }
        return param.getBoolean("value");
    }

    public static Map<String, List<Map<String, Object>>> getMatCost(List<Map<String, Object>> params, Long org, Long costAccount, String datatype) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatCostInfoPriceService", (String)"getMatCost", (Object[])new Object[]{params, org, costAccount, datatype, "sca"});
        return result;
    }

    public static List<QFilter> getSrcQFilters(Long calOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, DynamicObject config, Map<Long, List<QFilter>> collConfigFilterMap, Map<String, String> fieldMappingMap, Map<String, String> selectValueMappingMap, Map<String, Set<Long>> costCentersourceTypeDataMap, List<Long> mftOrderEntryIds, Map<String, Object> collectParamMap, Long costAccountId, Long period, String appNum, Map<DynamicObject, Map<Long, Long>> configProEntryIdWorkCenterMap, CollectReport collectReport) {
        List<QFilter> collConfigFilter = ImportServiceHelper.getSrcQFiltersForNoTime(calOrgId, costCenterIds, manuOrgIds, config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, costCentersourceTypeDataMap, mftOrderEntryIds, costAccountId, period, appNum, configProEntryIdWorkCenterMap, collectReport, null);
        String targetEntity = config.getString("costbill.id");
        if ("cad_planresource".equals(targetEntity)) {
            return collConfigFilter;
        }
        String timeField = "";
        timeField = "cad_plannedoutputbill".equals(targetEntity) || "sca_workqtycollec".equals(targetEntity) || "aca_matalloc".equals(targetEntity) ? fieldMappingMap.get("bizdate") : fieldMappingMap.get("bookdate");
        if (CadEmptyUtils.isEmpty(timeField)) {
            return collConfigFilter;
        }
        if ("cad_costobject".equals(targetEntity) && !CadEmptyUtils.isEmpty(mftOrderEntryIds) && ("pom_mftorder".equals(config.getDynamicObject("sourcebill").getString("number")) || "om_mftorder".equals(config.getDynamicObject("sourcebill").getString("number")))) {
            return collConfigFilter;
        }
        if ("cad_mfgfeebill".equals(targetEntity)) {
            DynamicObject currentPeriod = PeriodHelper.getCurrentPeriod(costAccountId);
            HashSet<Long> periodIds = new HashSet<Long>(2);
            periodIds.add(currentPeriod == null ? 0L : currentPeriod.getLong("id"));
            Map<String, Date> dateByPeriod = PeriodHelper.getDateByPeriod(periodIds);
            if (!CadEmptyUtils.isEmpty(dateByPeriod)) {
                QFilter timeQFilter = new QFilter(timeField, ">=", (Object)dateByPeriod.get("begindate"));
                timeQFilter.and(new QFilter(timeField, "<=", (Object)dateByPeriod.get("enddate")));
                collConfigFilter.add(timeQFilter);
            }
        } else if ("cad_plannedoutputbill".equals(targetEntity) && ("pom_mftorder".equals(config.getDynamicObject("sourcebill").getString("number")) || "om_mftorder".equals(config.getDynamicObject("sourcebill").getString("number")))) {
            List<Map<String, Date>> importScopeDate = SysParamHelper.getImportScopeDate(calOrgId, appNum);
            QFilter importScopeDateFilter = ImportServiceHelper.getImportScopeDateFilter(importScopeDate, "treeentryentity.closebookdate");
            QFilter importTimeScopeFilter = SysParamHelper.getImportTimeScope(calOrgId, timeField, appNum, collectReport);
            importTimeScopeFilter.or(importScopeDateFilter);
            collConfigFilter.add(importTimeScopeFilter);
        } else {
            QFilter importTimeScopeFilter = SysParamHelper.getImportTimeScope(calOrgId, timeField, appNum, collectReport);
            collConfigFilter.add(importTimeScopeFilter);
        }
        if (!CadEmptyUtils.isEmpty(collectParamMap) && collectParamMap.get("startDate") != null && collectParamMap.get("endDate") != null && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            QFilter collectTimeQFilter = new QFilter(timeField, ">=", collectParamMap.get("startDate"));
            collectTimeQFilter.and(new QFilter(timeField, "<=", collectParamMap.get("endDate")));
            collConfigFilter.add(collectTimeQFilter);
        }
        return collConfigFilter;
    }

    public static List<QFilter> getSrcQFiltersForNoTime(Long calOrgId, List<Long> costCenterIds, List<Long> manuOrgIds, DynamicObject config, Map<Long, List<QFilter>> collConfigFilterMap, Map<String, String> fieldMappingMap, Map<String, String> selectValueMappingMap, Map<String, Set<Long>> costCentersourceTypeDataMap, List<Long> mftOrderEntryIds, Long costAccountId, Long period, String appNum, Map<DynamicObject, Map<Long, Long>> configProEntryIdWorkCenterMap, CollectReport collectReport, Set<Long> dsEntryIds) {
        List<QFilter> collectParamsFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter speFilter = new QFilter("1", "!=", (Object)1);
        if (config == null) {
            filters.add(speFilter);
            return filters;
        }
        Long configId = config.getLong("id");
        String targetBillEntity = config.getString("costbill.id");
        String sourceBillEntity = config.getString("sourcebill.id");
        String manuOrgField = fieldMappingMap.getOrDefault("manuorg", "");
        String costCenterField = fieldMappingMap.get("costcenter");
        boolean vouCherAssgrp = "cad_mfgfeebill".equals(targetBillEntity) && "gl_voucher".equals(sourceBillEntity) && costCenterField.equals("entries.assgrp");
        List<Object> storedConfigFilter = collConfigFilterMap.get(configId) == null ? new ArrayList(10) : collConfigFilterMap.get(configId);
        ArrayList<QFilter> collConfigFilter = new ArrayList<QFilter>(storedConfigFilter);
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            QFilter filter = ImportServiceHelper.dealHasOrderEntryId(mftOrderEntryIds, sourceBillEntity);
            if (filter == null) {
                filters.add(speFilter);
                return filters;
            }
            collConfigFilter.add(filter);
        } else if (CadEmptyUtils.isEmpty(dsEntryIds) || "im_materialreqoutbill".equals(sourceBillEntity) || "cad_costobject".equals(targetBillEntity) || "cad_plannedoutputbill".equals(targetBillEntity)) {
            QFilter ccFilter = null;
            if (costCenterField == null) {
                boolean materialCostDriver = false;
                if (targetBillEntity.equals("sca_diycostdriver")) {
                    try {
                        DynamicObject costDriver = config.getDynamicObject("costdriver");
                        if (!CadEmptyUtils.isEmpty(costDriver)) {
                            String allocClass = costDriver.getString("allocclass");
                            materialCostDriver = "MATERIAL".equals(allocClass);
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u914d\u7f6e\u65b9\u6848{}\uff0c\u83b7\u53d6\u6210\u672c\u52a8\u56e0\u62a5\u9519:", (Object)config.getString("number"), (Object)e);
                    }
                }
                if (materialCostDriver) {
                    filters.addAll(collConfigFilter);
                } else {
                    logger.info("\u914d\u7f6e\u65b9\u6848{}\uff0c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb-\u6210\u672c\u4e2d\u5fc3\u5bf9\u5e94\u6e90\u5355\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u67e5\u8be2\u6e90\u5355\u5931\u8d25\u3002", (Object)config.getString("number"));
                    filters.add(speFilter);
                }
                return filters;
            }
            Object[] splitCostCenterField = costCenterField.split(",");
            if (splitCostCenterField.length == 1 && ((String)splitCostCenterField[0]).contains("costcenter")) {
                ccFilter = new QFilter((String)splitCostCenterField[0], "in", costCenterIds);
            } else if (!CadEmptyUtils.isEmpty(splitCostCenterField) && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
                Set<Long> workCenterIds = costCentersourceTypeDataMap.get("mpdm_workcentre");
                Set<Long> adminOrgIds = costCentersourceTypeDataMap.get("bos_adminorg");
                Set<Long> bosOrgIds = costCentersourceTypeDataMap.get("bos_org");
                for (Object splitCostCenter : splitCostCenterField) {
                    if (CadEmptyUtils.isEmpty((String)splitCostCenter)) continue;
                    if (((String)splitCostCenter).contains("costcenter")) {
                        if (ccFilter == null) {
                            ccFilter = new QFilter((String)splitCostCenter, "in", costCenterIds);
                            continue;
                        }
                        ccFilter = ccFilter.or(new QFilter((String)splitCostCenter, "in", costCenterIds));
                        continue;
                    }
                    QFilter orgFilter = null;
                    orgFilter = orgFields.contains(splitCostCenter) ? ImportServiceHelper.getWcOrOrgOrAoQFByWay(null, null, bosOrgIds, (String)splitCostCenter, sourceBillEntity) : (adminOrgFields.contains(splitCostCenter) ? ImportServiceHelper.getWcOrOrgOrAoQFByWay(null, adminOrgIds, null, (String)splitCostCenter, sourceBillEntity) : (workCenterFields.contains(splitCostCenter) ? ImportServiceHelper.getWcOrOrgOrAoQFByWay(workCenterIds, null, null, (String)splitCostCenter, sourceBillEntity) : ImportServiceHelper.getWcOrOrgOrAoQFByWay(workCenterIds, adminOrgIds, bosOrgIds, (String)splitCostCenter, sourceBillEntity)));
                    if (ccFilter == null) {
                        ccFilter = orgFilter;
                        continue;
                    }
                    if (orgFilter == null) continue;
                    ccFilter = ccFilter.or(orgFilter);
                }
            }
            if (!"2".equals(selectValueMappingMap.get("costcenter")) && !vouCherAssgrp) {
                filters.add(ccFilter);
                if (!CadEmptyUtils.isEmpty(costCentersourceTypeDataMap.get("mpdm_workcentre")) && ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) && CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
                    HashMap<Long, Long> entryIdWorkCenterMap = new HashMap<Long, Long>(16);
                    Set<Long> workCenter = costCentersourceTypeDataMap.get("mpdm_workcentre");
                    String manfethEntity = "pom_mftorder".equals(sourceBillEntity) ? "sfc_manftech" : "om_mfttechnics";
                    List<Long> entryIds = CostCenterHelper.getOrderEntryIds(new ArrayList<Long>(workCenter), manfethEntity, entryIdWorkCenterMap, mftOrderEntryIds);
                    QFilter wcFilter = InFilterHelper.getQFilterByBachSize("treeentryentity.id", new ArrayList<Object>(entryIds), "in", 20000);
                    if ("aca".equals(appNum)) {
                        wcFilter.or(InFilterHelper.getQFilterByBachSize("treeentryentity.pid", new ArrayList<Object>(entryIds), "in", 20000));
                    }
                    ccFilter = ccFilter == null ? wcFilter : ccFilter.or(wcFilter);
                    if (configProEntryIdWorkCenterMap != null) {
                        configProEntryIdWorkCenterMap.computeIfAbsent(config, p -> new HashMap()).putAll(entryIdWorkCenterMap);
                    }
                }
                collConfigFilter.add(ccFilter);
            }
        } else if (!CadEmptyUtils.isEmpty(dsEntryIds)) {
            if ("sca_resourceuse".equals(targetBillEntity)) {
                if ("pom_mftorderreport".equals(sourceBillEntity)) {
                    ArrayList<Object> entryIdStrs = new ArrayList<Object>(dsEntryIds.size());
                    dsEntryIds.forEach(entryId -> entryIdStrs.add(String.valueOf(entryId)));
                    collConfigFilter.add(InFilterHelper.getQFilterByBachSize("sumentry.mftentryid", entryIdStrs, "in", 20000));
                } else {
                    collConfigFilter.add(InFilterHelper.getQFilterByBachSize("sumentry.manufactureentryid", new ArrayList<Object>(dsEntryIds), "in", 20000));
                }
            } else {
                collConfigFilter.add(InFilterHelper.getQFilterByBachSize("billentry.manuentryid", new ArrayList<Object>(dsEntryIds), "in", 20000));
            }
        }
        QFilter manuOrgFilter = null;
        if (!CadEmptyUtils.isEmpty(manuOrgIds) && !CadEmptyUtils.isEmpty(manuOrgField)) {
            manuOrgFilter = new QFilter(manuOrgField, "in", manuOrgIds);
            collConfigFilter.add(manuOrgFilter);
        }
        if ("eca".equals(appNum) && "cal_costrecord_subentity".equals(config.getDynamicObject("sourcebill").getString("number"))) {
            QFilter filter = new QFilter("costaccount", "=", (Object)costAccountId);
            if (!CadEmptyUtils.isEmpty(period)) {
                filter.and("period", "=", (Object)period);
            }
            collConfigFilter.add(filter);
        }
        if (!CadEmptyUtils.isEmpty(collectParamsFilter = ImportServiceHelper.getCollectParamsQFilter(calOrgId, targetBillEntity, sourceBillEntity, appNum, collectReport))) {
            collConfigFilter.addAll(collectParamsFilter);
        }
        return collConfigFilter;
    }

    public static QFilter getWcOrOrgOrAoQFByWay(Set<Long> workCenterIds, Set<Long> adminOrgIds, Set<Long> bosOrgIds, String costCenterField, String sourceBillEntity) {
        QFilter ccFilter = null;
        if (!CadEmptyUtils.isEmpty(workCenterIds)) {
            ccFilter = new QFilter(costCenterField, "in", workCenterIds);
            if ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) {
                ccFilter.and(new QFilter("transactiontype.isprocedure", "=", (Object)Boolean.FALSE));
            }
        }
        if (!CadEmptyUtils.isEmpty(adminOrgIds)) {
            if ("productworkshop".equals(costCenterField)) {
                costCenterField = costCenterField + ".workshoporg";
            }
            ccFilter = ccFilter == null ? new QFilter(costCenterField, "in", adminOrgIds) : ccFilter.or(new QFilter(costCenterField, "in", adminOrgIds));
        }
        if (!CadEmptyUtils.isEmpty(bosOrgIds)) {
            ccFilter = ccFilter == null ? new QFilter(costCenterField, "in", bosOrgIds) : ccFilter.or(new QFilter(costCenterField, "in", bosOrgIds));
        }
        return ccFilter;
    }

    public static QFilter getImportScopeDateFilter(List<Map<String, Date>> importScopeDate, String field) {
        QFilter dateFilter = null;
        if (!CadEmptyUtils.isEmpty(importScopeDate)) {
            Date startDate = importScopeDate.get(0).get("start");
            Date endDate = importScopeDate.get(0).get("end");
            dateFilter = new QFilter(field, "<=", (Object)endDate).and(new QFilter(field, ">=", (Object)startDate));
            if (importScopeDate.size() > 1) {
                Date nextStartDate = importScopeDate.get(1).get("start");
                Date nextEndDate = importScopeDate.get(1).get("end");
                QFilter nextDateFilter = new QFilter(field, "<=", (Object)nextEndDate).and(new QFilter(field, ">=", (Object)nextStartDate));
                dateFilter = dateFilter.or(nextDateFilter);
            }
        }
        return dateFilter;
    }

    public static Map<Long, Map<String, String>> getCollConfigMappingMap(List<DynamicObject> costCollectConfigs) {
        HashMap<Long, Map<String, String>> collConfigMappingMap = new HashMap<Long, Map<String, String>>(16);
        if (CadEmptyUtils.isEmpty(costCollectConfigs)) {
            return collConfigMappingMap;
        }
        costCollectConfigs.forEach(collConfig -> {
            DynamicObjectCollection fields = collConfig.getDynamicObjectCollection("fieldmapentity");
            for (DynamicObject field : fields) {
                String costfield = field.getString("costfield");
                String sourcefield = field.getString("sourcefield");
                collConfigMappingMap.computeIfAbsent(collConfig.getLong("id"), config -> new HashMap()).put(costfield, sourcefield);
            }
        });
        return collConfigMappingMap;
    }

    public static Map<Long, Map<String, String>> getCollSelectValueMappingMap(List<DynamicObject> costCollectConfigs) {
        HashMap<Long, Map<String, String>> collSelectValueMappingMap = new HashMap<Long, Map<String, String>>(16);
        if (CadEmptyUtils.isEmpty(costCollectConfigs)) {
            return collSelectValueMappingMap;
        }
        costCollectConfigs.forEach(collConfig -> {
            DynamicObjectCollection fields = collConfig.getDynamicObjectCollection("fieldmapentity");
            for (DynamicObject field : fields) {
                String costField = field.getString("costfield");
                String selectValue = field.getString("selectvalue");
                collSelectValueMappingMap.computeIfAbsent(collConfig.getLong("id"), config -> new HashMap()).put(costField, selectValue);
            }
        });
        return collSelectValueMappingMap;
    }

    public static Map<Long, List<QFilter>> getCollConfigFilterMap(List<DynamicObject> costCollectConfigs, String entity) {
        HashMap<Long, List<QFilter>> collConfigFilterMap = new HashMap<Long, List<QFilter>>(16);
        if (CadEmptyUtils.isEmpty(costCollectConfigs)) {
            return collConfigFilterMap;
        }
        costCollectConfigs.forEach(collConfig -> {
            String filterStr = collConfig.getString("filter_tag");
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            if (filterCondition != null && filterCondition.getFilterRow().size() > 0) {
                if ("aca_matalloc".equals(entity)) {
                    for (int i = 0; i < filterCondition.getFilterRow().size(); ++i) {
                        SimpleFilterRow filterRow = (SimpleFilterRow)filterCondition.getFilterRow().get(i);
                        FilterValue filterRowValue = (FilterValue)filterRow.getValue().get(0);
                        if (!"billstatus".equals(filterRow.getFieldName()) || !"C".equals(filterRowValue.getValue())) continue;
                        filterCondition.getFilterRow().remove(i);
                        break;
                    }
                }
                String sourceEntity = collConfig.getString("sourcebill.id");
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)sourceEntity);
                FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
                filterBuilder.buildFilter();
                collConfigFilterMap.computeIfAbsent(collConfig.getLong("id"), config -> new ArrayList()).add(filterBuilder.getQFilter());
            }
        });
        return collConfigFilterMap;
    }

    private static QFilter dealHasOrderEntryId(List<Long> mftOrderEntryIds, String sourceBillEntity) {
        QFilter filter = null;
        if (!CadEmptyUtils.isEmpty(mftOrderEntryIds)) {
            if ("om_mftorder".equals(sourceBillEntity) || "pom_mftorder".equals(sourceBillEntity)) {
                filter = InFilterHelper.getQFilterByBachSize("treeentryentity.id", new ArrayList<Object>(mftOrderEntryIds), "in", 490000);
            } else if ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_omcmplinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity)) {
                filter = InFilterHelper.getQFilterByBachSize("billentry.manuentryid", new ArrayList<Object>(mftOrderEntryIds), "in", 490000);
            } else if ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity)) {
                filter = InFilterHelper.getQFilterByBachSize("billentry.manuentryid", new ArrayList<Object>(mftOrderEntryIds), "in", 490000);
            } else if ("sfc_processreportbill".equals(sourceBillEntity) || "sfc_reportresource_adjust".equals(sourceBillEntity) || "pom_mftorderreport".equals(sourceBillEntity) || "om_processreport".equals(sourceBillEntity)) {
                if ("pom_mftorderreport".equals(sourceBillEntity)) {
                    ArrayList<String> entryStrIds = new ArrayList<String>(mftOrderEntryIds.size());
                    for (Long id : mftOrderEntryIds) {
                        entryStrIds.add(String.valueOf(id));
                    }
                    filter = InFilterHelper.getQFilterByBachSize("sumentry.mftentryid", new ArrayList<Object>(entryStrIds), "in", 490000);
                } else {
                    filter = InFilterHelper.getQFilterByBachSize("sumentry.manufactureentryid", new ArrayList<Object>(mftOrderEntryIds), "in", 490000);
                }
            } else if ("cal_costrecord_subentity".equals(sourceBillEntity)) {
                filter = InFilterHelper.getQFilterByBachSize("entry.mainbillentryid", new ArrayList<Object>(mftOrderEntryIds), "in", 490000);
            }
        }
        return filter;
    }

    private static List<QFilter> getCollectParamsQFilter(Long orgId, String targetBillEntity, String sourceBillEntity, String appNum, CollectReport collectReport) {
        ArrayList<QFilter> collConfigFilter = new ArrayList<QFilter>(10);
        if (CadEmptyUtils.isEmpty(sourceBillEntity)) {
            return collConfigFilter;
        }
        if (("cad_costobject".equals(targetBillEntity) || "cad_plannedoutputbill".equals(targetBillEntity)) && ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity))) {
            Set<Long> notNeedCollectBillBizIdsForCo = SysParamHelper.getNotNeedCollectBillBizIds(orgId, targetBillEntity, sourceBillEntity, "bizsettingentry.transactiontype.fbasedataid.id", appNum);
            if (!CadEmptyUtils.isEmpty(notNeedCollectBillBizIdsForCo)) {
                QFilter notCollRangeFilter = new QFilter("transactiontype", "not in", notNeedCollectBillBizIdsForCo);
                collConfigFilter.add(notCollRangeFilter);
                collectReport.setTransactionTypes(notNeedCollectBillBizIdsForCo);
            }
        } else if ("cad_factnedoutputbill".equals(targetBillEntity) && ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity)) || "im_mdc_omcmplinbill".equals(sourceBillEntity)) {
            Map<String, Set<Long>> notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap(orgId, targetBillEntity, sourceBillEntity, "bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", appNum);
            Set<Long> bizTypeIds = notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
            Set<Long> invSchemeIds = notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
            if (!CadEmptyUtils.isEmpty(bizTypeIds)) {
                collectReport.setBizTypeIds(bizTypeIds);
                collConfigFilter.add(new QFilter("biztype", "not in", bizTypeIds));
            }
            if (!CadEmptyUtils.isEmpty(invSchemeIds)) {
                collectReport.setInvSchemeIds(invSchemeIds);
                collConfigFilter.add(new QFilter("invscheme", "not in", invSchemeIds));
            }
        } else if (("sca_matusecollect".equals(targetBillEntity) || "aca_matusecollect".equals(targetBillEntity)) && ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity)) || "im_mdc_mftfeedorder".equals(sourceBillEntity) || "im_mdc_omoutbill".equals(sourceBillEntity) || "im_mdc_omreturnbill".equals(sourceBillEntity) || "im_mdc_omfeedbill".equals(sourceBillEntity) || "im_materialreqoutbill".equals(sourceBillEntity)) {
            Map<String, Set<Long>> notNeedCollectBillBizIdsMap = SysParamHelper.getNotNeedCollectBillBizIdsMap(orgId, targetBillEntity, sourceBillEntity, "bizsettingentry.biztype.fbasedataid.id,bizsettingentry.invscheme.fbasedataid.id", appNum);
            Set<Long> bizTypeIds = notNeedCollectBillBizIdsMap.get("bizsettingentry.biztype.fbasedataid.id");
            Set<Long> invSchemeIds = notNeedCollectBillBizIdsMap.get("bizsettingentry.invscheme.fbasedataid.id");
            if (!CadEmptyUtils.isEmpty(bizTypeIds)) {
                collectReport.setBizTypeIds(bizTypeIds);
                collConfigFilter.add(new QFilter("biztype", "not in", bizTypeIds));
            }
            if (!CadEmptyUtils.isEmpty(invSchemeIds)) {
                collectReport.setInvSchemeIds(invSchemeIds);
                collConfigFilter.add(new QFilter("invscheme", "not in", invSchemeIds));
            }
        }
        return collConfigFilter;
    }
}

