/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.QueryServiceHelper;

public class InFilterHelper {
    public static QFilter getQFilterByInMaxSize(String queryStr, List<Object> list, String qcp) {
        QFilter qf = null;
        if (list.size() > HugeInConfig.inMaxSize()) {
            List lists = Lists.partition(list, (int)HugeInConfig.inMaxSize());
            for (List tempList : lists) {
                if (qf == null) {
                    qf = new QFilter(queryStr, qcp, (Object)tempList);
                    continue;
                }
                if ("in".equals(qcp)) {
                    qf = qf.or(new QFilter(queryStr, qcp, (Object)tempList));
                    continue;
                }
                qf = qf.and(new QFilter(queryStr, qcp, (Object)tempList));
            }
        } else {
            qf = new QFilter(queryStr, qcp, list);
        }
        return qf;
    }

    public static QFilter getQFilterByInThreshold(String queryStr, List<Object> list, String qcp) {
        QFilter qf = null;
        if (list.size() > HugeInConfig.inThreshold() - 1) {
            List lists = Lists.partition(list, (int)(HugeInConfig.inThreshold() - 1));
            for (List tempList : lists) {
                if (qf == null) {
                    qf = new QFilter(queryStr, qcp, (Object)tempList);
                    continue;
                }
                if ("in".equals(qcp)) {
                    qf = qf.or(new QFilter(queryStr, qcp, (Object)tempList));
                    continue;
                }
                qf = qf.and(new QFilter(queryStr, qcp, (Object)tempList));
            }
        } else {
            qf = new QFilter(queryStr, qcp, list);
        }
        return qf;
    }

    public static QFilter getQFilterByBachSize(String queryStr, List<Object> list, String qcp, int batchSize) {
        QFilter qf = null;
        if (list.size() > batchSize) {
            List lists = Lists.partition(list, (int)batchSize);
            for (List tempList : lists) {
                if (qf == null) {
                    qf = new QFilter(queryStr, qcp, (Object)tempList);
                    continue;
                }
                if ("in".equals(qcp)) {
                    qf = qf.or(new QFilter(queryStr, qcp, (Object)tempList));
                    continue;
                }
                qf = qf.and(new QFilter(queryStr, qcp, (Object)tempList));
            }
        } else {
            qf = new QFilter(queryStr, qcp, list);
        }
        return qf;
    }

    public static DataSet queryDataSetIn(String entity, String selectField, QFilter filter, String inField, List<Object> listIds) {
        return InFilterHelper.queryDataSetIn(entity, selectField, filter, inField, listIds, 200000);
    }

    public static DataSet queryDataSetIn(String entity, String selectField, QFilter filter, String inField, List<Object> listIds, int batch) {
        List<Object> batchIds;
        if (listIds == null || listIds.isEmpty()) {
            batchIds = new ArrayList();
            batchIds.add(-1L);
        } else {
            batchIds = listIds;
        }
        DataSet csDataSet = null;
        List groupList = Lists.partition(batchIds, (int)batch);
        for (List list : groupList) {
            QFilter coFilter = new QFilter(inField, "in", (Object)list);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)entity, (String)entity, (String)selectField, (QFilter[])new QFilter[]{filter, coFilter}, null);
            if (csDataSet == null) {
                csDataSet = dataSet;
                continue;
            }
            csDataSet = csDataSet.union(dataSet);
        }
        return csDataSet;
    }
}

