/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.constants.InputOutputRptParam;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class InputOutputRptHelper {
    public static InputOutputRptParam getRptParam(ReportQueryParam reportQueryParam) {
        FilterInfo filter = reportQueryParam.getFilter();
        InputOutputRptParam rptParam = new InputOutputRptParam();
        rptParam.setAccountorg(filter.getDynamicObject("accountorg"));
        rptParam.setCostcenter(filter.getDynamicObject("costcenter"));
        rptParam.setCostobject(filter.getDynamicObject("costobject"));
        rptParam.setMaterial(filter.getDynamicObject("material"));
        rptParam.setIsShowDetail(filter.getBoolean("isshowdetail"));
        DynamicObjectCollection manuorg = filter.getDynamicObjectCollection("manuorg");
        if (manuorg != null) {
            Set<Long> manuorgIds = manuorg.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            rptParam.setManuorgIds(manuorgIds);
        }
        rptParam.setAppNum(filter.getString("appnum"));
        if (filter.getBoolean("isshowdetail")) {
            rptParam.setPlanneddate_startdate(filter.getDate("planneddate_startdate"));
            rptParam.setPlanneddate_enddate(filter.getDate("planneddate_enddate"));
        }
        return rptParam;
    }

    public static List<QFilter> getFiltersByPlan(InputOutputRptParam param, String entityId, String appNum) {
        long orgId;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (param.getAccountorg() != null) {
            filters.add(new QFilter("accountorg", "=", param.getAccountorg().getPkValue()));
        }
        if (param.getCostcenter() != null) {
            filters.add(new QFilter("costcenter", "=", param.getCostcenter().getPkValue()));
        }
        if (param.getCostobject() != null) {
            filters.add(new QFilter("costobject", "=", param.getCostobject().getPkValue()));
        }
        if (param.getMaterial() != null) {
            filters.add(new QFilter("material", "=", param.getMaterial().getPkValue()));
        }
        if (!CadEmptyUtils.isEmpty(param.getManuorgIds())) {
            filters.add(new QFilter("manuorg", "in", param.getManuorgIds()));
        } else if (param.getAccountorg() != null && OrgHelper.isOrgEnableMultiFactory(orgId = param.getAccountorg().getLong("id"))) {
            filters.add(new QFilter("manuorg", "in", ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, entityId, appNum)));
        }
        if (param.getPlanneddate_startdate() != null || param.getPlanneddate_enddate() != null) {
            Date planneddate_startdate = param.getPlanneddate_startdate();
            Calendar startCal = Calendar.getInstance();
            startCal.setTime(planneddate_startdate);
            startCal.set(11, 0);
            startCal.set(12, 0);
            startCal.set(13, 0);
            Date planneddate_enddate = param.getPlanneddate_enddate();
            Calendar endCal = Calendar.getInstance();
            endCal.setTime(planneddate_enddate);
            endCal.set(11, 23);
            endCal.set(12, 59);
            endCal.set(13, 59);
            filters.add(new QFilter("planneddate", ">=", (Object)startCal.getTime()));
            filters.add(new QFilter("planneddate", "<=", (Object)endCal.getTime()));
        }
        if ("aca".equals(param.getAppNum())) {
            filters.add(new QFilter("appnum", "=", (Object)"aca"));
        } else {
            filters.add(new QFilter("appnum", "!=", (Object)"aca"));
        }
        return filters;
    }

    public static List<QFilter> getFiltersByfactned(InputOutputRptParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (param.getAccountorg() != null) {
            filters.add(new QFilter("org", "=", param.getAccountorg().getPkValue()));
        }
        if (param.getCostcenter() != null) {
            filters.add(new QFilter("costcenter", "=", param.getCostcenter().getPkValue()));
        }
        if (param.getCostobject() != null) {
            filters.add(new QFilter("entryentity.costobjectf7", "=", param.getCostobject().getPkValue()));
        }
        if (param.getMaterial() != null) {
            filters.add(new QFilter("material", "=", param.getMaterial().getPkValue()));
        }
        return filters;
    }
}

