/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.constants.LogarithmParam;
import kd.macc.cad.common.constants.MultiLanguageConstants;
import kd.macc.cad.common.dto.CollectReport;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.EntityPropertyHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.OldCollectConfigHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DataSetUtils;

public class LogarithmHelper {
    private static final Log logger = LogFactory.getLog(LogarithmHelper.class);
    private static String[] COSTOBJECT_KEY_STR = new String[]{"material", "bookdate"};
    private static String[] PLAN_KEY_STR = new String[]{"material", "bizdate", "srctransmittime", "planneddate", "qty", "baseunit"};
    private static String[] FACT_KEY_STR = new String[]{"material", "bookdate", "bizdate", "baseunit", "completeqty"};
    private static String[] RES_KEY_STR = new String[]{"resource", "entryentity.workhour", "entryentity.facthour", "entryentity.opra", "entryentity.material"};
    private static String[] MAT_KEY_STR = new String[]{"entryentity.material", "entryentity.qty"};

    public static Map<String, Date> getQueryTime(FilterInfo info) {
        HashMap<String, Date> map = new HashMap<String, Date>(16);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDateStr = sdf1.format(info.getDate("startdate")) + " 00:00:00";
        String endDateStr = sdf1.format(info.getDate("enddate")) + " 24:00:00";
        try {
            map.put("startDate", sdf1.parse(startDateStr));
            map.put("endDate", sdf2.parse(endDateStr));
        }
        catch (ParseException e) {
            logger.info("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\uff1a" + e.getMessage());
        }
        return map;
    }

    public static DataSet getLogarithmInfo(LogarithmParam logarithmParam, QFilter filter, String algoKey, String entity, Set<String> ranges) {
        DataSet dataSet = null;
        if (org.apache.commons.lang.StringUtils.isBlank((String)entity)) {
            return dataSet;
        }
        switch (entity) {
            case "cad_costobject": {
                dataSet = LogarithmHelper.getCostObjectLogarithm(logarithmParam, filter, algoKey);
                break;
            }
            case "cad_plannedoutputbill": {
                dataSet = LogarithmHelper.getPlannedOutputLogarithm(logarithmParam, filter, algoKey, ranges);
                break;
            }
            case "cad_factnedoutputbill": {
                dataSet = LogarithmHelper.getFactoutputLogarithm(logarithmParam, filter, algoKey, entity, ranges);
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                dataSet = LogarithmHelper.getMatUseCollectLogarithm(logarithmParam, filter, algoKey, entity, ranges);
                break;
            }
            case "sca_resourceuse": {
                dataSet = LogarithmHelper.getResourceUseLogarithm(logarithmParam, filter, algoKey, entity, ranges);
                break;
            }
        }
        return dataSet;
    }

    public static Map<String, List<DynamicObject>> getCostCenterSourceDataMap(List<Long> costCenterIds, LogarithmParam logarithmParam) {
        HashMap<String, List<DynamicObject>> costCenterSourceDataListMap = new HashMap<String, List<DynamicObject>>(16);
        Date startDate = logarithmParam.getStartDate();
        Date endDate = logarithmParam.getEndDate();
        QFilter dateFilter = new QFilter("effectdate", "<", (Object)endDate).and(new QFilter("expdate", ">", (Object)startDate));
        QFilter ccFilter = new QFilter("costcenter", "in", costCenterIds);
        Object[] centerSourceMap = BusinessDataServiceHelper.load((String)"bos_costcentersourcemap", (String)"id,costcenter,effectdate,expdate,entryentity,entryentity.sourcetype,entryentity.sourcedata", (QFilter[])new QFilter[]{ccFilter, dateFilter});
        if (CadEmptyUtils.isEmpty(centerSourceMap)) {
            return costCenterSourceDataListMap;
        }
        for (Object sourceMap : centerSourceMap) {
            DynamicObjectCollection entryEntity = sourceMap.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                String mapKey = entry.getString("sourcetype") + "@" + entry.getLong("sourcedata.id");
                costCenterSourceDataListMap.computeIfAbsent(mapKey, s -> new ArrayList()).add(sourceMap);
            }
        }
        return costCenterSourceDataListMap;
    }

    public static Map<Long, DataSet> getCollconfigsDataSet(LogarithmParam logarithmParam, String entity) {
        HashMap<Long, DataSet> map = new HashMap<Long, DataSet>(16);
        Long orgId = logarithmParam.getOrgId();
        String appNum = logarithmParam.getAppnum();
        ORMImpl orm = new ORMImpl();
        List<Long> costCenterIds = logarithmParam.getCostCenterIds();
        if (costCenterIds == null) {
            return map;
        }
        List<Long> enableCostCenters = ImportServiceHelper.getCostCenterByDataRule(RequestContext.get().getCurrUserId(), Collections.singletonList(logarithmParam.getOrgId()), Sets.newHashSet(costCenterIds), entity, null);
        Map<String, DynamicObject> objRules = CostObjectHelper.getCostObjectRulesMap(orgId, enableCostCenters);
        HashSet<Long> calcDimensionIds = new HashSet<Long>(10);
        objRules.values().forEach(p -> {
            if ("RO".equalsIgnoreCase(p.getString("biztype"))) {
                calcDimensionIds.add(p.getLong("costcalcdimension"));
            }
        });
        List<DynamicObject> collConfigList = ImportServiceHelper.getCollConfigs(orgId, null, calcDimensionIds, entity, appNum);
        if (CadEmptyUtils.isEmpty(collConfigList)) {
            return map;
        }
        Map<Long, Map<String, String>> collConfigMappingMap = ImportServiceHelper.getCollConfigMappingMap(collConfigList);
        Map<Long, Map<String, String>> collSelectValueMappingMap = ImportServiceHelper.getCollSelectValueMappingMap(collConfigList);
        Map<Long, List<QFilter>> collConfigFilterMap = ImportServiceHelper.getCollConfigFilterMap(collConfigList, entity);
        Map<String, List<DynamicObject>> costCenterSourceDataMap = LogarithmHelper.getCostCenterSourceDataMap(enableCostCenters, logarithmParam);
        HashMap costCentersourceTypeDataMap = new HashMap(16);
        costCenterSourceDataMap.forEach((ccs, obj) -> {
            String[] srcDataStr = ccs.split("@");
            if (srcDataStr.length < 2) {
                return;
            }
            String sourceType = srcDataStr[0];
            Long sourceData = Long.parseLong(srcDataStr[1]);
            costCentersourceTypeDataMap.computeIfAbsent(sourceType, p -> new HashSet(10)).add(sourceData);
        });
        Boolean isOldUserForSysParamBizRange = ImportServiceHelper.isOldUserForSysParamBizRange();
        Map<String, List<Long>> billRangeMap = isOldUserForSysParamBizRange != false ? OldCollectConfigHelper.getBillRangeMap(logarithmParam.getOrgId(), logarithmParam.getCostCenterIds(), entity, logarithmParam.getAppnum(), new CollectReport()) : null;
        collConfigList.forEach(arg_0 -> LogarithmHelper.lambda$getCollconfigsDataSet$5(collConfigMappingMap, collSelectValueMappingMap, isOldUserForSysParamBizRange, billRangeMap, orgId, enableCostCenters, logarithmParam, collConfigFilterMap, costCentersourceTypeDataMap, entity, (ORM)orm, map, arg_0));
        return map;
    }

    private static String getQueryConfigFields(DynamicObjectCollection fields, String sourceBillEntity, String entity) {
        String field = "";
        ArrayList<String> list = new ArrayList<String>(10);
        switch (entity) {
            case "cad_costobject": {
                list.addAll(Arrays.asList(COSTOBJECT_KEY_STR));
                if (!"pom_mftorder".equals(sourceBillEntity) && !"om_mftorder".equals(sourceBillEntity)) break;
                field = "id,billno AS bizbillno,org AS bizorg,org.name AS bizorgname,transactiontype,transactiontype.name AS transactiontypename,transactiontype.isprocedure AS isprocedure,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.producedept AS adminorg,treeentryentity.workcenter AS workcenter,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype,'A' AS targetbill,1 AS srcbillnum";
                break;
            }
            case "cad_plannedoutputbill": {
                list.addAll(Arrays.asList(PLAN_KEY_STR));
                if ("pom_mftorder".equals(sourceBillEntity) || "om_mftorder".equals(sourceBillEntity)) {
                    field = "id,billno AS bizbillno,org AS bizorg,org.name AS bizorgname,transactiontype,transactiontype.name AS transactiontypename,transactiontype.isprocedure AS isprocedure,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.producedept AS adminorg,treeentryentity.workcenter AS workcenter,treeentryentity.bizstatus AS bizstatus,treeentryentity.closetime AS bizclosetime,billtype.billformid as srcbilltype,billtype.billformid.name as sourcebilltype,0L AS fromlogid,'B' AS targetbill,1 AS srcbillnum";
                    break;
                }
                if (!"cad_factnedoutputbill".equals(sourceBillEntity)) break;
                String sourceBillType = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355", (String)"LogarithmHelper_60", (String)"macc-cad-common", (Object[])new Object[0]);
                field = "id,billno AS bizbillno,manuorg AS bizorg,org.name AS bizorgname,0L transactiontype,' ' AS transactiontypename,1==0 AS isprocedure,entryentity.id AS entryId,entryentity.seq AS entryseq,0L AS adminorg,0L AS workcenter,' ' AS bizstatus,bookdate AS bizclosetime,'cad_factnedoutputbill' as srcbilltype,'" + sourceBillType + "' as sourcebilltype,0L AS fromlogid,'B' AS targetbill,1 AS srcbillnum";
                break;
            }
            case "cad_factnedoutputbill": {
                list.addAll(Arrays.asList(FACT_KEY_STR));
                if ("im_mdc_mftmanuinbill".equals(sourceBillEntity) || "im_mdc_mftreturnbill".equals(sourceBillEntity)) {
                    Set<String> billentrySet = EntityPropertyHelper.getEntryPropertys(sourceBillEntity, "billentry");
                    String dept = "bizdept";
                    if (billentrySet.contains("producedept")) {
                        dept = "billentry.producedept";
                    }
                    field = "id,billtype,billno AS bizbillno,productionorg AS bizorg,productionorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,billentry.id AS entryId,billentry.seq AS entryseq," + dept + " AS adminorg,billentry.workcenterid AS workcenter,billentry.manubill AS manubillno,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype,'C' AS targetbill,1 AS srcbillnum";
                }
                if (!"im_mdc_omcmplinbill".equals(sourceBillEntity)) break;
                field = "id,billtype,billno AS bizbillno,billentry.entryreqorg AS bizorg,bizorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,billentry.id AS entryId,billentry.seq AS entryseq,billentry.producedept AS adminorg,0 AS workcenter,billentry.manubill AS manubillno,billtype.billformid as srcbilltype,billtype.billformid.name as sourcebilltype,'C' AS targetbill,1 AS srcbillnum";
                break;
            }
            case "sca_resourceuse": {
                list.addAll(Arrays.asList(RES_KEY_STR));
                if ("sfc_processreportbill".equals(sourceBillEntity)) {
                    field = "id, billno AS bizbillno, org AS bizorg, org.name AS bizorgname, sumentry.seq AS seq,sumentry.completqty AS completqty,sumentry.manufacturenun AS manubillno,'' AS manftechno,0 AS transactiontype,'' AS transactiontypename,sumentry.repsubentryentity.seq AS subseq,sumentry.repsubentryentity.repactivity.unit AS subentryunit,docbilltype.billformid as srcbilltype,docbilltype.billformid.name as sourcebilltype,productworkshop.workshoporg AS adminorg,sumentry.workcenter AS workcenter,'D' AS targetbill,1 AS srcbillnum";
                }
                if ("sfc_reportresource_adjust".equals(sourceBillEntity)) {
                    list.remove("entryentity.material");
                    field = "id, billno AS bizbillno, org AS bizorg, org.name AS bizorgname, sumentry.seq AS seq,sumentry.completqty AS completqty,sumentry.manufacturenun AS manubillno,sumentry.manftechno.billno AS manftechno,0 AS transactiontype,'' AS transactiontypename,sumentry.repsubentryentity.seq AS subseq,sumentry.repsubentryentity.unit AS subentryunit,docbilltype.billformid as srcbilltype,docbilltype.billformid.name as sourcebilltype,productworkshop.workshoporg AS adminorg,sumentry.workcenter AS workcenter,'D' AS targetbill,1 AS srcbillnum";
                }
                if ("pom_mftorderreport".equals(sourceBillEntity)) {
                    field = "id, billno AS bizbillno, org AS bizorg, org.name AS bizorgname, sumentry.seq AS seq,sumentry.completqty AS completqty,sumentry.manufacturenun AS manubillno,'' AS manftechno,0 AS transactiontype,'' AS transactiontypename,sumentry.subentryentity.seq AS subseq,sumentry.subentryentity.repactivity.unit AS subentryunit,docbilltype.billformid as srcbilltype,docbilltype.billformid.name as sourcebilltype,sumentry.producedept AS adminorg,sumentry.workcenter AS workcenter,'D' AS targetbill,1 AS srcbillnum";
                }
                if (!"om_processreport".equals(sourceBillEntity)) break;
                field = "id, billno AS bizbillno, org AS bizorg, org.name AS bizorgname, sumentry.seq AS seq,sumentry.completqty AS completqty,sumentry.manufacturenun AS manubillno,'' AS manftechno,0 AS transactiontype,'' AS transactiontypename,sumentry.repsubentryentity.seq AS subseq,sumentry.repsubentryentity.repactivity.unit AS subentryunit,docbilltype.billformid as srcbilltype,docbilltype.billformid.name as sourcebilltype,productworkshop.workshoporg AS adminorg,0 AS workcenter,'D' AS targetbill,1 AS srcbillnum";
                break;
            }
            case "sca_matusecollect": 
            case "aca_matusecollect": {
                list.addAll(Arrays.asList(MAT_KEY_STR));
                if ("im_mdc_mftproorder".equals(sourceBillEntity) || "im_mdc_mftreturnorder".equals(sourceBillEntity) || "im_mdc_mftfeedorder".equals(sourceBillEntity)) {
                    field = "id,billtype,billno AS bizbillno,bizorg,bizorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,bookdate,billentry.id AS entryId,billentry.seq AS entryseq,billentry.baseunit AS bizbaseunit,billentry.manubill AS manubillno,billentry.manuentry AS manuentry, bizdept AS adminorg,billentry.oprworkcenter AS workcenter,workshopid,'E' AS targetbill,1 AS srcbillnum,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype";
                }
                if ("im_materialreqoutbill".equals(sourceBillEntity)) {
                    field = "id,billtype,billno AS bizbillno,bizorg,bizorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,bookdate,billentry.id AS entryId,billentry.seq AS entryseq,billentry.baseunit AS bizbaseunit,'' AS manubillno,'' AS manuentry, bizdept AS adminorg,0 AS workcenter, 0L AS workshopid,'E' AS targetbill,1 AS srcbillnum,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype";
                }
                if (!"im_mdc_omoutbill".equals(sourceBillEntity) && !"im_mdc_omreturnbill".equals(sourceBillEntity) && !"im_mdc_omfeedbill".equals(sourceBillEntity)) break;
                field = "id,billtype,billno AS bizbillno,bizorg,bizorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,bookdate,billentry.id AS entryId,billentry.seq AS entryseq,billentry.baseunit AS bizbaseunit,billentry.manubill AS manubillno,billentry.manuentry AS manuentry,bizdept AS adminorg,billentry.oprworkcenter AS workcenter, 0L AS workshopid,'E' AS targetbill,1 AS srcbillnum,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype";
                break;
            }
        }
        StringBuilder sbField = new StringBuilder(field);
        for (DynamicObject obj : fields) {
            String costfield = obj.getString("costfield");
            String sourcefield = obj.getString("sourcefield");
            String selectValue = obj.getString("selectvalue");
            if (!list.contains(costfield) || "1".equals(selectValue)) continue;
            String temp = "";
            temp = sourcefield.split(",").length > 1 ? sourcefield : sourcefield + " AS " + costfield;
            if (field.endsWith(",")) {
                sbField.append(temp);
                continue;
            }
            sbField.append(',').append(temp);
        }
        return sbField.toString();
    }

    public static Map<Long, Map<String, String>> getCollConfigMappingMap(List<DynamicObject> costCollectConfigs) {
        HashMap<Long, Map<String, String>> collConfigMappingMap = new HashMap<Long, Map<String, String>>(16);
        if (CadEmptyUtils.isEmpty(costCollectConfigs)) {
            return collConfigMappingMap;
        }
        costCollectConfigs.forEach(collConfig -> {
            DynamicObjectCollection fields = collConfig.getDynamicObjectCollection("fieldmapentity");
            for (DynamicObject field : fields) {
                String costfield = field.getString("costfield");
                String sourcefield = field.getString("sourcefield");
                collConfigMappingMap.computeIfAbsent(collConfig.getLong("id"), config -> new HashMap()).put(costfield, sourcefield);
            }
        });
        return collConfigMappingMap;
    }

    public static DataSet getCostObjectLogarithm(LogarithmParam logarithmParam, QFilter filter, String algoKey) {
        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5dee\u5f02\u5355\u67e5\u8be2\u5f00\u59cb");
        DataSet dataSetSource = LogarithmHelper.getCostObjectSource(logarithmParam, algoKey);
        DataSet dataSet = LogarithmHelper.getCostObject(filter, algoKey);
        DataSet dataSetResult = dataSetSource.join(dataSet).on("entryId", "probill").on("entryseq", "srcbillrow").select(new String[]{"bizorg", "bizbillno", "entryseq", "transactiontype", "bizmaterial", "srcbilltype"}, new String[]{"costcenter", "costobjectbillno", "material", "bizstatus", "sourcebilltype", "targetbill"}).finish().filter("bizmaterial != material").orderBy(new String[]{"bizorg", "costcenter", "bizbillno", "costobjectbillno"});
        logger.info("\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u5dee\u5f02\u5355\u67e5\u8be2\u7ed3\u675f");
        return dataSetResult;
    }

    public static DataSet getCostObjectSource(LogarithmParam logarithmParam, String algoKey) {
        Map<Long, DataSet> collConfigDataSetMap = LogarithmHelper.getCollconfigsDataSet(logarithmParam, "cad_costobject");
        String selectFiledsOne = "id,billno AS bizbillno,org AS bizorg,org.name AS bizorgname,transactiontype,transactiontype.name AS transactiontypename,transactiontype.isprocedure AS isprocedure,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.material.masterid AS bizmaterial,treeentryentity.beginbookdate AS transmittime,treeentryentity.producedept AS adminorg,treeentryentity.workcenter AS workcenter,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype,'A' AS targetbill,1 AS srcbillnum";
        ORMImpl orm = new ORMImpl();
        QFilter filter = new QFilter("1", "=", (Object)2);
        DataSet dataSet = orm.queryDataSet(algoKey, "pom_mftorder", selectFiledsOne, new QFilter[]{filter}, "", -1, null);
        if (collConfigDataSetMap.size() > 0) {
            String queryFields = "id,bizbillno,bizorg,bizorgname,transactiontype,transactiontypename,isprocedure,entryId,entryseq,material AS bizmaterial,bookdate AS transmittime,adminorg,workcenter,srcbilltype,sourcebilltype,targetbill,srcbillnum";
            for (Map.Entry<Long, DataSet> map : collConfigDataSetMap.entrySet()) {
                DataSet dataset = map.getValue();
                DataSet pomDataSet = dataset.select(queryFields);
                dataSet = DataSetUtils.union(dataSet, pomDataSet);
            }
            DataSet dataSetOne = dataSet.filter("isprocedure");
            DataSet dataSetTwo = dataSet.filter("!isprocedure");
            dataSetOne = LogarithmHelper.getResultDataSetByPlan(dataSetOne, "cad_costobject", algoKey);
            dataSet = dataSetOne.union(dataSetTwo);
        }
        return dataSet;
    }

    private static DataSet getResultDataSetByPlan(DataSet dataSet, String entity, String algoKey) {
        DataSet ds = dataSet.copy();
        HashSet<Long> entryIds = new HashSet<Long>(10);
        while (ds.hasNext()) {
            Row row = ds.next();
            if (row == null) continue;
            entryIds.add(row.getLong("entryId"));
        }
        QFilter entryIdQf = InFilterHelper.getQFilterByBachSize("mftentryseq.id", new ArrayList<Object>(entryIds), "in", 20000);
        DataSet manftechsDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"sfc_manftech", (String)"id,mftentryseq.id entryId,oprentryentity.id processentryid,oprentryentity.oprworkcenter workcenter,oprentryentity.oprno oprno", (QFilter[])new QFilter[]{entryIdQf}, null);
        DataSet omManftechsDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_mfttechnics", (String)"id,mftentryseq.id entryId,oprentryentity.id processentryid,oprentryentity.oprworkcenter workcenter,oprentryentity.oprno oprno", (QFilter[])new QFilter[]{entryIdQf}, null);
        manftechsDataSet = manftechsDataSet.union(omManftechsDataSet);
        DataSet groupbyDataSet = manftechsDataSet.copy().select("id,entryId,processentryid,workcenter,cast(oprno as Long) as oprno").groupBy(new String[]{"id"}).minP("oprno", "processentryid").finish();
        DataSet manFtechDataSet = groupbyDataSet.join(manftechsDataSet, JoinType.LEFT).on("id", "id").on("processentryid", "processentryid").select(manftechsDataSet.getRowMeta().getFieldNames()).finish();
        if ("cad_costobject".equals(entity)) {
            dataSet = dataSet.join(manFtechDataSet, JoinType.LEFT).on("entryId", "entryId").select(new String[]{"id", "bizbillno", "bizorg", "bizorgname", "transactiontype", "transactiontypename", "isprocedure", "entryId", "entryseq", "bizmaterial", "transmittime", "adminorg", "srcbilltype", "sourcebilltype", "targetbill", "srcbillnum"}, new String[]{"workcenter"}).finish().select(dataSet.getRowMeta().getFieldNames());
            return dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
        }
        dataSet = dataSet.join(manFtechDataSet, JoinType.LEFT).on("entryId", "entryId").select(new String[]{"id", "bizbillno", "bizorg", "bizorgname", "transactiontype", "transactiontypename", "isprocedure", "entryId", "entryseq", "bizmaterial", "transmittime", "adminorg", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "srcbilltype", "sourcebilltype", "fromlogid", "targetbill", "srcbillnum"}, new String[]{"workcenter"}).finish().select(dataSet.getRowMeta().getFieldNames());
        return dataSet.groupBy(dataSet.getRowMeta().getFieldNames()).finish();
    }

    public static DataSet getCostObject(QFilter filter, String algoKey) {
        String outSource = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355", (String)"LogarithmHelper_38", (String)"macc-cad-common", (Object[])new Object[0]);
        String proSource = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355", (String)"LogarithmHelper_39", (String)"macc-cad-common", (Object[])new Object[0]);
        String selectFiledstwo = "id,billno AS costobjectbillno,org,manuorg,manuorg.name AS manuorgname,costcenter,bizstatus,probill,srcbillrow,material,createtime AS transmittime,case when isoutsource='1' then '" + outSource + "' else '" + proSource + "' end sourcebilltype,1 AS billnum";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(algoKey, "cad_costobject", selectFiledstwo, new QFilter[]{filter}, "", -1, null);
        return dataSet;
    }

    public static DataSet getPlannedOutputLogarithm(LogarithmParam logarithmParam, QFilter filter, String algoKey, Set<String> ranges) {
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u67e5\u8be2\u5f00\u59cb");
        logger.info("\u67e5\u8be2\u6761\u4ef6:" + filter.toString());
        String appNum = logarithmParam.getAppnum();
        DataSet dataSetSource = LogarithmHelper.getPlannedOutputSource(logarithmParam, algoKey);
        QFilter filterResLog = new QFilter("changestatus", "=", (Object)"B");
        filterResLog.and(new QFilter("biztime", ">=", (Object)logarithmParam.getStartDate()));
        filterResLog.and(new QFilter("biztime", "<", (Object)logarithmParam.getEndDate()));
        QFilter filterSplit = new QFilter("orderstatus", "=", (Object)"C");
        filterSplit.and(new QFilter("createtime", ">=", (Object)logarithmParam.getStartDate()));
        filterSplit.and(new QFilter("createtime", "<", (Object)logarithmParam.getEndDate()));
        QFilter filterUnCurManu = new QFilter("org", "in", logarithmParam.getBizorgIds());
        filterUnCurManu.and(new QFilter("treeentryentity.taskstatus", "!=", (Object)"A"));
        if ("sca".equals(logarithmParam.getAppnum())) {
            filterUnCurManu.and(new QFilter("treeentryentity.producttype", "=", (Object)"C"));
        }
        Map<String, Map<String, Set<Long>>> collectMap = OldCollectConfigHelper.getCollectBillBizIdsMap(logarithmParam.getOrgId(), "cad_plannedoutputbill", logarithmParam.getAppnum());
        DataSet manuBillsSourceDataSet = dataSetSource.copy().filter("srcbilltype = 'pom_mftorder'");
        DataSet pomXmftOrderLogDataSet = LogarithmHelper.getPomXmftOrderLog(filterResLog, algoKey);
        DataSet pomXmftOrderSplitLogDataSet = LogarithmHelper.getPomMftOrderSplitLog(filterSplit, algoKey);
        manuBillsSourceDataSet = LogarithmHelper.getManuBillDataSet(manuBillsSourceDataSet, pomXmftOrderLogDataSet, pomXmftOrderSplitLogDataSet, filterUnCurManu, Boolean.FALSE, algoKey, collectMap);
        DataSet omManuBillsSourceDataSet = dataSetSource.copy().filter("srcbilltype = 'om_mftorder'");
        DataSet omXmftOrderLogDataSet = LogarithmHelper.getOmXmftOrderLog(filterResLog, algoKey);
        DataSet omXmftOrderSplitLogDataSet = LogarithmHelper.getOmMftOrderSplitLog(filterSplit, algoKey);
        omManuBillsSourceDataSet = LogarithmHelper.getManuBillDataSet(omManuBillsSourceDataSet, omXmftOrderLogDataSet, omXmftOrderSplitLogDataSet, filterUnCurManu, Boolean.TRUE, algoKey, collectMap);
        DataSet dataSetPlanSource = manuBillsSourceDataSet.union(omManuBillsSourceDataSet.select(manuBillsSourceDataSet.getRowMeta().getFieldNames())).groupBy(manuBillsSourceDataSet.getRowMeta().getFieldNames()).finish();
        DataSet dataSetPlan = LogarithmHelper.getPlannedOutput(filter, algoKey);
        if ("aca".equals(appNum)) {
            ArrayList<String> srcbilltype = new ArrayList<String>(10);
            ArrayList<String> source = new ArrayList<String>(10);
            if (ranges.contains("SCGD")) {
                srcbilltype.add(String.format("'%s'", "pom_mftorder"));
                source.add(String.format("'%s'", "pom_mftorder"));
                source.add(String.format("'%s'", "pom_xmftorderlog"));
                source.add(String.format("'%s'", "pom_mftorder_splitlog"));
            }
            if (ranges.contains("WWGD")) {
                srcbilltype.add(String.format("'%s'", "om_mftorder"));
                source.add(String.format("'%s'", "om_mftorder"));
                source.add(String.format("'%s'", "om_xmftorderlog"));
                source.add(String.format("'%s'", "om_mftorder_splitog"));
            }
            if (srcbilltype.size() > 0) {
                dataSetPlanSource = dataSetPlanSource.filter("srcbilltype in (" + org.apache.commons.lang.StringUtils.join(srcbilltype, (String)",") + ")");
            }
            if (source.size() > 0) {
                dataSetPlan = dataSetPlan.filter("sourceType in (" + org.apache.commons.lang.StringUtils.join(source, (String)",") + ")");
            }
        }
        DataSet dataSetQtySum = dataSetPlan.groupBy(new String[]{"costobject"}).sum("calqty").finish();
        DataSet dataSetPlanResult = dataSetPlan.leftJoin(dataSetQtySum).on("costobject", "costobject").select(new String[]{"plannedoutputbillno", "accountorg", "manuorg", "costcenter", "sourcebill", "srcbillrow", "material", "baseunit", "qty", "closestatus", "closetime", "bizdate", "billnum"}, new String[]{"calqty"}).finish();
        DataSet dataSetPlanSourceSum = dataSetPlanSource.groupBy(new String[]{"id", "entryId", "bizmaterial", "entryseq"}).sum("bizqty").finish().select(new String[]{"id", "entryId", "bizmaterial", "entryseq", "bizqty calbizqty"});
        DataSet dataSetPlanSourceSeult = dataSetPlanSource.leftJoin(dataSetPlanSourceSum).on("id", "id").on("entryId", "entryId").on("bizmaterial", "bizmaterial").on("entryseq", "entryseq").select(dataSetPlanSource.getRowMeta().getFieldNames(), new String[]{"calbizqty"}).finish();
        DataSet dataSet = dataSetPlanSourceSeult.join(dataSetPlanResult).on("id", "sourcebill").on("entryseq", "srcbillrow").select(new String[]{"bizorg", "bizbillno", "entryseq", "transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "bizstatus", "bizclosetime", "srcbilltype", "calbizqty"}, new String[]{"costcenter", "plannedoutputbillno", "material", "baseunit", "qty", "closestatus", "closetime", "sourcebilltype", "targetbill", "calqty"}).finish().filter("calbizqty != calqty or bizmaterial != material").orderBy(new String[]{"bizorg", "costcenter", "bizbillno", "plannedoutputbillno"});
        logger.info("\u8ba1\u5212\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u5355\u67e5\u8be2\u7ed3\u675f");
        return dataSet;
    }

    public static DataSet getPlannedOutputSource(LogarithmParam logarithmParam, String algoKey) {
        String selectFileds = "id,billno AS bizbillno,org AS bizorg,org.name AS bizorgname,transactiontype,transactiontype.name AS transactiontypename,transactiontype.isprocedure AS isprocedure,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.material.masterid AS bizmaterial,treeentryentity.beginbookdate AS transmittime,treeentryentity.producedept AS adminorg,treeentryentity.workcenter AS workcenter,treeentryentity.baseunit AS bizbaseunit,treeentryentity.planbaseqty AS bizqty,treeentryentity.bizstatus AS bizstatus,treeentryentity.closetime AS bizclosetime,billtype.billformid as srcbilltype,billtype.billformid.name as sourcebilltype,0L AS fromlogid,'B' AS targetbill,1 AS srcbillnum";
        ORMImpl orm = new ORMImpl();
        QFilter filter = new QFilter("1", "=", (Object)2);
        DataSet dataSet = orm.queryDataSet(algoKey, "pom_mftorder", selectFileds, new QFilter[]{filter}, "", -1, null);
        Map<Long, DataSet> collConfigDataSetMap = LogarithmHelper.getCollconfigsDataSet(logarithmParam, "cad_plannedoutputbill");
        if (collConfigDataSetMap.size() > 0) {
            String queryFields = "id,bizbillno,bizorg,bizorgname,transactiontype,transactiontypename,isprocedure,entryId,entryseq,material AS bizmaterial,bizdate AS transmittime,adminorg,workcenter,baseunit AS bizbaseunit,qty AS bizqty,bizstatus,bizclosetime,srcbilltype,sourcebilltype,fromlogid,targetbill,srcbillnum";
            for (Map.Entry<Long, DataSet> map : collConfigDataSetMap.entrySet()) {
                DataSet dataset = map.getValue();
                DataSet tempDataSet = dataset.select(queryFields);
                dataSet = DataSetUtils.union(dataSet, tempDataSet);
            }
            DataSet dataSetOne = dataSet.filter("isprocedure");
            DataSet dataSetTwo = dataSet.filter("!isprocedure");
            dataSetOne = LogarithmHelper.getResultDataSetByPlan(dataSetOne, "cad_plannedoutputbill", algoKey);
            dataSet = dataSetOne.union(dataSetTwo);
        }
        return dataSet;
    }

    public static DataSet getManuBills(QFilter filter, List<Long> costCenterSources, String costCenterSourceType, String algoKey, Map<String, Map<String, Set<Long>>> collectMap) {
        Set<Long> transactiontype;
        Map<String, Set<Long>> entryMap;
        String selectFileds = "id,billno AS bizbillno,org AS bizorg,org.name AS bizorgname,transactiontype,transactiontype.name AS transactiontypename,transactiontype.isprocedure AS isprocedure,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.material.masterid AS bizmaterial,treeentryentity.beginbookdate AS transmittime,treeentryentity.producedept AS adminorg,treeentryentity.workcenter AS workcenter,treeentryentity.baseunit AS bizbaseunit,treeentryentity.planbaseqty AS bizqty,treeentryentity.bizstatus AS bizstatus,treeentryentity.closetime AS bizclosetime,billtype.billformid as srcbilltype,billtype.billformid.name as sourcebilltype,0L AS fromlogid,'B' AS targetbill,1 AS srcbillnum";
        ORMImpl orm = new ORMImpl();
        QFilter ccQfilterByCostCenter = LogarithmHelper.getCcQfilterByCostCenter(costCenterSources, costCenterSourceType, "pom_mftorder");
        QFilter setQfilter = null;
        if (!(CadEmptyUtils.isEmpty(collectMap) || CadEmptyUtils.isEmpty(entryMap = collectMap.get("pom_mftorder")) || CadEmptyUtils.isEmpty(transactiontype = entryMap.get("transactiontype")))) {
            setQfilter = new QFilter("transactiontype", "not in", transactiontype);
        }
        DataSet pomDataSet = orm.queryDataSet(algoKey, "pom_mftorder", selectFileds, new QFilter[]{filter, ccQfilterByCostCenter, setQfilter}, "", -1, null);
        DataSet dataSetOne = pomDataSet.filter("isprocedure");
        DataSet dataSetTwo = pomDataSet.filter("!isprocedure");
        dataSetOne = LogarithmHelper.getResultDataSetByPlan(dataSetOne, "cad_plannedoutputbill", algoKey);
        return dataSetOne.union(dataSetTwo);
    }

    public static DataSet getOmManuBills(QFilter filter, List<Long> costCenterSources, String costCenterSourceType, String algoKey, Map<String, Map<String, Set<Long>>> collectMap) {
        Set<Long> transactiontype;
        Map<String, Set<Long>> entryMap;
        String selectFileds = "id,billno AS bizbillno,org AS bizorg,org.name AS bizorgname,transactiontype,transactiontype.name AS transactiontypename,transactiontype.isprocedure AS isprocedure,treeentryentity.id AS entryId,treeentryentity.seq AS entryseq,treeentryentity.material.masterid AS bizmaterial,treeentryentity.beginbookdate AS transmittime,treeentryentity.producedept AS adminorg,treeentryentity.workcenter AS workcenter,treeentryentity.baseunit AS bizbaseunit,treeentryentity.planbaseqty AS bizqty,treeentryentity.bizstatus AS bizstatus,treeentryentity.closetime AS bizclosetime,billtype.billformid as srcbilltype,billtype.billformid.name as sourcebilltype,0L AS fromlogid,'B' AS targetbill,1 AS srcbillnum";
        ORMImpl orm = new ORMImpl();
        QFilter ccQfilterByCostCenter = LogarithmHelper.getCcQfilterByCostCenter(costCenterSources, costCenterSourceType, "om_mftorder");
        QFilter setQfilter = null;
        if (!(CadEmptyUtils.isEmpty(collectMap) || CadEmptyUtils.isEmpty(entryMap = collectMap.get("om_mftorder")) || CadEmptyUtils.isEmpty(transactiontype = entryMap.get("transactiontype")))) {
            setQfilter = new QFilter("transactiontype", "not in", transactiontype);
        }
        return orm.queryDataSet(algoKey, "om_mftorder", selectFileds, new QFilter[]{filter, ccQfilterByCostCenter, setQfilter}, "", -1, null);
    }

    public static DataSet getPomXmftOrderLog(QFilter filter, String algoKey) {
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom_xmftorderlog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_xmftorderlog", (String)"id,xbillno,srcbillid,srcbillentryid,entryentity.qty as qty", (QFilter[])new QFilter[]{filter}, null);
        int len = dataSet.getRowMeta().getFields().length;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String qty = row.getString("qty");
            qty = String.valueOf(LogarithmHelper.parseQty(qty));
            Object[] dataRow = new Object[len];
            for (int i = 0; i < len; ++i) {
                dataRow[i] = "qty".equals(dataSet.getRowMeta().getFieldName(i)) ? qty : row.get(i);
            }
            dataList.add(dataRow);
        }
        String proBillChange = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u53d8\u66f4\u5355", (String)"LogarithmHelper_40", (String)"macc-cad-common", (Object[])new Object[0]);
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), dataSet.getRowMeta()).filter("qty != 'null'").addField("'pom_xmftorderlog'", "srcbilltype").addField(String.format("'%s'", proBillChange), "sourcebilltype");
    }

    public static DataSet getOmXmftOrderLog(QFilter filter, String algoKey) {
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"om_xmftorderlog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_xmftorderlog", (String)"id,xbillno,srcbillid,srcbillentryid,entryentity.qty as qty", (QFilter[])new QFilter[]{filter}, null);
        int len = dataSet.getRowMeta().getFields().length;
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            String qty = row.getString("qty");
            qty = String.valueOf(LogarithmHelper.parseQty(qty));
            Object[] dataRow = new Object[len];
            for (int i = 0; i < len; ++i) {
                dataRow[i] = "qty".equals(dataSet.getRowMeta().getFieldName(i)) ? qty : row.get(i);
            }
            dataList.add(dataRow);
        }
        String outBillChange = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u53d8\u66f4\u5355", (String)"LogarithmHelper_41", (String)"macc-cad-common", (Object[])new Object[0]);
        return Algo.create((String)"macc.cad.rpt").createDataSet(dataList.iterator(), dataSet.getRowMeta()).filter("qty != 'null'").addField("'om_xmftorderlog'", "srcbilltype").addField(String.format("'%s'", outBillChange), "sourcebilltype");
    }

    public static DataSet getPomMftOrderSplitLog(QFilter filter, String algoKey) {
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"pom_mftorder_splitlog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pom_mftorder_splitlog", (String)"id,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty,id as xbillno", (QFilter[])new QFilter[]{filter}, null);
        String proBillSplit = ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355\u62c6\u5206\u5355", (String)"LogarithmHelper_42", (String)"macc-cad-common", (Object[])new Object[0]);
        return dataSet.select("id,xbillno,srcbillid,srcbillentryid,aftqty-befqty as qty").filter("qty is not null").addField("'pom_mftorder_splitlog'", "srcbilltype").addField(String.format("'%s'", proBillSplit), "sourcebilltype");
    }

    public static DataSet getOmMftOrderSplitLog(QFilter filter, String algoKey) {
        if (!QueryServiceHelper.exists((String)"bos_objecttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"om_mftorder_splitog")})) {
            return null;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"om_mftorder_splitog", (String)"id,orderid as srcbillid,orderentryid as srcbillentryid,aftsplitqty as aftqty,befsplitqty as befqty,id as xbillno", (QFilter[])new QFilter[]{filter}, null);
        String proBillSplit = ResManager.loadKDString((String)"\u59d4\u5916\u5de5\u5355\u62c6\u5206\u5355", (String)"LogarithmHelper_61", (String)"macc-cad-common", (Object[])new Object[0]);
        return dataSet.select("id,xbillno,srcbillid,srcbillentryid,aftqty-befqty as qty").filter("qty is not null").addField("'om_mftorder_splitog'", "srcbilltype").addField(String.format("'%s'", proBillSplit), "sourcebilltype");
    }

    public static DataSet getPlannedOutput(QFilter filter, String algoKey) {
        String selectFiledstwo = "id, costobject,billno AS plannedoutputbillno,accountorg,manuorg,manuorg.name AS manuorgname,costcenter,sourcebill,sourcebillentry,costobject.srcbillrow AS srcbillrow,fromlogid,material,baseunit,qty,qty AS calqty,closestatu AS closestatus,closedatetime AS closetime,bizdate,srcbilltype sourceType,srcbilltype.name sourcebilltype,1 AS billnum,collconfig";
        ORMImpl orm = new ORMImpl();
        return orm.queryDataSet(algoKey, "cad_plannedoutputbill", selectFiledstwo, new QFilter[]{filter}, "", -1, null);
    }

    public static DataSet getFactoutputLogarithm(LogarithmParam logarithmParam, QFilter filter, String algoKey, String entity, Set<String> ranges) {
        logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u5f00\u59cb" + entity);
        DataSet dataSetSource = LogarithmHelper.getFactoutputSource(logarithmParam, algoKey);
        DataSet dataSetFact = LogarithmHelper.getFactoutput(filter, algoKey, entity);
        ArrayList<String> srcbilltype = new ArrayList<String>(10);
        if (ranges.contains("WIPCOMPELETE")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_mftmanuinbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftreturnbill"));
        }
        if (ranges.contains("WWGRK")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_omcmplinbill"));
        }
        if (srcbilltype.size() > 0) {
            dataSetSource = dataSetSource.filter("srcbilltype in (" + org.apache.commons.lang.StringUtils.join(srcbilltype, (String)",") + ")");
            dataSetFact = dataSetFact.filter("completetype in (" + org.apache.commons.lang.StringUtils.join(srcbilltype, (String)",") + ")");
        }
        DataSet dataSet = dataSetSource.join(dataSetFact).on("id", "sourcebill").on("entryId", "sourcebillentry").select(new String[]{"bizorg", "manubillno", "bizbillno", "entryseq", "invscheme", "transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype", "targetbill"}, new String[]{"costcenter", "factoutputbillno", "material", "baseunit", "completeqty", "costobject", "sourcebilltype"}).finish().filter("bizqty != completeqty or bizmaterial != material").orderBy(new String[]{"bizorg", "costcenter", "bizbillno", "factoutputbillno"});
        logger.info("\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u7ed3\u675f" + entity);
        return dataSet;
    }

    public static DataSet getFactoutputSource(LogarithmParam logarithmParam, String algoKey) {
        Set<String> billentrySet = EntityPropertyHelper.getEntryPropertys("im_mdc_mftmanuinbill", "billentry");
        String dept = "bizdept";
        if (billentrySet.contains("producedept")) {
            dept = "billentry.producedept";
        }
        String selectFileds = "id,billtype,billno AS bizbillno,productionorg AS bizorg,productionorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,billentry.id AS entryId,billentry.seq AS entryseq," + dept + " AS adminorg,billentry.workcenterid AS workcenter,billentry.material.masterid AS bizmaterial,billentry.unit AS bizbaseunit,billentry.baseqty AS bizqty,billentry.manubill AS manubillno,billtype.billformid as srcbilltype,billtype.billformid.name as sourcebilltype,'C' AS targetbill,1 AS srcbillnum";
        QFilter filter = new QFilter("1", "=", (Object)2);
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(algoKey, "im_mdc_mftmanuinbill", selectFileds, new QFilter[]{filter}, "", -1, null);
        Map<Long, DataSet> collConfigDataSetMap = LogarithmHelper.getCollconfigsDataSet(logarithmParam, "cad_factnedoutputbill");
        if (collConfigDataSetMap.size() > 0) {
            String queryFields = "id,billtype,bizbillno,bizorg,bizorgname,invscheme,transactiontype,transactiontypename,entryId,entryseq,adminorg,workcenter,material AS bizmaterial,baseunit AS bizbaseunit,completeqty AS bizqty,manubillno,srcbilltype,sourcebilltype,targetbill,srcbillnum";
            for (Map.Entry<Long, DataSet> map : collConfigDataSetMap.entrySet()) {
                DataSet dataset = map.getValue();
                DataSet tempDataSet = dataset.select(queryFields);
                dataSet = DataSetUtils.union(dataSet, tempDataSet);
            }
        }
        return dataSet.distinct();
    }

    public static Set<Long> queryObjSourceBill(LogarithmParam logarithmParam, long orgId) {
        HashSet<Long> entryIds = new HashSet<Long>(32);
        if (CadEmptyUtils.isEmpty(orgId)) {
            return entryIds;
        }
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        QFilter billStatusQf = new QFilter("billstatus", "=", (Object)"C");
        QFilter[] filters = new QFilter[]{orgQf, billStatusQf};
        DataSet costObjects = QueryServiceHelper.queryDataSet((String)"ColDiffRptBase.queryObj", (String)"cad_costobject", (String)"probill", (QFilter[])filters, (String)"id desc");
        if (costObjects != null) {
            for (Row costObject : costObjects) {
                Long proBill = costObject.getLong("probill");
                if (CadEmptyUtils.isEmpty(proBill)) continue;
                entryIds.add(proBill);
            }
        }
        logarithmParam.getEntryIds().addAll(entryIds);
        return entryIds;
    }

    public static DataSet getFactoutput(QFilter filter, String algoKey, String entity) {
        String selectFiledsThree = "id,billno AS factoutputbillno,org,manuorg,manuorg.name AS manuorgname,costcenter,sourcebill,sourcebillentry,material,baseunit,completeqty,entryentity.costobject AS costobject,bookdate,srcbilltype completetype,srcbilltype.name sourcebilltype,1 AS billnum";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(algoKey, entity, selectFiledsThree, new QFilter[]{filter}, "", -1, null);
        return dataSet;
    }

    public static DataSet getMatUseCollectLogarithm(LogarithmParam logarithmParam, QFilter filter, String algoKey, String entity, Set<String> ranges) {
        logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u5f00\u59cb");
        if (org.apache.commons.lang.StringUtils.isBlank((String)entity)) {
            return null;
        }
        DataSet dataSetSource = LogarithmHelper.getMatUseCollectSource(logarithmParam, algoKey);
        DataSet dataSetMat = LogarithmHelper.getMatUseCollect(filter, algoKey, entity);
        ArrayList<String> srcbilltype = new ArrayList<String>(10);
        if (ranges.contains("PRO_GET")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_mftproorder"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftreturnorder"));
            srcbilltype.add(String.format("'%s'", "im_mdc_mftfeedorder"));
        }
        if (ranges.contains("GET_OUTSTORAGE")) {
            srcbilltype.add(String.format("'%s'", "im_materialreqoutbill"));
        }
        if (ranges.contains("WLL")) {
            srcbilltype.add(String.format("'%s'", "im_mdc_omoutbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_omreturnbill"));
            srcbilltype.add(String.format("'%s'", "im_mdc_omfeedbill"));
        }
        if (srcbilltype.size() > 0) {
            dataSetSource = dataSetSource.filter("srcbilltype in (" + org.apache.commons.lang.StringUtils.join(srcbilltype, (String)",") + ")");
            dataSetMat = dataSetMat.filter("srcbill in (" + org.apache.commons.lang.StringUtils.join(srcbilltype, (String)",") + ")");
        }
        DataSet dataSet = dataSetSource.join(dataSetMat).on("id", "sourcebillid").on("entryId", "sourceEntryId").select(new String[]{"bizorg", "manubillno", "bizbillno", "entryseq", "invscheme", "transactiontype", "bizmaterial", "bizbaseunit", "bizqty", "srcbilltype"}, new String[]{"costcenter", "matcollectbillno", "material", "unit", "qty", "appnum", "sourcebilltype", "targetbill", "entryseq1"}).finish().filter("bizqty != qty or bizmaterial != material").orderBy(new String[]{"bizorg", "costcenter", "bizbillno", "matcollectbillno"});
        logger.info("\u6750\u6599\u8017\u7528\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u7ed3\u675f");
        return dataSet;
    }

    public static DataSet getMatUseCollectSource(LogarithmParam logarithmParam, String algoKey) {
        Map<Long, DataSet> collConfigDataSetMap;
        String selectFileds = "id,billtype,billno AS bizbillno,bizorg,bizorg.name AS bizorgname,invscheme,invscheme AS transactiontype,invscheme.name AS transactiontypename,bookdate,billentry.id AS entryId,billentry.seq AS entryseq,billentry.material.masterid AS bizmaterial,billentry.baseunit AS bizbaseunit,billentry.baseqty AS bizqty,billentry.manubill AS manubillno,billentry.manuentry AS manuentry, bizdept AS adminorg,billentry.oprworkcenter AS workcenter,workshopid,'E' AS targetbill,1 AS srcbillnum,billtype.billformid AS srcbilltype,billtype.billformid.name AS sourcebilltype";
        QFilter filter = new QFilter("1", "=", (Object)2);
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(algoKey, "im_mdc_mftproorder", selectFileds, new QFilter[]{filter}, "", -1, null);
        String entity = "sca_matusecollect";
        if ("ACA".equalsIgnoreCase(logarithmParam.getAppnum())) {
            entity = "aca_matusecollect";
        }
        if ((collConfigDataSetMap = LogarithmHelper.getCollconfigsDataSet(logarithmParam, entity)).size() > 0) {
            String queryFields = "id,billtype,bizbillno,bizorg,bizorgname,invscheme,transactiontype,transactiontypename,bookdate,entryId,entryseq,entryentity.material AS bizmaterial,bizbaseunit,entryentity.qty AS bizqty,manubillno,manuentry,adminorg,workcenter,workshopid,targetbill,srcbillnum,srcbilltype,sourcebilltype";
            for (Map.Entry<Long, DataSet> map : collConfigDataSetMap.entrySet()) {
                DataSet dataset = map.getValue();
                DataSet tempDataSet = dataset.select(queryFields);
                dataSet = DataSetUtils.union(dataSet, tempDataSet);
            }
        }
        return dataSet;
    }

    public static DataSet getMatUseCollect(QFilter filter, String algoKey, String entity) {
        String selectFiledsThree = "id,billno AS matcollectbillno,org,manuorg,manuorg.name AS manuorgname,costcenter,srcbilltype AS srcbill,appnum,sourcebillid,entryentity.seq AS entryseq1,entryentity.sourcebillentryid AS sourceEntryId,entryentity.material AS material,entryentity.unit AS unit,entryentity.qty AS qty\t,bookdate,srcbilltype.name sourcebilltype,1 AS billnum";
        ORMImpl orm = new ORMImpl();
        return orm.queryDataSet(algoKey, entity, selectFiledsThree, new QFilter[]{filter}, "", -1, null);
    }

    public static DataSet getResourceUseLogarithm(LogarithmParam logarithmParam, QFilter filter, String algoKey, String entity, Set<String> ranges) {
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u5f00\u59cb" + entity);
        String appnum = logarithmParam.getAppnum();
        DataSet dataSetSource = LogarithmHelper.getResourceUseSource(logarithmParam, algoKey).addField("bizbillno+'-'+cast(seq AS String)+'-'+cast(subseq AS String)", "selectKey");
        DataSet dataSetResource = LogarithmHelper.getResourceUse(filter, algoKey, entity);
        ArrayList<String> srcbilltype = new ArrayList<String>(10);
        ArrayList<String> sourcebilltype = new ArrayList<String>(10);
        if (ranges.contains("PROCESSREPORT")) {
            srcbilltype.add(String.format("'%s'", "sfc_processreportbill"));
            sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadProcessReportBill()));
        }
        if (ranges.contains("PROCESSADJUST")) {
            srcbilltype.add(String.format("'%s'", "sfc_reportresource_adjust"));
            sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadReportResourceAdjust()));
        }
        if (ranges.contains("MFTORDERREPORT")) {
            srcbilltype.add(String.format("'%s'", "pom_mftorderreport"));
            sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadMftOrderReport()));
        }
        if (ranges.contains("WGXHB")) {
            srcbilltype.add(String.format("'%s'", "om_processreport"));
            sourcebilltype.add(String.format("'%s'", MultiLanguageConstants.getCadProcessReport()));
        }
        if (srcbilltype.size() > 0) {
            dataSetSource = dataSetSource.filter("srcbilltype in (" + org.apache.commons.lang.StringUtils.join(srcbilltype, (String)",") + ")");
        }
        if (sourcebilltype.size() > 0) {
            dataSetResource = dataSetResource.filter("sourcebilltype in (" + org.apache.commons.lang.StringUtils.join(sourcebilltype, (String)",") + ")");
        }
        String filterStr = "entryresource != resource or bizmaterial != material or subentrysumqty != facthour or subentryunit != workhour";
        if ("sca".equals(appnum)) {
            filterStr = "entryresource != resource or bizmaterial != material or subentryunit != workhour or subentrysumqty != facthour or completqty != factuse";
        }
        DataSet dataSet3 = dataSetSource.join(dataSetResource).on("id", "srcbillid").on("selectKey", "resourceusebillno").select(new String[]{"bizorg", "manubillno", "bizbillno", "subseq", "bizmaterial", "oprunit", "transactiontype", "completqty", "srcbilltype", "entryresource", "subentryunit", "subentrysumqty", "targetbill", "sourcebilltype"}, new String[]{"costcenter", "resourceusebillno", "material", "resource", "workhour", "facthour", "factuse", "factbatch", "costobject"}).finish().filter(filterStr).orderBy(new String[]{"bizorg", "costcenter", "bizbillno", "resourceusebillno"});
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5dee\u5f02\u8868\u67e5\u8be2\u7ed3\u675f" + entity);
        return dataSet3;
    }

    public static DataSet getResourceUse(QFilter filter, String algoKey, String entity) {
        String selectFiledsThree = "id,billno AS resourceusebillno,org,manuorg,manuorg.name AS manuorgname,costcenter,resource,srcbillid,entryentity.material AS material,entryentity.workhour AS workhour,entryentity.facthour AS facthour,entryentity.factuse AS factuse,entryentity.factbatch AS factbatch,entryentity.costobject AS costobject,case when srcbilltype = 'sfc_processreportbill' then '" + MultiLanguageConstants.getCadProcessReportBill() + "' when srcbilltype = 'sfc_reportresource_adjust' then '" + MultiLanguageConstants.getCadReportResourceAdjust() + "' when srcbilltype = 'pom_mftorderreport' then '" + MultiLanguageConstants.getCadMftOrderReport() + "' else '" + MultiLanguageConstants.getCadProcessReport() + "' end sourcebilltype,1 AS billnum";
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(algoKey, entity, selectFiledsThree, new QFilter[]{filter}, "", -1, null);
        return dataSet;
    }

    public static DataSet getResourceUseSource(LogarithmParam logarithmParam, String algoKey) {
        String selectFileds = "id, billno AS bizbillno, org AS bizorg, org.name AS bizorgname, sumentry.seq AS seq,sumentry.sequnit AS oprunit,sumentry.completqty AS completqty,sumentry.manufacturenun AS manubillno,'' AS manftechno,0 AS transactiontype,'' AS transactiontypename,sumentry.repsubentryentity.seq AS subseq,sumentry.repsubentryentity.represources AS entryresource,sumentry.repsubentryentity.repactivity.unit AS subentryunit,sumentry.repsubentryentity.repactualqty AS subentrysumqty,docbilltype.billformid as srcbilltype,docbilltype.billformid.name as sourcebilltype,sumentry.material.masterid AS bizmaterial,productworkshop.workshoporg AS adminorg,sumentry.workcenter AS workcenter,'D' AS targetbill,1 AS srcbillnum";
        QFilter filter = new QFilter("1", "=", (Object)2);
        ORMImpl orm = new ORMImpl();
        DataSet dataSet = orm.queryDataSet(algoKey, "sfc_processreportbill", selectFileds, new QFilter[]{filter}, "", -1, null);
        Map<Long, DataSet> collConfigDataSetMap = LogarithmHelper.getCollconfigsDataSet(logarithmParam, "sca_resourceuse");
        if (collConfigDataSetMap.size() > 0) {
            String queryFields = "id,bizbillno,bizorg,bizorgname,seq,entryentity.workhour AS oprunit,completqty,manubillno,manftechno,transactiontype,transactiontypename,subseq,resource AS entryresource,subentryunit,entryentity.facthour AS subentrysumqty,srcbilltype,sourcebilltype,entryentity.material AS bizmaterial,adminorg,workcenter,targetbill,srcbillnum";
            for (Map.Entry<Long, DataSet> map : collConfigDataSetMap.entrySet()) {
                DataSet dataset = map.getValue();
                DataSet tempDataSet = dataset.select(queryFields);
                dataSet = DataSetUtils.union(dataSet, tempDataSet);
            }
        }
        return dataSet;
    }

    public static List<String> getAccountFlex(DynamicObjectCollection account) {
        ArrayList<String> list = new ArrayList<String>();
        for (DynamicObject dy : account) {
            Long accountId = dy.getLong("id");
            if (list.size() > 0) {
                list.retainAll(LogarithmHelper.getAssistByAcc(accountId));
                continue;
            }
            list.addAll(LogarithmHelper.getAssistByAcc(accountId));
        }
        return list;
    }

    private static List<String> getAssistByAcc(long accId) {
        ArrayList<String> result = new ArrayList<String>();
        QFilter accFilter = new QFilter("id", "=", (Object)accId);
        QFilter typeFilter = new QFilter("checkitementry.asstactitem.valuetype", "in", (Object)new String[]{"1", "2"});
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem.flexfield assist", (QFilter[])new QFilter[]{accFilter, typeFilter});
        for (DynamicObject col : cols) {
            result.add(col.getString("assist"));
        }
        return result;
    }

    public static DynamicObject getFlexPropertyId(String source, List<String> flexfields) {
        QFilter flexFilter = new QFilter("flexfield", "in", flexfields);
        QFilter sourceFilter = new QFilter("valuesource", "=", (Object)source);
        DynamicObject result = QueryServiceHelper.queryOne((String)"bos_flex_property", (String)"id,flexfield", (QFilter[])new QFilter[]{flexFilter, sourceFilter});
        if (result == null) {
            return null;
        }
        return result;
    }

    public static Long getCostCenterAccountId(DynamicObjectCollection newAccounts) {
        List<String> AccountFlexs = LogarithmHelper.getAccountFlex(newAccounts);
        DynamicObject dy = LogarithmHelper.getFlexPropertyId("bos_costcenter", AccountFlexs);
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("id");
    }

    public static Long getExpenseitemeditAccountId(DynamicObjectCollection newAccounts) {
        List<String> AccountFlexs = LogarithmHelper.getAccountFlex(newAccounts);
        DynamicObject dy = LogarithmHelper.getFlexPropertyId("er_expenseitemedit", AccountFlexs);
        if (dy == null) {
            return 0L;
        }
        return dy.getLong("id");
    }

    private static BigDecimal parseQty(String qty) {
        if (StringUtils.isEmpty((CharSequence)qty)) {
            return null;
        }
        String splictStr = "->";
        if (!qty.contains(splictStr)) {
            return null;
        }
        String[] split = qty.trim().replace(" ", "").split(splictStr);
        if (split.length != 2) {
            return null;
        }
        String endQtyStr = split[1];
        if (endQtyStr.endsWith("\u2193") || endQtyStr.endsWith("\u2191")) {
            String substring = endQtyStr.substring(0, endQtyStr.length() - 1);
            try {
                BigDecimal endQty = new BigDecimal(substring);
                BigDecimal startQty = new BigDecimal(split[0]);
                return endQty.subtract(startQty);
            }
            catch (Exception e) {
                logger.error("\u6570\u91cf\u5b57\u7b26\u4e32\u89e3\u6790\u5f02\u5e38,\u53ef\u80fd\u5bfc\u81f4\u90e8\u5206\u5dee\u5f02\u5355\u6570\u91cf\u9519\u8bef", (Throwable)e);
            }
        }
        return null;
    }

    public static DataSet getManuBillDataSet(DataSet manuBillsSourceDataSet, DataSet xmftOrderLogDataSet, DataSet xmftOrderSplitLogDataSet, QFilter notCurrManuBillQFilter, Boolean isOutSource, String algoKey, Map<String, Map<String, Set<Long>>> collectMap) {
        DataSet logDataSet = xmftOrderLogDataSet.join(manuBillsSourceDataSet.copy(), JoinType.LEFT).on("srcbillid", "id").on("srcbillentryid", "entryId").select(new String[]{"id as fromlogid", "srcbillid", "srcbillentryid", "xbillno as bizbillno", "cast(qty as BigDecimal) as bizqty", "srcbilltype", "sourcebilltype"}, new String[]{"id", "bizorg", "bizorgname", "transactiontype", "transactiontypename", "isprocedure", "entryId", "entryseq", "bizmaterial", "transmittime", "adminorg", "workcenter", "bizbaseunit", "bizstatus", "bizclosetime", "targetbill", "srcbillnum"}).finish();
        DataSet curLogDataSet = logDataSet.filter("id is not null").select(manuBillsSourceDataSet.getRowMeta().getFieldNames());
        DataSet notCurLogDataSet = logDataSet.filter("id is null");
        DataSet notCurrManuBillDataSet = LogarithmHelper.getNotCurrManuBillDataSet(notCurLogDataSet, notCurrManuBillQFilter, isOutSource, algoKey, collectMap);
        DataSet dataSet = notCurLogDataSet = notCurrManuBillDataSet == null ? null : notCurrManuBillDataSet.join(notCurLogDataSet, JoinType.LEFT).on("id", "srcbillid").on("entryId", "srcbillentryid").select(new String[]{"id", "bizorg", "bizorgname", "transactiontype", "transactiontypename", "isprocedure", "entryId", "entryseq", "bizmaterial", "transmittime", "adminorg", "workcenter", "bizbaseunit", "bizstatus", "bizclosetime", "targetbill", "srcbillnum"}, new String[]{"fromlogid", "bizbillno", "bizqty", "srcbilltype", "sourcebilltype"}).finish().select(notCurrManuBillDataSet.getRowMeta().getFieldNames()).filter("bizbillno is not null");
        if (curLogDataSet != null) {
            manuBillsSourceDataSet = manuBillsSourceDataSet.union(curLogDataSet);
        }
        if (notCurLogDataSet != null) {
            manuBillsSourceDataSet = manuBillsSourceDataSet.union(notCurLogDataSet);
        }
        if (xmftOrderSplitLogDataSet == null) {
            return manuBillsSourceDataSet;
        }
        DataSet splitLogDataSet = xmftOrderSplitLogDataSet.join(manuBillsSourceDataSet.copy(), JoinType.LEFT).on("srcbillid", "id").on("srcbillentryid", "entryId").select(new String[]{"id as fromlogid", "srcbillid", "srcbillentryid", "cast(xbillno as String) as bizbillno", "qty as bizqty", "srcbilltype", "sourcebilltype"}, new String[]{"id", "bizorg", "bizorgname", "transactiontype", "transactiontypename", "isprocedure", "entryId", "entryseq", "bizmaterial", "transmittime", "adminorg", "workcenter", "bizbaseunit", "bizstatus", "bizclosetime", "targetbill", "srcbillnum"}).finish();
        DataSet curSplitLogDataSet = splitLogDataSet.filter("id is not null").select(manuBillsSourceDataSet.getRowMeta().getFieldNames());
        DataSet notCurSplitLogDataSet = splitLogDataSet.filter("id is null");
        notCurrManuBillDataSet = LogarithmHelper.getNotCurrManuBillDataSet(notCurSplitLogDataSet, notCurrManuBillQFilter, isOutSource, algoKey, collectMap);
        DataSet dataSet2 = notCurSplitLogDataSet = notCurrManuBillDataSet == null ? null : notCurrManuBillDataSet.join(notCurSplitLogDataSet, JoinType.LEFT).on("id", "srcbillid").on("entryId", "srcbillentryid").select(new String[]{"id", "bizorg", "bizorgname", "transactiontype", "transactiontypename", "isprocedure", "entryId", "entryseq", "bizmaterial", "transmittime", "adminorg", "workcenter", "bizbaseunit", "bizstatus", "bizclosetime", "targetbill", "srcbillnum"}, new String[]{"fromlogid", "bizbillno", "bizqty", "srcbilltype", "sourcebilltype"}).finish().select(notCurrManuBillDataSet.getRowMeta().getFieldNames()).filter("bizbillno is not null");
        if (curSplitLogDataSet != null) {
            manuBillsSourceDataSet = manuBillsSourceDataSet.union(curSplitLogDataSet);
        }
        if (notCurSplitLogDataSet != null) {
            manuBillsSourceDataSet = manuBillsSourceDataSet.union(notCurSplitLogDataSet);
        }
        return manuBillsSourceDataSet;
    }

    private static DataSet getNotCurrManuBillDataSet(DataSet notCurLogDataSet, QFilter notCurrManuBillQFilter, Boolean isOutSource, String algoKey, Map<String, Map<String, Set<Long>>> collectMap) {
        if (notCurLogDataSet == null) {
            return null;
        }
        notCurLogDataSet = notCurLogDataSet.copy();
        HashSet<Long> ids = new HashSet<Long>(20);
        HashSet<Long> entryIds = new HashSet<Long>(20);
        while (notCurLogDataSet.hasNext()) {
            Row row = notCurLogDataSet.next();
            if (row == null) continue;
            ids.add(row.getLong("srcbillid"));
            entryIds.add(row.getLong("srcbillentryid"));
        }
        QFilter filter = InFilterHelper.getQFilterByBachSize("id", new ArrayList<Object>(ids), "in", 20000);
        filter.and(InFilterHelper.getQFilterByBachSize("treeentryentity.id", new ArrayList<Object>(entryIds), "in", 20000));
        filter.and(notCurrManuBillQFilter);
        if (isOutSource.booleanValue()) {
            return LogarithmHelper.getOmManuBills(filter, null, null, algoKey, collectMap);
        }
        return LogarithmHelper.getManuBills(filter, null, null, algoKey, collectMap);
    }

    private static QFilter getCcQfilterByCostCenter(List<Long> costCenterSources, String costCenterSourceType, String entity) {
        if (costCenterSources == null || costCenterSources.isEmpty()) {
            return null;
        }
        switch (costCenterSourceType) {
            case "bos_org": {
                if ("pom_mftorder".equals(entity)) {
                    return new QFilter("org", "in", costCenterSources);
                }
                if ("om_mftorder".equals(entity)) {
                    return new QFilter("org", "in", costCenterSources);
                }
                if ("im_mdc_mftmanuinbill".equals(entity)) {
                    return new QFilter("productionorg", "in", costCenterSources);
                }
                if ("im_mdc_omcmplinbill".equals(entity)) {
                    return new QFilter("billentry.entryreqorg", "in", costCenterSources);
                }
                if ("im_productinbill".equals(entity)) {
                    return new QFilter("bizorg", "in", costCenterSources);
                }
                if ("sfc_reportresource_adjust".equals(entity)) {
                    return new QFilter("org", "in", costCenterSources);
                }
                if ("sfc_processreportbill".equals(entity)) {
                    return new QFilter("org", "in", costCenterSources);
                }
                if ("pom_mftorderreport".equals(entity)) {
                    return new QFilter("org", "in", costCenterSources);
                }
                if ("om_processreport".equals(entity)) {
                    return new QFilter("org", "in", costCenterSources);
                }
                if ("im_mdc_mftproorder".equals(entity)) {
                    return new QFilter("bizorg", "in", costCenterSources);
                }
                if ("im_mdc_omoutbill".equals(entity)) {
                    return new QFilter("bizorg", "in", costCenterSources);
                }
                if (!"im_materialreqoutbill".equals(entity)) break;
                return new QFilter("bizorg", "in", costCenterSources);
            }
            case "bos_adminorg": {
                if ("pom_mftorder".equals(entity)) {
                    return new QFilter("treeentryentity.producedept", "in", costCenterSources);
                }
                if ("om_mftorder".equals(entity)) {
                    return new QFilter("treeentryentity.producedept", "in", costCenterSources);
                }
                if ("im_mdc_mftmanuinbill".equals(entity)) {
                    Set<String> billentrySet = EntityPropertyHelper.getEntryPropertys("im_mdc_mftmanuinbill", "billentry");
                    String dept = "bizdept";
                    if (billentrySet.contains("producedept")) {
                        dept = "billentry.producedept";
                    }
                    return new QFilter(dept, "in", costCenterSources);
                }
                if ("im_mdc_omcmplinbill".equals(entity)) {
                    return new QFilter("billentry.producedept", "in", costCenterSources);
                }
                if ("im_productinbill".equals(entity)) {
                    return new QFilter("bizdept", "in", costCenterSources);
                }
                if ("sfc_reportresource_adjust".equals(entity)) {
                    return new QFilter("productworkshop", "in", costCenterSources);
                }
                if ("sfc_processreportbill".equals(entity)) {
                    return new QFilter("productworkshop", "in", costCenterSources);
                }
                if ("pom_mftorderreport".equals(entity)) {
                    return new QFilter("sumentry.producedept", "in", costCenterSources);
                }
                if ("om_processreport".equals(entity)) {
                    return new QFilter("productworkshop", "in", costCenterSources);
                }
                if ("im_materialreqoutbill".equals(entity)) {
                    return new QFilter("bizdept", "in", costCenterSources);
                }
                if ("im_mdc_mftproorder".equals(entity)) {
                    return new QFilter("bizdept", "in", costCenterSources);
                }
                if (!"im_mdc_omoutbill".equals(entity)) break;
                return new QFilter("bizdept", "in", costCenterSources);
            }
            case "mpdm_workcentre": {
                if ("pom_mftorder".equals(entity)) {
                    List<Long> entryIds = CostCenterHelper.getOrderEntryIds(costCenterSources);
                    QFilter entryIdQFilter = InFilterHelper.getQFilterByBachSize("treeentryentity.id", new ArrayList<Object>(entryIds), "in", 20000);
                    QFilter notProdQFilter = new QFilter("treeentryentity.workcenter", "in", costCenterSources).and(new QFilter("transactiontype.isprocedure", "=", (Object)Boolean.FALSE));
                    return entryIdQFilter.or(notProdQFilter);
                }
                if ("im_mdc_mftmanuinbill".equals(entity)) {
                    return new QFilter("billentry.workcenterid", "in", costCenterSources);
                }
                if ("sfc_reportresource_adjust".equals(entity)) {
                    return new QFilter("sumentry.workcenter", "in", costCenterSources);
                }
                if ("sfc_processreportbill".equals(entity)) {
                    return new QFilter("sumentry.workcenter", "in", costCenterSources);
                }
                if ("pom_mftorderreport".equals(entity)) {
                    return new QFilter("sumentry.workcenter", "in", costCenterSources);
                }
                if (!"im_mdc_mftproorder".equals(entity)) break;
                return new QFilter("billentry.oprworkcenter", "in", costCenterSources);
            }
        }
        return new QFilter("1", "!=", (Object)1);
    }

    private static /* synthetic */ void lambda$getCollconfigsDataSet$5(Map collConfigMappingMap, Map collSelectValueMappingMap, Boolean isOldUserForSysParamBizRange, Map billRangeMap, Long orgId, List enableCostCenters, LogarithmParam logarithmParam, Map collConfigFilterMap, Map costCentersourceTypeDataMap, String entity, ORM orm, Map map, DynamicObject config) {
        long configId = config.getLong("id");
        String targetBillEntity = config.getString("costbill.id");
        String sourceBillEntity = config.getString("sourcebill.id");
        Map fieldMappingMap = (Map)collConfigMappingMap.get(configId);
        Map selectValueMappingMap = (Map)collSelectValueMappingMap.get(configId);
        if (isOldUserForSysParamBizRange.booleanValue() && billRangeMap != null && !billRangeMap.containsKey("norange")) {
            if (!billRangeMap.containsKey(sourceBillEntity)) {
                logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u4e0d\u5728\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\u8bbe\u7f6e\u7684\u5f52\u96c6\u5355\u636e\u8303\u56f4\u5185");
                return;
            }
            List ccsIds = (List)billRangeMap.get(sourceBillEntity);
            if (CadEmptyUtils.isEmpty(ccsIds)) {
                logger.info("\u6e90\u5355\uff1a\u3010" + sourceBillEntity + "\u3011\uff0c\u76ee\u6807\u5355\u3010" + targetBillEntity + "\u3011\uff0c\u6ca1\u6709\u9700\u8981\u5f52\u96c6\u7684\u6210\u672c\u4e2d\u5fc3");
                return;
            }
        }
        List<QFilter> collConfigFilterExCenter = ImportServiceHelper.getSrcQFiltersForNoTime(orgId, enableCostCenters, logarithmParam.getBizorgIds(), config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, costCentersourceTypeDataMap, null, null, null, logarithmParam.getAppnum(), null, new CollectReport(), logarithmParam.getEntryIds());
        List<QFilter> collConfigFilterInCenter = ImportServiceHelper.getSrcQFiltersForNoTime(orgId, enableCostCenters, logarithmParam.getBizorgIds(), config, collConfigFilterMap, fieldMappingMap, selectValueMappingMap, costCentersourceTypeDataMap, null, null, null, logarithmParam.getAppnum(), null, new CollectReport(), null);
        ArrayList<QFilter> extraQfilters = new ArrayList<QFilter>();
        String timeField = "";
        timeField = "cad_plannedoutputbill".equals(entity) ? (String)fieldMappingMap.get("bizdate") : (String)fieldMappingMap.get("bookdate");
        QFilter timeFilter = null;
        if (!CadEmptyUtils.isEmpty(timeField)) {
            timeFilter = new QFilter(timeField, ">=", (Object)logarithmParam.getStartDate());
            timeFilter.and(new QFilter(timeField, "<", (Object)logarithmParam.getEndDate()));
            extraQfilters.add(timeFilter);
        }
        if ("sca_resourceuse".equals(entity) && "pom_mftorderreport".equals(sourceBillEntity) && logarithmParam.getIsWareHousePoint().booleanValue()) {
            extraQfilters.add(new QFilter("sumentry.warehousepoint", "=", (Object)true));
        }
        if ("sca_resourceuse".equals(entity)) {
            extraQfilters.add(new QFilter("docbilltype.billformid", "=", (Object)sourceBillEntity));
        } else if (!"cad_factnedoutputbill".equals(entity)) {
            extraQfilters.add(new QFilter("billtype.billformid", "=", (Object)sourceBillEntity));
        }
        ArrayList<QFilter> allQfExCenters = new ArrayList<QFilter>(collConfigFilterExCenter.size() + extraQfilters.size());
        ArrayList<QFilter> allQfInCenters = new ArrayList<QFilter>(collConfigFilterInCenter.size() + extraQfilters.size());
        allQfExCenters.addAll(collConfigFilterExCenter);
        allQfExCenters.addAll(extraQfilters);
        allQfInCenters.addAll(collConfigFilterInCenter);
        allQfInCenters.addAll(extraQfilters);
        logger.info("\u67e5\u8be2\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\uff1a{}:{}", allQfExCenters, allQfInCenters);
        DynamicObjectCollection fields = config.getDynamicObjectCollection("fieldmapentity");
        String selectFields = LogarithmHelper.getQueryConfigFields(fields, sourceBillEntity, entity);
        DataSet tempDataExCenterSet = orm.queryDataSet("LogarithmHelper_getCollconfigsDataSet", sourceBillEntity, selectFields, allQfExCenters.toArray(new QFilter[0]), "", -1, null);
        DataSet tempDataInCenterSet = orm.queryDataSet("LogarithmHelper_getCollconfigsDataSet", sourceBillEntity, selectFields, allQfInCenters.toArray(new QFilter[0]), "", -1, null);
        DataSet tempDataSet = DataSetUtils.union(tempDataExCenterSet, tempDataInCenterSet).distinct();
        if (tempDataSet.hasNext()) {
            if ("sca_resourceuse".equals(entity) && "sfc_reportresource_adjust".equals(sourceBillEntity)) {
                DataSet docExCenter = QueryServiceHelper.queryDataSet((String)"adjust_exCenter", (String)"sfc_reportresource_adjust", (String)"sumentry.manftechno.billno AS manftechno", (QFilter[])allQfExCenters.toArray(new QFilter[0]), (String)"");
                DataSet docInCenter = QueryServiceHelper.queryDataSet((String)"adjust_inCenter", (String)"sfc_reportresource_adjust", (String)"sumentry.manftechno.billno AS manftechno", (QFilter[])allQfInCenters.toArray(new QFilter[0]), (String)"");
                DataSet doc = DataSetUtils.union(docExCenter, docInCenter).distinct();
                HashSet manftechnoSet = new HashSet(64);
                doc.forEach(e -> manftechnoSet.add(e.getString("manftechno")));
                String selectField = "billno,material.masterid entryentity.material";
                QFilter filter = new QFilter("billno", "in", manftechnoSet);
                DataSet dataSetManftech = orm.queryDataSet("LogarithmHelper_manftech", "sfc_manftech", selectField, new QFilter[]{filter}, "", -1, null).groupBy(new String[]{"billno", "entryentity.material"}).finish();
                DataSet dataSet = tempDataSet.join(dataSetManftech).on("manftechno", "billno").select(tempDataSet.getRowMeta().getFieldNames(), new String[]{"entryentity.material"}).finish();
                map.put(configId, dataSet);
            } else {
                map.put(configId, tempDataSet);
            }
        }
    }
}

