/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.StandardMacRptParam;
import kd.macc.cad.common.constants.StdMacMultiLevelAnalyRptParam;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MacRptHelper {
    private static Map<Integer, String> mapColor = new HashMap<Integer, String>();

    public static StandardMacRptParam getRptParam(ReportQueryParam reportQueryParam) {
        String lots;
        String calcRecord;
        FilterInfo filter = reportQueryParam.getFilter();
        StandardMacRptParam rptParam = new StandardMacRptParam();
        rptParam.setCostType(filter.getDynamicObject("costtype"));
        rptParam.setMaterial(filter.getDynamicObject("querymaterial"));
        DynamicObjectCollection productDc = filter.getDynamicObjectCollection("mulmaterial");
        HashSet<Long> productIds = new HashSet<Long>(2048);
        if (CadEmptyUtils.isEmpty(productDc)) {
            String matIds = reportQueryParam.getFilter().getFilterItem("matIds").getString();
            if (!CadEmptyUtils.isEmpty(matIds)) {
                rptParam.setProducts(rptParam.getCalcMatIds());
            } else {
                List materialIds;
                DynamicObject ct = filter.getDynamicObject("costtype");
                DynamicObject matVer = filter.getDynamicObject("version");
                List<QFilter> filters = ElementRelationHelper.getMatFiltersBy(ct, matVer);
                DynamicObjectCollection mulProductGroup = filter.getDynamicObjectCollection("mulproductgroup");
                if (!CadEmptyUtils.isEmpty(mulProductGroup)) {
                    DynamicObject productGrpStd = filter.getDynamicObject("productgrpstd");
                    QFilter classifiedMaterialIdFilter = InFilterHelper.getQFilterByBachSize("id", new ArrayList<Object>(MaterialGroupHelper.getClassifiedMaterialId(mulProductGroup, false, productGrpStd)), "in", 20000);
                    filters.add(classifiedMaterialIdFilter);
                }
                if (!CadEmptyUtils.isEmpty(materialIds = QueryServiceHelper.queryPrimaryKeys((String)"bd_material", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1))) {
                    materialIds.forEach(s -> productIds.add(Long.parseLong(String.valueOf(s))));
                }
                rptParam.setProducts(productIds);
            }
        } else {
            productDc.forEach(s -> productIds.add(s.getLong("id")));
            rptParam.setProducts(productIds);
        }
        rptParam.setVersion(filter.getDynamicObject("version"));
        rptParam.setAuxprop(filter.getLong("auxprop"));
        rptParam.setQueryDate(filter.getDate("querydate"));
        DynamicObject materialgrpstd = filter.getDynamicObject("materialgrpstd");
        if (materialgrpstd == null) {
            materialgrpstd = BusinessDataServiceHelper.loadSingleFromCache((Object)730148448254487552L, (String)"bd_materialgroupstandard");
        }
        rptParam.setMaterialgrpstd(materialgrpstd);
        rptParam.setMulmaterialgroup(filter.getDynamicObjectCollection("mulmaterialgroup"));
        rptParam.setMulgroupmaterial(filter.getDynamicObjectCollection("mulgroupmaterial"));
        DynamicObject queryPeriod = filter.getDynamicObject("queryperiod");
        if (queryPeriod != null) {
            rptParam.setQueryPeriodId(queryPeriod.getLong("id"));
        }
        if (!CadEmptyUtils.isEmpty(calcRecord = filter.getString("calcrecord"))) {
            rptParam.setCalcRecordName(calcRecord);
        }
        rptParam.setDateial(filter.getBoolean("isdetail"));
        rptParam.setShowsum(filter.getBoolean("showsum"));
        rptParam.setShowgroup(filter.getBoolean("showgroup"));
        DynamicObjectCollection mulConfiguredCode = filter.getDynamicObjectCollection("mulconfiguredcode");
        if (!CadEmptyUtils.isEmpty(mulConfiguredCode)) {
            List<Long> configuredCodeIds = mulConfiguredCode.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            rptParam.setConfiguredCodeIds(configuredCodeIds);
        } else if (!CadEmptyUtils.isEmpty(rptParam.getProducts())) {
            rptParam.setConfiguredCodeIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulTracknumber = filter.getDynamicObjectCollection("multracknumber");
        if (!CadEmptyUtils.isEmpty(mulTracknumber)) {
            List<Long> trackNumberIds = mulTracknumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            rptParam.setTrackNumberIds(trackNumberIds);
        } else if (!CadEmptyUtils.isEmpty(rptParam.getProducts())) {
            rptParam.setTrackNumberIds(Collections.singletonList(0L));
        }
        DynamicObjectCollection mulProjectNumber = filter.getDynamicObjectCollection("mulprojectnumber");
        if (mulProjectNumber != null) {
            List<Long> projectNumberIds = mulProjectNumber.stream().map(obj -> obj.getLong("id")).collect(Collectors.toList());
            rptParam.setProjectNumberIds(projectNumberIds);
        }
        if (!CadEmptyUtils.isEmpty(lots = filter.getString("mullot"))) {
            rptParam.setLots(lots);
        }
        return rptParam;
    }

    public static List<QFilter> getOutFiltersBy(StandardMacRptParam param) {
        String lots;
        List<Long> projectNumberIds;
        List<Long> trackNumberIds;
        List<Long> configuredCodeIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (param.getCostType() != null) {
            filters.add(new QFilter("costtype", "=", param.getCostType().getPkValue()));
        }
        if (param.getVersion() != null) {
            filters.add(new QFilter("matversion", "=", param.getVersion().getPkValue()));
        }
        if (param.getAuxprop() != null && param.getAuxprop() != 0L) {
            filters.add(new QFilter("auxpty", "=", (Object)param.getAuxprop()));
        }
        if (!CadEmptyUtils.isEmpty(configuredCodeIds = param.getConfiguredCodeIds())) {
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = param.getTrackNumberIds())) {
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = param.getProjectNumberIds())) {
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(lots = param.getLots())) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        return filters;
    }

    public static List<QFilter> getCommonFiltersBy(StandardMacRptParam param) {
        String lots;
        List<Long> projectNumberIds;
        List<Long> trackNumberIds;
        List<Long> configuredCodeIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Long costTypeId = param.getCostType().getLong("id");
        boolean isAnalogCost = BomRouterHelper.isAnalogCostType(param.getCostType().getLong("id"));
        HashSet<Long> costTypeIds = new HashSet<Long>(2);
        costTypeIds.add(costTypeId);
        if (!isAnalogCost && !CadEmptyUtils.isEmpty(param.getTrackKeyCols())) {
            costTypeIds.add(param.getSimCosttypeId());
            filters.add(new QFilter("costtype", "in", costTypeIds));
        } else {
            filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        }
        if (param.getVersion() != null) {
            filters.add(new QFilter("matvers", "=", param.getVersion().getPkValue()));
        }
        if (param.getAuxprop() != null && param.getAuxprop() != 0L) {
            filters.add(new QFilter("auxproperty", "=", (Object)param.getAuxprop()));
        }
        if (!CadEmptyUtils.isEmpty(configuredCodeIds = param.getConfiguredCodeIds())) {
            filters.add(new QFilter("configuredcode", "in", configuredCodeIds));
        }
        if (!CadEmptyUtils.isEmpty(trackNumberIds = param.getTrackNumberIds())) {
            filters.add(new QFilter("tracknumber", "in", trackNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(projectNumberIds = param.getProjectNumberIds())) {
            filters.add(new QFilter("project", "in", projectNumberIds));
        }
        if (!CadEmptyUtils.isEmpty(lots = param.getLots())) {
            filters.add(new QFilter("lot", "in", (Object)lots.split(",")));
        }
        return filters;
    }

    public static StdMacMultiLevelAnalyRptParam getMultiLevelRptParam(DynamicObject mainData) {
        StdMacMultiLevelAnalyRptParam rptParam = new StdMacMultiLevelAnalyRptParam();
        rptParam.setCostType(mainData.getDynamicObject("costtype"));
        rptParam.setCostTypeCP(mainData.getDynamicObject("costtypecp"));
        rptParam.setMaterial(mainData.getDynamicObject("querymaterial"));
        rptParam.setVersion(mainData.getDynamicObject("version"));
        rptParam.setAuxprop(mainData.getLong("auxprop"));
        rptParam.setQueryDate(mainData.getDate("querydate"));
        rptParam.setDateial(Boolean.TRUE);
        rptParam.setIsMultiQuery(mainData.getBoolean("ismultilevel"));
        rptParam.setQueryLevel(mainData.getInt("querylevel"));
        return rptParam;
    }

    public static List<QFilter> getMultiLevelCommonFiltersBy(StdMacMultiLevelAnalyRptParam param, boolean isCPCostType) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (isCPCostType) {
            filters.add(new QFilter("costtype", "=", param.getCostTypeCP().getPkValue()));
        } else {
            filters.add(new QFilter("costtype", "=", param.getCostType().getPkValue()));
        }
        if (param.getMaterial() != null) {
            filters.add(new QFilter("material", "=", param.getMaterial().getPkValue()));
        }
        if (param.getVersion() != null) {
            filters.add(new QFilter("matvers", "=", param.getVersion().getPkValue()));
        }
        if (param.getAuxprop() != null && param.getAuxprop() != 0L) {
            filters.add(new QFilter("auxproperty", "=", (Object)param.getAuxprop()));
        }
        if (param.getQueryLevel() != null) {
            filters.add(new QFilter("level", "=", (Object)param.getQueryLevel()));
        }
        filters.add(new QFilter("bom", ">", (Object)0L));
        filters.add(new QFilter("entryentity.element", ">", (Object)0L));
        return filters;
    }

    public static List<Object> getUnCommonRootMatId(String entity, boolean isCPCostType, StdMacMultiLevelAnalyRptParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String costTypeId = isCPCostType ? param.getCostTypeCPId() : param.getCostTypeId();
        filters.add(new QFilter("costtype", "=", (Object)costTypeId));
        DataSet dateSet = QueryServiceHelper.queryDataSet((String)"MacRptHelper.getUnCommonRootNodeId", (String)entity, (String)"level,material", (QFilter[])filters.toArray(new QFilter[0]), (String)"level");
        dateSet = dateSet.select(new String[]{"material", "level"}).groupBy(new String[]{"material"}).max("level").finish();
        if (dateSet.isEmpty()) {
            return null;
        }
        ArrayList<Object> matIdList = new ArrayList<Object>();
        while (dateSet.hasNext()) {
            Row row = dateSet.next();
            if (row.getInteger("level") != 0) continue;
            matIdList.add(row.get("material"));
        }
        return matIdList;
    }

    public static Set<Object> getParentMatIds(StdMacMultiLevelAnalyRptParam param) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("costtype", "in", Arrays.asList(param.getCostTypeCPId(), param.getCostTypeId())));
        filters.add(new QFilter("isleaf", "=", (Object)"0"));
        DynamicObjectCollection rows = QueryServiceHelper.query((String)MacRptHelper.getCaclEntityBy(Long.valueOf(param.getCostTypeId())), (String)"material", (QFilter[])filters.toArray(new QFilter[0]));
        if (rows == null) {
            return null;
        }
        HashSet<Object> matIdSet = new HashSet<Object>();
        rows.forEach(s -> matIdSet.add(s.get("material")));
        return matIdSet;
    }

    public static boolean getItemsIsEqual(Map row, Map secdRow, String field) {
        Object val = row.get(field);
        Object valNext = secdRow.get(field);
        if (val == null && valNext == null) {
            return true;
        }
        return val != null && val.equals(valNext);
    }

    public static String getCaclEntityBy(Long costTypeId) {
        return BomRouterHelper.isAnalogCostType(costTypeId) ? "cad_calcsimulationresult" : "cad_calceffectiveresult";
    }

    public static int[] listToIntArr(List<Integer> list) {
        if (CadEmptyUtils.isEmpty(list)) {
            return null;
        }
        int[] arr = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    public static String getRowColor(int level) {
        String color = mapColor.get(level);
        if (StringUtils.isEmpty((String)color)) {
            return mapColor.get(10);
        }
        return color;
    }

    public static String getLevelFmt(Integer level, String flag) {
        if (level == null) {
            level = 0;
        }
        StringBuilder sb = new StringBuilder();
        String str = "";
        for (int j = 0; j < level; ++j) {
            sb.append("    ");
        }
        sb.append(flag);
        sb.append(level);
        return sb.toString();
    }

    public static Long getLongFromMapVal(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return Long.valueOf(val.toString());
        }
        return (Long)val;
    }

    public static BigDecimal getBigDecimalFromMapVal(Object val) {
        if (val == null) {
            return BigDecimal.ZERO;
        }
        if (val instanceof Integer) {
            return new BigDecimal((Integer)val);
        }
        return (BigDecimal)val;
    }

    public static Object getCompareMapVal(Map map, String field) {
        Object val = map.get(field);
        Object valCp = map.get(field + "_cp");
        return MacRptHelper.getCompareMapVal(val, valCp);
    }

    public static Object getCompareMapVal(Object val, Object valCp) {
        if (valCp == null) {
            return val;
        }
        if (val == null && valCp != null) {
            return valCp;
        }
        String str = String.valueOf(val);
        if ("0".equals(str) || "null".equals(str)) {
            return valCp;
        }
        return val;
    }

    static {
        mapColor.put(0, "#faebd7");
        mapColor.put(1, "#ffffff");
        mapColor.put(2, "#faebd7");
        mapColor.put(3, "#ffffff");
        mapColor.put(4, "#faebd7");
        mapColor.put(5, "#ffffff");
        mapColor.put(6, "#faebd7");
        mapColor.put(7, "#ffffff");
        mapColor.put(8, "#faebd7");
        mapColor.put(9, "#ffffff");
        mapColor.put(10, "#faebd7");
    }
}

