/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.hugein.HugeInConfig;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class MatAllocDataHelper {
    private static final Log logger = LogFactory.getLog(MatAllocDataHelper.class);
    public static final String fields = "id, billno,bookdate, bizdate, org, manuorg, costcenter, biztype,srcbiztype, appnum, sourcebillid, srcauditdate, auditdate,entryentity.id As entryid, entryentity.seq As seq, entryentity.material As material, entryentity.material.baseunit As baseunit, entryentity.material.group As materialgroup, entryentity.matversion AS matversion,entryentity.auxpty AS auxpty,entryentity.qty AS qty, entryentity.warehouse AS warehouse, entryentity.location AS location,entryentity.outinvtype AS outinvtype,entryentity.costobject AS costobject, entryentity.unit AS unit,entryentity.sourcebillentryid AS sourcebillentryid,entryentity.isrework AS isrework,entryentity.configuredcode AS configuredcode,entryentity.tracknumber AS tracknumber,entryentity.project AS project,entryentity.lotcoderule AS lotcoderule,entryentity.subproductnum AS subproductnum";

    public static DynamicObjectCollection getImportData(Map<String, Object> costaccountMap, String appNum) {
        boolean queryId = false;
        if (costaccountMap.get("isAlgox") != null) {
            queryId = (Boolean)costaccountMap.get("isAlgox");
        }
        String queryFields = queryId ? "id,entryentity.id as entryid" : fields;
        HashSet collecSrcBillIds = (HashSet)costaccountMap.get("collecSrcBillIds");
        if (collecSrcBillIds != null && !collecSrcBillIds.isEmpty()) {
            QFilter temp;
            QFilter filter = new QFilter("sourcebillid", "in", (Object)collecSrcBillIds);
            filter.and("appnum", "=", costaccountMap.get("appnum"));
            if (costaccountMap.containsKey("autoFinishCalc") && (temp = MatAllocDataHelper.notInclude(costaccountMap)) != null) {
                filter.and(temp);
            }
            return QueryServiceHelper.query((String)"sca_matusecollect", (String)queryFields, (QFilter[])filter.toArray());
        }
        Set<Object> matUseBillIds = (HashSet)costaccountMap.get("matUseBillIds");
        if (matUseBillIds != null && !matUseBillIds.isEmpty()) {
            matUseBillIds = MatAllocDataHelper.getNeedIncludeIds(costaccountMap, matUseBillIds);
            QFilter filter = new QFilter("entryentity.id", "in", (Object)matUseBillIds);
            filter.and("appnum", "=", costaccountMap.get("appnum"));
            return QueryServiceHelper.query((String)"sca_matusecollect", (String)queryFields, (QFilter[])filter.toArray());
        }
        Long orgId = (Long)costaccountMap.get("org");
        QFilter orgIdQF = new QFilter("org", "=", (Object)orgId);
        Long manuorg = (Long)costaccountMap.get("manuorg");
        if (manuorg != 0L) {
            orgIdQF = orgIdQF.and(new QFilter("manuorg", "=", (Object)manuorg));
        } else if (CostAccountHelper.isEnableMulFactory((Long)costaccountMap.get("costaccountId"))) {
            List<Long> manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, "sca_matalloc", appNum);
            orgIdQF = orgIdQF.and(new QFilter("manuorg", "in", manuorgList));
        }
        Object currentperiodId = costaccountMap.get("currentperiodId");
        QFilter periodQF = new QFilter("id", "=", currentperiodId);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"begindate, enddate", (QFilter[])new QFilter[]{periodQF});
        if (periods.size() == 0) {
            return null;
        }
        DynamicObject period = (DynamicObject)periods.get(0);
        QFilter begindateQF = new QFilter("bookdate", ">=", (Object)period.getDate("begindate"));
        QFilter enddateQF = new QFilter("bookdate", "<=", (Object)period.getDate("enddate"));
        QFilter costaccountQF = new QFilter("costaccount", "=", costaccountMap.get("costaccountId"));
        QFilter currPeriodQF = new QFilter("period", "=", currentperiodId);
        QFilter existQF = null;
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        ArrayList<Long> existAllocIds = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.alloc.MatAllocHelper", (String)"sca_matalloc", (String)"matcollect", (QFilter[])new QFilter[]{orgIdQF, costaccountQF, currPeriodQF, appNumQF}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long matUseEntryId = row.getLong("matcollect");
                existAllocIds.add(matUseEntryId);
            }
        }
        if (existAllocIds.size() > 0) {
            existQF = MatAllocDataHelper.getQFilter("entryentity.id", existAllocIds, "not in");
        }
        QFilter billstatusQF = new QFilter("billstatus", "=", (Object)"C");
        List costObjectList = (List)costaccountMap.get("costObjectList");
        QFilter costObjectQF = null;
        if (costObjectList != null && !costObjectList.isEmpty()) {
            costObjectQF = MatAllocDataHelper.getQFilter("entryentity.costobject", costObjectList, "in");
        }
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"sca_matusecollect", (String)queryFields, (QFilter[])new QFilter[]{billstatusQF, orgIdQF, existQF, begindateQF, enddateQF, costObjectQF, appNumQF});
        return bills;
    }

    public static List<Long> getImportDataToList(Map<String, Object> costaccountMap, String appNum) {
        HashSet collecSrcBillIds = (HashSet)costaccountMap.get("collecSrcBillIds");
        if (collecSrcBillIds != null && !collecSrcBillIds.isEmpty()) {
            QFilter temp;
            QFilter filter = new QFilter("sourcebillid", "in", (Object)collecSrcBillIds);
            filter.and("appnum", "=", costaccountMap.get("appnum"));
            if (costaccountMap.containsKey("autoFinishCalc") && (temp = MatAllocDataHelper.notInclude(costaccountMap)) != null) {
                filter.and(temp);
            }
            DataSet importDataIdDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocDataHelper.getImportDataToList", (String)"sca_matusecollect", (String)"entryentity.id As entryid", (QFilter[])filter.toArray(), null);
            return MatAllocDataHelper.getEntryIdfromDs(importDataIdDataSet);
        }
        Set<Object> matUseBillIds = (HashSet)costaccountMap.get("matUseBillIds");
        if (matUseBillIds != null && !matUseBillIds.isEmpty()) {
            matUseBillIds = MatAllocDataHelper.getNeedIncludeIds(costaccountMap, matUseBillIds);
            QFilter filter = new QFilter("entryentity.id", "in", (Object)matUseBillIds);
            filter.and("appnum", "=", costaccountMap.get("appnum"));
            DataSet importDataIdDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocDataHelper.getImportDataToList", (String)"sca_matusecollect", (String)"entryentity.id As entryid", (QFilter[])filter.toArray(), null);
            return MatAllocDataHelper.getEntryIdfromDs(importDataIdDataSet);
        }
        Long orgId = (Long)costaccountMap.get("org");
        QFilter orgIdQF = new QFilter("org", "=", (Object)orgId);
        Long manuorg = (Long)costaccountMap.get("manuorg");
        if (manuorg != 0L) {
            orgIdQF = orgIdQF.and(new QFilter("manuorg", "=", (Object)manuorg));
        } else if (CostAccountHelper.isEnableMulFactory((Long)costaccountMap.get("costaccountId"))) {
            List<Long> manuorgList = ImportServiceHelper.getUserHasPermProOrgsByAccOrg(orgId, "sca_matalloc", appNum);
            orgIdQF = orgIdQF.and(new QFilter("manuorg", "in", manuorgList));
        }
        Long currentperiodId = (Long)costaccountMap.get("currentperiodId");
        Date[] periodDate = PeriodHelper.getPeriodStartAndEndTime(currentperiodId);
        if (periodDate == null) {
            return null;
        }
        QFilter begindateQF = new QFilter("bookdate", ">=", (Object)periodDate[0]);
        QFilter enddateQF = new QFilter("bookdate", "<=", (Object)periodDate[1]);
        QFilter costaccountQF = new QFilter("costaccount", "=", costaccountMap.get("costaccountId"));
        QFilter currPeriodQF = new QFilter("period", "=", (Object)currentperiodId);
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appNum);
        DataSet matAllocDs = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.alloc.MatAllocHelper", (String)"sca_matalloc", (String)"matcollect,nsrcauditdate", (QFilter[])new QFilter[]{orgIdQF, costaccountQF, currPeriodQF, appNumQF}, (String)"");
        QFilter billstatusQF = new QFilter("billstatus", "=", (Object)"C");
        List costObjectList = (List)costaccountMap.get("costObjectList");
        QFilter costObjectQF = null;
        if (costObjectList != null && !costObjectList.isEmpty()) {
            costObjectQF = MatAllocDataHelper.getQFilter("entryentity.costobject", costObjectList, "in");
        }
        QFilter[] qfilterArr = new QFilter[]{billstatusQF, orgIdQF, begindateQF, enddateQF, appNumQF, costObjectQF};
        StringBuilder filterSb = new StringBuilder();
        for (QFilter filter : qfilterArr) {
            if (filter == null) continue;
            filterSb.append(filter.toString()).append(" ");
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u83b7\u53d6\u9700\u8981\u5f15\u5165\u7684\u6570\u636e\u6761\u4ef6\uff1a{}", (Object)filterSb);
        DataSet matCollectDs = QueryServiceHelper.queryDataSet((String)"MatAllocDataHelper.getImportDataToList", (String)"sca_matusecollect", (String)"entryentity.id As entryid,auditdate", (QFilter[])qfilterArr, (String)"entryentity.material asc");
        HashSet<Long> needDelMatAllocs = new HashSet<Long>(128);
        ArrayList<Long> needImportMatCols = new ArrayList<Long>();
        if (!matCollectDs.isEmpty()) {
            DataSet relateDs = matCollectDs.leftJoin(matAllocDs).on("entryid", "matcollect").select(new String[]{"entryid", "auditdate"}, new String[]{"matcollect", "nsrcauditdate"}).finish();
            for (Row relateData : relateDs) {
                Long matCollect = relateData.getLong("matcollect");
                Long entryId = relateData.getLong("entryid");
                Date srcAuditDate = relateData.getDate("nsrcauditdate");
                Date auditDate = relateData.getDate("auditdate");
                if (srcAuditDate != null && auditDate != null) {
                    if (srcAuditDate.compareTo(auditDate) == 0) continue;
                    needDelMatAllocs.add(entryId);
                    needImportMatCols.add(entryId);
                    continue;
                }
                if (!CadEmptyUtils.isEmpty(matCollect)) {
                    needDelMatAllocs.add(matCollect);
                }
                needImportMatCols.add(entryId);
            }
        }
        if (!needDelMatAllocs.isEmpty()) {
            QFilter matAllocDelQf = InFilterHelper.getQFilterByBachSize("matcollect", new ArrayList<Object>(needDelMatAllocs), "in", 20000);
            int deleteSize = DeleteServiceHelper.delete((String)"sca_matalloc", (QFilter[])new QFilter[]{matAllocDelQf, orgIdQF, costaccountQF, currPeriodQF, appNumQF});
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6210\u529f\u5220\u9664\u6570\u636e:{}\u6761", (Object)deleteSize);
        }
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u9700\u8981\u5f15\u5165\u6570\u636eid\u6570\u636e\uff1a{}", (Object)needImportMatCols.size());
        return needImportMatCols;
    }

    private static List<Long> getEntryIdfromDs(DataSet ds) {
        ArrayList<Long> totalIds = new ArrayList<Long>(1024);
        for (Row row : ds) {
            totalIds.add(row.getLong("entryid"));
        }
        return totalIds;
    }

    private static QFilter getQFilter(String queryStr, List<Long> list, String qcp) {
        QFilter qf = null;
        if (list.size() > HugeInConfig.inMaxSize()) {
            List lists = Lists.partition(list, (int)HugeInConfig.inMaxSize());
            for (List tempList : lists) {
                if (qf == null) {
                    qf = new QFilter(queryStr, qcp, (Object)tempList);
                    continue;
                }
                if ("in".equals(qcp)) {
                    qf = qf.or(new QFilter(queryStr, qcp, (Object)tempList));
                    continue;
                }
                qf = qf.and(new QFilter(queryStr, qcp, (Object)tempList));
            }
        } else {
            qf = new QFilter(queryStr, qcp, list);
        }
        return qf;
    }

    private static QFilter notInclude(Map<String, Object> costaccountMap) {
        QFilter existQF = null;
        QFilter orgIdQF = new QFilter("org", "=", costaccountMap.get("org"));
        QFilter costaccountQF = new QFilter("costaccount", "=", costaccountMap.get("costaccountId"));
        QFilter currPeriodQF = new QFilter("period", "=", costaccountMap.get("currentperiodId"));
        ArrayList<Long> existAllocIds = new ArrayList<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.alloc.MatAllocHelper", (String)"sca_matalloc", (String)"matcollect", (QFilter[])new QFilter[]{orgIdQF, costaccountQF, currPeriodQF}, (String)"");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long matUseEntryId = row.getLong("matcollect");
                existAllocIds.add(matUseEntryId);
            }
        }
        if (existAllocIds.size() > 0) {
            existQF = MatAllocDataHelper.getQFilter("entryentity.id", existAllocIds, "not in");
        }
        return existQF;
    }

    private static Set<Long> getNeedIncludeIds(Map<String, Object> costaccountMap, Set<Long> matUseCollectIds) {
        QFilter orgQf = new QFilter("org", "=", costaccountMap.get("org"));
        QFilter entryIdQf = InFilterHelper.getQFilterByBachSize("entryentity.id", new ArrayList<Object>(matUseCollectIds), "in", 20000);
        DataSet matCollectDs = QueryServiceHelper.queryDataSet((String)"MatAllocDataHelper.getNeedIncludeIds", (String)"sca_matusecollect", (String)"entryentity.id AS entryid,auditdate", (QFilter[])new QFilter[]{orgQf, entryIdQf}, (String)"id desc");
        QFilter costAccountQf = new QFilter("costaccount", "=", costaccountMap.get("costaccountId"));
        QFilter periodQf = new QFilter("period", "=", costaccountMap.get("currentperiodId"));
        QFilter matCollectQf = new QFilter("matcollect", "in", matUseCollectIds);
        HashSet<Long> needDelMatAllocs = new HashSet<Long>(128);
        HashSet<Long> needImportMatCols = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.macc.sca.algox.alloc.MatAllocHelper", (String)"sca_matalloc", (String)"matcollect,nsrcauditdate", (QFilter[])new QFilter[]{orgQf, costAccountQf, periodQf, matCollectQf}, (String)"");){
            DataSet relateDs = matCollectDs.leftJoin(dataSet).on("entryid", "matcollect").select(new String[]{"entryid", "auditdate"}, new String[]{"matcollect", "nsrcauditdate"}).finish();
            for (Row relateData : relateDs) {
                Long entryId = relateData.getLong("entryid");
                Long matCollect = relateData.getLong("matcollect");
                Date srcAuditDate = relateData.getDate("nsrcauditdate");
                Date auditDate = relateData.getDate("auditdate");
                if (srcAuditDate != null && auditDate != null) {
                    if (srcAuditDate.compareTo(auditDate) == 0) continue;
                    needDelMatAllocs.add(entryId);
                    needImportMatCols.add(entryId);
                    continue;
                }
                if (!CadEmptyUtils.isEmpty(matCollect)) {
                    needDelMatAllocs.add(matCollect);
                }
                needImportMatCols.add(entryId);
            }
        }
        if (!needDelMatAllocs.isEmpty()) {
            QFilter matAllocDelQf = InFilterHelper.getQFilterByBachSize("matcollect", new ArrayList<Object>(needDelMatAllocs), "in", 20000);
            int deleteSize = DeleteServiceHelper.delete((String)"sca_matalloc", (QFilter[])new QFilter[]{matAllocDelQf, orgQf, costAccountQf, periodQf});
            logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165-\u6210\u529f\u5220\u9664\u6570\u636e:{}\u6761", (Object)deleteSize);
        }
        return needImportMatCols;
    }

    public static Map<String, List<Map<String, Object>>> getMatCost(Object[] params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"macc", (String)"cad", (String)"MatCostInfoService", (String)"getMatCost", (Object[])params);
        return result;
    }

    public static void dealBatchDataToSca(List<DynamicObject> scaProcessList, Map<String, Object> costAccountMap, Map<Long, DynamicObject> matMap, Map<String, Long> matAllocStdMap) {
        HashSet<Long> matIds = new HashSet<Long>(16);
        for (DynamicObject bill : scaProcessList) {
            matIds.add(bill.getLong("material"));
        }
        DynamicObjectCollection mats = QueryServiceHelper.query((String)"bd_material", (String)"id, isenablematerialversion AS isusematver, isuseauxpty AS isuseauxpty, name As materialname", (QFilter[])new QFilter[]{new QFilter("id", "in", matIds)});
        mats.forEach(e -> matMap.putIfAbsent(e.getLong("id"), (DynamicObject)e));
    }

    static void dealBatchDataToAca(List<DynamicObject> acaProcessList, Map<String, Object> costAccountMap, Map<Long, Boolean> isForwardAmountMap, Map<String, Long> matAllocStdMap) {
        HashSet<Long> outInvTypeIds = new HashSet<Long>(16);
        for (DynamicObject bill : acaProcessList) {
            outInvTypeIds.add(bill.getLong("outinvtype"));
        }
        DynamicObjectCollection outInvTypes = QueryServiceHelper.query((String)"bd_invtype", (String)"id, isforwardamount", (QFilter[])new QFilter[]{new QFilter("id", "in", outInvTypeIds)});
        outInvTypes.forEach(e -> isForwardAmountMap.put(e.getLong("id"), e.getBoolean("isforwardamount")));
    }

    public static void setMatAllocStdNull(Set<Long> ids) {
        QFilter idFilter = new QFilter("id", "in", ids);
        idFilter.and("allocstatus", "=", (Object)"0");
        idFilter.and("costdriver", "=", (Object)0);
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"sca_matalloc", (String)"id,org,costcenter,costdriver,manuorg, material,matversion,auxpty", (QFilter[])new QFilter[]{idFilter});
        if (dynObjs.length == 0) {
            return;
        }
        Long orgId = 0L;
        for (DynamicObject dynObj : dynObjs) {
            orgId = dynObj.getLong("org.id");
        }
        Map<String, Long> matAllocStdMap = MatAllocDataHelper.getMatAllocStdMap(orgId, "sca");
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>();
        for (DynamicObject dynObj : dynObjs) {
            Long costdriverId = MatAllocDataHelper.getMatAllocStdCostDriver(dynObj.getLong("org.id"), dynObj.getLong("manuorg.id"), dynObj.getLong("costcenter.id"), dynObj.getLong("material.id"), dynObj.getLong("matversion.id"), dynObj.getLong("auxpty.id"), dynObj.getLong("material.group.id"), matAllocStdMap);
            if (costdriverId == null || costdriverId <= 0L) continue;
            dynObj.set("costdriver", (Object)costdriverId);
            saveObjs.add(dynObj);
        }
        if (saveObjs.size() == 0) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])saveObjs.toArray(new DynamicObject[0]));
    }

    public static Map<Long, Map<Long, List<DynamicObject>>> getCalCostRecord(Long costAccountId, List<Long> sourceBillEntryIds) {
        DynamicObjectCollection costRecords = MatAllocDataHelper.getCalCostRecordData(costAccountId, sourceBillEntryIds);
        HashMap<Long, Map<Long, List<DynamicObject>>> resultMap = new HashMap<Long, Map<Long, List<DynamicObject>>>();
        costRecords.forEach(e -> {
            Long bizbillid = e.getLong("bizbillid");
            long bizbillentryid = e.getLong("bizbillentryid");
            HashMap<Long, List> calCostRecEntryMap = (HashMap<Long, List>)resultMap.get(bizbillid);
            if (calCostRecEntryMap == null) {
                calCostRecEntryMap = new HashMap<Long, List>();
                resultMap.put(bizbillid, calCostRecEntryMap);
            }
            calCostRecEntryMap.computeIfAbsent(bizbillentryid, s -> new ArrayList()).add(e);
        });
        return resultMap;
    }

    private static DynamicObjectCollection getCalCostRecordData(Long costAccountId, List<Long> sourceBillEntryIds) {
        String fields = "bizbillid,entry.bizbillentryid AS bizbillentryid,entry.actualcost AS actualcost,entry.material AS material,entry.mversion.id AS matversion,entry.assist.id AS auxpty,entry.subentrycostelement.sub_actualcost AS subactualcost,entry.subentrycostelement.sub_unitactualcost AS subunitactualcost,entry.subentrycostelement.costelement AS element,entry.subentrycostelement.costsubelement AS subelement";
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])new QFilter[]{new QFilter("entry.bizbillentryid", "in", sourceBillEntryIds), new QFilter("costaccount", "=", (Object)costAccountId), new QFilter("billstatus", "=", (Object)"C")});
        return costRecords;
    }

    public static Long getMatAllocStdCostDriver(Long orgId, Long manuOrg, Long costcenter, Long material, Long matversion, Long auxpty, Long materialgroup, Map<String, Long> stdMap) {
        manuOrg = MatAllocDataHelper.getLongVal(manuOrg);
        costcenter = MatAllocDataHelper.getLongVal(costcenter);
        material = MatAllocDataHelper.getLongVal(material);
        matversion = MatAllocDataHelper.getLongVal(matversion);
        auxpty = MatAllocDataHelper.getLongVal(auxpty);
        String keyFormat = "%s@%s@%s@%s@%s@%s@%s";
        logger.info("\u83b7\u53d6\u5206\u914d\u6807\u51c6\u5b8c\u6574\u7684\u5339\u914d\u4e32:\u6838\u7b97\u7ec4\u7ec7\uff1a{}\u751f\u4ea7\u7ec4\u7ec7\uff1a{}\uff0c\u6210\u672c\u4e2d\u5fc3\uff1a{}\uff0c\u7269\u6599\uff1a{}\uff0c\u7269\u6599\u7248\u672c\uff1a{}\uff0c\u8f85\u52a9\u5c5e\u6027\uff1a{}", new Object[]{orgId, manuOrg, costcenter, material, matversion, auxpty});
        logger.info("\u5339\u914d\u4e32\uff1a{}", (Object)String.format(keyFormat, orgId, manuOrg, costcenter, material, matversion, auxpty, 0));
        if (manuOrg != 0L) {
            String key = String.format(keyFormat, orgId, manuOrg, costcenter, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, 0, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, costcenter, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, 0, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, costcenter, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, manuOrg, 0, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
        } else {
            String key = String.format(keyFormat, orgId, 0, costcenter, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, material, matversion, auxpty, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, material);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, costcenter, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
            key = String.format(keyFormat, orgId, 0, 0, 0, 0, 0, 0);
            if (stdMap.containsKey(key)) {
                return stdMap.get(key);
            }
        }
        return 0L;
    }

    public static Map<String, Long> getMatAllocStdMap(Long orgId, String appnum) {
        HashSet<Long> orgIds = new HashSet<Long>();
        orgIds.add(orgId);
        return MatAllocDataHelper.getMatAllocStdMap(orgIds, appnum);
    }

    public static Map<String, Long> getMatAllocStdMap(Set<Long> orgIds, String appnum) {
        HashMap<String, Long> map = new HashMap<String, Long>(32);
        QFilter stdFilter = QFilter.of((String)"billstatus =?", (Object[])new Object[]{"C"});
        stdFilter = stdFilter.and(new QFilter("org", "in", orgIds));
        stdFilter = stdFilter.and("appnum", "=", (Object)appnum);
        stdFilter = stdFilter.and("expdate", ">=", (Object)new Date());
        DataSet stdDataSet = QueryServiceHelper.queryDataSet((String)"MatAllocHelper.getMatAllocStdMap", (String)"sca_matallocstd", (String)"id,billno,org,manuorg,allocentry.costcenter costcenter,allocentry.bmaterial bmaterial,allocentry.matversion matversion,allocentry.auxpty auxpty,allocentry.materialgroup materialgroup,allocentry.materialgroup.longnumber materialgrouplongnumber,allocentry.materialgroup.standard standard,allocentry.costdriver costdriver", (QFilter[])new QFilter[]{stdFilter}, null);
        if (!stdDataSet.isEmpty()) {
            while (stdDataSet.hasNext()) {
                Row row = stdDataSet.next();
                Long costdriverId = row.getLong("costdriver");
                Long materialgroup = MatAllocDataHelper.getRowLongVal(row, "materialgroup");
                if (CadEmptyUtils.isEmpty(materialgroup)) {
                    String uniqKey = String.format("%s@%s@%s@%s@%s@%s@%s", MatAllocDataHelper.getRowLongVal(row, "org"), MatAllocDataHelper.getRowLongVal(row, "manuorg"), MatAllocDataHelper.getRowLongVal(row, "costcenter"), MatAllocDataHelper.getRowLongVal(row, "bmaterial"), MatAllocDataHelper.getRowLongVal(row, "matversion"), MatAllocDataHelper.getRowLongVal(row, "auxpty"), materialgroup);
                    map.put(uniqKey, costdriverId);
                    continue;
                }
                Set<Long> materialIds = MatAllocDataHelper.getGroupMaterial(materialgroup, MatAllocDataHelper.getRowLongVal(row, "standard"), row.getString("materialgrouplongnumber"));
                for (Long id : materialIds) {
                    String uniqKey = String.format("%s@%s@%s@%s@%s@%s@%s", MatAllocDataHelper.getRowLongVal(row, "org"), MatAllocDataHelper.getRowLongVal(row, "manuorg"), MatAllocDataHelper.getRowLongVal(row, "costcenter"), MatAllocDataHelper.getRowLongVal(row, "bmaterial"), MatAllocDataHelper.getRowLongVal(row, "matversion"), MatAllocDataHelper.getRowLongVal(row, "auxpty"), id);
                    map.put(uniqKey, costdriverId);
                }
            }
        }
        return map;
    }

    public static Set<Long> getGroupMaterial(Long groupId, Long standardId, String groupLongNum) {
        HashSet groupIds = Sets.newHashSet();
        groupIds.add(groupId);
        if (StringUtils.isNotEmpty((CharSequence)groupLongNum)) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "!";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = new QFilter("standard", "=", (Object)standardId);
            groupFilter.and("longnumber", "like", (Object)(groupLongNum + longNumberDLM + "%"));
            DataSet groupDs = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroup", (String)"id,number,standard", (QFilter[])groupFilter.toArray(), null);
            for (Row row : groupDs) {
                groupIds.add(row.getLong("id"));
            }
        }
        QFilter filter = new QFilter("group", "in", (Object)groupIds);
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material", (QFilter[])filter.toArray(), null);
        HashSet materialIds = Sets.newHashSet();
        for (Row row : classifiedMaterialDataSet) {
            materialIds.add(row.getLong("material"));
        }
        return materialIds;
    }

    private static Long getRowLongVal(Row row, String key) {
        return MatAllocDataHelper.getLongVal(row.getLong(key));
    }

    private static Long getLongVal(Long val) {
        if (val == null) {
            return 0L;
        }
        return val;
    }
}

