/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.enums.ScaAllocEnum;
import kd.macc.cad.common.helper.ElementHelper;
import kd.macc.cad.common.helper.MatAllocDataHelper;
import kd.macc.cad.common.output.AllocResult;
import kd.macc.cad.common.utils.BigDecimalUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

@Deprecated
public class MatAllocImportHelper {
    private static final Log logger = LogFactory.getLog(MatAllocImportHelper.class);

    public static AllocResult toAlloc(List<Map<String, Object>> costAccountList, String appNum) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(10);
        AllocResult allocRes = MatAllocImportHelper.toAlloc(costAccountList, billList, appNum);
        SaveServiceHelper.save((DynamicObject[])billList.toArray(new DynamicObject[0]));
        allocRes.getReasonMap().put("successQty", String.valueOf(billList.size()));
        HashSet<Long> billIds = new HashSet<Long>();
        billList.forEach(e -> billIds.add(e.getLong("id")));
        allocRes.setBillIds(billIds);
        return allocRes;
    }

    public static AllocResult toAlloc(List<Map<String, Object>> costAccountList, List<DynamicObject> billList, String appNum) {
        logger.info("\u6750\u6599\u8017\u7528\u5206\u914d\u4f20\u5165\u53c2\u6570:{}", (Object)SerializationUtils.toJsonString(costAccountList));
        AllocResult res = new AllocResult();
        res.setReasonMap(new HashMap<String, String>());
        int totalCount = 0;
        for (Map<String, Object> costAccountMap : costAccountList) {
            DynamicObjectCollection bills = MatAllocDataHelper.getImportData(costAccountMap, appNum);
            if (bills == null || bills.isEmpty()) continue;
            totalCount += bills.size();
            ArrayList<DynamicObject> scaProcessList = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> acaProcessList = new ArrayList<DynamicObject>();
            HashMap<String, Date> costRecDateMap = new HashMap<String, Date>(16);
            ArrayList<Long> sourceBillEntryIds = new ArrayList<Long>();
            MatAllocImportHelper.splitScaAndAcaBill(costAccountMap, bills, scaProcessList, acaProcessList, sourceBillEntryIds, costRecDateMap);
            Long orgId = (Long)costAccountMap.get("org");
            Map<String, Long> matAllocStdMap = MatAllocDataHelper.getMatAllocStdMap(orgId, "sca");
            MatAllocImportHelper.toScaBills(scaProcessList, costAccountMap, billList, costRecDateMap, res, matAllocStdMap);
            MatAllocImportHelper.toAcaBills(acaProcessList, costAccountMap, billList, costRecDateMap, res, sourceBillEntryIds, matAllocStdMap);
        }
        res.setTotalCount(totalCount);
        res.setSuccessCount(billList.size());
        res.setFailCount(totalCount - billList.size());
        String countTip = MatAllocImportHelper.generateCountTip(res);
        ArrayList errorList = Lists.newArrayList();
        Map<String, String> reasonMap = res.getReasonMap();
        if (res.isSuccess()) {
            if (billList.isEmpty()) {
                res.setSuccess(false);
                reasonMap.put("false", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\u3002\u5f53\u524d\u671f\u95f4\u5185\u6ca1\u6709\u53ef\u5f15\u5165\u7684\u6570\u636e\u3002", (String)"MatAllocImportHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
            } else {
                String useAmountIsEmptyTip = MatAllocImportHelper.generateUseAmountIsEmptyTip(billList);
                reasonMap.put("useAmountIsEmptyTip", useAmountIsEmptyTip);
                reasonMap.put("success", countTip);
            }
        } else {
            errorList.add(new String[]{ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u6570\u636e", (String)"MatAllocImportHelper_2", (String)"macc-cad-common", (Object[])new Object[0]), "Error", countTip});
            MatAllocImportHelper.generateFailBillTip(reasonMap, errorList);
            reasonMap.clear();
            res.setErrorList(errorList);
        }
        return res;
    }

    private static void splitScaAndAcaBill(Map<String, Object> costAccountMap, DynamicObjectCollection bills, List<DynamicObject> scaProcessList, List<DynamicObject> acaProcessList, List<Long> sourceBillEntryIds, Map<String, Date> costRecDateMap) {
        ArrayList matUseSrcBillEntryIds = new ArrayList();
        bills.forEach(bill -> {
            long srcBillEntryId = bill.getLong("sourcebillentryid");
            if (srcBillEntryId != 0L) {
                matUseSrcBillEntryIds.add(srcBillEntryId);
            }
        });
        String fields = "storageorgunit, bookdate, costaccount, entry.bizbillentryid AS bizbillentryid, entry.accounttype AS accounttype";
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("entry.bizbillentryid", "in", matUseSrcBillEntryIds));
        DynamicObjectCollection costRecords = QueryServiceHelper.query((String)"cal_costrecord_subentity", (String)fields, (QFilter[])qfList.toArray(new QFilter[0]));
        HashMap billOrgMap = new HashMap(16);
        HashSet existCostRecScaBizBillIds = new HashSet();
        StringBuilder dateKey = new StringBuilder();
        costRecords.forEach(e -> {
            dateKey.setLength(0);
            dateKey.append(e.getLong("costaccount")).append('@').append(e.getLong("bizbillentryid"));
            costRecDateMap.putIfAbsent(dateKey.toString(), e.getDate("bookdate"));
            if ("D".equalsIgnoreCase(e.getString("accounttype"))) {
                existCostRecScaBizBillIds.add(e.getLong("bizbillentryid"));
                billOrgMap.put(dateKey.toString(), e.getLong("storageorgunit"));
            }
        });
        costAccountMap.put("billOrgMap", billOrgMap);
        matUseSrcBillEntryIds.forEach(e -> {
            if (!existCostRecScaBizBillIds.contains(e)) {
                sourceBillEntryIds.add((Long)e);
            }
        });
        bills.forEach(e -> {
            if (sourceBillEntryIds.contains(e.getLong("sourcebillentryid"))) {
                acaProcessList.add((DynamicObject)e);
            } else {
                scaProcessList.add((DynamicObject)e);
            }
        });
    }

    private static void toScaBills(List<DynamicObject> scaProcessList, Map<String, Object> costAccountMap, List<DynamicObject> billList, Map<String, Date> costRecDateMap, AllocResult res, Map<String, Long> matAllocStdMap) {
        HashMap<String, List<DynamicObject>> billMap = new HashMap<String, List<DynamicObject>>(16);
        HashSet<Map<String, Object>> matCostInfoObjects = new HashSet<Map<String, Object>>(16);
        StringBuilder matKey = new StringBuilder();
        HashMap<Long, DynamicObject> matMap = new HashMap<Long, DynamicObject>(16);
        MatAllocDataHelper.dealBatchDataToSca(scaProcessList, costAccountMap, matMap, matAllocStdMap);
        for (DynamicObject bill : scaProcessList) {
            String matUseBillMatKey = MatAllocImportHelper.getMatUseBillMatKey(bill, matMap, costAccountMap, matKey);
            billMap.computeIfAbsent(matUseBillMatKey, s -> new ArrayList()).add(bill);
            Map<String, Object> param = MatAllocImportHelper.wrapMatInfoParam(bill, matMap, costAccountMap);
            matCostInfoObjects.add(param);
        }
        Object[] params = new Object[]{matCostInfoObjects, false};
        HashSet<Long> hasCostInfoMatIdSet = new HashSet<Long>(16);
        HashSet<String> hasCostInfoMatSet = new HashSet<String>(16);
        ArrayList<DynamicObject> tempList = new ArrayList<DynamicObject>(16);
        Long org = (Long)costAccountMap.get("org");
        Map<Object, Object> matCostInfoMap = new HashMap(10);
        matCostInfoMap = MatAllocDataHelper.getMatCost(params);
        if (matCostInfoMap != null && matCostInfoMap.size() > 0) {
            MatAllocImportHelper.setBillInfoForStd(costAccountMap, billMap, costRecDateMap, matCostInfoMap, tempList, hasCostInfoMatSet, hasCostInfoMatIdSet, matAllocStdMap);
            List<DynamicObject> dealtBillList = MatAllocImportHelper.dealAmoutOver(tempList, res);
            billList.addAll(dealtBillList);
            MatAllocImportHelper.fillEntrySubElement(org, billList, hasCostInfoMatIdSet);
        }
        MatAllocImportHelper.putNotMatMsg(billMap, costAccountMap, hasCostInfoMatSet, res, matMap);
    }

    private static List<DynamicObject> dealAmoutOver(List<DynamicObject> tempList, AllocResult res) {
        if (tempList.isEmpty()) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> dealtBillList = new ArrayList<DynamicObject>(10);
        tempList.forEach(e -> {
            Long maxAount;
            BigDecimal useAmount = e.getBigDecimal("useamount");
            if (useAmount.compareTo(new BigDecimal(maxAount = Long.valueOf(9999999999999L))) > 0) {
                String billNo = e.getString("billno");
                String[] billNoArr = billNo.split("_");
                Map<String, String> reasonMap = res.getReasonMap();
                reasonMap.put(billNo, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u6570\u91cf*\u5355\u4f4d\u6210\u672c>%2$s\u3002", (String)"MatAllocImportHelper_9", (String)"macc-cad-common", (Object[])new Object[0]), billNoArr[1], maxAount));
            } else {
                dealtBillList.add((DynamicObject)e);
            }
        });
        if (tempList.size() > dealtBillList.size()) {
            res.setSuccess(false);
        }
        return dealtBillList;
    }

    private static void toAcaBills(List<DynamicObject> acaProcessList, Map<String, Object> costAccountMap, List<DynamicObject> billList, Map<String, Date> costRecDateMap, AllocResult res, List<Long> acaBillEntryIds, Map<String, Long> matAllocStdMap) {
        if (acaProcessList.isEmpty()) {
            return;
        }
        Long costAccountId = (Long)costAccountMap.get("costaccountId");
        Long orgId = (Long)costAccountMap.get("org");
        Map<Long, Map<Long, List<DynamicObject>>> costRecords = MatAllocDataHelper.getCalCostRecord(costAccountId, acaBillEntryIds);
        ArrayList<DynamicObject> tempBillList = new ArrayList<DynamicObject>(10);
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject bill : acaProcessList) {
            String rowIndex = bill.getString("seq");
            String billno = bill.getString("billno") + "_" + rowIndex + "_" + (String)costAccountMap.get("costaccountnum");
            Long sourcebillid = bill.getLong("sourcebillid");
            Long sourcebillentryid = bill.getLong("sourcebillentryid");
            Map<Long, List<DynamicObject>> entryIdActualCostMap = costRecords.get(sourcebillid);
            boolean hasRec = true;
            List<DynamicObject> calCostRecList = null;
            if (entryIdActualCostMap == null || entryIdActualCostMap.isEmpty()) {
                hasRec = false;
            } else {
                calCostRecList = entryIdActualCostMap.get(sourcebillentryid);
                if (calCostRecList == null || calCostRecList.isEmpty()) {
                    hasRec = false;
                }
            }
            if (!hasRec) {
                Map<String, String> reasonMap = res.getReasonMap();
                reasonMap.put(billno, ResManager.loadKDString((String)"\u5b58\u5728\u5206\u5f55\u672a\u627e\u5230\u5173\u8054\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u3002", (String)"MatAllocImportHelper_4", (String)"macc-cad-common", (Object[])new Object[0]));
                res.setSuccess(false);
                continue;
            }
            DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_matalloc");
            allocBill.set("entrysrc", (Object)"calrec");
            allocBill.set("billno", (Object)billno);
            allocBill.set("matcostinfo", (Object)sourcebillentryid);
            if (calCostRecList != null && calCostRecList.size() > 0) {
                allocBill.set("useamount", (Object)calCostRecList.get(0).getBigDecimal("actualcost"));
            }
            MatAllocImportHelper.setBillData(allocBill, bill, costAccountMap, costRecDateMap, matAllocStdMap);
            allocBill.set("isreturnitem", (Object)bill.getBoolean("isrework"));
            Long costobject = bill.getLong("costobject");
            if (costobject != null && costobject != 0L) {
                MatAllocImportHelper.setAllocDetail(allocBill, bill, costAccountMap, calCostRecList);
                MatAllocImportHelper.setDirAllocData(allocBill);
            }
            materialIds.add(allocBill.getLong("material"));
            tempBillList.add(allocBill);
        }
        Map<Long, Long[]> matToSubEleMap = ElementHelper.getDefSubEles(orgId, materialIds);
        for (DynamicObject bill : tempBillList) {
            Long[] matToSubEle;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            if (rows == null || rows.isEmpty() || (matToSubEle = matToSubEleMap.get(bill.getLong("material"))) == null) continue;
            for (DynamicObject row : rows) {
                row.set("elemententry", (Object)matToSubEle[0]);
                row.set("subelemententry", (Object)matToSubEle[1]);
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                if (subentryentity == null || !subentryentity.isEmpty()) continue;
                DynamicObject subentry = subentryentity.addNew();
                subentry.set("element", row.get("elemententry"));
                subentry.set("subelement", row.get("subelemententry"));
                subentry.set("standardcost", row.get("price"));
                subentry.set("standardamt", row.get("amount"));
            }
        }
        billList.addAll(tempBillList);
    }

    private static void setBillData(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, Map<String, Date> costRecDateMap, Map<String, Long> matAllocStdMap) {
        allocBill.set("id", (Object)DB.genLongId((String)"sca_matalloc"));
        allocBill.set("org", (Object)bill.getLong("org"));
        allocBill.set("manuorg", (Object)bill.getLong("manuorg"));
        allocBill.set("costcenter", (Object)bill.getLong("costcenter"));
        allocBill.set("biztype", (Object)bill.getString("biztype"));
        allocBill.set("bizdate", (Object)bill.getDate("bizdate"));
        Long costobjectId = bill.getLong("costobject");
        if (costobjectId == null || costobjectId == 0L) {
            Long costdriverId = MatAllocDataHelper.getMatAllocStdCostDriver(bill.getLong("org"), bill.getLong("manuorg"), bill.getLong("costcenter"), bill.getLong("material"), bill.getLong("matversion"), bill.getLong("auxpty"), bill.getLong("materialgroup"), matAllocStdMap);
            allocBill.set("costdriver", (Object)costdriverId);
        }
        allocBill.set("material", (Object)bill.getLong("material"));
        allocBill.set("matversion", (Object)bill.getLong("matversion"));
        allocBill.set("auxpty", (Object)bill.getLong("auxpty"));
        allocBill.set("useqty", (Object)bill.getBigDecimal("qty"));
        allocBill.set("warehouse", (Object)bill.getLong("warehouse"));
        allocBill.set("location", (Object)bill.getLong("location"));
        allocBill.set("costobject", (Object)bill.getLong("costobject"));
        allocBill.set("lotcoderule", bill.get("lotcoderule"));
        allocBill.set("unit", (Object)bill.getLong("unit"));
        allocBill.set("baseunit", (Object)bill.getLong("baseunit"));
        allocBill.set("appnum", (Object)bill.getString("appnum"));
        allocBill.set("costaccount", costaccountMap.get("costaccountId"));
        allocBill.set("period", costaccountMap.get("currentperiodId"));
        allocBill.set("currency", costaccountMap.get("currencyId"));
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("alloctype", (Object)ScaAllocEnum.ALLOCTYP_AUTO.getValue());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_UNALLOC.getValue());
        allocBill.set("matcollect", (Object)bill.getLong("entryid"));
        allocBill.set("matusesrcbillentryid", (Object)bill.getLong("sourcebillentryid"));
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_PUBLIC.getValue());
        Date costRecDate = MatAllocImportHelper.getCostRecDate(costRecDateMap, costaccountMap, bill);
        allocBill.set("srcsyncdate", (Object)costRecDate);
        allocBill.set("creator", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("createtime", (Object)new Date());
        allocBill.set("modifier", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("modifytime", (Object)new Date());
    }

    private static void setAllocDetail(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costAccountMap, List<DynamicObject> calCostRecList) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        BigDecimal price = allocBill.getBigDecimal("useamount").divide(bill.getBigDecimal("qty"), 10, RoundingMode.HALF_UP);
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        entry.set("amount", allocBill.get("useamount"));
        entry.set("price", (Object)price);
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        if (calCostRecList != null && !calCostRecList.isEmpty()) {
            HashMap<String, DynamicObject> onlyMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject calRec : calCostRecList) {
                StringBuilder key = new StringBuilder();
                key.append(calRec.get("element")).append("@");
                key.append(calRec.get("subelement")).append("@");
                key.append(calRec.get("material")).append("@");
                key.append(calRec.get("matversion")).append("@");
                key.append(calRec.get("auxpty"));
                onlyMap.put(key.toString(), calRec);
            }
            for (DynamicObject calCostRec : onlyMap.values()) {
                BigDecimal subactualcost = (BigDecimal)calCostRec.get("subactualcost");
                if (BigDecimal.ZERO.compareTo(subactualcost) == 0) continue;
                DynamicObject subentry = subentryentity.addNew();
                subentry.set("element", calCostRec.get("element"));
                subentry.set("subelement", calCostRec.get("subelement"));
                subentry.set("standardcost", calCostRec.get("subunitactualcost"));
                subentry.set("standardamt", (Object)subactualcost);
                subentry.set("submaterial", calCostRec.get("material"));
                subentry.set("submatverison", calCostRec.get("matversion"));
                subentry.set("subauxpty", calCostRec.get("auxpty"));
                subentry.set("subqty", allocBill.get("useqty"));
            }
        }
    }

    private static void setDirAllocData(DynamicObject allocBill) {
        allocBill.set("billstatus", (Object)"A");
        allocBill.set("auditor", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("allocstatus", (Object)ScaAllocEnum.ALLOCSTATUS_CONFIRM.getValue());
        allocBill.set("alloctor", (Object)RequestContext.get().getCurrUserId());
        allocBill.set("allocatedate", (Object)new Date());
        allocBill.set("usetype", (Object)ScaAllocEnum.USETYPE_DRIECT.getValue());
        allocBill.set("costdriver", (Object)0L);
    }

    private static void generateFailBillTip(Map<String, String> reasonMap, List<String[]> errorList) {
        HashSet<String> tipSet = new HashSet<String>(16);
        for (Map.Entry<String, String> entry : reasonMap.entrySet()) {
            String key = entry.getKey();
            String msg = ResManager.loadKDString((String)(key.substring(0, key.indexOf("_")) + "MatAllocImportHelper_5" + entry.getValue()), (String)"macc-cad-common", (String)"macc-cad-common", (Object[])new Object[0]);
            if (tipSet.contains(msg)) continue;
            tipSet.add(msg);
            errorList.add(new String[]{ResManager.loadKDString((String)"\u6750\u6599\u8017\u7528\u5206\u914d\u5f15\u5165\u6570\u636e", (String)"MatAllocImportHelper_2", (String)"macc-cad-common", (Object[])new Object[0]), "Error", msg});
        }
    }

    private static String generateCountTip(AllocResult res) {
        return String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$s\u6761\uff0c\u5bfc\u5165\u5931\u8d25%2$s\u6761\u3002", (String)"MatAllocImportHelper_10", (String)"macc-cad-common", (Object[])new Object[0]), res.getSuccessCount(), res.getFailCount());
    }

    private static String generateUseAmountIsEmptyTip(List<DynamicObject> billList) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject bill : billList) {
            if (BigDecimal.ZERO.compareTo(bill.getBigDecimal("useamount")) != 0 || !"calrec".equals(bill.getString("entrysrc"))) continue;
            String msg = String.format(ResManager.loadKDString((String)"%s: \u91d1\u989d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u76f8\u5e94\u7684\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u5b9e\u9645\u6210\u672c\u3002", (String)"MatAllocImportHelper_7", (String)"macc-cad-common", (Object[])new Object[0]), bill.getString("billno"));
            sb.append(msg);
            sb.append("\r\n");
        }
        if (!StringUtils.isEmpty((CharSequence)sb.toString())) {
            return sb.toString();
        }
        return "";
    }

    private static void putNotMatMsg(Map<String, List<DynamicObject>> billMap, Map<String, Object> costAccountMap, Set<String> hasCostInfoMatSet, AllocResult res, Map<Long, DynamicObject> matMap) {
        String costAccountNum = (String)costAccountMap.get("costaccountnum");
        StringBuilder tipSb = new StringBuilder();
        String split = "_";
        for (Map.Entry<String, List<DynamicObject>> billKV : billMap.entrySet()) {
            if (hasCostInfoMatSet.contains(billKV.getKey())) continue;
            for (DynamicObject bill : billKV.getValue()) {
                tipSb.setLength(0);
                tipSb.append(bill.getString("billno")).append(split).append(bill.getString("seq")).append(split).append(costAccountNum);
                Map<String, String> reasonMap = res.getReasonMap();
                Long matId = bill.getLong("material");
                reasonMap.put(tipSb.toString(), String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%s\u201d\u7684\u7269\u6599\u6210\u672c\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", (String)"MatAllocImportHelper_11", (String)"macc-cad-common", (Object[])new Object[0]), matMap.get(matId).getString("materialname")));
                res.setSuccess(false);
            }
        }
    }

    private static void fillEntrySubElement(Long orgId, List<DynamicObject> tempList, Set<Long> hasCostInfoMatIdSet) {
        Map<Long, Long[]> matToSubEleMap = ElementHelper.getDefSubEles(orgId, hasCostInfoMatIdSet);
        for (DynamicObject bill : tempList) {
            Long[] matToSubEle;
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("entryentity");
            if (rows == null || rows.isEmpty() || (matToSubEle = matToSubEleMap.get(bill.getLong("material"))) == null) continue;
            for (DynamicObject row : rows) {
                row.set("elemententry", (Object)matToSubEle[0]);
                row.set("subelemententry", (Object)matToSubEle[1]);
            }
        }
    }

    private static Map<String, Object> wrapMatInfoParam(DynamicObject bill, Map<Long, DynamicObject> matMap, Map<String, Object> costAccountMap) {
        Date bizDate = bill.getDate("srcauditdate");
        boolean useMatVer = (Boolean)costAccountMap.get("useMatVer");
        DynamicObject mat = matMap.get(bill.getLong("material"));
        Long matVerId = 0L;
        if (mat.getBoolean("isusematver") && useMatVer) {
            matVerId = bill.getLong("matversion");
        }
        Long auxptyId = 0L;
        if (mat.getBoolean("isuseauxpty")) {
            auxptyId = bill.getLong("auxpty");
        }
        Long costaccountId = (Long)costAccountMap.get("costaccountId");
        Long org = (Long)costAccountMap.get("org");
        Long invorg = 1L;
        if (costAccountMap.get("billOrgMap") != null) {
            String keyValue;
            Map billOrgMap = (Map)costAccountMap.get("billOrgMap");
            invorg = billOrgMap.get(keyValue = costaccountId + "@" + bill.getLong("sourcebillentryid")) == null ? Long.valueOf(1L) : (Long)billOrgMap.get(keyValue);
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("org", org);
        param.put("invorg", invorg);
        param.put("costaccount", costaccountId);
        param.put("material", bill.getLong("material"));
        param.put("matversion", matVerId);
        param.put("auxpty", auxptyId);
        param.put("date", bizDate);
        return param;
    }

    private static String getMatUseBillMatKey(DynamicObject bill, Map<Long, DynamicObject> matMap, Map<String, Object> costAccountMap, StringBuilder matKey) {
        matKey.setLength(0);
        Long matId = bill.getLong("material");
        DynamicObject mat = matMap.get(matId);
        boolean useMatVer = (Boolean)costAccountMap.get("useMatVer");
        long matVerId = 0L;
        if (mat != null && mat.getBoolean("isusematver") && useMatVer) {
            matVerId = bill.getLong("matversion");
        }
        long auxptyId = 0L;
        if (mat != null && mat.getBoolean("isuseauxpty")) {
            auxptyId = bill.getLong("auxpty");
        }
        Date bizDate = bill.getDate("srcauditdate");
        Long costaccountId = (Long)costAccountMap.get("costaccountId");
        Long invorg = 1L;
        if (costAccountMap.get("billOrgMap") != null) {
            String keyValue;
            Map billOrgMap = (Map)costAccountMap.get("billOrgMap");
            invorg = billOrgMap.get(keyValue = costaccountId + "@" + bill.getLong("sourcebillentryid")) == null ? Long.valueOf(1L) : (Long)billOrgMap.get(keyValue);
        }
        matKey.setLength(0);
        matKey.append(invorg).append('@').append(matId).append('@').append(matVerId).append('@').append(auxptyId).append('@').append(bizDate);
        return matKey.toString();
    }

    private static void setBillInfoForStd(Map<String, Object> costAccountMap, Map<String, List<DynamicObject>> billMap, Map<String, Date> costRecDateMap, Map<String, List<Map<String, Object>>> matCostInfoMap, List<DynamicObject> billList, Set<String> hasCostInfoMatSet, Set<Long> hasCostInfoMatIdSet, Map<String, Long> matAllocStdMap) {
        StringBuilder matKey = new StringBuilder();
        String costAccountNum = (String)costAccountMap.get("costaccountnum");
        Integer amtPrecision = (Integer)costAccountMap.get("amtprecision");
        HashSet<String> hasGenBillNo = new HashSet<String>(32);
        for (Map.Entry<String, List<Map<String, Object>>> matCostInfoEntry : matCostInfoMap.entrySet()) {
            String matCostInfoKey = matCostInfoEntry.getKey();
            List<Map<String, Object>> matCostInfoList = matCostInfoEntry.getValue();
            Map<String, Object> matCostInfo = matCostInfoList.get(0);
            String[] matCostInfoArr = matCostInfoKey.split("#");
            String matCombKey = MatAllocImportHelper.getMatCostInfoKey(matCostInfoArr, matKey);
            List<DynamicObject> bills = billMap.get(matCombKey);
            if (bills == null || bills.isEmpty()) continue;
            for (DynamicObject bill : bills) {
                String rowIndex = bill.getString("seq");
                String billno = bill.getString("billno") + "_" + rowIndex + "_" + costAccountNum;
                if (hasGenBillNo.contains(billno)) continue;
                hasGenBillNo.add(billno);
                DynamicObject allocBill = BusinessDataServiceHelper.newDynamicObject((String)"sca_matalloc");
                allocBill.set("billno", (Object)billno);
                allocBill.set("entrysrc", (Object)"calcres");
                allocBill.set("matcostinfo", matCostInfo.get("id"));
                MatAllocImportHelper.setBillData(allocBill, bill, costAccountMap, costRecDateMap, matAllocStdMap);
                allocBill.set("isreturnitem", (Object)bill.getBoolean("isrework"));
                BigDecimal totalStandardamt = BigDecimal.ZERO;
                BigDecimal qty = bill.getBigDecimal("qty");
                for (Map<String, Object> row : matCostInfoList) {
                    String datatype = (String)row.get("datatype");
                    if (datatype != null && !"2".equals(datatype) && !"3".equals(datatype)) continue;
                    BigDecimal standardcost = row.get("stdprice") == null ? BigDecimal.ZERO : (BigDecimal)row.get("stdprice");
                    BigDecimal standardamt = standardcost.multiply(qty).setScale((int)amtPrecision, 4);
                    totalStandardamt = totalStandardamt.add(standardamt);
                }
                allocBill.set("useamount", (Object)totalStandardamt);
                Long costobject = bill.getLong("costobject");
                if (costobject != null && costobject != 0L) {
                    MatAllocImportHelper.setEntryDataForStd(allocBill, bill, costAccountMap, matCostInfoList);
                    MatAllocImportHelper.setDirAllocData(allocBill);
                }
                billList.add(allocBill);
                hasCostInfoMatSet.add(matCombKey);
                hasCostInfoMatIdSet.add(Long.parseLong(matCostInfoArr[3]));
            }
        }
    }

    public static void setEntryDataForStd(DynamicObject allocBill, DynamicObject bill, Map<String, Object> costaccountMap, List<Map<String, Object>> matCostInfos) {
        DynamicObjectCollection entryentity = allocBill.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entryentity.addNew();
        entry.set("costobejctentry", (Object)bill.getLong("costobject"));
        entry.set("qty", (Object)bill.getBigDecimal("qty"));
        DynamicObjectCollection subentryentity = entry.getDynamicObjectCollection("subentryentity");
        BigDecimal totalStandardcost = BigDecimal.ZERO;
        BigDecimal stdQty = bill.getBigDecimal("qty");
        Integer amtPrecision = (Integer)costaccountMap.get("amtprecision");
        if (!CadEmptyUtils.isEmpty(matCostInfos)) {
            int seq = 1;
            for (Map<String, Object> info : matCostInfos) {
                String datatype = (String)info.get("datatype");
                if (datatype != null && !"2".equals(datatype) && !"3".equals(datatype)) continue;
                DynamicObject sub = subentryentity.addNew();
                sub.set("seq", (Object)seq);
                ++seq;
                sub.set("element", info.get("element"));
                sub.set("subelement", info.get("subelement"));
                if (info.get("qty") != null) {
                    sub.set("calcbasis", info.get("calcbasis"));
                    sub.set("resource", info.get("resource"));
                    sub.set("submaterial", info.get("submaterial"));
                    sub.set("submatverison", info.get("submatvers"));
                    sub.set("subauxpty", info.get("subauxproperty"));
                    BigDecimal subqty = stdQty.multiply((BigDecimal)info.get("qty"));
                    sub.set("subqty", (Object)subqty);
                } else {
                    sub.set("submaterial", (Object)allocBill.getLong("material"));
                    sub.set("submatverison", (Object)allocBill.getLong("matversion"));
                    sub.set("subauxpty", (Object)allocBill.getLong("auxpty"));
                    sub.set("subqty", (Object)(stdQty.compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(1) : stdQty));
                }
                BigDecimal standardcost = info.get("stdprice") == null ? BigDecimal.ZERO : (BigDecimal)info.get("stdprice");
                sub.set("standardcost", (Object)standardcost);
                totalStandardcost = totalStandardcost.add(standardcost);
                BigDecimal standardamt = standardcost.multiply(stdQty).setScale((int)amtPrecision, 4);
                sub.set("standardamt", (Object)standardamt);
            }
        }
        entry.set("price", (Object)totalStandardcost);
        entry.set("amount", (Object)allocBill.getBigDecimal("useamount"));
        BigDecimalUtils.dealDiff(subentryentity, "seq", "standardamt", entry.getBigDecimal("amount"), amtPrecision);
    }

    public static void countTotalStandardamtForStd(DynamicObject allocBill, DynamicObject bill, List<DynamicObject> effeResList, boolean isEffeRes, Integer amtPrecision) {
        if (effeResList == null) {
            allocBill.set("useamount", (Object)0);
            return;
        }
        BigDecimal totalStandardamt = BigDecimal.ZERO;
        BigDecimal qty = bill.getBigDecimal("qty");
        for (DynamicObject entryRow : effeResList) {
            BigDecimal standardcost = entryRow.getBigDecimal("standardcost");
            BigDecimal standardamt = standardcost.multiply(qty).setScale((int)amtPrecision, 4);
            totalStandardamt = totalStandardamt.add(standardamt);
        }
        allocBill.set("useamount", (Object)totalStandardamt.setScale((int)amtPrecision, 4));
        allocBill.set("matcostinfo", effeResList.get(0).get("id"));
    }

    private static String getMatCostInfoKey(String[] matCostInfo, StringBuilder matKey) {
        matKey.setLength(0);
        Long invorg = Long.parseLong(matCostInfo[1]);
        Long matId = Long.parseLong(matCostInfo[3]);
        Long matVerId = Long.parseLong(matCostInfo[4]);
        Long auxptyId = Long.parseLong(matCostInfo[5]);
        String bizDate = matCostInfo[6];
        matKey.append(invorg).append('@').append(matId).append('@').append(matVerId).append('@').append(auxptyId).append('@').append(bizDate);
        return matKey.toString();
    }

    private static Date getCostRecDate(Map<String, Date> costRecDateMap, Map<String, Object> costAccountMap, DynamicObject bill) {
        String dateKey = costAccountMap.get("costaccountId") + "@" + bill.getLong("sourcebillentryid");
        Date costRecDate = costRecDateMap.get(dateKey) == null ? bill.getDate("auditdate") : costRecDateMap.get(dateKey);
        return costRecDate;
    }
}

