/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatDimensionHelper {
    private static final Log logger = LogFactory.getLog(MatDimensionHelper.class);

    public static Map<Long, DynamicObject> getDimensionByMatIds(Long simCostType, Set<Long> matIds) {
        HashMap<Long, DynamicObject> result = new HashMap<Long, DynamicObject>();
        HashSet<Long> materialSet = new HashSet<Long>(matIds);
        HashMap<Long, Long> matDimensionMap = new HashMap<Long, Long>(16);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("costtype", "=", (Object)simCostType);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"MatDimensionHelper_getDimensionByMatIds_1", (String)"cad_matcalcseting", (String)"costtype,materialgrpstd,entryentity.material as material,entryentity.materialgroup as materialgroup,entryentity.materialgroup.number as groupnum,entryentity.calcdimension as calcdimension", (QFilter[])new QFilter[]{filter}, null);
        if (!dataSet.isEmpty()) {
            DataSet matLevelDs = dataSet.copy().filter("material !=0 and  materialgroup = 0");
            for (Row next : matLevelDs) {
                matDimensionMap.put(next.getLong("material"), next.getLong("calcdimension"));
            }
            materialSet.removeAll(matDimensionMap.keySet());
            QFilter stdFilter = new QFilter("material", "in", materialSet);
            DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"MatDimensionHelper_getDimensionByMatIds_2", (String)"bd_materialgroupdetail", (String)"standard,group,group.longnumber as longnumber,material", (QFilter[])new QFilter[]{stdFilter}, null);
            HashMap<String, Long> hashMap = new HashMap<String, Long>(16);
            DataSet stdLevelDS = dataSet.filter("material=0 and materialgroup != 0");
            for (Row next : stdLevelDS) {
                hashMap.put(next.getString("materialgrpstd") + "@" + next.getString("groupnum"), next.getLong("calcdimension"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getDimensionByMatIds dimension map ==>{}", hashMap);
            }
            block2: for (Row next : dataSet2) {
                String standard = next.getString("standard");
                String longNumber = next.getString("longnumber");
                if (CadEmptyUtils.isEmpty(longNumber)) continue;
                Long material = next.getLong("material");
                Object[] split = longNumber.split("!");
                logger.info("grpOIterator material ==>{},standard ==>{},longNumber ==>{}", new Object[]{material, standard, longNumber});
                MatDimensionHelper.reverseArray(split);
                for (Object groupNum : split) {
                    Long calcDimension = (Long)hashMap.get(standard + "@" + (String)groupNum);
                    if (calcDimension == null) continue;
                    matDimensionMap.put(material, calcDimension);
                    continue block2;
                }
            }
        }
        if (!matDimensionMap.isEmpty()) {
            Long value;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"cad_calcdimension");
            Map dimensionMap = BusinessDataServiceHelper.loadFromCache((Object[])matDimensionMap.values().toArray(), (DynamicObjectType)entityType);
            for (Map.Entry entry : matDimensionMap.entrySet()) {
                Long l = (Long)entry.getKey();
                value = (Long)entry.getValue();
                DynamicObject dynamicObject = (DynamicObject)dimensionMap.get(value);
                if (dynamicObject == null) continue;
                result.put(l, dynamicObject);
            }
            HashSet mats = new HashSet(16);
            for (Map.Entry entry : result.entrySet()) {
                value = (DynamicObject)entry.getValue();
                Set<String> dimensionsFields = MatDimensionHelper.getDimensions(value.getString("dimension"));
                if (dimensionsFields.size() != 1 || !dimensionsFields.contains("configuredcode")) continue;
                mats.add(entry.getKey());
            }
            if (!mats.isEmpty()) {
                DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_material", (String)"id,configproperties", (QFilter[])new QFilter[]{new QFilter("id", "in", mats)});
                HashMap<Long, String> hashMap = new HashMap<Long, String>();
                for (DynamicObject obj : dynamicObjectCollection) {
                    hashMap.put(obj.getLong("id"), obj.getString("configproperties"));
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    Long materialId = (Long)entry.getKey();
                    String configProperties = (String)entry.getValue();
                    if ("2".equals(configProperties)) continue;
                    logger.info("\u83b7\u53d6\u7269\u6599\u5377\u7b97\u7ef4\u5ea6\uff0c\u5f53\u524d\u7269\u6599\u672a\u5f00\u542f\u914d\u7f6e\u4ef6\uff0c\u9ed8\u8ba4\u6309\u7269\u6599\u7ef4\u5ea6\u83b7\u53d6\u6570\u636e\uff0c\u7269\u6599ID==>{}", (Object)materialId);
                    result.remove(materialId);
                }
            }
        }
        return result;
    }

    private static void reverseArray(Object[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    private static Set<String> getDimensions(String dimension) {
        HashSet<String> set = new HashSet<String>(16);
        if (dimension.length() != 0) {
            String[] split;
            dimension = dimension.substring(1, dimension.length() - 1);
            for (String item : split = dimension.split(",")) {
                set.add(item);
            }
        }
        return set;
    }
}

