/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.output.StdCostMatResult;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatHelper {
    private static final Log logger = LogFactory.getLog(MatHelper.class);

    public static Map<Long, Long> getMatBaseUnit(Set<Long> matIds) {
        HashMap<Long, Long> matBaseUnit = new HashMap<Long, Long>(16);
        String fields = "id,baseunit";
        QFilter idQF = new QFilter("id", "in", matIds);
        QFilter enableQF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusQF = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection res = QueryServiceHelper.query((String)"bd_material", (String)fields, (QFilter[])new QFilter[]{idQF, enableQF, statusQF});
        for (DynamicObject mat : res) {
            matBaseUnit.put(mat.getLong("id"), mat.getLong("baseunit"));
        }
        return matBaseUnit;
    }

    public static QFilter getMatQFilterByOrgs(Collection<Long> collection) {
        if (collection == null || collection.size() < 1) {
            return null;
        }
        QFilter totalFilter = null;
        HashSet masterids = new HashSet(2000);
        ArrayList<Long> orgIds = new ArrayList<Long>(collection);
        QFilter materialFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", orgIds, (boolean)true);
        DynamicObjectCollection mats = QueryServiceHelper.query((String)"bd_material", (String)"masterid", (QFilter[])new QFilter[]{materialFilter});
        mats.forEach(p -> masterids.add(p.getLong("masterid")));
        if (CadEmptyUtils.isEmpty(masterids)) {
            return totalFilter;
        }
        List partition = Lists.partition(new ArrayList(masterids), (int)2000);
        for (List list : partition) {
            if (totalFilter == null) {
                totalFilter = new QFilter("masterid", "in", (Object)list);
                continue;
            }
            totalFilter = totalFilter.or(new QFilter("masterid", "in", (Object)list));
        }
        logger.info("\u5377\u7b97-\u7269\u6599\u8fc7\u6ee4-\u83b7\u53d6\u7ec4\u7ec7\u7684\u7269\u6599\uff1a{}", totalFilter);
        return totalFilter;
    }

    public static StdCostMatResult getUseStdCostMatQfilter() {
        QFilter calRangeIdQF;
        DynamicObjectCollection accountTypes;
        StdCostMatResult smResult = new StdCostMatResult();
        Set<Long> costAccounts = StartCostHelper.getEnabledCostAccount("sca");
        if (CadEmptyUtils.isEmpty(costAccounts)) {
            smResult.setSuccessType(3);
            smResult.setFalseInfo(ResManager.loadKDString((String)"\u672a\u627e\u5230\u542f\u7528\u6807\u51c6\u6210\u672c\u7684\u6210\u672c\u8d26\u7c3f\u3002", (String)"MatHelper_0", (String)"macc-cad-common", (Object[])new Object[0]));
            return smResult;
        }
        QFilter costAcountIdQF = new QFilter("costaccount", "in", costAccounts);
        QFilter enableQF = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter statusQF = new QFilter("status", "=", (Object)"C");
        DynamicObjectCollection calRanges = QueryServiceHelper.query((String)"cal_bd_calrange", (String)"id,accounttype,costaccount.name,headcalorg,headcalorg.name", (QFilter[])new QFilter[]{costAcountIdQF, enableQF, statusQF});
        if (CadEmptyUtils.isEmpty(calRanges)) {
            smResult.setFalseInfo(ResManager.loadKDString((String)"\u542f\u7528\u6807\u51c6\u6210\u672c\u7684\u6210\u672c\u8d26\u7c3f\u672a\u8bbe\u7f6e\u6838\u7b97\u8303\u56f4\u3002", (String)"MatHelper_1", (String)"macc-cad-common", (Object[])new Object[0]));
            smResult.setMatQfilter(new QFilter("id", "=", (Object)0L));
            return smResult;
        }
        ArrayList<Long> allRanges = new ArrayList<Long>(10);
        HashMap<Long, Long> stdCostRanges = new HashMap<Long, Long>(16);
        ArrayList<Long> notStdCostRanges = new ArrayList<Long>(10);
        for (DynamicObject calRange : calRanges) {
            allRanges.add(calRange.getLong("id"));
            if ("D".equals(calRange.getString("accounttype"))) {
                stdCostRanges.put(calRange.getLong("id"), calRange.getLong("headcalorg"));
                continue;
            }
            notStdCostRanges.add(calRange.getLong("id"));
        }
        QFilter matQFilterByOrgs = null;
        if (!CadEmptyUtils.isEmpty(stdCostRanges)) {
            matQFilterByOrgs = MatHelper.getMatQFilterByOrgs(stdCostRanges.values());
        }
        if (CadEmptyUtils.isEmpty(accountTypes = QueryServiceHelper.query((String)"cal_bd_accounttype", (String)"calrange,entry.material.masterid entry.material,entry.materialgroup,entry.accounttype", (QFilter[])new QFilter[]{calRangeIdQF = new QFilter("calrange", "in", allRanges), enableQF, statusQF})) && !CadEmptyUtils.isEmpty(stdCostRanges)) {
            smResult.setSuccess(true);
            smResult.setMatQfilter(matQFilterByOrgs);
            return smResult;
        }
        if (CadEmptyUtils.isEmpty(accountTypes) && CadEmptyUtils.isEmpty(stdCostRanges) && !CadEmptyUtils.isEmpty(notStdCostRanges)) {
            smResult.setSuccess(true);
            smResult.setSuccessType(2);
            smResult.setFalseInfo(ResManager.loadKDString((String)"\u76ee\u524d\u6ca1\u6709\u7269\u6599\u4f7f\u7528\u6807\u51c6\u6210\u672c\u8ba1\u4ef7\u6cd5\u3002", (String)"MatHelper_2", (String)"macc-cad-common", (Object[])new Object[0]));
            smResult.setMatQfilter(new QFilter("id", "=", (Object)0L));
            return smResult;
        }
        ArrayList<Long> inMats = new ArrayList<Long>(10);
        ArrayList<Long> notInMats = new ArrayList<Long>(10);
        ArrayList<Long> inMatGroups = new ArrayList<Long>(10);
        ArrayList<Long> notInMatGroups = new ArrayList<Long>(10);
        for (DynamicObject accountType : accountTypes) {
            if (stdCostRanges.containsKey(accountType.getLong("calrange")) && !"D".equals(accountType.getString("entry.accounttype"))) {
                if (accountType.getLong("entry.material") == 0L) {
                    notInMatGroups.add(accountType.getLong("entry.materialgroup"));
                    continue;
                }
                notInMats.add(accountType.getLong("entry.material"));
                continue;
            }
            if (!notStdCostRanges.contains(accountType.getLong("calrange")) || !"D".equals(accountType.getString("entry.accounttype"))) continue;
            if (accountType.getLong("entry.material") == 0L) {
                inMatGroups.add(accountType.getLong("entry.materialgroup"));
                continue;
            }
            inMats.add(accountType.getLong("entry.material"));
        }
        if (CadEmptyUtils.isEmpty(notStdCostRanges)) {
            logger.info("\u7b2c\u4e00\u79cd\u60c5\u51b5\uff1a\u6838\u7b97\u8303\u56f4\u90fd\u4f7f\u7528\u6807\u51c6\u6210\u672c\u8ba1\u4ef7\u6cd5");
            if (!CadEmptyUtils.isEmpty(notInMats) && !CadEmptyUtils.isEmpty(notInMatGroups)) {
                smResult.setSuccess(true);
                smResult.setMatQfilter(new QFilter("masterid", "not in", notInMats).and(new QFilter("group", "not in", notInMatGroups)).and(matQFilterByOrgs));
                return smResult;
            }
            if (!CadEmptyUtils.isEmpty(notInMatGroups)) {
                smResult.setSuccess(true);
                smResult.setMatQfilter(new QFilter("group", "not in", notInMatGroups).and(matQFilterByOrgs));
                return smResult;
            }
            if (!CadEmptyUtils.isEmpty(notInMats)) {
                smResult.setSuccess(true);
                smResult.setMatQfilter(new QFilter("masterid", "not in", notInMats).and(matQFilterByOrgs));
                return smResult;
            }
            smResult.setSuccess(true);
            smResult.setMatQfilter(matQFilterByOrgs);
            return smResult;
        }
        if (CadEmptyUtils.isEmpty(stdCostRanges)) {
            logger.info("\u7b2c\u4e8c\u79cd\u60c5\u51b5\uff1a\u6838\u7b97\u8303\u56f4\u90fd\u4f7f\u7528\u975e\u6807\u51c6\u6210\u672c\u8ba1\u4ef7\u6cd5");
            if (CadEmptyUtils.isEmpty(inMats) && CadEmptyUtils.isEmpty(inMatGroups)) {
                smResult.setSuccess(true);
                smResult.setSuccessType(2);
                smResult.setFalseInfo(ResManager.loadKDString((String)"\u76ee\u524d\u6ca1\u6709\u7269\u6599\u4f7f\u7528\u6807\u51c6\u6210\u672c\u8ba1\u4ef7\u6cd5\u3002", (String)"MatHelper_2", (String)"macc-cad-common", (Object[])new Object[0]));
                smResult.setMatQfilter(new QFilter("id", "=", (Object)0L));
                return smResult;
            }
            if (!CadEmptyUtils.isEmpty(inMats) && !CadEmptyUtils.isEmpty(inMatGroups)) {
                smResult.setSuccess(true);
                smResult.setMatQfilter(new QFilter("masterid", "in", inMats).or(new QFilter("group", "in", inMatGroups)));
                return smResult;
            }
            if (CadEmptyUtils.isEmpty(inMats)) {
                smResult.setSuccess(true);
                smResult.setMatQfilter(new QFilter("group", "in", inMatGroups));
                return smResult;
            }
            smResult.setSuccess(true);
            smResult.setMatQfilter(new QFilter("masterid", "in", inMats));
            return smResult;
        }
        logger.info("\u7b2c\u4e09\u79cd\u60c5\u51b5\uff1a\u6838\u7b97\u8303\u56f4\u65e2\u6709\u4f7f\u7528\u6807\u51c6\u6210\u672c\u8ba1\u4ef7\u6cd5\uff0c\u4e5f\u6709\u975e\u6807\u51c6\u6210\u672c\u8ba1\u4ef7\u6cd5");
        if (!CadEmptyUtils.isEmpty(notInMats) && !CadEmptyUtils.isEmpty(notInMatGroups)) {
            smResult.setSuccess(true);
            smResult.setMatQfilter(new QFilter("group", "not in", notInMatGroups).and(new QFilter("masterid", "not in", notInMats)).and(matQFilterByOrgs));
            return smResult;
        }
        if (!CadEmptyUtils.isEmpty(notInMatGroups)) {
            smResult.setSuccess(true);
            smResult.setMatQfilter(new QFilter("group", "not in", notInMatGroups).and(matQFilterByOrgs));
            return smResult;
        }
        if (!CadEmptyUtils.isEmpty(notInMats)) {
            smResult.setSuccess(true);
            smResult.setMatQfilter(new QFilter("masterid", "not in", notInMats).and(matQFilterByOrgs));
            return smResult;
        }
        smResult.setSuccess(true);
        smResult.setMatQfilter(matQFilterByOrgs);
        return smResult;
    }
}

