/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MaterialGroupHelper {
    private static final Log logger = LogFactory.getLog(MaterialGroupHelper.class);
    public static final String MATERIALGROUP = "mulmaterialgroup";
    public static final String MATERIALGROUPSTANDARD = "materialgrpstd";
    public static final long BASE_MGS_ID = 730148448254487552L;

    public static Set<Long> getClassifiedMaterialId(DynamicObjectCollection mulmaterialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard, boolean isFromFilteInfo) {
        DataSet materialDataSet;
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)1024);
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (mulmaterialgroup != null && mulmaterialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(mulmaterialgroup, isFromFilteInfo, "group.longnumber"));
        }
        if ((materialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group,group.number as groupnumber,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc")) == null) {
            return materialIds;
        }
        for (Row row : materialDataSet) {
            materialIds.add(row.getLong("material"));
        }
        return materialIds;
    }

    public static QFilter getClassifiedMaterialIdFilter(DynamicObjectCollection mulmaterialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        Set<Long> materialIds = MaterialGroupHelper.getClassifiedMaterialId(mulmaterialgroup, notShowMaterialGroup, materialgroupstandard, false);
        QFilter classifiedMaterialIdFilter = null;
        classifiedMaterialIdFilter = materialIds == null || materialIds.size() < 200000 ? new QFilter("id", "in", materialIds) : InFilterHelper.getQFilterByBachSize("id", new ArrayList<Object>(materialIds), "in", 200000);
        return classifiedMaterialIdFilter;
    }

    public static Set<Long> getClassifiedMaterialId(DynamicObjectCollection mulmaterialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        return MaterialGroupHelper.getClassifiedMaterialId(mulmaterialgroup, notShowMaterialGroup, materialgroupstandard, false);
    }

    public static DataSet getClassifiedMaterialDataSet(DynamicObjectCollection materialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard, Set<Long> matIds) {
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(materialgroup, true, "group.longnumber"));
        }
        if (!CadEmptyUtils.isEmpty(matIds)) {
            filter.and(InFilterHelper.getQFilterByBachSize("material", new ArrayList<Object>(matIds), "in", 20000));
        }
        return QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.longnumber longnumber,group.number as materialgroupnumber,group.name as materialgroupname,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
    }

    public static DataSet getClassifiedMaterialDataSet(DynamicObjectCollection materialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard) {
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(materialgroup, true, "group.longnumber"));
        }
        return QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.longnumber longnumber,group.number as materialgroupnumber,group.name as materialgroupname,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
    }

    public static DataSet getClassifiedMaterialDataSet(DynamicObjectCollection materialgroup, boolean notShowMaterialGroup, DynamicObject materialgroupstandard, boolean isFromFilteInfo) {
        if (notShowMaterialGroup) {
            return null;
        }
        Object pkValue = 730148448254487552L;
        if (materialgroupstandard != null) {
            pkValue = materialgroupstandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (materialgroup != null && materialgroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(materialgroup, isFromFilteInfo, "group.longnumber"));
        }
        return QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.longnumber longnumber,group.number as materialgroupnumber,group.name as materialgroupname,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
    }

    public static DataSet getClassifiedMaterialDataSet(long materialgroupstandardId, List<Long> materialgroupId) {
        QFilter filter = new QFilter("standard", "=", (Object)materialgroupstandardId);
        if (!CadEmptyUtils.isEmpty(materialgroupId)) {
            QFilter groupFilter = new QFilter("id", "in", materialgroupId);
            DynamicObjectCollection materialgroup = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,parent,longnumber", (QFilter[])groupFilter.toArray());
            filter.and(MaterialGroupHelper.getGroupFilter(materialgroup, true, "group.longnumber"));
        }
        return QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.longnumber longnumber,group.number as materialgroupnumber,group.name as materialgroupname,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
    }

    public static List<Long> queryMaterialIdList(Long materialGroupStandardId, List<Long> materialgroupId) {
        if (CadEmptyUtils.isEmpty(materialgroupId)) {
            return new ArrayList<Long>();
        }
        QFilter groupFilter = new QFilter("standard", "=", (Object)materialGroupStandardId);
        groupFilter.and(new QFilter("id", "in", materialgroupId));
        DynamicObjectCollection materialgroup = QueryServiceHelper.query((String)"bd_materialgroup", (String)"id,parent,longnumber", (QFilter[])groupFilter.toArray());
        if (CadEmptyUtils.isEmpty(materialgroup)) {
            return new ArrayList<Long>();
        }
        QFilter materialFilter = new QFilter("standard", "=", (Object)materialGroupStandardId);
        materialFilter.and(MaterialGroupHelper.getGroupFilter(materialgroup, true, "group.longnumber"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"material", (QFilter[])materialFilter.toArray(), null);
        if (dataSet == null || dataSet.isEmpty()) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>();
        dataSet.forEach(item -> materialIdList.add(item.getLong("material")));
        return materialIdList;
    }

    public static DataSet getClassifiedMaterialDataSet(DynamicObject materialGroupStandard, DynamicObjectCollection materialGroup, DynamicObjectCollection matCollection) {
        Object pkValue = 730148448254487552L;
        if (materialGroupStandard != null) {
            pkValue = materialGroupStandard.getPkValue();
        }
        QFilter filter = new QFilter("standard", "=", pkValue);
        if (matCollection != null && !matCollection.isEmpty()) {
            HashSet ids = new HashSet();
            matCollection.forEach(o -> ids.add(o.getLong("id")));
            filter.and("material.id", "in", ids);
        }
        if (materialGroup != null && materialGroup.size() > 0) {
            filter.and(MaterialGroupHelper.getGroupFilter(materialGroup, true, "group.longnumber"));
        }
        DataSet classifiedMaterialDataSet = QueryServiceHelper.queryDataSet((String)MaterialGroupHelper.class.getName(), (String)"bd_materialgroupdetail", (String)"group as materialgroup,group.number as materialgroupnumber,material,material.number as materialnumber,material.materialtype as materialtype", (QFilter[])filter.toArray(), (String)"group desc");
        return classifiedMaterialDataSet;
    }

    public static QFilter getGroupFilter(DynamicObjectCollection materialgroupColl, boolean isFromFilteInfo, String fieldName) {
        if (materialgroupColl != null && materialgroupColl.size() > 0) {
            DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
            GroupProp group = (GroupProp)property;
            String longNumberDLM = "";
            if (group instanceof ParentBasedataProp) {
                longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
            }
            QFilter groupFilter = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
            HashSet<String> groupNumSet = new HashSet<String>(16);
            for (DynamicObject matgroup : materialgroupColl) {
                String longnumber = isFromFilteInfo ? matgroup.getString("longnumber") : (matgroup.getDataEntityType().getProperties().get((Object)"fbasedataid") == null ? matgroup.getString("longnumber") : matgroup.getDynamicObject("fbasedataid").getString("longnumber"));
                groupFilter.or(new QFilter(fieldName, "like", (Object)(longnumber + longNumberDLM + "%")));
                groupNumSet.add(longnumber);
            }
            if (!groupNumSet.isEmpty()) {
                groupFilter.or(new QFilter(fieldName, "in", groupNumSet));
            }
            return groupFilter;
        }
        return QFilter.of((String)"1=1", (Object[])new Object[0]);
    }

    public static String getLongNumberDLM() {
        DynamicProperty property = EntityMetadataCache.getDataEntityType((String)"bd_materialgroup").getProperty("parent");
        GroupProp group = (GroupProp)property;
        String longNumberDLM = "";
        if (group instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)group).getLongNumberDLM();
        }
        return longNumberDLM;
    }

    public static List<Long> getGroupStandard(String entityNumber, Long createOrg, boolean isAddEnable) {
        ArrayList<Long> standardSetIds = new ArrayList<Long>();
        try {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (ctrlview == null) {
                return standardSetIds;
            }
            ORM ormOv = ORM.create();
            QFilter f1 = new QFilter("view.id", "=", (Object)Long.valueOf(ctrlview.getPkValue().toString()));
            QFilter f2 = new QFilter("org", "=", (Object)createOrg);
            HashSet<String> orglongnumberSets = new HashSet<String>();
            DataSet ds = ormOv.queryDataSet("MaterilaGroupHelper.getGroupStandard", "bos_org_structure", "longnumber", new QFilter[]{f1, f2});
            Object object = null;
            try {
                for (Row row : ds) {
                    if (row.getString("longnumber") == null) continue;
                    orglongnumberSets.add(row.getString("longnumber"));
                }
            }
            catch (Throwable iter) {
                object = iter;
                throw iter;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iter) {
                            ((Throwable)object).addSuppressed(iter);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            HashSet<String> orgnumberSets = new HashSet<String>();
            for (String orglongnumber : orglongnumberSets) {
                String[] orgnumbers = orglongnumber.split("!");
                orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
            }
            QFilter f = new QFilter("number", "in", orgnumberSets);
            f2 = new QFilter("enable", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{f, f2};
            HashSet<Long> orgIdSets = new HashSet<Long>();
            try (DataSet ds2 = ormOv.queryDataSet("MaterilaGroupHelper.getGroupStandard", "bos_org", "id", qFilters);){
                for (Row row : ds2) {
                    if (row.getLong("id") == null) continue;
                    orgIdSets.add(row.getLong("id"));
                }
            }
            f = new QFilter("createorg", "in", orgIdSets);
            qFilters = isAddEnable ? new QFilter[]{f, f2} : new QFilter[]{f};
            ds2 = ormOv.queryDataSet("MaterilaGroupHelper.getGroupStandard", entityNumber + "groupstandard", "id", qFilters, "id asc,ispreset desc");
            var14_19 = null;
            try {
                for (Row row : ds2) {
                    if (row.get("id") == null || standardSetIds.contains(Long.valueOf(row.get("id").toString()))) continue;
                    standardSetIds.add(Long.valueOf(row.get("id").toString()));
                }
            }
            catch (Throwable throwable) {
                var14_19 = throwable;
                throw throwable;
            }
            finally {
                if (ds2 != null) {
                    if (var14_19 != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable throwable) {
                            var14_19.addSuppressed(throwable);
                        }
                    } else {
                        ds2.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        return standardSetIds;
    }
}

