/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.common.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.dto.MaterialCodeDto;
import org.apache.commons.lang3.StringUtils;

public class MaterialLevelCompareHelper {
    private static final Log logger = LogFactory.getLog(MaterialLevelCompareHelper.class);

    public static void saveLevelCode(List<List<MaterialCodeDto>> matLvlList, List<List<String>> nestMat, Long reportid) {
        List<List<String>> levelStringList = MaterialLevelCompareHelper.transferCodeObj(matLvlList);
        ArrayList serialObj = Lists.newArrayList((Object[])new List[]{levelStringList, nestMat});
        DynamicObject levelcode = BusinessDataServiceHelper.newDynamicObject((String)"cad_levelcode");
        levelcode.set("reportid", (Object)reportid);
        levelcode.set("levelcode_tag", (Object)JSON.toJSONString((Object)serialObj));
        levelcode.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{levelcode});
    }

    private static List<List<String>> transferCodeObj(List<List<MaterialCodeDto>> matLvlList) {
        ArrayList levelStringList = Lists.newArrayListWithCapacity((int)16);
        for (List<MaterialCodeDto> levelCodeList : matLvlList) {
            ArrayList stringList = Lists.newArrayListWithCapacity((int)160);
            for (MaterialCodeDto mcd : levelCodeList) {
                stringList.add(mcd.getMaterialKey());
            }
            levelStringList.add(stringList);
        }
        return levelStringList;
    }

    public static boolean compareLevelCode(List<List<MaterialCodeDto>> srcMatLvlList, List<List<String>> srcNestMat, Long reportid) {
        DynamicObject levelcode = QueryServiceHelper.queryOne((String)"cad_levelcode", (String)"levelcode_tag", (QFilter[])new QFilter("reportid", "=", (Object)reportid).toArray());
        String levelcodeTag = levelcode.getString("levelcode_tag");
        if (StringUtils.isBlank((CharSequence)levelcodeTag)) {
            return false;
        }
        List serialObj = (List)JSON.parseObject((String)levelcodeTag, List.class);
        if (serialObj == null || serialObj.size() != 2) {
            return false;
        }
        List tarLevelCodeStr = (List)serialObj.get(0);
        List<List<String>> srcLevelCodeStr = MaterialLevelCompareHelper.transferCodeObj(srcMatLvlList);
        if (tarLevelCodeStr.size() != srcLevelCodeStr.size()) {
            return false;
        }
        for (int i = 0; i < srcLevelCodeStr.size(); ++i) {
            List<String> srcTmp = srcLevelCodeStr.get(i);
            List tarTmp = (List)tarLevelCodeStr.get(i);
            if (srcTmp.size() != tarTmp.size()) {
                return false;
            }
            tarTmp.removeAll(srcTmp);
            if (tarTmp.size() <= 0) continue;
            return false;
        }
        List tarNestCodeStr = (List)serialObj.get(1);
        if (tarNestCodeStr.size() != srcNestMat.size()) {
            return false;
        }
        tarNestCodeStr.removeAll(srcNestMat);
        return tarNestCodeStr.size() <= 0;
    }
}

